#include	"defs.h"

#include "ethernet.h"
#ifdef SNMP_SUPPORT
#include "\rtrware\lsl\klsl.h"
#include "\rtrware\lsl\vbufstr.h"
#include "\rtrware\lsl\vlslstr.h"
#endif

extern ETHERNET_CLASS		ethernet;
extern ULONG	EthRxError;
extern ULONG EthTxError;
extern ULONG	NetRcvOverFlow;
extern int wanpkts_act_txed;
extern int wanpkts_act_freed;

#if ETHER_DEBUG
   int ether_debugger_on = 0;
   int ethernet_device_driver_mem_debug_on = 0;
   int number_of_device_driver_allocations[2] ;
   void dummy_free_for_lan_1();
   void dummy_free_for_lan_2();
#endif


/****************************************************************************/
/* 
	ethernet_packet_received 
	This is called from lsl to check if there are any packets pending to 
	be processed. vptr_buffer & usptr_number_of_bytes_rxed are initialized
	if there is an packet present. 
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors.
*/
	
/****************************************************************************/
enum BOOLEAN ethernet_packet_received (USHORT port_number, void **vptr_buffer,
	USHORT *usptr_number_of_bytes_rxed)
{
	int	TmpSr;
	ETHERNET_RX_DESCRIPTOR *sptr_current_rx_descriptor;
/* 
	We are going to modify the current_rx_list linked list. Which is also being
   	modified when a packet received from the network. so disable ints.
*/
		TmpSr = _GPL(); 
		_SPL(7);
	sptr_current_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_entry_from_list (&ethernet.port[port_number].current_rx_list);
		_SPL(TmpSr);

	if (sptr_current_rx_descriptor != NULL)
	{
#if ETHER_DEBUG
      if (ether_debugger_on)
         printf("E-DEBUG: Rxed Packet on Port %04X\n", port_number);
#endif      

		*usptr_number_of_bytes_rxed = sptr_current_rx_descriptor->number_of_bytes_rxed;
		*vptr_buffer = sptr_current_rx_descriptor->sptr_rx_buffer;
		get_a_new_ethernet_buffer (port_number, sptr_current_rx_descriptor); 
		return(TRUE);
	}
/* Added by Naveen ...*/
   return FALSE;
/* ... Added by Naveen */
}

/****************************************************************************/
/*
	This is called only when interrupts are enabled.
	This routine modifies free_rx_list if a free buffer can be malloced so 
	make that call with ints disabled as free_rx_list is modified in the
	interrupt service routine of ethernet.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors.
*/
/****************************************************************************/
enum TEST get_a_new_ethernet_buffer (USHORT real_port_number, ETHERNET_RX_DESCRIPTOR *sptr_current_rx_descriptor)
{
	int	TmpSr;
	sptr_current_rx_descriptor->sptr_rx_buffer =
		(ETHERNET_BUFFER *) device_driver_malloc (real_port_number, ethernet.port[real_port_number].device_driver_id, (USHORT) NULL);

	if (sptr_current_rx_descriptor->sptr_rx_buffer != NULL)
		{
#if ETHER_DEBUG
#if STATUS_DEBUG
      number_of_device_driver_allocations[real_port_number]++;
#endif
#endif
		sptr_current_rx_descriptor->number_of_bytes_rxed = 0x0000;
		TmpSr = _GPL(); 
		_SPL(7);
		add_entry_to_list ((LINK *) &ethernet.port[real_port_number].free_rx_list, (LINK *) sptr_current_rx_descriptor);
		_SPL(TmpSr);
		return (PASS);
		}
	else
		{
		sptr_current_rx_descriptor->number_of_bytes_rxed = 0x0000;
		add_entry_to_list ((LINK *) &ethernet.port[real_port_number].rx_descriptor_need_buffer_list, (LINK *) sptr_current_rx_descriptor);
		return (FAIL);
		}
}

/****************************************************************************/
/*
	this routine is called from  lsl with interrupts enabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void ethernet_return_buffer_to_device_driver (USHORT port_number, void *vptr_buffer)
{
	ETHERNET_RX_DESCRIPTOR *sptr_rx_descriptor;

device_driver_free (port_number, ethernet.port[port_number].device_driver_id, vptr_buffer);

#if ETHER_DEBUG
#if STATUS_DEBUG
      number_of_device_driver_allocations[port_number] --;
#endif
      if (port_number == 0) /* IF LAN-1 */
         dummy_free_for_lan_1();
      else
      if (port_number == 1) /* IF LAN-2 */
         dummy_free_for_lan_2();
#endif

	sptr_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *)
		get_entry_from_list ((LINK *) &ethernet.port[port_number].rx_descriptor_need_buffer_list);

	if (sptr_rx_descriptor != NULL)
		{
		get_a_new_ethernet_buffer (port_number, sptr_rx_descriptor);
		}
}
/****************************************************************************/
/* this is called whenever a new packet is received from ethernet and a new
   buffer is to be allocated for reception. This is also called in the
   beginning when ethernet controller is being initialized. After the buffer
   is got from the free_rx_list the descriptor is added to scheduled_rx_list
   queue. This is called with interrupts disabled from ethernet interrupt
   service routine.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void *get_a_free_ethernet_rx_descriptor(USHORT port_number)
{
	ETHERNET_RX_DESCRIPTOR *sptr_free_rx_descriptor;

	sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_entry_from_list (&ethernet.port[port_number].free_rx_list);
	if(sptr_free_rx_descriptor != NULL)
   {
		add_entry_to_list (&ethernet.port[port_number].scheduled_rx_list,
			(LINK *)sptr_free_rx_descriptor);
		return(sptr_free_rx_descriptor->sptr_rx_buffer);
	}
#if ETHER_DEBUG

/* Added By Ravi */
	  { int  i,j ;
		for (i=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[port_number].current_rx_list);
			  sptr_free_rx_descriptor != NULL;
			  i++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));

		for (j=0, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_first_entry_in_list (&ethernet.port[port_number].rx_descriptor_need_buffer_list);
			  sptr_free_rx_descriptor != NULL;
			  j++, sptr_free_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_free_rx_descriptor->links));

      printf("E-DEBUG: Failed to get rx desc for port %04X\n", port_number);
/*      printf("E-DEBUG: Current Rx List=%d\n", i);
      printf("E-DEBUG: Need Buffer List=%d\n", j); */
/* Added By Ravi */

	  }
#endif
		return(NULL);
}

/****************************************************************************/
/* if a packet is received with no errors and also an free rx_descriptor is
   available this is called. this just picks up the packet from 
   scheduled_rx_list queue and put it on current_rx_list.
   This is called with interrupts disabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void	put_pkt_on_recvd_que(USHORT port_number, USHORT length_of_ethernet_packet)
{
	ETHERNET_RX_DESCRIPTOR  *sptr_rx_descriptor;


	sptr_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *) get_entry_from_list (&ethernet.port[port_number].scheduled_rx_list);
	if(sptr_rx_descriptor == NULL)
   {
		printf("\r\n scheduled_rx_list list empty");
		return;
	}
	sptr_rx_descriptor->number_of_bytes_rxed = length_of_ethernet_packet;
	add_entry_to_list (&ethernet.port[port_number].current_rx_list,
		(LINK *)sptr_rx_descriptor);

/* By Sanjay */
 	(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(ethernet.port[port_number].device_driver_id))->rfc1213_ifEntry.ifInOctets) += length_of_ethernet_packet;
	ethernet.port[port_number].statistics.number_of_packets_rxed++;
	ethernet.port[port_number].statistics.number_of_bytes_rxed += length_of_ethernet_packet;
/* By Sanjay */
}

/****************************************************************************/
/* this is called when ever there an ethernet packet which is in error is
   received. In this case it is necessarry to take out the first packet from
   scheduled_rx_list queue and put it in end. This is done this way as we will
   continue to use the same buffer for subsequent reception. this is also
   called whenever the free_rx_list becomes empty in the ethernet int servie
   routine and we need to allocate a buffer for the RX BD.
   this is called with ints disabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void ethernet_rx_error_adjust_scheduled_rx_list(USHORT port_number, int overflow)
{
	LINK  *sptr_rx_descriptor;

	sptr_rx_descriptor = get_entry_from_list (&ethernet.port[port_number].scheduled_rx_list);
	if(sptr_rx_descriptor == NULL)
   {
		printf("\r\n Rx interrupt for not received packet");
		return;
	}
	add_entry_to_list (&ethernet.port[port_number].scheduled_rx_list,(LINK *)sptr_rx_descriptor);
/* By Sanjay */
	if (overflow)
	{
		++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(ethernet.port[port_number].device_driver_id))->rfc1213_ifEntry.ifInDiscards);
		ethernet.port[port_number].statistics.number_of_rx_queue_overflows++;
	}
	else
	{
	 	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(ethernet.port[port_number].device_driver_id))->rfc1213_ifEntry.ifInErrors);
		ethernet.port[port_number].statistics.number_of_rx_errors++;
	}
/* By Sanjay */
}


#if ETHER_DEBUG
/* The following functions are dummy functions, used for debugging */
void dummy_free_for_lan_1()
{
   int i = 0;
   i = 1;
}
   
void dummy_free_for_lan_2()
{
   int i = 0;
   i = 1;
}
#endif

