#include	"defs.h"
#include "ethernet.h"

extern enum	BOOLEAN	TxPktOnEthSCC1(void *, USHORT,USHORT);
extern enum	BOOLEAN	TxPktOnEthSCC2(void *, USHORT,USHORT);

extern ETHERNET_CLASS		ethernet;


/****************************************************************************/
/*
	This is called from lsl to transmit a packet. This is called with interrupts
	enabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
enum TEST send_ethernet_packet (ULONG protocol_stack_id,
		USHORT port_number, 
		USHORT virtual_port_number, 
		void *sptr_tx_buffer,
		USHORT number_of_bytes,	
		enum BOOLEAN bridged_packet, 			/* do not cal new_crc */
		enum BOOLEAN protocol_packet,			/* device driver buffer */
		void (*fptr_tx_completion) (USHORT port_number, 
			void *sptr_ethernet_buffer) )
{
	int	TmpSr;
	ETHERNET_PORT_CLASS *sptr_ethernet_port_class = &ethernet.port[port_number];
	ETHERNET_TX_DESCRIPTOR *sptr_current_tx_descriptor;

	PARAMETER_NOT_USED (protocol_stack_id);
	PARAMETER_NOT_USED (virtual_port_number);

#if ETHER_DEBUG
  /*  if (fptr_tx_completion != NULL)
      my_debug_break(); */
#endif

	sptr_current_tx_descriptor = get_entry_from_list (&sptr_ethernet_port_class->free_tx_list);

	if ( (sptr_current_tx_descriptor == NULL) )
	{

		++sptr_ethernet_port_class->statistics.number_of_rejected_tx_packets;
/* By Sanjay */
		++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutDiscards);
/* By Sanjay */

		if (protocol_packet == TRUE)
		{
			packet_forward_device_driver_free (port_number, ethernet.port[port_number].device_driver_id,
				(void *) ((ULONG) sptr_tx_buffer));
		}

		if (fptr_tx_completion != NULL)
			{
			(*fptr_tx_completion) (virtual_port_number, sptr_tx_buffer);
			}

		return (FAIL);
	}

	++sptr_ethernet_port_class->statistics.number_of_packets_to_tx;
/* By Sanjay */
	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
 	(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ethernet_port_class->device_driver_id))->rfc1213_ifEntry.ifOutOctets) += number_of_bytes;
/* By Sanjay */

	sptr_current_tx_descriptor->length = number_of_bytes;
	sptr_current_tx_descriptor->protocol_stack_virtual_port_number = virtual_port_number;
	sptr_current_tx_descriptor->sptr_tx_packet = sptr_tx_buffer;
	sptr_current_tx_descriptor->fptr_tx_complete = fptr_tx_completion;
	sptr_current_tx_descriptor->device_driver_buffer = protocol_packet;
	sptr_current_tx_descriptor->bridged_packet = bridged_packet;
	sptr_current_tx_descriptor->in_use = TRUE;

/*
	we are modifying the current_tx_list and scheduled_tx_list lists both of 
	these are being accessed even in the ethernet interrupts service routine
	so disable the interrupts.
*/
	TmpSr = _GPL();
	_SPL(7);

   switch(port_number)                                
   {
      case ETHERNET_PORT_1:
	      if( TxPktOnEthSCC1(sptr_tx_buffer,number_of_bytes,bridged_packet) )	

      /* 
         if a free TX BD can be obtained in the 68360 for ethernet this returns TRUE
         then we must put this on scheduled_tx_list list otherwise we need to put
         this on current_tx_list so that when ever a tx gets completed current_tx_list
         can be checked for any pending frames to be txed.
      */
	         add_entry_to_list (&sptr_ethernet_port_class->scheduled_tx_list, (LINK *) sptr_current_tx_descriptor);
	      else
	         add_entry_to_list (&sptr_ethernet_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);
         break;

      case ETHERNET_PORT_2:
	      if( TxPktOnEthSCC2(sptr_tx_buffer,number_of_bytes,bridged_packet) )	

      /* 
         if a free TX BD can be obtained in the 68360 for ethernet this returns TRUE
         then we must put this on scheduled_tx_list list otherwise we need to put
         this on current_tx_list so that when ever a tx gets completed current_tx_list
         can be checked for any pending frames to be txed.
      */
	         add_entry_to_list (&sptr_ethernet_port_class->scheduled_tx_list, (LINK *) sptr_current_tx_descriptor);
	      else
	         add_entry_to_list (&sptr_ethernet_port_class->current_tx_list, (LINK *) sptr_current_tx_descriptor);
         break;

      default:
         printf("ETHERNET: Ethernet Transmit function not available for port %04X\n", port_number);
   }

   /* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit submission. */
	lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, port_number, LSL_PACKET_SUBMITTED_FOR_TRANSMIT);

	_SPL(TmpSr);
	return (PASS);
}
/****************************************************************************/
/*
	this is called from interrupt service routine for every completed tx.
	take out the first tx bd from scheduled for tx list and put them on 
	transmit completed list.
	This is called with ints disabled.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/

void ethernet_tx_isr_complete(USHORT port_number) /* Handle */
{

	ETHERNET_PORT_CLASS *sptr_ether_port_class = &ethernet.port[port_number];
	ETHERNET_TX_DESCRIPTOR *sptr_tx_descriptor;

	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port[port_number].scheduled_tx_list);
	if(sptr_tx_descriptor == NULL)
   {
		printf("ETHERNET: Interrupt for packet not sent \n\r");
		return;
	}
	--sptr_ether_port_class->statistics.number_of_packets_to_tx;
	sptr_ether_port_class->statistics.number_of_packets_txed++;
	sptr_ether_port_class->statistics.number_of_bytes_txed +=
						sptr_tx_descriptor->length;
/* By Sanjay */
	--(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(sptr_ether_port_class->device_driver_id))->rfc1213_ifEntry.ifOutQLen);
/* By Sanjay */
	add_entry_to_list (&sptr_ether_port_class->transmit_completed_list, (LINK *) sptr_tx_descriptor);

	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port[port_number].current_tx_list);
	if(sptr_tx_descriptor == NULL)
   {
		return;
	}

   switch(port_number)
   {
      case ETHERNET_PORT_1 :
	      if(TxPktOnEthSCC1(sptr_tx_descriptor->sptr_tx_packet,sptr_tx_descriptor->length,sptr_tx_descriptor->bridged_packet)) 
         {
		      add_entry_to_list (&sptr_ether_port_class->scheduled_tx_list, (LINK *) sptr_tx_descriptor);
	      } 
         else 
         {
		      /* This entry couldn't be scheduled!!! at least do the last rites */
		      /* Vidy 05/06/96 */
		      add_entry_to_list (&sptr_ether_port_class->transmit_completed_list, (LINK *) sptr_tx_descriptor);
		      ether_printf("\n\r FATAL atleast one of the tx bd's must be free \r\n");
	      }
         break;
      case ETHERNET_PORT_2 :
	      if(TxPktOnEthSCC2(sptr_tx_descriptor->sptr_tx_packet,sptr_tx_descriptor->length,sptr_tx_descriptor->bridged_packet)) 
         {
		      add_entry_to_list (&sptr_ether_port_class->scheduled_tx_list, (LINK *) sptr_tx_descriptor);
	      } 
         else 
         {
		      /* This entry couldn't be scheduled!!! at least do the last rites */
		      /* Vidy 05/06/96 */
		      add_entry_to_list (&sptr_ether_port_class->transmit_completed_list, (LINK *) sptr_tx_descriptor);
		      ether_printf("\n\r FATAL atleast one of the tx bd's must be free \r\n");
	      }
         break;

      default:
         printf("ETHERNET: Ethernet Transmit function not available for port %04X\n", port_number);
   }
}
/****************************************************************************/
/*
	This is called with interrupts enabled from main to call transmit completed
	routines of all the tx descriptors queued up in current_tx_list.
	look in wan device driver header files for details on the different 
	pointers to tx & rx descriptors. Look at the corresponding function in
	c-files in wan device driver.
*/
/****************************************************************************/
void ethernet_packet_transmitted (int port_number) /* Handle */
{
	int	TmpSr;
	ETHERNET_PORT_CLASS *sptr_ether_port_class = &ethernet.port[port_number];
	ETHERNET_TX_DESCRIPTOR *sptr_tx_descriptor;
	ETHERNET_RX_DESCRIPTOR *sptr_rx_descriptor;


	sptr_rx_descriptor = (ETHERNET_RX_DESCRIPTOR *)
		get_entry_from_list ((LINK *) &ethernet.port[port_number].rx_descriptor_need_buffer_list);

	if (sptr_rx_descriptor != NULL)
	{
		get_a_new_ethernet_buffer (port_number, sptr_rx_descriptor);
	}
/*
	transmit_completed_list queue is modified even in the interrupt service routine
	so disable interrupts
*/
	TmpSr = _GPL();
	_SPL(7);
	sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port[port_number].transmit_completed_list);
	_SPL(TmpSr);
	while(sptr_tx_descriptor != NULL)
	{
		sptr_tx_descriptor->in_use = FALSE;

#ifdef NOT_NOW
		++sptr_ether_port_class->statistics.number_of_packets_txed;
#endif

		if (sptr_tx_descriptor->fptr_tx_complete != NULL)
		{
#if ETHER_DEBUG
         if (port_number != sptr_tx_descriptor->protocol_stack_virtual_port_number)
            while(1) printf("ETHERNET: Real Port Number %04x and Virtual Port Number %04X are NOT EQUAL\n", port_number, sptr_tx_descriptor->protocol_stack_virtual_port_number);
         
#endif
			(*sptr_tx_descriptor->fptr_tx_complete) (
				sptr_tx_descriptor->protocol_stack_virtual_port_number,sptr_tx_descriptor->sptr_tx_packet);

			/* Srikar, Mar 24, 1997. Following added to inform LSL of packet transmit completion. */

			lsl_control(LSL_PACKET_TRANSMIT_SUBMITTED_OR_COMPLETED, port_number, LSL_PACKET_TRANSMIT_OVER);

		}

		if (sptr_tx_descriptor->device_driver_buffer == TRUE)
		{
			packet_forward_device_driver_free (port_number,ethernet.port[port_number].device_driver_id,
				sptr_tx_descriptor->sptr_tx_packet);
			}
	   add_entry_to_list (&sptr_ether_port_class->free_tx_list,(LINK *) &sptr_tx_descriptor->links);

		TmpSr = _GPL();
		_SPL(7);
		sptr_tx_descriptor = get_entry_from_list ((LINK *) &ethernet.port[port_number].transmit_completed_list);
		_SPL(TmpSr);
	}
}

void ether_tx_error(USHORT port_number) /* Handle */
{
/* By Sanjay */
	++(((DEVICE_DRIVER_REGISTRATION_ENTRY *)(ethernet.port[port_number].device_driver_id))->rfc1213_ifEntry.ifOutErrors);
	ethernet.port[port_number].statistics.number_of_tx_errors++;
/* By Sanjay */
}

#if 0
void send_test_packets_on_scc2()
{
   BYTE a[100];
   BYTE buffer[] = "              Testing Firewall       ";
   BYTE b[100];
   a[0] = b[0] = 0;

   if (send_ethernet_packet(0, 1, 1, (void*)buffer, strlen(buffer), FALSE,  FALSE, NULL) == PASS)  
   {
      printf("Packet Sent\n");
   }
   else
   {
      printf("Failed to send Packet \n");
   }
}
#endif
