#include	"defs.h"
/*	$Modname: annexdrx.c$  $version: 1.13$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 01/17/93 ross added function to store ipx dlci
1.4 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.5 02/01/94 ross fixed status message check.
1.6 02/01/94 ross fixed one status message check, left out.
1.7 03/01/94 ross testing with cisco frame relay and pacific bell.
1.8 03/19/94 ross fixes for cisco conformance testing
1.9 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.10 04/12/94 ross cosmetic changes.
1.11 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.12 01/12/95 ross conversion warnings.
1.13 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "fr.h"

extern ULONG mux_control (enum DEVICE_CONTROL_OPERATION command, int param0, int param1, int param2);

/****************************************************************************/
static void full_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame,USHORT number_of_bytes_rxed);
static void liv_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame);
static void async_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame);
static void process_full_status_response (USHORT port_number,
	FULL_STATUS_RESPONSE_MESSAGE *sptr_full_status_response,USHORT number_of_bytes_rxed);
static void process_liv_status_response (USHORT port_number,LIV_STATUS_RESPONSE_MESSAGE *sptr_liv_status_response);
static void process_async_status_response (USHORT port_number,ASYNC_STATUS_RESPONSE_MESSAGE *sptr_async_status_response);
/****************************************************************************/
enum RX_PACKET_STATE annex_d_frame_received (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame,
	USHORT number_of_bytes_rxed)
{
	BYTE_ENUM (ANNEX_D_REPORT_TYPE) 	frame_type;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		frame_type = sptr_rxed_frame->header.report.type;
	else
		frame_type = sptr_rxed_frame->anxa_header.report.type;

	switch (frame_type)
		{
		case FULL_STATUS_MESSAGE_REPORT:
			full_status_message_rxed (port_number,sptr_rxed_frame,number_of_bytes_rxed);
			break;
		case LIV_MESSAGE_REPORT:
			liv_status_message_rxed (port_number,sptr_rxed_frame);
			break;
		case ASYNC_STATUS_MESSAGE_REPORT:
			async_status_message_rxed (port_number,sptr_rxed_frame);
			break;
		default:
#ifdef DEBUG
			printf ("FR: Annexd - Received ILLEGAL message\r\n");
#endif
			++frame_relay.port[port_number].annex_d.statistics.number_of_illegal_report_types_rxed;
			break;
		}

	return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
}
/****************************************************************************/
static void full_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame,USHORT number_of_bytes_rxed)
{
	if (frame_relay.port[port_number].annex_d.user.enabled == TRUE)
		{
		if (sptr_rxed_frame->header.status_message == STATUS_MESSAGE)
			{
			++frame_relay.port[port_number].annex_d.statistics.rx.number_of_full_status_responses;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Full Status Response received on port %04x\n",port_number);

			process_full_status_response (port_number,&sptr_rxed_frame->full_status_response,number_of_bytes_rxed);
			}
		}
}
/****************************************************************************/
static void liv_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame)
{
	if (frame_relay.port[port_number].annex_d.user.enabled == TRUE)
		{
		if (sptr_rxed_frame->header.status_message == STATUS_MESSAGE)
			{
			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Liv Status Response received on port %04x\n",port_number);

			++frame_relay.port[port_number].annex_d.statistics.rx.number_of_liv_status_responses;

			process_liv_status_response (port_number,&sptr_rxed_frame->liv_status_response);
			}
		}
}
/****************************************************************************/
static void async_status_message_rxed (USHORT port_number,UNION_ANNEX_D_MESSAGE *sptr_rxed_frame)
{
	if (frame_relay.port[port_number].annex_d.user.enabled == TRUE)
		{
		if (sptr_rxed_frame->header.status_message == STATUS_MESSAGE)
			{
			++frame_relay.port[port_number].annex_d.statistics.rx.number_of_async_status_responses;

			process_async_status_response (port_number,&sptr_rxed_frame->async_status_response);
			}
		}
}
/****************************************************************************/
static void process_full_status_response (USHORT port_number,FULL_STATUS_RESPONSE_MESSAGE *sptr_full_status_response,
	USHORT number_of_bytes_rxed)
{
	USHORT pvc_index;
	USHORT dlci;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;
	PVC_STATUS_INFORMATION_ELEMENT *sptr_pvc_status_array;
	USHORT number_of_pvcs_rxed;

	lsl_control (LSL_PORT,port_number,TRUE);

	pvc_index = 0x0000;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		sptr_pvc_status_array = &sptr_full_status_response->pvc_status[0];

		number_of_pvcs_rxed = (USHORT) ((number_of_bytes_rxed - sizeof (ANNEX_D_HEADER) - sizeof (LIV_INFORMATION_ELEMENT))/
			sizeof (PVC_STATUS_INFORMATION_ELEMENT));
		}
	else
		{
		sptr_pvc_status_array = &((ANXA_FULL_STATUS_RESPONSE_MESSAGE *)sptr_full_status_response)->pvc_status[0];

		number_of_pvcs_rxed = (USHORT) ((number_of_bytes_rxed - sizeof (ANNEX_A_HEADER) - sizeof (LIV_INFORMATION_ELEMENT))/
			sizeof (PVC_STATUS_INFORMATION_ELEMENT));
		}

	while ((pvc_index < number_of_pvcs_rxed) && (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS) && (number_of_pvcs_rxed != 0x0000))
		{
		dlci = get_annexd_ushort_dlci (sptr_pvc_status_array->dlci);

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: PVC for dlci %04x\n",dlci);

		sptr_current_connection_entry = get_dlci_connection_entry (port_number,dlci);

		if (sptr_current_connection_entry != NULL)
			{
			if ((sptr_pvc_status_array->type._bit.active == TRUE) &&
				sptr_current_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE)
				{
				sptr_current_connection_entry->mib.frCircuitState = ACTIVE_FRAME_RELAY_CIRCUIT_STATE;
				printf ("FR: PVC with DLCI - %d, became active\r\n", dlci);
				sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;

#ifdef MUX
				mux_control (LOWER_DEVICE_DRIVER_UP, port_number, dlci, 0);
#endif
				sptr_current_connection_entry->stop_sending = FALSE;
				}
			else if ((sptr_pvc_status_array->type._bit.active == FALSE) &&
				sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE)
				{
				sptr_current_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;
				printf ("FR: PVC with DLCI - %d, became Inactive\r\n", dlci);
				sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;
#ifdef DLCI_STATS
				sptr_current_connection_entry->dlci_down_count++;
#endif

#ifdef MUX
				reset_mux_raw_dlci (dlci);
#endif
#ifdef FR_COMP
				reset_compression_on_dlci (dlci);
#endif
				sptr_current_connection_entry->stop_sending = TRUE;
#ifdef MUX
				mux_control (LOWER_DEVICE_DRIVER_DOWN, port_number, dlci, 0);
#endif
				}

			sptr_current_connection_entry->new = (enum BOOLEAN) sptr_pvc_status_array->type._bit.new;
			}
		else
			{
			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Created New Connection Entry for dlci %04x\n",dlci);

			create_dlci_connection_entry (port_number,dlci,(enum BOOLEAN) sptr_pvc_status_array->type._bit.active,
				(enum BOOLEAN) sptr_pvc_status_array->type._bit.new);

			get_dlci_connection_entry (port_number,dlci);
			}

		set_protocol_stacks_virtual_port (dlci,(enum BOOLEAN) sptr_pvc_status_array->type._bit.active);

		++sptr_pvc_status_array;
		++pvc_index;
		}

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		if (sptr_full_status_response->liv_information_element.tx_sequence_number !=
			(BYTE) frame_relay.port[port_number].annex_d.rx_sequence_number + 1)
			{
			++frame_relay.port[port_number].annex_d.statistics.number_of_sequence_number_errors;
		
			frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
			}

		frame_relay.port[port_number].annex_d.rx_sequence_number =
			sptr_full_status_response->liv_information_element.tx_sequence_number;
		}
	else
		{
		if (((ANXA_FULL_STATUS_RESPONSE_MESSAGE *)sptr_full_status_response)->liv_information_element.tx_sequence_number !=
			(BYTE) frame_relay.port[port_number].annex_d.rx_sequence_number + 1)
			{
			++frame_relay.port[port_number].annex_d.statistics.number_of_sequence_number_errors;
		
			frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
			}

		frame_relay.port[port_number].annex_d.rx_sequence_number =
			((ANXA_FULL_STATUS_RESPONSE_MESSAGE *)sptr_full_status_response)->liv_information_element.tx_sequence_number;
		}
}
/****************************************************************************/
static void process_liv_status_response (USHORT port_number,LIV_STATUS_RESPONSE_MESSAGE *sptr_liv_status_response)
{
	frame_relay.port[port_number].annex_d.user.number_of_status_responses_rxed += (BYTE) 1;
	frame_relay.port[port_number].annex_d.total_number_of_monitored_events += (BYTE) 1;

	if (frame_relay.port[port_number].management_type == ANNEX_D_MGMT_TYPE)
		{
		if (sptr_liv_status_response->liv_information_element.tx_sequence_number !=
			(BYTE) frame_relay.port[port_number].annex_d.rx_sequence_number + 1)
			{
			++frame_relay.port[port_number].annex_d.statistics.number_of_sequence_number_errors;

			frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
			}

		frame_relay.port[port_number].annex_d.rx_sequence_number =
			sptr_liv_status_response->liv_information_element.tx_sequence_number;
		}
	else
		{
		if (((ANXA_LIV_STATUS_RESPONSE_MESSAGE *)sptr_liv_status_response)->liv_information_element.tx_sequence_number !=
			(BYTE) frame_relay.port[port_number].annex_d.rx_sequence_number + 1)
			{
			++frame_relay.port[port_number].annex_d.statistics.number_of_sequence_number_errors;

			frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;
			}

		frame_relay.port[port_number].annex_d.rx_sequence_number =
			((ANXA_LIV_STATUS_RESPONSE_MESSAGE *)sptr_liv_status_response)->liv_information_element.tx_sequence_number;
		}

	if (frame_relay.port[port_number].annex_d.user.liv_response_received == FALSE)
		{
		frame_relay.port[port_number].annex_d.user.liv_response_received = TRUE;
		}
}
/****************************************************************************/
static void process_async_status_response (USHORT port_number,ASYNC_STATUS_RESPONSE_MESSAGE *sptr_async_status_response)
{
#if 0		/* donot do anything */
	USHORT dlci;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;
	PVC_STATUS_INFORMATION_ELEMENT *sptr_pvc_status_array;

	sptr_pvc_status_array = &sptr_async_status_response->pvc_status;

	dlci = get_annexd_ushort_dlci (sptr_pvc_status_array->dlci);

	frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Async Status Response received on DLCI %04x\n",dlci);

	sptr_current_connection_entry = get_dlci_connection_entry (port_number,dlci);

	if (sptr_current_connection_entry != NULL)
		{
		if ((sptr_pvc_status_array->type._bit.active == TRUE) &&
			sptr_current_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE)
			{
			sptr_current_connection_entry->mib.frCircuitState = ACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			printf ("FR: PVC with DLCI - %d, became active\r\n", dlci);
			sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;

			mux_control (LOWER_DEVICE_DRIVER_UP, port_number, dlci, 0);
			sptr_current_connection_entry->stop_sending = FALSE;
			}
		else if ((sptr_pvc_status_array->type._bit.active == FALSE) &&
			sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE)
			{
			sptr_current_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;
			printf ("FR: PVC with DLCI - %d, became Inactive\r\n", dlci);
			sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;

			reset_mux_raw_dlci (dlci);
			reset_compression_on_dlci (dlci);
			sptr_current_connection_entry->stop_sending = TRUE;
			mux_control (LOWER_DEVICE_DRIVER_DOWN, port_number, dlci, 0);
			}

		sptr_current_connection_entry->new = (enum BOOLEAN) sptr_pvc_status_array->type._bit.new;
		}
	else
		{
		create_dlci_connection_entry (port_number,dlci,(enum BOOLEAN) sptr_pvc_status_array->type._bit.active,
			sptr_current_connection_entry->new);
		}
#endif	/* donot do anything */
}
/****************************************************************************/
USHORT get_annexd_ushort_dlci (UNION_ANNEX_D_DLCI annex_d_format_dlci)
{
	UNION_USEABLE_DLCI useable_dlci;

	useable_dlci._ushort = 0x0000;

	useable_dlci._bit.dlci_lsb = annex_d_format_dlci._bit.dlci_lsb;
	useable_dlci._bit.dlci_msb = annex_d_format_dlci._bit.dlci_msb;

	return (useable_dlci._ushort);
}
