#include	"defs.h"
/*	$Modname: annexdtm.c$  $version: 1.9$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 01/02/93 ross
1.1 01/02/93 ross
1.2 01/10/93 ross changing to symmetric dlci's - IBM way
1.3 01/17/93 ross added function to store ipx dlci
1.4 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.5 03/19/94 ross fixes for cisco conformance testing
1.6 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.7 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.8 01/12/95 ross conversion warnings.
1.9 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

#include "fr.h"

extern ULONG mux_control (enum DEVICE_CONTROL_OPERATION command, int param0, int param1, int param2);

/****************************************************************************/
static void check_for_annex_d_timeouts (void);
static void check_for_polling_verification_timeout (USHORT port_number);
static void check_monitored_events_counter (USHORT port_number);
static enum BOOLEAN polling_verification_timeout (USHORT port_number);
static enum BOOLEAN error_threshold_exceeded (USHORT port_number);
static void clear_monitored_events_counters (USHORT port_number);
/****************************************************************************/
void frame_relay_timer (void)
{
	if (frame_relay.enabled == TRUE)
		{
		if (++frame_relay._1_second_counter >= (frame_relay.clock_ticks_per_second * frame_relay.total_number_of_frame_relay_ports))
			{
			frame_relay._1_second_counter = 0x00000000L;

			++frame_relay.timer;

			check_for_annex_d_timeouts ();

			check_for_lmi_timeouts ();

#ifdef FR_COMP
			check_dlci_mode_1_state (0);
#endif

			check_for_inverse_arp_packets_to_send ();

			check_congestion_on_ports ();

			update_dlci_uptime ();
			}

		check_dlci_timeouts ();
		}
}
/****************************************************************************/
static void check_for_annex_d_timeouts (void)
{
	USHORT port_number;       /* port number for loop */

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
		{
		if (frame_relay.port[port_number].enabled == TRUE)
			{
			if (frame_relay.port[port_number].annex_d.enabled == TRUE)
				{
				check_monitored_events_counter (port_number);

				if (frame_relay.port[port_number].annex_d.user.enabled == TRUE)
					{
					send_liv_status_enquiry_message (port_number);

					send_full_status_enquiry_message (port_number);
					}
				}
			}
		}
}
/****************************************************************************/
static void check_monitored_events_counter (USHORT port_number)
{
	if (frame_relay.port[port_number].annex_d.total_number_of_monitored_events >=
		frame_relay.port[port_number].annex_d.frDlcmiMonitoredEvents)
		{
		if (error_threshold_exceeded (port_number) == TRUE)
			{
			set_frame_relay_link_state (port_number,FRAME_RELAY_LINK_DOWN);
			}
		else
			{
			set_frame_relay_link_state (port_number,FRAME_RELAY_LINK_UP);

			clear_monitored_events_counters (port_number);
			}
		}
}
/****************************************************************************/
static void check_for_polling_verification_timeout (USHORT port_number)
{
	if (polling_verification_timeout (port_number) == TRUE)
		{
		if (error_threshold_exceeded (port_number) == TRUE)
			{
			set_frame_relay_link_state (port_number,FRAME_RELAY_LINK_DOWN);
			}
		}
}
/****************************************************************************/
static enum BOOLEAN polling_verification_timeout (USHORT port_number)
{
	if (frame_relay.timer > (frame_relay.port[port_number].annex_d.polling_verification_timer_T392 +	
		frame_relay.port[port_number].annex_d.network.time_since_last_status_enquiry_message_received))
		{
		frame_relay.port[port_number].annex_d.network.time_since_last_status_enquiry_message_received = frame_relay.timer;

		frame_relay.port[port_number].annex_d.network.number_of_missed_status_enquiry_messages += (BYTE) 1;
		frame_relay.port[port_number].annex_d.total_number_of_monitored_events += (BYTE) 1;
		frame_relay.port[port_number].annex_d.total_number_of_error_events += (BYTE) 1;

		return (TRUE);
		}
	else
		return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN error_threshold_exceeded (USHORT port_number)
{
	if (frame_relay.port[port_number].annex_d.total_number_of_error_events >
		frame_relay.port[port_number].annex_d.frDlcmiErrorThreshold)
		{
		clear_monitored_events_counters (port_number);

		return (TRUE);
		}
	else
		return (FALSE);
}
/****************************************************************************/
static void clear_monitored_events_counters (USHORT port_number)
{
	frame_relay.port[port_number].annex_d.network.number_of_missed_status_enquiry_messages = 0x00;
	frame_relay.port[port_number].annex_d.user.number_of_missed_status_response_messages = 0x00;
	frame_relay.port[port_number].annex_d.total_number_of_monitored_events = 0x00;
	frame_relay.port[port_number].annex_d.total_number_of_error_events = 0x00;
}
/****************************************************************************/
void set_frame_relay_link_state (USHORT port_number,enum FRAME_RELAY_LINK_STATE link_state)
{
	if (link_state == FRAME_RELAY_LINK_DOWN)
		{
		if (frame_relay.port[port_number].annex_d.enabled == TRUE)
			{
			if (frame_relay.port[port_number].annex_d.link_state == FRAME_RELAY_LINK_DOWN)
				return;

			frame_relay.port[port_number].annex_d.link_state = link_state;

			++frame_relay.port[port_number].annex_d.statistics.number_of_link_downs;
			}
		else
			{
			if (frame_relay.port[port_number].lmi.link_state == FRAME_RELAY_LINK_DOWN)
				return;

			frame_relay.port[port_number].lmi.link_state = link_state;

			++frame_relay.port[port_number].lmi.statistics.number_of_link_downs;
			}

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Link going Down for port %04x\n",port_number);

		set_all_dlcis_active_flag (port_number,FALSE);

		lsl_control (LSL_PORT,port_number,FALSE);

		printf ("FR: Link going Down for port %04x\n",port_number);

#ifdef MUX
		reset_mux_raw_dlci (0xFFFF);
		mux_control (LOWER_DEVICE_DRIVER_DOWN, port_number, 0, 0);
#endif
		stop_sending_on_all_dlcis(port_number);
		}
	else if (link_state == FRAME_RELAY_LINK_UP)
		{
		if (frame_relay.port[port_number].annex_d.enabled == TRUE)
			{
			if (frame_relay.port[port_number].annex_d.link_state == FRAME_RELAY_LINK_UP)
				return;

			frame_relay.port[port_number].annex_d.link_state = link_state;

			++frame_relay.port[port_number].annex_d.statistics.number_of_link_ups;
			}
		else
			{
			if (frame_relay.port[port_number].lmi.link_state == FRAME_RELAY_LINK_UP)
				return;

			frame_relay.port[port_number].lmi.link_state = link_state;

			++frame_relay.port[port_number].lmi.statistics.number_of_link_ups;
			}

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Link going Up for port %04x\n",port_number);

		lsl_control (LSL_PORT,port_number,TRUE);

		printf ("FR: Link going Up for port %04x\n",port_number);

#ifdef MUX
		mux_control (LOWER_DEVICE_DRIVER_UP, port_number, 0, 0);
#endif
		/* start_sending_on_all_dlcis(port_number); */
		}
}
/****************************************************************************/
enum BOOLEAN is_frame_relay_link_up (USHORT port_number)
{
	if (frame_relay.port[port_number].annex_d.enabled == TRUE) {
		if (frame_relay.port[port_number].annex_d.link_state == FRAME_RELAY_LINK_UP)
			return TRUE;
	}
	else {
		if (frame_relay.port[port_number].lmi.link_state == FRAME_RELAY_LINK_UP)
			return TRUE;
	}
	return FALSE;
}
