#include	"defs.h"
/*	$Modname: frconfig.c$  $version: 1.3$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 03/01/94 ross
1.1 03/19/94 ross fixes for cisco conformance testing
1.2 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.3 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include "fr.h"
#include	<vnvrmstr.h>
#include	"vnvfr.h"

USHORT 	get_ushort_from_string (char **pptr_string);
ULONG 	get_dlci_and_value (char *cptr_string, USHORT *ptr_dlci);

/****************************************************************************/
void map_port_numbers_to_dlci_numbers (char *cptr_port_number_dlci_string)
{
#if 0
	USHORT port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_port_number_dlci_string,&port_number);

	create_dlci_connection_entry (port_number,dlci,TRUE,TRUE);
#else
	USHORT 	port_number;
	USHORT 	dlci;
	char 		*cptr_string;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	cptr_string = cptr_port_number_dlci_string;

	port_number = get_ushort_from_string (&cptr_string);

	while (1)
	{
		if ((dlci = get_ushort_from_string (&cptr_string)) == 0)
			break;

		if ((sptr_dlci_connection_entry = get_dlci_connection_entry (port_number,dlci)) == NULL)
		{
			/* instead of assuming the circuit is active, assume it is down */
			create_dlci_connection_entry (port_number,dlci,FALSE,TRUE);
		}
	}
#endif
}

/****************************************************************************/
void map_ipx_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci)
{
	USHORT virtual_port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_virtual_port_number_and_dlci,&virtual_port_number);
	frame_relay.ipx_dlci_table.entry[virtual_port_number].dlci = dlci;
}

/****************************************************************************/
void map_ip_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci)
{
	USHORT virtual_port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_virtual_port_number_and_dlci,&virtual_port_number);
	frame_relay.ip_dlci_table.entry[virtual_port_number].dlci = dlci;
}

/****************************************************************************/
void map_source_routing_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci)
{
	USHORT virtual_port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_virtual_port_number_and_dlci,&virtual_port_number);
	frame_relay.source_routing_dlci_table.entry[virtual_port_number].dlci = dlci;
}

/****************************************************************************/
void map_stp_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci)
{
	USHORT virtual_port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_virtual_port_number_and_dlci,&virtual_port_number);
	frame_relay.stp_dlci_table.entry[virtual_port_number].dlci = dlci;
}

/****************************************************************************/
void set_frame_relay_encapsulation_type (char *cptr_port_number_and_encapsulation_type)
{
	char encapsulation_type_string[20];
	USHORT port_number;

	port_number = get_port_number_and_string (cptr_port_number_and_encapsulation_type,&encapsulation_type_string[0]);

	if (strstr (strlwr (encapsulation_type_string),"cisco") != NULL)
 		frame_relay.port[port_number].encapsulation_type = CISCO;
	else
 		frame_relay.port[port_number].encapsulation_type = RFC1490;
}

/****************************************************************************/
void set_dlci_number_function (char *cptr_string)
{
	USHORT port_number;
	USHORT dlci;

	dlci = (USHORT) get_port_number_and_value (cptr_string, &port_number);

	if (get_dlci_connection_entry (0,dlci) == NULL)
	{
		create_dlci_connection_entry (0,dlci,FALSE,TRUE);
	}
}

/****************************************************************************/
void set_dlci_CIR_function (char *cptr_string)
{
	set_dlci_value_function (cptr_string, 1);
}

/****************************************************************************/
void set_dlci_Be_function (char *cptr_string)
{
	set_dlci_value_function (cptr_string, 2);
}

/****************************************************************************/
void set_dlci_mode_function (char *cptr_string)
{
	set_dlci_value_function (cptr_string, 3);
}

/****************************************************************************/
void set_dlci_compression_function (char *cptr_string)
{
	set_dlci_value_function (cptr_string, 4);
}

/****************************************************************************/
void set_dlci_value_function (char *cptr_string, USHORT index)
{
	USHORT dlci;
	ULONG	 value;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	value = get_dlci_and_value (cptr_string, &dlci);

	if ((sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci)) == NULL)
	{
		if (create_dlci_connection_entry (0,dlci,FALSE,TRUE) == FAIL)
			return;

		sptr_dlci_connection_entry = get_dlci_connection_entry (0,dlci);
	}

	if (index == 1)
	{
		sptr_dlci_connection_entry->CIR = value;
		sptr_dlci_connection_entry->mib.frCircuitCommittedBurst = sptr_dlci_connection_entry->CIR;

		sptr_dlci_connection_entry->committed_burst_size =
			(((sptr_dlci_connection_entry->CIR * (ULONG)frame_relay.CIR_interval) / (ULONG)1000) >> 3);

#if 1
		/* Take 95% of the CIR value as the limit as we don't know how the   */
		/* switch calculates the CIR to check if we are exceeding the limit. */

		sptr_dlci_connection_entry->committed_burst_size *= 95;
		sptr_dlci_connection_entry->committed_burst_size /= 100;
#endif

#ifdef DEBUG
		printf ("DLCI - %d, CIR - %d\r\n", dlci, sptr_dlci_connection_entry->committed_burst_size);
#endif
	}
	else if (index == 2)
	{
		sptr_dlci_connection_entry->Be = value;
		sptr_dlci_connection_entry->mib.frCircuitExcessBurst = sptr_dlci_connection_entry->Be;

		sptr_dlci_connection_entry->excess_burst_size =
			(((sptr_dlci_connection_entry->Be * (ULONG)frame_relay.CIR_interval) / (ULONG)1000) >> 3);

#if 1
		sptr_dlci_connection_entry->excess_burst_size *= 95;
		sptr_dlci_connection_entry->excess_burst_size /= 100;
#endif

#ifdef DEBUG
		printf ("DLCI - %d, Be - %d\r\n", dlci, sptr_dlci_connection_entry->excess_burst_size);
#endif
	}
	else if (index == 3)
	{
		sptr_dlci_connection_entry->mode = (USHORT)value;

		if (sptr_dlci_connection_entry->mode == PVC_ADHERE_TO_CIR)
		{
			sptr_dlci_connection_entry->access_rate = sptr_dlci_connection_entry->committed_burst_size;
			sptr_dlci_connection_entry->current_rate = sptr_dlci_connection_entry->committed_burst_size;
		}
		else
		{
			sptr_dlci_connection_entry->access_rate = sptr_dlci_connection_entry->committed_burst_size
								+ sptr_dlci_connection_entry->excess_burst_size;
			sptr_dlci_connection_entry->current_rate = sptr_dlci_connection_entry->committed_burst_size
								+ sptr_dlci_connection_entry->excess_burst_size;
		}
		sptr_dlci_connection_entry->step_up_rate = (sptr_dlci_connection_entry->access_rate >> 4);
		sptr_dlci_connection_entry->step_down_rate = (sptr_dlci_connection_entry->access_rate >> 3);

#ifdef DEBUG
		printf ("DLCI - %d, Mode - %d, Access Rate - %d, Current Rate - %d, up - %d, down - %d\r\n",
			dlci, value,
			sptr_dlci_connection_entry->access_rate,
			sptr_dlci_connection_entry->current_rate,
			sptr_dlci_connection_entry->step_up_rate,
			sptr_dlci_connection_entry->step_down_rate);
#endif
	}
	else if (index == 4)
	{
		sptr_dlci_connection_entry->compression = (value == 1) ? TRUE : FALSE;
	}
}

/****************************************************************************/
USHORT get_ushort_from_string (char **pptr_string)
{
	USHORT	index, value;
	char 		*ptr_string;
	char 		buf[10];

	index = 0;
	ptr_string = *pptr_string;

	while (*ptr_string)
	{
		if (*ptr_string == ',')
		{
		 	ptr_string++;
			goto ret_value;
		}

		buf[index++] = *ptr_string++;
	}

	if ((*ptr_string == 0) && (index == 0))
		return (0);

ret_value:

	buf[index] = 0;
	value = (USHORT) atoi(&buf[0]);
	*pptr_string = ptr_string;

	return (value);
}

/****************************************************************************/
ULONG get_dlci_and_value (char *cptr_string, USHORT *ptr_dlci)
{
	int		dlci = 0;
	ULONG		value = 0;

	sscanf (cptr_string,"%04lu,%08lu",(int *) &dlci,(ULONG *) &value);

	*ptr_dlci = (USHORT)dlci;

	return (value);
}
