#include "defs.h"

#include "fr.h"

#define	FR_MEM_ENTRY_SIZE		32
#define	FR_NUM_MEM_ENTRIES	64

#define	FR_TOTAL_MEM_SIZE		(FR_MEM_ENTRY_SIZE * FR_NUM_MEM_ENTRIES)

#define	FR_MAGIC_BYTE			0x95

typedef	struct	FR_MEM_ENTRY
{
	BYTE		magic_num;	/* magic number */
	BYTE		in_use;		/* in use or free */
	BYTE		mem_data[FR_MEM_ENTRY_SIZE-2];
} FR_MEM_ENTRY;

static	FR_MEM_ENTRY	fr_mem_table[FR_NUM_MEM_ENTRIES];

/****************************************************************************/
void fr_init_mem (void)
{
	int		entries;

	for (entries=0; entries < FR_NUM_MEM_ENTRIES; entries++) {
		fr_mem_table[entries].magic_num = FR_MAGIC_BYTE;
		fr_mem_table[entries].in_use = 0;
	}
}

/****************************************************************************/
void *fr_malloc (int size)
{
	int		entries;

	if (size > (FR_MEM_ENTRY_SIZE - 2)) {
		printf ("FR: Size requested - %d, greater than Block size\r\n", size);
		return (NULL);
	}

	for (entries=0; entries < FR_NUM_MEM_ENTRIES; entries++) {
		if (fr_mem_table[entries].in_use == 0) {
			fr_mem_table[entries].in_use = 1;
			return ((void *)(&fr_mem_table[entries].mem_data[0]));
		}
	}

	printf ("FR: All memory blocks used up. No more memory.\r\n");
	return (NULL);
}

/****************************************************************************/
void fr_free (void *memptr)
{
	FR_MEM_ENTRY	*mem_entry_ptr;

	if (memptr == NULL) {
		printf ("FR: freeing NULL pointer\r\n");
		return;
	}

	mem_entry_ptr = (FR_MEM_ENTRY *)(ULONG)((ULONG)memptr - 2);

	if (mem_entry_ptr->magic_num != FR_MAGIC_BYTE) {
		printf ("FR: freeing invalid magic number\r\n");
		return;
	}

	mem_entry_ptr->in_use = 0;
}

