#include	"defs.h"

/************************************************************************/
/* Module to handle reception of packets related to APSM module.        */
/************************************************************************/

#include "fr.h"

static	int		num_raw_dlcis = 0;
static	USHORT	raw_dlci_table[MAXIMUM_NUMBER_OF_DLCI_CONNECTIONS];

extern 	int 		mux_handle_received_frame (USHORT ch_DLCI, void **frame_ptr, USHORT *length);
extern 	USHORT 	get_mux_channel_number (USHORT ch_DLCI, BYTE *buf);

/****************************************************************************/
static enum BOOLEAN mux_frame_relay_packet (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_buffer, USHORT *usptr_number_of_bytes_rxed);

/****************************************************************************/
enum BOOLEAN receive_mux_frame_relay_frame (USHORT port_number, FRAME_RELAY_PACKET *sptr_rxed_frame,
	FRAME_RELAY_PACKET **sptr_return_frame, USHORT *usptr_number_of_bytes_received)
{
	USHORT	ch_DLCI;
#ifdef DLCI_STATS
	USHORT	mux_channel_number;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
#endif

	ch_DLCI = ((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort;
#ifdef DEBUG
	printf ("FR: Received Mux pkt, DLCI = 0x%x\r\n", ch_DLCI);
#endif

	if (mux_frame_relay_packet (sptr_rxed_frame, sptr_return_frame, usptr_number_of_bytes_received) == TRUE)
		{
#ifdef DLCI_STATS
		mux_channel_number = get_mux_channel_number (ch_DLCI, (BYTE *)(*sptr_return_frame));
#endif

		mux_handle_received_frame (ch_DLCI, sptr_return_frame, usptr_number_of_bytes_received);

#ifdef DLCI_STATS
		sptr_dlci_connection_entry = get_dlci_connection_entry (0, ch_DLCI);
		if (mux_channel_number == 0) {
			sptr_dlci_connection_entry->bytes_received.Channel_1_data += *usptr_number_of_bytes_received;
			sptr_dlci_connection_entry->frames_received.Channel_1_data ++;
		}
		else if (mux_channel_number == 1) {
			sptr_dlci_connection_entry->bytes_received.Channel_2_data += *usptr_number_of_bytes_received;
			sptr_dlci_connection_entry->frames_received.Channel_2_data ++;
		}
#endif

		return TRUE;
		}

	return FALSE;
}

/****************************************************************************/
enum BOOLEAN receive_mux_raw_frame_relay_frame (USHORT port_number, FRAME_RELAY_PACKET *sptr_rxed_frame,
	FRAME_RELAY_PACKET **sptr_return_frame, USHORT *usptr_number_of_bytes_received)
{
	USHORT	ch_DLCI;
	BYTE 		*bptr_start_of_header;
#ifdef DLCI_STATS
	USHORT	mux_channel_number;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
#endif

	ch_DLCI = ((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort;
#ifdef DEBUG
	printf ("FR: Received Raw data pkt, DLCI = 0x%x\r\n", ch_DLCI);
#endif

	bptr_start_of_header = (BYTE *)sptr_rxed_frame;
	bptr_start_of_header += sizeof(FRAME_RELAY_GENERIC_HEADER);

	*usptr_number_of_bytes_received -= (USHORT) sizeof(FRAME_RELAY_GENERIC_HEADER);
	*sptr_return_frame = (FRAME_RELAY_PACKET *)bptr_start_of_header;

#ifdef DLCI_STATS
	mux_channel_number = get_mux_channel_number (ch_DLCI, (BYTE *)(*sptr_return_frame));
#endif

	mux_handle_received_frame (ch_DLCI, sptr_return_frame, usptr_number_of_bytes_received);

#ifdef DLCI_STATS
	sptr_dlci_connection_entry = get_dlci_connection_entry (0, ch_DLCI);
	if (mux_channel_number == 0) {
		sptr_dlci_connection_entry->bytes_received.Channel_1_data += *usptr_number_of_bytes_received;
		sptr_dlci_connection_entry->frames_received.Channel_1_data ++;
	}
	else if (mux_channel_number == 1) {
		sptr_dlci_connection_entry->bytes_received.Channel_2_data += *usptr_number_of_bytes_received;
		sptr_dlci_connection_entry->frames_received.Channel_2_data ++;
	}
#endif

	return TRUE;
}

/***************************************************************************/
static enum BOOLEAN mux_frame_relay_packet (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_return_frame,USHORT *usptr_number_of_bytes_rxed)
{
	BYTE 		*bptr_start_of_header;
	BYTE		nlpid;
	USHORT	pid;

	bptr_start_of_header = (BYTE *) sptr_frame_relay_frame;

	bptr_start_of_header += sizeof (FRAME_RELAY_GENERIC_HEADER);

	nlpid = *bptr_start_of_header;
	if (nlpid != 0x08)
		return FALSE;
	++bptr_start_of_header;

	pid = *(USHORT *)bptr_start_of_header;
	if (pid != MULTITECH_MUX_PID)
		return FALSE;
	bptr_start_of_header += sizeof(USHORT);

	pid = *(USHORT *)bptr_start_of_header;
#ifdef DEBUG
	if (pid == (USER_SPECIFIED_PID+1))
		printf ("Got dummy pkt\r\n");
#endif
	if (pid != USER_SPECIFIED_PID)
		return FALSE;
	bptr_start_of_header += sizeof(USHORT);

	/* now that, we reached here it is a MUX packet */
	*sptr_return_frame = (FRAME_RELAY_PACKET *)bptr_start_of_header;

	*usptr_number_of_bytes_rxed -= (USHORT) (sizeof(FRAME_RELAY_MUX_HEADER));

	return TRUE;
}

/***************************************************************************/
void init_mux_raw_dlci (USHORT ch_DLCI)
{
	int	index;

	if (num_raw_dlcis == MAXIMUM_NUMBER_OF_DLCI_CONNECTIONS)
		return;

	/* check if the DLCI has been already added */
	for (index = 0; index < num_raw_dlcis; index++) {
		if (raw_dlci_table[index] == ch_DLCI)
			return;
	}

	raw_dlci_table[num_raw_dlcis] = ch_DLCI;
	num_raw_dlcis ++;
}

/***************************************************************************/
void reset_mux_raw_dlci (USHORT ch_DLCI)
{
	int	index;

	if (ch_DLCI == 0xFFFF) {
		for (index = 0; index < MAXIMUM_NUMBER_OF_DLCI_CONNECTIONS; index++) {
			raw_dlci_table[index] = 0;
		}
		num_raw_dlcis = 0;
	}
	else {
		for (index = 0; index < num_raw_dlcis; index++) {
			if (raw_dlci_table[index] == ch_DLCI) {
				index++;
				break;
			}
		}

		for ( ; index < num_raw_dlcis; index++) {
			raw_dlci_table[index-1] = raw_dlci_table[index];
		}

		num_raw_dlcis --;
	}
}

/***************************************************************************/
enum BOOLEAN is_mux_raw_dlci (USHORT ch_DLCI)
{
	int	index;

	for (index = 0; index < num_raw_dlcis; index++) {
		if (raw_dlci_table[index] == ch_DLCI)
			return TRUE;
	}

	return FALSE;
}
