#include	"defs.h"

/************************************************************************/
/* Module to handle transmission of packets submitted by APSM module.   */
/************************************************************************/

#include <string.h>
#include "fr.h"

/* mode of data packetization for MUXing */

#define	CH_RAW_MODE					1
#define	CH_RFC1490_MODE			2
#define	CH_APSM_MODE				3

/* definitions for frame discardable in case of FR */

#define	FRAME_NOT_DISCARDABLE	0
#define	FRAME_DISCARDABLE			1

#ifdef MUX
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_mux_frame_relay_header (USHORT port_number,
	USHORT mode, UNION_FRAME_RELAY_HEADER *sptr_tx_frame, USHORT *usptr_number_of_bytes_to_tx);
void send_a_dummy_pkt (USHORT port_number, USHORT dlci);
/****************************************************************************/
enum TEST send_mux_frame_relay_frame (USHORT mux_port_number,
	USHORT mux_channel_number,
	USHORT dlci,
	USHORT mode,
	USHORT frame_discardable,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,
	USHORT number_of_bytes,
	USHORT org_number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number,void *sptr_mux_buffer))
{
	USHORT	real_port_number;
	USHORT	old_num_of_bytes;
	UNION_FRAME_RELAY_HEADER *old_sptr_tx_frame;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	old_sptr_tx_frame = sptr_tx_frame;
	old_num_of_bytes = number_of_bytes;

	real_port_number = get_port_number_from_dlci (dlci);
	if (real_port_number == 0xFFFF)
		goto FailRet;

	if (frame_relay.port[real_port_number].enabled == FALSE)
	{
FailRet:
		if (fptr_tx_completion != NULL)
		{
			(* fptr_tx_completion) (mux_port_number,sptr_tx_frame);
		}
		return (FAIL);
	}

	if (frame_relay.port[real_port_number].serial_driver.fptr_tx_routine == NULL)
		goto FailTx;

	sptr_dlci_connection_entry = get_dlci_connection_entry (real_port_number, dlci);
	
	if (sptr_dlci_connection_entry == NULL)
	{
		frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,
			"Frame Relay: Cannot get dlci control block %08lx or dlci inactive %04x\r\n",
			sptr_dlci_connection_entry, dlci);

		frame_relay_management_alarm (UNKNOWN_DLCI,FALSE,real_port_number,sptr_tx_frame,number_of_bytes);

FailTx:
		++frame_relay.port[real_port_number].statistics.number_of_tx_frames_discarded;

		if (fptr_tx_completion != NULL)
		{
			(* fptr_tx_completion) (mux_port_number,sptr_tx_frame);
		}
		return (FAIL);
	}

	check_dlci_congestion (sptr_dlci_connection_entry, number_of_bytes);

#ifndef	STEP_CONGESTION_MGMT
	if ((sptr_dlci_connection_entry->BECN_set == TRUE) ||
			(sptr_dlci_connection_entry->stop_sending == TRUE))
#else
	if (sptr_dlci_connection_entry->stop_sending == TRUE)
#endif
	{
		if (frame_discardable == FRAME_DISCARDABLE)
		{
#ifdef DEBUG
			printf ("FR: Mux Packet not sent as Line is congested on DLCI %04x\r\n",dlci);
#endif
			goto FailTx;
		}
	}

	sptr_tx_frame = build_mux_frame_relay_header (real_port_number, mode, sptr_tx_frame, &number_of_bytes);

	sptr_tx_frame->generic.dlci._ushort = dlci;

	if (frame_relay.port[real_port_number].annex_d.enabled == TRUE)
	{
		if ((sptr_tx_frame->generic.dlci._ushort != ANNEX_D_DLCI) &&
			(sptr_dlci_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE))
		{
			frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"Frame Relay: Packet sent on inactive DLCI %04x\r\n",
				sptr_tx_frame->generic.dlci._ushort);

			goto FailTx;
		}
	}
	else
	{
		if ((sptr_tx_frame->generic.dlci._ushort != LMI_DLCI) &&
			(sptr_dlci_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE))
		{
			goto FailTx;
		}
	}

	if (frame_relay.port[real_port_number].annex_d.enabled == TRUE)
	{
		if (frame_relay.port[real_port_number].annex_d.link_state == FRAME_RELAY_LINK_DOWN &&
			sptr_tx_frame->generic.dlci._ushort != ANNEX_D_DLCI)
		{
			frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"Frame Relay: Packet not sent as LINK is down on DLCI %04x\r\n",
				sptr_tx_frame->generic.dlci._ushort);

			goto FailTx;
		}
	}
	else
	{
		if ((frame_relay.port[real_port_number].lmi.link_state == FRAME_RELAY_LINK_DOWN) &&
				(sptr_tx_frame->generic.dlci._ushort != LMI_DLCI))
		{
			goto FailTx;
		}
	}

#ifdef FRF9
	if (sptr_dlci_connection_entry->compression == TRUE) {
		if (mode != CH_APSM_MODE) {
			sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *)build_frf9_frame (real_port_number,
								dlci, (BYTE *)sptr_tx_frame, &number_of_bytes);
		}
	}
#endif

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_tx_frame->generic.dlci._ushort);

	if (frame_discardable == FRAME_DISCARDABLE)
		sptr_tx_frame->generic.dlci._bit.discard_eligibility = 1;

	if ((*frame_relay.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,
		mux_port_number,
		(FRAME_RELAY_PACKET *)sptr_tx_frame,
		number_of_bytes,
		FALSE,
		FALSE,
		(void (*) (USHORT port_number,void *sptr_serial_buffer)) fptr_tx_completion,
		(char *)old_sptr_tx_frame) == PASS)
	{
#ifdef DEBUG
		printf ("FR: Sent MUX pkt - len = %d\r\n", old_num_of_bytes);
#endif

#ifdef DLCI_STATS
		if (mux_channel_number == 0) {
			sptr_dlci_connection_entry->bytes_sent.Channel_1_data += org_number_of_bytes;
			sptr_dlci_connection_entry->frames_sent.Channel_1_data ++;
		}
		else if (mux_channel_number == 1) {
			sptr_dlci_connection_entry->bytes_sent.Channel_2_data += org_number_of_bytes;
			sptr_dlci_connection_entry->frames_sent.Channel_2_data ++;
		}
#endif

		++frame_relay.port[real_port_number].statistics.number_of_tx_frames;

#if 0
		frame_relay.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) number_of_bytes;
#else
		frame_relay.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) org_number_of_bytes;
#endif

		++sptr_dlci_connection_entry->mib.frCircuitSentFrames;

#if 0
		sptr_dlci_connection_entry->mib.frCircuitSentOctets += (ULONG) number_of_bytes;
#else
		sptr_dlci_connection_entry->mib.frCircuitSentOctets += (ULONG) org_number_of_bytes;
#endif

		update_dlci_data_sent (sptr_dlci_connection_entry, number_of_bytes);

		return (PASS);
	}
	else
	{
		++frame_relay.port[real_port_number].statistics.number_of_tx_frames_discarded;

#ifdef FRF9
		if (sptr_dlci_connection_entry->compression == TRUE) {
			if (mode != CH_APSM_MODE) {
				reset_frf9_tx_sequence_number (sptr_dlci_connection_entry);
			}
		}
#endif
		return (FAIL);
	}
}

/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_mux_frame_relay_header (USHORT port_number,
	USHORT mode, UNION_FRAME_RELAY_HEADER *sptr_tx_frame, USHORT *usptr_number_of_bytes_to_tx)
{
	if (mode == CH_RAW_MODE)
	{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame - (ULONG) sizeof (FRAME_RELAY_GENERIC_HEADER));
		*usptr_number_of_bytes_to_tx += (USHORT) sizeof (FRAME_RELAY_GENERIC_HEADER); 
		sptr_tx_frame->generic.control = 0x03;
	}
	else
	{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame - (ULONG) sizeof (FRAME_RELAY_MUX_HEADER));

		sptr_tx_frame->mux.control = 0x03;
		sptr_tx_frame->mux.nlpid = Q933_NLPID;
		sptr_tx_frame->mux.L2_protocol_id = MULTITECH_MUX_PID;
		sptr_tx_frame->mux.L3_protocol_id = USER_SPECIFIED_PID;

		*usptr_number_of_bytes_to_tx += (USHORT) sizeof (FRAME_RELAY_MUX_HEADER); 
	}

	return (sptr_tx_frame);
}
#endif
/****************************************************************************/
static FRAME_RELAY_MUX_HEADER	dummy_mux_pkt;

void send_a_dummy_pkt (USHORT port_number, USHORT dlci)
{
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame;
	DLCI_LIST_ENTRY 			 *sptr_dlci_connection_entry;

	if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
		return;

	sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *)&dummy_mux_pkt;

	sptr_tx_frame->mux.control = 0x03;
	sptr_tx_frame->mux.nlpid = Q933_NLPID;
	sptr_tx_frame->mux.L2_protocol_id = MULTITECH_MUX_PID;
	sptr_tx_frame->mux.L3_protocol_id = (USER_SPECIFIED_PID+1);

	sptr_tx_frame->generic.dlci._ushort = dlci;

	convert_dlci ((UNION_USEABLE_DLCI *)&sptr_tx_frame->generic.dlci._ushort);

	if ((*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
		0,
		(FRAME_RELAY_PACKET *)sptr_tx_frame,
		sizeof(FRAME_RELAY_MUX_HEADER),
		FALSE,
		FALSE,
		(void (*) (USHORT port_number,void *sptr_serial_buffer)) NULL,
		(char *)sptr_tx_frame) == PASS)
	{
#ifdef DEBUG
		printf ("FR: Sent Dummy pkt\r\n");
#endif

#ifdef DLCI_STATS
		sptr_dlci_connection_entry = get_dlci_connection_entry (0, dlci);
		sptr_dlci_connection_entry->bytes_sent.Other_data += sizeof(FRAME_RELAY_MUX_HEADER);
		sptr_dlci_connection_entry->frames_sent.Other_data ++;
#endif
	}
}
