#include	"defs.h"
/*	$Modname: frrx.c$  $version: 1.25$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 12/27/92 ross
1.1 01/02/93 ross
1.2 01/02/93 ross
1.3 01/10/93 ross changing to symmetric dlci's - IBM way
1.4 01/23/93 ross moved lsl code into frrx.c.
1.5 01/23/93 ross fixing cisco encapsulation.
1.6 01/23/93 ross Completed testing for cisco encapsulation.
1.7 01/27/93 ross fixed a cisco encap format bug and took out pad bytes for other router vendors
1.8 01/27/93 ross changed ethernet_header to ethernet
1.9 01/29/93 ross changed spanning tree fixed frame relay bug.
1.10 01/30/93 ross removed stack calls from ipx and stp
1.11 02/03/93 ross changed packet sizes to minimum for 1294
1.12 02/06/93 ross fix for odd size frame drivers like the USC
1.13 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.14 11/22/93 ross delete frame relay header is even routine.
1.15 12/03/93 ross fixes for lsl version 3.0
1.16 02/01/94 ross fixed some LSL version 3 bugs.
1.17 02/27/94 ross added support for new ip
1.18 03/01/94 ross testing with cisco frame relay and pacific bell.
1.19 03/19/94 ross fixes for cisco conformance testing
1.20 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.21 04/12/94 ross cleaned up cisco encapsulation, although it looks like they don't use it.
1.22 05/02/94 ross inverse arp fixes.
1.23 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.24 01/12/95 ross conversion warnings.
1.25 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "fr.h"

#define	INVALID_FR_DLCI	0x8000
/****************************************************************************/
static enum BOOLEAN validate_frame_relay_frame (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,
	USHORT number_of_bytes_received);
static enum FRAME_RELAY_PROTOCOL_TYPES determine_cisco_frame_relay_protocol_type (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_buffer,USHORT *usptr_number_of_bytes_rxed);
static enum FRAME_RELAY_PROTOCOL_TYPES determine_frame_relay_protocol_type (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_buffer,USHORT *usptr_number_of_bytes_rxed,USHORT *usptr_size_of_header);
static enum BOOLEAN inverse_arp_packet_received (INVERSE_ARP_PACKET *sptr_inverse_arp_message);
static void count_frame_relay_mib_statistics (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,USHORT number_of_bytes);

extern void send_a_dummy_pkt (USHORT port_number, USHORT dlci);

void reset_frame_relay_rxed_dlci (void);

static USHORT rxed_dlci = INVALID_FR_DLCI;

/****************************************************************************/
enum BOOLEAN frame_relay_receive (USHORT port_number,FRAME_RELAY_PACKET **sptr_return_frame,
	USHORT *usptr_number_of_bytes_received)
{
	FRAME_RELAY_PACKET *sptr_rxed_frame;
#ifdef FRF9
	FRAME_RELAY_PACKET *sptr_rxed_frame_start;
#endif
	USHORT size_of_serial_header;
	USHORT number_of_bytes_received;
	USHORT real_port_number;
	enum FRAME_RELAY_PROTOCOL_TYPES protocol_type;
	DLCI_LIST_ENTRY *sptr_dlci_entry;

	real_port_number = (USHORT) (port_number - (USHORT) frame_relay.number_of_lan_ports);

	if (frame_relay.port[real_port_number].enabled == FALSE)
		{
		++frame_relay.port[real_port_number].statistics.number_rxed_in_disabled_port;

		return (FALSE);
		}

	if (frame_relay.port[real_port_number].serial_driver.fptr_rx_routine == NULL)
		return (FALSE);

	if ((*frame_relay.port[real_port_number].serial_driver.fptr_rx_routine) (real_port_number,
		(void *) &sptr_rxed_frame,&number_of_bytes_received) == FALSE)
		{
		return (FALSE);
		}

#ifdef FRF9
	sptr_rxed_frame_start = sptr_rxed_frame;
#endif

	count_frame_relay_mib_statistics (real_port_number,sptr_rxed_frame,number_of_bytes_received);

	do_frame_relay_congestion_mgmt (real_port_number,sptr_rxed_frame,number_of_bytes_received);

#ifdef FRF9
	if (is_frf9_frame((BYTE *)sptr_rxed_frame,&number_of_bytes_received)) {
		if (handle_frf9_frame (real_port_number,(BYTE **)&sptr_rxed_frame,&number_of_bytes_received) == FALSE)
			goto ReturnBuffer;
	}
	else {
		convert_dlci_to_ushort (&sptr_rxed_frame->header.generic.dlci);
	}
#else
	convert_dlci_to_ushort (&sptr_rxed_frame->header.generic.dlci);
#endif

	rxed_dlci = sptr_rxed_frame->header.generic.dlci._ushort;

#if 1
	sptr_dlci_entry = get_dlci_connection_entry (real_port_number,rxed_dlci);
	if (sptr_dlci_entry != NULL)
		sptr_dlci_entry->mib.frCircuitReceivedOctets += number_of_bytes_received;
#endif

#ifdef DEBUG
	printf ("FR: Received pkt, DLCI = 0x%x\r\n", 
		((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort);
#endif

	if (validate_frame_relay_frame (real_port_number,(FRAME_RELAY_PACKET *) sptr_rxed_frame,number_of_bytes_received) == TRUE)
		{																					  /* check if frame was Annex D frame */
		if (((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort == ANNEX_D_DLCI) 
			{
			annex_d_frame_received (real_port_number,(UNION_ANNEX_D_MESSAGE *) sptr_rxed_frame,number_of_bytes_received);

#ifdef FRF9
			frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame_start);
#else
			frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame);
#endif

			reset_frame_relay_rxed_dlci ();

			return (FALSE);
			}
		else if (((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort == LMI_DLCI) 
			{
			lmi_frame_received (real_port_number,(UNION_LMI_MESSAGE *) sptr_rxed_frame,number_of_bytes_received);

			goto ReturnBuffer;
			}
		else
			{
			*usptr_number_of_bytes_received = number_of_bytes_received;

			frame_relay.port[real_port_number].statistics.number_of_rx_bytes += number_of_bytes_received;

			++frame_relay.port[real_port_number].statistics.number_of_rx_frames;

#ifdef MUX
			if (is_mux_raw_dlci(((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort) == TRUE)
				{
				receive_mux_raw_frame_relay_frame (real_port_number,sptr_rxed_frame, 
						sptr_return_frame, usptr_number_of_bytes_received);

				goto ReturnBuffer;
				}
#endif

			if (frame_relay.port[real_port_number].encapsulation_type == CISCO)
				{
	  			protocol_type = determine_cisco_frame_relay_protocol_type (sptr_rxed_frame,sptr_return_frame,usptr_number_of_bytes_received);
				}
			else
				{
	  			protocol_type = determine_frame_relay_protocol_type (sptr_rxed_frame,sptr_return_frame,usptr_number_of_bytes_received,
					&size_of_serial_header);
				}

#ifdef DLCI_STATS
			sptr_dlci_entry = get_dlci_connection_entry (real_port_number,rxed_dlci);
			if (protocol_type == IP_FRAME_RELAY) {
				sptr_dlci_entry->bytes_received.IP_data += *usptr_number_of_bytes_received;
				sptr_dlci_entry->frames_received.IP_data ++;
			}
			else if (protocol_type == IPX_FRAME_RELAY) {
				sptr_dlci_entry->bytes_received.IPX_data += *usptr_number_of_bytes_received;
				sptr_dlci_entry->frames_received.IPX_data ++;
			}
			else if (protocol_type == STP_FRAME_RELAY) {
				sptr_dlci_entry->bytes_received.STP_data += *usptr_number_of_bytes_received;
				sptr_dlci_entry->frames_received.STP_data ++;
			}
#endif

#if 1
			if (protocol_type == UNKNOWN_FRAME_RELAY_PROTOCOL_TYPE)
				{
#ifdef MUX
				if (receive_mux_frame_relay_frame (real_port_number,sptr_rxed_frame, 
						sptr_return_frame, usptr_number_of_bytes_received) == FALSE)
					{
					++frame_relay.port[real_port_number].statistics.number_of_rx_frames_discarded;

#ifdef DLCI_STATS
					sptr_dlci_entry->bytes_received.Other_data += *usptr_number_of_bytes_received;
					sptr_dlci_entry->frames_received.Other_data ++;
#endif

#ifdef DEBUG
					printf ("FR: Unknown protocol type, DLCI = 0x%x\r\n", 
						((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort);
#endif
					}
#endif
#else
				++frame_relay.port[real_port_number].statistics.number_of_rx_frames_discarded;

#ifdef DEBUG
				printf ("FR: Unknown protocol type, DLCI = 0x%x\r\n", 
					((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort);
#endif
#endif

ReturnBuffer:

#ifdef FRF9
				frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame_start);
#else
				frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame);
#endif

				reset_frame_relay_rxed_dlci ();

				return (FALSE);
				}
			}

		return (TRUE);
		}
	else
		{
#ifdef DEBUG
		printf ("FR: Invalid frame, DLCI = 0x%x\r\n", 
			((FRAME_RELAY_PACKET *) sptr_rxed_frame)->header.generic.dlci._ushort);
#endif

#ifdef FRF9
		frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame_start);
#else
		frame_relay_return_buffer_to_device_driver (port_number,sptr_rxed_frame);
#endif

		reset_frame_relay_rxed_dlci ();

		++frame_relay.port[real_port_number].statistics.number_of_rx_frames_discarded;

#ifdef DLCI_STATS
		sptr_dlci_entry->bytes_received.Other_data += number_of_bytes_received;
		sptr_dlci_entry->frames_received.Other_data ++;
#endif

		return (FALSE);
		}
}
/***************************************************************************/
static void count_frame_relay_mib_statistics (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,USHORT number_of_bytes)
{
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
	USHORT dlci;

	dlci = get_ushort_dlci (sptr_rxed_frame->header.generic.dlci);

	sptr_dlci_connection_entry = get_dlci_connection_entry (port_number,dlci);

	if (sptr_dlci_connection_entry != NULL)
		{
		if (sptr_rxed_frame->header.generic.dlci._bit.forward_explicit_congestion_notification)
			sptr_dlci_connection_entry->mib.frCircuitReceivedFECNs ++;

		if (sptr_rxed_frame->header.generic.dlci._bit.backward_explicit_congestion_notification)
			sptr_dlci_connection_entry->mib.frCircuitReceivedBECNs ++;

		++sptr_dlci_connection_entry->mib.frCircuitReceivedFrames;

#if 0
		sptr_dlci_connection_entry->mib.frCircuitReceivedOctets += number_of_bytes;
#endif
		}
}
/***************************************************************************/
static enum FRAME_RELAY_PROTOCOL_TYPES determine_cisco_frame_relay_protocol_type (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_return_frame,USHORT *usptr_number_of_bytes_rxed)
{
	extern MAC_ADDRESS bridge_group_address;

	*usptr_number_of_bytes_rxed = (USHORT ) (*usptr_number_of_bytes_rxed + (ULONG) sizeof (ETHERNET_HEADER)
		- sizeof (FRAME_RELAY_CISCO_HEADER));

	switch (sptr_frame_relay_frame->header.cisco.snap_protocol_id)
		{
		case SNAP_IPX_PROTOCOL_ID:
			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) sptr_frame_relay_frame - (ULONG) sizeof (ETHERNET_HEADER) +
				(ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

			return (IPX_FRAME_RELAY);
		case SNAP_CISCO_BPDU_PROTOCOL_ID:
			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) sptr_frame_relay_frame - (ULONG) sizeof (ETHERNET_HEADER) +
				(ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

 			(*sptr_return_frame)->header.ethernet.destination_address._ulong = bridge_group_address._ulong;
 			(*sptr_return_frame)->header.ethernet.destination_address._ushort = bridge_group_address._ushort;

			return (STP_FRAME_RELAY);
		case SNAP_CISCO_BRIDGED_DATA:
			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) sptr_frame_relay_frame + (ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));
			return (STP_FRAME_RELAY);
		case SNAP_IP_PACKET:
			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) sptr_frame_relay_frame - (ULONG) sizeof (ETHERNET_HEADER) +
				(ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

			return (IP_FRAME_RELAY);
		default:
			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) sptr_frame_relay_frame + (ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));
			return (STP_FRAME_RELAY);
		}
}
/****************************************************************************/
static enum BOOLEAN validate_frame_relay_frame (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,
	USHORT number_of_bytes_received)
{
	if (number_of_bytes_received <= frame_relay.port[port_number].minimum_frame_size)
		{
		frame_relay_management_alarm (RX_PACKET_TOO_SHORT,FALSE,port_number,sptr_rxed_frame,number_of_bytes_received);
		return (FALSE);
		}

	if (number_of_bytes_received > frame_relay.port[port_number].maximum_frame_size) 
		{
		frame_relay_management_alarm (RX_PACKET_TOO_LONG,FALSE,port_number,sptr_rxed_frame,number_of_bytes_received);
		return (FALSE);
		}

#ifdef COMMENT
	if ((sptr_rxed_frame->frame_relay_header.dlci._bit.extended_address_1 != TRUE) &&
		(sptr_rxed_frame->frame_relay_header.dlci._bit.extended_address_2 != FALSE)) 
		{
		frame_relay_management_alarm (ILLEGAL_DLCI,FALSE,port_number,sptr_rxed_frame,number_of_bytes_received);
		return (FALSE);
		}
#endif

	return (TRUE);
}
/***************************************************************************/
static enum FRAME_RELAY_PROTOCOL_TYPES determine_frame_relay_protocol_type (FRAME_RELAY_PACKET *sptr_frame_relay_frame,
	FRAME_RELAY_PACKET **sptr_return_frame,USHORT *usptr_number_of_bytes_rxed,USHORT *usptr_size_of_header)
{
	BYTE *bptr_start_of_header;
	enum NLPID_TYPES nlpid;
	enum FRAME_RELAY_PROTOCOL_TYPES protocol_type;
	extern MAC_ADDRESS bridge_group_address;
	USHORT	snap_id;

	bptr_start_of_header = (BYTE *) sptr_frame_relay_frame;

	bptr_start_of_header += sizeof (FRAME_RELAY_GENERIC_HEADER);

	while (*bptr_start_of_header == 0x00) /* get rid of pad bytes */
		{
		++bptr_start_of_header;
		}

	nlpid = (enum NLPID_TYPES) *bptr_start_of_header;

	++bptr_start_of_header; /* point to start of SNAP header or protocol header (in case of IP) */

	protocol_type = UNKNOWN_FRAME_RELAY_PROTOCOL_TYPE;

	switch (nlpid)
		{
		case IP_NLPID:
			*usptr_size_of_header = (USHORT) ((ULONG) bptr_start_of_header - (ULONG) sptr_frame_relay_frame);

			*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header - (ULONG) sizeof (UNION_MAC_HEADER));

			*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ETHERNET_HEADER) - *usptr_size_of_header);

#ifdef DEBUG
			printf ("FR: Received IP pkt, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

			(*sptr_return_frame)->header.ethernet.length = SNAP_IP_PACKET;

			(*sptr_return_frame)->header.ethernet.destination_address._ulong = 0xffffffffL;
			(*sptr_return_frame)->header.ethernet.destination_address._ushort = 0xffff;

			protocol_type = IP_FRAME_RELAY;
			break;
		case SNAP_NLPID:
			*usptr_size_of_header = (USHORT) (((ULONG) bptr_start_of_header - (ULONG) sptr_frame_relay_frame) +
				sizeof (FRAME_RELAY_SNAP_HEADER));

			bptr_start_of_header += sizeof (sptr_frame_relay_frame->header.ipx.oui);

#if 0
			switch (*((enum SNAP_PROTOCOL_ID *) bptr_start_of_header))
#else
			snap_id = *((USHORT *)bptr_start_of_header);
			switch ((enum SNAP_PROTOCOL_ID) snap_id)
#endif
				{
				case SNAP_IPX_PROTOCOL_ID:
					protocol_type = IPX_FRAME_RELAY;

#if 0
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (enum SNAP_PROTOCOL_ID) - (ULONG) sizeof (UNION_MAC_HEADER));
#else
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (USHORT) - (ULONG) sizeof (UNION_MAC_HEADER));
#endif

					*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ETHERNET_HEADER) - sizeof (FRAME_RELAY_IPX_HEADER));

#ifdef DEBUG
					printf ("FR: Received IPX pkt, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

					(*sptr_return_frame)->header.ethernet.length = SNAP_IPX_PROTOCOL_ID;
					(*sptr_return_frame)->header.ethernet.destination_address._ulong = 0xffffffffL;
					(*sptr_return_frame)->header.ethernet.destination_address._ushort = 0xffff;
					(*sptr_return_frame)->header.ethernet.source_address._ulong = 0x00000000L;
					(*sptr_return_frame)->header.ethernet.source_address._ushort = 0x0000;

					break;
				case SNAP_STP_BPDU_PACKET:
#if 0
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (enum SNAP_PROTOCOL_ID) - (ULONG) sizeof (UNION_MAC_HEADER));
#else
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (USHORT) - (ULONG) sizeof (UNION_MAC_HEADER));
#endif

					*usptr_number_of_bytes_rxed -= *usptr_size_of_header;

#ifdef DEBUG
					printf ("FR: Received STP-BPDU pkt, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

					(*sptr_return_frame)->header.ethernet.destination_address._ulong = bridge_group_address._ulong;
					(*sptr_return_frame)->header.ethernet.destination_address._ushort = bridge_group_address._ushort;

					protocol_type = STP_FRAME_RELAY;
					break;

				case SNAP_8025_BRIDGED_PACKET_WITH_CRC:
				case SNAP_8025_BRIDGED_PACKET_WITHOUT_CRC:
#if 0
					bptr_start_of_header += sizeof (enum SNAP_PROTOCOL_ID);
#else
					bptr_start_of_header += sizeof (USHORT);
#endif

					*sptr_return_frame = (FRAME_RELAY_PACKET *) bptr_start_of_header;

					*usptr_number_of_bytes_rxed -= *usptr_size_of_header;

#if 0				/* donot strip the ethernet CRC */
					*usptr_number_of_bytes_rxed -= (USHORT) sizeof (CRC);
#endif

#ifdef DEBUG
					if (snap_id == SNAP_8025_BRIDGED_PACKET_WITH_CRC)
						printf ("FR: Received 802.5 with CRC, len = %d\r\n", *usptr_number_of_bytes_rxed);
					else
						printf ("FR: Received 802.5 without CRC, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

					protocol_type = STP_FRAME_RELAY;
					break;
				case SNAP_8023_BRIDGED_PACKET_WITH_CRC:
				case SNAP_8023_BRIDGED_PACKET_WITHOUT_CRC:
#if 0
					bptr_start_of_header += sizeof (enum SNAP_PROTOCOL_ID);
#else
					bptr_start_of_header += sizeof (USHORT);
#endif

					*sptr_return_frame = (FRAME_RELAY_PACKET *) bptr_start_of_header;

					*usptr_number_of_bytes_rxed -= *usptr_size_of_header;

#if 0				/* donot strip the ethernet CRC */
					*usptr_number_of_bytes_rxed -= (USHORT) sizeof (CRC);
#endif

#ifdef DEBUG
					if (snap_id == SNAP_8023_BRIDGED_PACKET_WITH_CRC)
						printf ("FR: Received 802.3 with CRC, len = %d\r\n", *usptr_number_of_bytes_rxed);
					else
						printf ("FR: Received 802.3 without CRC, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

					protocol_type = STP_FRAME_RELAY;
					break;
				case SNAP_IP_ARP_PACKET:

					if (inverse_arp_packet_received ((INVERSE_ARP_PACKET *) sptr_frame_relay_frame) == FALSE)
						{
#if 0
						*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
							(ULONG) sizeof (enum SNAP_PROTOCOL_ID) - (ULONG) sizeof (UNION_MAC_HEADER));
#else
						*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
							(ULONG) sizeof (USHORT) - (ULONG) sizeof (UNION_MAC_HEADER));
#endif

						*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ETHERNET_HEADER) - sizeof (FRAME_RELAY_IPX_HEADER));

#ifdef DEBUG
						printf ("FR: Received IP_ARP pkt, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

						(*sptr_return_frame)->header.ethernet.length = sptr_frame_relay_frame->header.ip.snap_protocol_id;

						(*sptr_return_frame)->header.ethernet.destination_address._ulong = 0xffffffffL;
						(*sptr_return_frame)->header.ethernet.destination_address._ushort = 0xffff;
						(*sptr_return_frame)->header.ethernet.source_address._ulong = 0x00000000L;
						(*sptr_return_frame)->header.ethernet.source_address._ushort = 0x0000;

						protocol_type = IP_FRAME_RELAY;
						}

					break;
				case SNAP_IP_RARP_PACKET:
				case SNAP_IP_PACKET:
				case SNAP_IP_FRAGMENT_PACKET:
#if 0
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (enum SNAP_PROTOCOL_ID) - (ULONG) sizeof (UNION_MAC_HEADER));
#else
					*sptr_return_frame = (FRAME_RELAY_PACKET *) ((ULONG) bptr_start_of_header +
						(ULONG) sizeof (USHORT) - (ULONG) sizeof (UNION_MAC_HEADER));
#endif

					*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ETHERNET_HEADER) - sizeof (FRAME_RELAY_IPX_HEADER));

#ifdef DEBUG
					printf ("FR: Received IP_RARP/IP/IP_FRAG pkt, len = %d\r\n", *usptr_number_of_bytes_rxed);
#endif

					(*sptr_return_frame)->header.ethernet.length = sptr_frame_relay_frame->header.ip.snap_protocol_id;

					(*sptr_return_frame)->header.ethernet.destination_address._ulong = 0xffffffffL;
					(*sptr_return_frame)->header.ethernet.destination_address._ushort = 0xffff;
					(*sptr_return_frame)->header.ethernet.source_address._ulong = 0x00000000L;
					(*sptr_return_frame)->header.ethernet.source_address._ushort = 0x0000;

					protocol_type = IP_FRAME_RELAY;
					break;
				default:
					break;
				}

			break;
		default:
			break;
		}

	return (protocol_type);
}
/***************************************************************************/
static enum BOOLEAN inverse_arp_packet_received (INVERSE_ARP_PACKET *sptr_inverse_arp_message)
{
	ULONG ip_address;
	USHORT virtual_port_number;
	IPX_PROTOCOL_ADDRESS source_protocol_address;

	/* must have similar (if not the same) type functions in your protocol stacks  */

	if (sptr_inverse_arp_message->header.snap_protocol_id == SNAP_IP_PACKET)
		{
		virtual_port_number = get_virtual_port_number_from_dlci (sptr_inverse_arp_message->header.dlci._ushort,
			&frame_relay.ip_dlci_table);
		}
	else
		{
		virtual_port_number = get_virtual_port_number_from_dlci (sptr_inverse_arp_message->header.dlci._ushort,
			&frame_relay.ipx_dlci_table);
		}

	if (virtual_port_number == ILLEGAL_VIRTUAL_PORT_NUMBER)
		{
 		frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,
			"Frame Relay: Receive Illegal Virtual Port number %04x from Arp Request DLCI %04x\r\n",
			virtual_port_number,sptr_inverse_arp_message->header.dlci._ushort);

		return (TRUE);
		}

	if ((sptr_inverse_arp_message->header.snap_protocol_id == SNAP_IP_PACKET) &&
		(frame_relay.ip_dlci_table.entry[virtual_port_number].inverse_arp_enabled == TRUE) &&
		(frame_relay.ip_dlci_table.entry[virtual_port_number].address_found == FALSE) &&
		(frame_relay.ip_stack_id != ILLEGAL_STACK_ID))
		{
		if (sptr_inverse_arp_message->header.command == INVERSE_ARP_REQUEST)
			{
			ip_address = swap_long (lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,virtual_port_number,frame_relay.ip_stack_id,
				GET_PROTOCOL_ADDRESS,(ULONG) NULL));

			set_inverse_arp_protocol_stack_virtual_port (sptr_inverse_arp_message->header.dlci._ushort,TRUE,
				(void *) &sptr_inverse_arp_message->hardware_and_protocol_address.ip.source_protocol_address,IP_PROTOCOL_STACK);

			frame_relay.ip_dlci_table.entry[virtual_port_number].address_found = TRUE;

 			frame_relay_printf (FRAME_RELAY_INVERSE_ARP_PRINTF,
				"Frame Relay: Receive IP Inverse Arp Request DLCI %04x\r\n",
				frame_relay.ip_dlci_table.entry[virtual_port_number].dlci);

			send_inverse_arp_packet (frame_relay.ip_stack_id,frame_relay.ip_dlci_table.entry[virtual_port_number].dlci,
				SNAP_IP_PACKET,virtual_port_number,sizeof (ULONG),
				sizeof (FRAME_RELAY_INVERSE_ARP_HEADER) + sizeof (IP_HARDWARE_AND_PROTOCOL_ADDRESS),(BYTE *) &ip_address,
				(BYTE *) &sptr_inverse_arp_message->hardware_and_protocol_address.ip.source_protocol_address,INVERSE_ARP_REPLY,
				sptr_inverse_arp_message->hardware_and_protocol_address.ip.target_hardware_address._ushort);
			}
		else
			{
 			frame_relay_printf (FRAME_RELAY_INVERSE_ARP_PRINTF,
				"Frame Relay: Receive IP Inverse Arp Reply DLCI %04x\r\n",frame_relay.ip_dlci_table.entry[virtual_port_number].dlci);

			frame_relay.ip_dlci_table.entry[virtual_port_number].address_found = TRUE;

			set_inverse_arp_protocol_stack_virtual_port (sptr_inverse_arp_message->header.dlci._ushort,TRUE,
				(void *) &sptr_inverse_arp_message->hardware_and_protocol_address.ip.source_protocol_address,IP_PROTOCOL_STACK);
			}
		}
	else if ((sptr_inverse_arp_message->header.snap_protocol_id == SNAP_IPX_PROTOCOL_ID) &&
		(frame_relay.ipx_dlci_table.entry[virtual_port_number].inverse_arp_enabled == TRUE) &&
		(frame_relay.ipx_dlci_table.entry[virtual_port_number].address_found == FALSE) &&
		(frame_relay.ipx_stack_id != ILLEGAL_STACK_ID))
		{
		if (sptr_inverse_arp_message->header.command == INVERSE_ARP_REQUEST)
			{
 			frame_relay_printf (FRAME_RELAY_INVERSE_ARP_PRINTF,
				"Frame Relay: Receive IPX Inverse Arp Request DLCI %04x\r\n",
				frame_relay.ip_dlci_table.entry[virtual_port_number].dlci);

			lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,virtual_port_number,frame_relay.ipx_stack_id,
				GET_PROTOCOL_ADDRESS,(ULONG) &source_protocol_address);

			set_inverse_arp_protocol_stack_virtual_port (sptr_inverse_arp_message->header.dlci._ushort,TRUE,
				(void *) &sptr_inverse_arp_message->hardware_and_protocol_address.ipx.source_protocol_address,IPX_PROTOCOL_STACK);

			frame_relay.ipx_dlci_table.entry[virtual_port_number].address_found = TRUE;

			send_inverse_arp_packet (frame_relay.ipx_stack_id,frame_relay.ipx_dlci_table.entry[virtual_port_number].dlci,
				SNAP_IPX_PROTOCOL_ID,virtual_port_number,sizeof (ULONG),
				sizeof (FRAME_RELAY_INVERSE_ARP_HEADER) + sizeof (IPX_HARDWARE_AND_PROTOCOL_ADDRESS),
				(BYTE *) &source_protocol_address,
				(BYTE *) &sptr_inverse_arp_message->hardware_and_protocol_address.ipx.source_protocol_address,INVERSE_ARP_REPLY,
				sptr_inverse_arp_message->hardware_and_protocol_address.ipx.target_hardware_address._ushort);
			}
		else
			{
 			frame_relay_printf (FRAME_RELAY_INVERSE_ARP_PRINTF,
				"Frame Relay: Receive IPX Inverse Arp Reply DLCI %04x\r\n",
				frame_relay.ip_dlci_table.entry[virtual_port_number].dlci);

			frame_relay.ipx_dlci_table.entry[virtual_port_number].address_found = TRUE;

			set_inverse_arp_protocol_stack_virtual_port (sptr_inverse_arp_message->header.dlci._ushort,TRUE,
				(void *) &sptr_inverse_arp_message->hardware_and_protocol_address.ipx.source_protocol_address,IPX_PROTOCOL_STACK);
			}
		}

	return (TRUE);
}
/***************************************************************************/
USHORT get_frame_relay_virtual_port_number (enum PROTOCOL_STACK_TYPE proto_type)
{
	USHORT protocol_stack_virtual_port_number;

	if ((frame_relay.enabled == FALSE) || (rxed_dlci == INVALID_FR_DLCI))
		return (0x00FF);

	if ((frame_relay.ipx_stack_id != ILLEGAL_STACK_ID) && (proto_type == IPX_PROTOCOL_STACK))
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (rxed_dlci,&frame_relay.ipx_dlci_table);

#ifdef DEBUG
		printf ("FR: IPX virtual port = %d, DLCI = %d\r\n", protocol_stack_virtual_port_number, rxed_dlci);
#endif
		return (protocol_stack_virtual_port_number);
		}

	if ((frame_relay.ip_stack_id != ILLEGAL_STACK_ID) && (proto_type == IP_PROTOCOL_STACK))
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (rxed_dlci,&frame_relay.ip_dlci_table);

#ifdef DEBUG
		printf ("FR: IP virtual port = %d, DLCI = %d\r\n", protocol_stack_virtual_port_number, rxed_dlci);
#endif
		return (protocol_stack_virtual_port_number);
		}

	if ((frame_relay.stp_stack_id != ILLEGAL_STACK_ID) && (proto_type == SPANNING_TREE_STACK))
		{
		protocol_stack_virtual_port_number = get_virtual_port_number_from_dlci (rxed_dlci,&frame_relay.stp_dlci_table);

#ifdef DEBUG
		printf ("FR: STP virtual port = %d, DLCI = %d\r\n", protocol_stack_virtual_port_number, rxed_dlci);
#endif
		return (protocol_stack_virtual_port_number);
		}

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
/***************************************************************************/
void reset_frame_relay_rxed_dlci (void)
{
	rxed_dlci = INVALID_FR_DLCI;
}

/***************************************************************************/
/*************** Congestion management related functions *******************/
/***************************************************************************/

/***************************************************************************/
void do_frame_relay_congestion_mgmt (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,USHORT number_of_bytes)
{
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
	USHORT dlci;

	dlci = get_ushort_dlci (sptr_rxed_frame->header.generic.dlci);

	sptr_dlci_connection_entry = get_dlci_connection_entry (port_number,dlci);

	if (sptr_dlci_connection_entry == NULL)
		return;

	if (sptr_dlci_connection_entry->mode == PVC_AS_FAST_AS_POSSIBLE)
		return;

	if (sptr_rxed_frame->header.generic.dlci._bit.forward_explicit_congestion_notification)
	{
		if (sptr_dlci_connection_entry->FECN_set == FALSE)
		{
			printf ("FR: FECN Set\r\n");
			sptr_dlci_connection_entry->FECN_set = TRUE;

			/* send a dummy packet to the other side so that the sender   */
			/* will get a chance to look at the DLCI header for BECN bit. */
			send_a_dummy_pkt (port_number, dlci);
		}
	}
	else
	{
		if (sptr_dlci_connection_entry->FECN_set == TRUE)
		{
			printf ("FR: FECN Reset\r\n");
			sptr_dlci_connection_entry->FECN_set = FALSE;

			/* send a dummy packet to the other side so that the sender   */
			/* will get a chance to look at the DLCI header for BECN bit. */
			send_a_dummy_pkt (port_number, dlci);
		}
	}

	if (sptr_rxed_frame->header.generic.dlci._bit.backward_explicit_congestion_notification)
	{
		if (sptr_dlci_connection_entry->BECN_set == FALSE)
		{
			printf ("FR: BECN Set\r\n");
			sptr_dlci_connection_entry->BECN_set = TRUE;
			sptr_dlci_connection_entry->BECN_count = 0;
		}

#ifdef	STEP_CONGESTION_MGMT
		sptr_dlci_connection_entry->BECN_count++;

		if (sptr_dlci_connection_entry->BECN_count == BECN_WINDOW_SIZE)
		{
			/* start decrementing the access rate by the calculated step */
			if (sptr_dlci_connection_entry->current_rate > sptr_dlci_connection_entry->minimum_rate)
			{
				sptr_dlci_connection_entry->current_rate -= sptr_dlci_connection_entry->step_down_rate;
				printf ("FR: Step Down to Rate - %d\r\n", sptr_dlci_connection_entry->current_rate);
			}

			sptr_dlci_connection_entry->BECN_count = 0;
		}
#endif
	}
	else
	{
		if (sptr_dlci_connection_entry->BECN_set == TRUE)
		{
			printf ("FR: BECN Reset\r\n");
			sptr_dlci_connection_entry->BECN_set = FALSE;
			sptr_dlci_connection_entry->BECN_count = 0;

#ifndef	STEP_CONGESTION_MGMT
			queue_pending_tx_buffers (sptr_dlci_connection_entry);
#endif
		}

#ifdef	STEP_CONGESTION_MGMT
		sptr_dlci_connection_entry->BECN_count++;

		if (sptr_dlci_connection_entry->BECN_count == BECN_WINDOW_SIZE)
		{
			/* start incrementing the access rate by the calculated step */
			if (sptr_dlci_connection_entry->current_rate < sptr_dlci_connection_entry->access_rate)
			{
				sptr_dlci_connection_entry->current_rate += sptr_dlci_connection_entry->step_up_rate;

				if (sptr_dlci_connection_entry->current_rate > sptr_dlci_connection_entry->access_rate)
				{
					sptr_dlci_connection_entry->current_rate = sptr_dlci_connection_entry->access_rate;
				}
				printf ("FR: Step Up to Rate - %d\r\n", sptr_dlci_connection_entry->current_rate);
			}

			sptr_dlci_connection_entry->BECN_count = 0;
		}
#endif
	}
}
/***************************************************************************/
void check_congestion_on_ports (void)
{
	USHORT port_number;       /* port number for loop */

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
	{
		if (frame_relay.port[port_number].enabled == TRUE)
		{
			send_congestion_awareness_pkt (port_number);
		}
	}
}
/***************************************************************************/
void send_congestion_awareness_pkt (USHORT port_number)
{
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	pvc_index = 0x0000;

	sptr_dlci_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

	while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_dlci_connection_entry != NULL)
	{
		++pvc_index;

		if (sptr_dlci_connection_entry->FECN_set == TRUE)
		{
			/* send a dummy packet so that the sender can look for BECN bit. */
			send_a_dummy_pkt (port_number, sptr_dlci_connection_entry->dlci);
		}

		sptr_dlci_connection_entry = sptr_dlci_connection_entry->links.sptr_forward_link;
	}
}
/****************************************************************************/
void check_dlci_congestion (DLCI_LIST_ENTRY *sptr_dlci_connection_entry, USHORT number_of_bytes)
{
	ULONG	bytes_sent_so_far;

	if (sptr_dlci_connection_entry->mode == PVC_AS_FAST_AS_POSSIBLE)
		return;

	bytes_sent_so_far = (sptr_dlci_connection_entry->bytes_sent_in_this_interval + (ULONG)number_of_bytes);

	if (bytes_sent_so_far > sptr_dlci_connection_entry->current_rate)
	{
		if (sptr_dlci_connection_entry->stop_sending == FALSE)
		{
			sptr_dlci_connection_entry->stop_sending = TRUE;
#if 0
			printf ("FR: Bytes sent (%d) exceeded Rate, Stop sending\r\n", bytes_sent_so_far);
#else
			printf ("FR: Stop sending on DLCI - %d\r\n", sptr_dlci_connection_entry->dlci);
#endif
		}
	}
}
/****************************************************************************/
void update_dlci_data_sent (DLCI_LIST_ENTRY *sptr_dlci_connection_entry, USHORT number_of_bytes)
{
	sptr_dlci_connection_entry->bytes_sent_in_this_interval += (ULONG)number_of_bytes;

	if (sptr_dlci_connection_entry->start_time_of_measurement_interval == (ULONG)-1L)
	{
		sptr_dlci_connection_entry->start_time_of_measurement_interval = frame_relay.CIR_timer;
	}
}
/****************************************************************************/
void check_dlci_timeouts (void)
{
	USHORT port_number;       /* port number for loop */
	USHORT pvc_index;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;

	if (frame_relay.check_CIR_timeout == FALSE)
		return;

	for (port_number = 0x0000; port_number < frame_relay.total_number_of_frame_relay_ports; ++port_number)
	{
		if (frame_relay.port[port_number].enabled == FALSE)
			continue;

		pvc_index = 0x0000;

		sptr_dlci_connection_entry = (DLCI_LIST_ENTRY *) frame_relay.port[port_number].dlci_list.sptr_forward_link;

		while (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS && sptr_dlci_connection_entry != NULL)
		{
			++pvc_index;

			if (sptr_dlci_connection_entry->start_time_of_measurement_interval != (ULONG)-1L)
			{
	 			if (frame_relay.CIR_timer >
						sptr_dlci_connection_entry->start_time_of_measurement_interval)
				{
					if (sptr_dlci_connection_entry->stop_sending == TRUE)
					{
#if 0
						printf ("FR: CIR interval expired, Start sending\r\n");
#else
						printf ("FR: Start sending on DLCI - %d\r\n", sptr_dlci_connection_entry->dlci);
#endif
					}

					sptr_dlci_connection_entry->stop_sending = FALSE;
 					sptr_dlci_connection_entry->bytes_sent_in_this_interval = 0;
					sptr_dlci_connection_entry->start_time_of_measurement_interval = (ULONG)-1L;

					queue_pending_tx_buffers (sptr_dlci_connection_entry);
				}
			}

			sptr_dlci_connection_entry = sptr_dlci_connection_entry->links.sptr_forward_link;
		}
	}

	frame_relay.CIR_ticks = 0;
	frame_relay.check_CIR_timeout = FALSE;
}
/****************************************************************************/
void CheckFrameRelayTimer (void)
{
#ifdef MUX
	frame_relay.CIR_ticks++;
	if (frame_relay.CIR_ticks == frame_relay.CIR_interval) {
		frame_relay.CIR_timer++;
		frame_relay.CIR_ticks = 0;
		frame_relay.check_CIR_timeout = TRUE;
	}
#endif
}


BYTE FrameRelayTimeOut = 0 ;
/* This is called every 50 ms i.e 20 times per second */
void frame_relay_inc_ticks (void)
{
	if (++FrameRelayTimeOut >= 20)
	{
		FrameRelayTimeOut = 0 ;
		frame_relay.CIR_timer++;
		frame_relay.check_CIR_timeout = TRUE;
/*		CheckFrameRelayTimer() ;  */
	}
}
