#include	"defs.h"
/*	$Modname: frtx.c$  $version: 1.26$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 12/27/92 ross
1.1 01/02/93 ross
1.2 01/02/93 ross
1.3 01/10/93 ross changing to symmetric dlci's - IBM way
1.4 01/17/93 ross added function to store ipx dlci
1.5 01/23/93 ross check for link_up in send_frame_relay_frame.
1.6 01/23/93 ross moved lsl code into frtx and frrx
1.7 01/23/93 ross added port_number to store_dlci functions.
1.8 01/23/93 ross Completed testing for cisco encapsulation.
1.9 01/27/93 ross fixed a cisco encap format bug and took out pad bytes for other router vendors
1.10 01/27/93 ross changed ethernet_header to ethernet
1.11 01/29/93 ross changed spanning tree fixed frame relay bug.
1.12 01/30/93 ross delete stack references.
1.13 02/03/93 ross changed packet sizes to minimum for 1294
1.14 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.15 12/03/93 ross fixes for lsl version 3.0
1.16 02/01/94 ross fixed some descriptor problems in transmit.
1.17 02/27/94 ross added support for new ip
1.18 03/01/94 ross testing with cisco frame relay and pacific bell.
1.19 03/10/94 ross protocol_stack_id routine was modified to support new lsl.
1.20 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.21 04/12/94 ross changed a name in the inverse arp code.
1.22 05/02/94 ross inverse arp fixes.
1.23 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.24 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.25 01/12/95 ross conversion warnings.
1.26 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "fr.h"

/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_stp_frame_relay_header (UNION_FRAME_RELAY_HEADER *sptr_tx_frame,
	enum BOOLEAN do_not_calculate_crc,enum BOOLEAN device_driver_buffer,USHORT *usptr_number_of_bytes);
static UNION_FRAME_RELAY_HEADER *build_ip_frame_relay_header (USHORT port_number,UNION_FRAME_RELAY_HEADER *sptr_tx_frame);
static UNION_FRAME_RELAY_HEADER *build_ipx_frame_relay_header (UNION_FRAME_RELAY_HEADER *sptr_tx_frame);
static UNION_FRAME_RELAY_HEADER *build_cisco_frame_relay_header (ULONG protocol_stack_id,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,enum BOOLEAN do_not_calculate_crc,USHORT *usptr_number_of_bytes);
static UNION_FRAME_RELAY_HEADER *build_rfc_1490_frame_relay_header (USHORT port_number,ULONG protocol_stack_id,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,enum BOOLEAN do_not_calculate_crc,enum BOOLEAN device_driver_buffer,
	USHORT *usptr_number_of_bytes_to_tx);
/****************************************************************************/
enum TEST send_frame_relay_frame (ULONG protocol_stack_id,USHORT real_port_number,USHORT virtual_port_number,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer))
{
	UNION_FRAME_RELAY_HEADER *old_sptr_tx_frame;
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry;
	USHORT		old_num_of_bytes;
	UNION_DLCI	dlci;

	old_sptr_tx_frame = sptr_tx_frame;
	old_num_of_bytes = number_of_bytes;

	real_port_number -= (USHORT) frame_relay.number_of_lan_ports;

	if (frame_relay.port[real_port_number].enabled == FALSE)
		{
		if (fptr_tx_completion != NULL)
			{
			(fptr_tx_completion) (virtual_port_number,sptr_tx_frame);
			}
		return (FAIL);
		}

	if (frame_relay.port[real_port_number].serial_driver.fptr_tx_routine == NULL)
		goto TxFail;

	dlci._ushort = get_dlci_from_protocol_stack_virtual_port_number (protocol_stack_id,virtual_port_number);
	if (dlci._ushort == 0)
	{
#if 0
		printf ("Virtual port %d not mapped\r\n",virtual_port_number);
#endif
		goto TxFail;
	}

	sptr_dlci_connection_entry = get_dlci_connection_entry (real_port_number,dlci._ushort);

	if (sptr_dlci_connection_entry == NULL)
		{
		frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,
			"Frame Relay: Cannot get dlci control block %08lx or dlci inactive %04x\r\n",
			sptr_dlci_connection_entry, dlci._ushort);

		frame_relay_management_alarm (UNKNOWN_DLCI,FALSE,real_port_number,sptr_tx_frame,number_of_bytes);

TxFail:
		if (fptr_tx_completion != NULL)
			{
			(fptr_tx_completion) (virtual_port_number,old_sptr_tx_frame);
			}

		++frame_relay.port[real_port_number].statistics.number_of_tx_frames_discarded;

		return (FAIL);
		}

	check_dlci_congestion (sptr_dlci_connection_entry, number_of_bytes);

#ifndef	STEP_CONGESTION_MGMT
	if ((sptr_dlci_connection_entry->BECN_set == TRUE)
		|| (sptr_dlci_connection_entry->stop_sending == TRUE))
#else
	if (sptr_dlci_connection_entry->stop_sending == TRUE)
#endif
		{
			if (queue_frame_relay_frame (protocol_stack_id,
					real_port_number, virtual_port_number,(UNION_FRAME_RELAY_HEADER *)sptr_tx_frame,
					number_of_bytes, do_not_calculate_crc,device_driver_buffer,
					fptr_tx_completion,sptr_dlci_connection_entry) == FAIL)
				{
#ifdef DEBUG
				printf ("FR: Packet not sent, Line congested on DLCI %04x\r\n", dlci._ushort);
#endif
				goto TxFail;
				}

#ifdef DEBUG
		printf ("FR: Packet added to wait list on DLCI %04x\r\n", dlci._ushort);
#endif
		return PASS;
		}

	if (frame_relay.port[real_port_number].encapsulation_type == RFC1490)
		{
		sptr_tx_frame = build_rfc_1490_frame_relay_header (real_port_number,protocol_stack_id,sptr_tx_frame,do_not_calculate_crc,
			device_driver_buffer,&number_of_bytes);
		}
	else
		{
		sptr_tx_frame = build_cisco_frame_relay_header (protocol_stack_id,sptr_tx_frame,do_not_calculate_crc,&number_of_bytes);
		}

	sptr_tx_frame->generic.dlci._ushort = dlci._ushort;

	if (frame_relay.port[real_port_number].annex_d.enabled == TRUE)
		{
		if ((sptr_tx_frame->generic.dlci._ushort != ANNEX_D_DLCI) &&
			(sptr_dlci_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE))
			{
RetFail_1:
			frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"Frame Relay: Packet sent on inactive DLCI %04x\r\n",
				sptr_tx_frame->generic.dlci._ushort);

			if (fptr_tx_completion != NULL)
				{
				(fptr_tx_completion) (virtual_port_number,old_sptr_tx_frame);
				}

			return (FAIL);
			}
		}
	else
		{
		if ((sptr_tx_frame->generic.dlci._ushort != LMI_DLCI) &&
			(sptr_dlci_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE))
			goto RetFail_1;
		}

	if (frame_relay.port[real_port_number].annex_d.enabled == TRUE)
		{
		if ((frame_relay.port[real_port_number].annex_d.link_state == FRAME_RELAY_LINK_DOWN) &&
				(sptr_tx_frame->generic.dlci._ushort != ANNEX_D_DLCI))
			{
RetFail_2:
			frame_relay_printf (FRAME_RELAY_ALARM_PRINTF,"Frame Relay: Packet not sent as LINK is down on DLCI %04x\r\n",
				sptr_tx_frame->generic.dlci._ushort);

			if (fptr_tx_completion != NULL)
				{
				(fptr_tx_completion) (virtual_port_number,old_sptr_tx_frame);
				}

			return (FAIL);
			}
		}
	else
		{
		if ((frame_relay.port[real_port_number].lmi.link_state == FRAME_RELAY_LINK_DOWN) &&
				(sptr_tx_frame->generic.dlci._ushort != LMI_DLCI))
			goto RetFail_2;
		}

#ifdef FRF9
	if (sptr_dlci_connection_entry->compression == TRUE) {
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *)build_frf9_frame (real_port_number,
								dlci._ushort, (BYTE *)sptr_tx_frame, &number_of_bytes);
	}
#endif

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_tx_frame->generic.dlci._ushort);

	if ((*frame_relay.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,
		virtual_port_number,
		(FRAME_RELAY_PACKET *)sptr_tx_frame,
		number_of_bytes,
		do_not_calculate_crc,
		device_driver_buffer,
		(void (*) (USHORT port_number,void *sptr_serial_buffer)) fptr_tx_completion,
		(char *)old_sptr_tx_frame) == PASS)
		{
#ifdef DEBUG
		if (protocol_stack_id == frame_relay.stp_stack_id)
			{
			printf ("FR: Sent STP Pkt - len = %d\r\n", old_num_of_bytes);
			}
		else if (protocol_stack_id == frame_relay.ipx_stack_id)
			{
			printf ("FR: Sent IPX, Port = %d, DLCI = %d\r\n", virtual_port_number, dlci._ushort);
			}
		else if (protocol_stack_id == frame_relay.ip_stack_id)
			{
			printf ("FR: Sent IP Pkt - len = %d\r\n", old_num_of_bytes);
			}
#endif

#ifdef DLCI_STATS
		if (protocol_stack_id == frame_relay.ip_stack_id) {
			sptr_dlci_connection_entry->bytes_sent.IP_data += old_num_of_bytes;
			sptr_dlci_connection_entry->frames_sent.IP_data ++;
		}
		else if (protocol_stack_id == frame_relay.ipx_stack_id) {
			sptr_dlci_connection_entry->bytes_sent.IPX_data += old_num_of_bytes;
			sptr_dlci_connection_entry->frames_sent.IPX_data ++;
		}
		else if (protocol_stack_id == frame_relay.stp_stack_id) {
			sptr_dlci_connection_entry->bytes_sent.STP_data += old_num_of_bytes;
			sptr_dlci_connection_entry->frames_sent.STP_data ++;
		}
		else {
			sptr_dlci_connection_entry->bytes_sent.Other_data += old_num_of_bytes;
			sptr_dlci_connection_entry->frames_sent.Other_data ++;
		}
#endif

		++frame_relay.port[real_port_number].statistics.number_of_tx_frames;

#if 0
		frame_relay.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) number_of_bytes;
#else
		frame_relay.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) old_num_of_bytes;
#endif

		++sptr_dlci_connection_entry->mib.frCircuitSentFrames;

#if 0
		sptr_dlci_connection_entry->mib.frCircuitSentOctets += (ULONG) number_of_bytes;
#else
		sptr_dlci_connection_entry->mib.frCircuitSentOctets += (ULONG) old_num_of_bytes;
#endif

		update_dlci_data_sent (sptr_dlci_connection_entry, number_of_bytes);

		return (PASS);
		}
	else
		{
		++frame_relay.port[real_port_number].statistics.number_of_tx_frames_discarded;

#ifdef FRF9
		if (sptr_dlci_connection_entry->compression == TRUE) {
			reset_frf9_tx_sequence_number (sptr_dlci_connection_entry);
		}
#endif

		return (FAIL);
		}
}
/****************************************************************************/
void queue_pending_tx_buffers (DLCI_LIST_ENTRY *sptr_dlci_connection_entry)
{
	USHORT				 count = 0;
	WAN_TX_DESCRIPTOR	 *sptr_wait_buf;

	sptr_wait_buf = (WAN_TX_DESCRIPTOR *)get_entry_from_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list);
	if (sptr_wait_buf == NULL)
		return;

	while (sptr_wait_buf != NULL)
		{
		add_entry_to_list ((LINK *)&sptr_dlci_connection_entry->tx_free_list,
			(LINK *)sptr_wait_buf);

		send_frame_relay_frame (sptr_wait_buf->protocol_stack_id,
			sptr_wait_buf->real_port_number, sptr_wait_buf->virtual_port_number,
			(UNION_FRAME_RELAY_HEADER *)sptr_wait_buf->sptr_tx_frame,
			sptr_wait_buf->number_of_bytes, sptr_wait_buf->do_not_calculate_crc,
			sptr_wait_buf->device_driver_buffer, sptr_wait_buf->fptr_tx_completion);

#ifndef	STEP_CONGESTION_MGMT
		if ((sptr_dlci_connection_entry->BECN_set == TRUE)
			|| (sptr_dlci_connection_entry->stop_sending == TRUE))
#else
		if (sptr_dlci_connection_entry->stop_sending == TRUE)
#endif
		{
#if 1	/* KVSP 3/24/97 */
			/* the current entry would have got added to the end of the list */
			/* so, remove it from the end and add it to the front.           */
			sptr_wait_buf = (WAN_TX_DESCRIPTOR *)get_pointer_to_last_entry_in_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list);

			delete_entry_from_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list, (LINK *)sptr_wait_buf);

			add_entry_to_front_of_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list, (LINK *)sptr_wait_buf);

#ifdef DEBUG
			printf ("FR: Removed from end and added at the start\r\n", count);
#endif
#endif
			break;
		}

		count++;

		sptr_wait_buf = (WAN_TX_DESCRIPTOR *)get_entry_from_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list);
		}

#ifdef DEBUG
	printf ("FR: Sent Pending packets - %d\r\n", count);
#endif
}
/*************************************************************************/
enum TEST queue_frame_relay_frame (ULONG protocol_stack_id,USHORT real_port_number,USHORT virtual_port_number,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer),
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry)
{
	WAN_TX_DESCRIPTOR	*sptr_wait_buf;

	sptr_wait_buf = (WAN_TX_DESCRIPTOR *)get_entry_from_list ((LINK *)&sptr_dlci_connection_entry->tx_free_list);
	if (sptr_wait_buf == NULL)
		return FAIL;

	sptr_wait_buf->protocol_stack_id = protocol_stack_id;
	sptr_wait_buf->real_port_number = real_port_number + (USHORT) frame_relay.number_of_lan_ports;
	sptr_wait_buf->virtual_port_number = virtual_port_number;
	sptr_wait_buf->sptr_tx_frame = (BYTE *)sptr_tx_frame;
	sptr_wait_buf->number_of_bytes = number_of_bytes;
	sptr_wait_buf->do_not_calculate_crc = do_not_calculate_crc;
	sptr_wait_buf->device_driver_buffer = device_driver_buffer;
	sptr_wait_buf->fptr_tx_completion = fptr_tx_completion;

	add_entry_to_list ((LINK *)&sptr_dlci_connection_entry->tx_wait_list,
			(LINK *)sptr_wait_buf);

	return (PASS);
}
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_rfc_1490_frame_relay_header (USHORT port_number,ULONG protocol_stack_id,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,enum BOOLEAN do_not_calculate_crc,enum BOOLEAN device_driver_buffer,
	USHORT *usptr_number_of_bytes_to_tx)
{
	if (protocol_stack_id == frame_relay.stp_stack_id)
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) build_stp_frame_relay_header (sptr_tx_frame,
			do_not_calculate_crc,device_driver_buffer,usptr_number_of_bytes_to_tx);

		*usptr_number_of_bytes_to_tx += (USHORT) sizeof (FRAME_RELAY_STP_HEADER); 
		}
	else if (protocol_stack_id == frame_relay.ipx_stack_id)
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) build_ipx_frame_relay_header (sptr_tx_frame);

		*usptr_number_of_bytes_to_tx += (USHORT) (sizeof (FRAME_RELAY_IPX_HEADER) - sizeof (ETHERNET_HEADER)); 
		}
	else if (protocol_stack_id == frame_relay.ip_stack_id)
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) build_ip_frame_relay_header (port_number,sptr_tx_frame);

#if 0
		*usptr_number_of_bytes_to_tx += (USHORT) (sizeof (FRAME_RELAY_IPX_HEADER) - sizeof (ETHERNET_HEADER)); 
#else
		if (frame_relay.port[port_number].enable_ip_snap == TRUE)
			{
			*usptr_number_of_bytes_to_tx += (USHORT) (sizeof (FRAME_RELAY_SNAP_IP_HEADER) - sizeof (ETHERNET_HEADER)); 
			}
		else
			{
			*usptr_number_of_bytes_to_tx += (USHORT) (sizeof (FRAME_RELAY_IP_HEADER) - sizeof (ETHERNET_HEADER)); 
			}
#endif
		}

	return (sptr_tx_frame);
}
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_stp_frame_relay_header (UNION_FRAME_RELAY_HEADER *sptr_tx_frame,
	enum BOOLEAN do_not_calculate_crc,enum BOOLEAN device_driver_buffer,USHORT *usptr_number_of_bytes)
{
	FRAME_RELAY_PACKET *sptr_return_frame_relay_packet;
	enum DEVICE_DRIVER_TYPE dd_type;
	extern MAC_ADDRESS bridge_group_address;

	if ((sptr_tx_frame->ethernet.destination_address._ushort == bridge_group_address._ushort) &&
		(sptr_tx_frame->ethernet.destination_address._ulong == bridge_group_address._ulong))
		{
		sptr_return_frame_relay_packet = (FRAME_RELAY_PACKET *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) +
			(ULONG) sizeof (LLC_HEADER) - (ULONG) sizeof (FRAME_RELAY_STP_HEADER));

		*usptr_number_of_bytes -= (USHORT) (sizeof (ETHERNET_HEADER) + sizeof (LLC_HEADER));

		sptr_return_frame_relay_packet->header.stp.snap_protocol_id = SNAP_STP_BPDU_PACKET;
		}
	else
		{
		sptr_return_frame_relay_packet = (FRAME_RELAY_PACKET *) ((ULONG) sptr_tx_frame -	(ULONG) sizeof (FRAME_RELAY_STP_HEADER));

		if (device_driver_buffer == TRUE && do_not_calculate_crc == TRUE)
			{
#if 0
			if (lsl_control (LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,sptr_tx_frame) == ETHERNET_DEVICE_DRIVER)
#else
			dd_type = lsl_control (LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,sptr_tx_frame);
			if (dd_type == ETHERNET_DEVICE_DRIVER)
#endif
				{
				sptr_return_frame_relay_packet->header.stp.snap_protocol_id = SNAP_8023_BRIDGED_PACKET_WITH_CRC;
				}
			else
				{																						  
				*((BYTE *)sptr_tx_frame) = 0x00;	/* delete the access control byte */

				sptr_return_frame_relay_packet->header.stp.snap_protocol_id = SNAP_8025_BRIDGED_PACKET_WITH_CRC;
				}
			}
		else
			{
#if 0
			if (lsl_control (LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,sptr_tx_frame) == ETHERNET_DEVICE_DRIVER)
#else
			dd_type = lsl_control (LSL_GET_DEVICE_DRIVER_TYPE_FROM_RECEIVE_PORT,sptr_tx_frame);
			if (dd_type == ETHERNET_DEVICE_DRIVER)
#endif
				{
				sptr_return_frame_relay_packet->header.stp.snap_protocol_id = SNAP_8023_BRIDGED_PACKET_WITHOUT_CRC;
				}
			else
				{																						  
				*((BYTE *)sptr_tx_frame) = 0x00;	/* delete the access control byte */

				sptr_return_frame_relay_packet->header.stp.snap_protocol_id = SNAP_8025_BRIDGED_PACKET_WITHOUT_CRC;
				}
			}
		}

	sptr_return_frame_relay_packet->header.stp.control = UNNUMBERED_INFORMATION;
	sptr_return_frame_relay_packet->header.stp.pad_byte = 0x00;
	sptr_return_frame_relay_packet->header.stp.nlpid = 0x80;
	sptr_return_frame_relay_packet->header.stp.oui[0] = 0x00;
	sptr_return_frame_relay_packet->header.stp.oui[1] = 0x80;
	sptr_return_frame_relay_packet->header.stp.oui[2] = 0xc2;

	return ((UNION_FRAME_RELAY_HEADER *) sptr_return_frame_relay_packet);
}
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_ipx_frame_relay_header (UNION_FRAME_RELAY_HEADER *sptr_tx_frame)
{
	sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) -
		(ULONG) sizeof (FRAME_RELAY_IPX_HEADER));

	sptr_tx_frame->ipx.control = UNNUMBERED_INFORMATION;
	sptr_tx_frame->ipx.pad_byte = 0x00;
	sptr_tx_frame->ipx.nlpid = 0x80;
	sptr_tx_frame->ipx.oui[0] = 0x00;
	sptr_tx_frame->ipx.oui[1] = 0x00;
	sptr_tx_frame->ipx.oui[2] = 0x00;
	sptr_tx_frame->ipx.snap_protocol_id = SNAP_IPX_PROTOCOL_ID;

	return (sptr_tx_frame);
}
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_ip_frame_relay_header (USHORT port_number,UNION_FRAME_RELAY_HEADER *sptr_tx_frame)
{
	enum SNAP_PROTOCOL_ID snap_protocol_id;

#if 0
	snap_protocol_id = *((enum SNAP_PROTOCOL_ID *)((ULONG) sptr_tx_frame - sizeof (USHORT)));
#else
	snap_protocol_id = *((USHORT *)((ULONG) sptr_tx_frame - sizeof (USHORT)));
#endif

	if (frame_relay.port[port_number].enable_ip_snap == TRUE)
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) -
			(ULONG) sizeof (FRAME_RELAY_SNAP_IP_HEADER));

		sptr_tx_frame->ip.control = UNNUMBERED_INFORMATION;
		sptr_tx_frame->ip.pad_byte = 0x00;
		sptr_tx_frame->ip.nlpid = 0x80;
		sptr_tx_frame->ip.oui[0] = 0x00;
		sptr_tx_frame->ip.oui[1] = 0x00;
		sptr_tx_frame->ip.oui[2] = 0x00;						
		sptr_tx_frame->ip.snap_protocol_id = snap_protocol_id;
		}
	else
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) -
			(ULONG) sizeof (FRAME_RELAY_IP_HEADER));

		sptr_tx_frame->ip_short.control = UNNUMBERED_INFORMATION;
		sptr_tx_frame->ip_short.nlpid = IP_NLPID;
		}

	return (sptr_tx_frame);
}
/****************************************************************************/
static UNION_FRAME_RELAY_HEADER *build_cisco_frame_relay_header (ULONG protocol_stack_id,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,enum BOOLEAN do_not_calculate_crc,USHORT *usptr_number_of_bytes)
{
	*usptr_number_of_bytes += (USHORT) sizeof (FRAME_RELAY_CISCO_HEADER);

	if (protocol_stack_id == frame_relay.stp_stack_id)
		{
		if (do_not_calculate_crc == FALSE)
			{
			sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) -
				(ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

			sptr_tx_frame->cisco.snap_protocol_id = SNAP_CISCO_BPDU_PROTOCOL_ID;
			}
		else
			{
			sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame - (ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

			sptr_tx_frame->cisco.snap_protocol_id = SNAP_CISCO_BRIDGED_DATA;
			}
		}
	else if (protocol_stack_id == frame_relay.ipx_stack_id)
		{
		sptr_tx_frame = (UNION_FRAME_RELAY_HEADER *) ((ULONG) sptr_tx_frame + (ULONG) sizeof (ETHERNET_HEADER) -
			(ULONG) sizeof (FRAME_RELAY_CISCO_HEADER));

		sptr_tx_frame->cisco.snap_protocol_id = SNAP_IPX_PROTOCOL_ID;
		}

	return (sptr_tx_frame);
}
/****************************************************************************/
void frame_relay_packet_transmitted (USHORT port_number)
{
	port_number -=	(USHORT) frame_relay.number_of_lan_ports;

	(*frame_relay.port[port_number].serial_driver.fptr_tx_complete) (port_number);
}
/****************************************************************************/
void send_periodic_inverse_arp_packets (void)
{
	USHORT virtual_port_number;
	IPX_PROTOCOL_ADDRESS source_protocol_address;
	IPX_PROTOCOL_ADDRESS target_protocol_address;
	ULONG ip_address;
	ULONG target_ip_address;

	/* must have similar (if not the same) type functions in your protocol stacks  */

	for (virtual_port_number = 0x0000; virtual_port_number < MAXIMUM_NUMBER_OF_PROTOCOL_STACK_VIRTUAL_PORT_NUMBERS_WITH_DLCI;
		++virtual_port_number)
		{
		if ((frame_relay.ip_dlci_table.entry[virtual_port_number].inverse_arp_enabled == TRUE) &&
			(frame_relay.ip_dlci_table.entry[virtual_port_number].address_found == FALSE) &&
			(frame_relay.ip_stack_id != ILLEGAL_STACK_ID))
			{
			ip_address = swap_long (lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,virtual_port_number,frame_relay.ip_stack_id,
				GET_PROTOCOL_ADDRESS,(ULONG) NULL));

			target_ip_address = 0x00000000L;

			send_inverse_arp_packet (frame_relay.ip_stack_id,frame_relay.ip_dlci_table.entry[virtual_port_number].dlci,
				SNAP_IP_PACKET,virtual_port_number,sizeof (ULONG),
				sizeof (FRAME_RELAY_INVERSE_ARP_HEADER) + sizeof (IP_HARDWARE_AND_PROTOCOL_ADDRESS),(BYTE *) &ip_address,
				(BYTE *) &target_ip_address,INVERSE_ARP_REQUEST,0x0000);
			}

		if ((frame_relay.ipx_dlci_table.entry[virtual_port_number].inverse_arp_enabled == TRUE) &&
			(frame_relay.ipx_dlci_table.entry[virtual_port_number].address_found == FALSE) &&
			(frame_relay.ipx_stack_id != ILLEGAL_STACK_ID))
			{
			target_protocol_address.network_number = 0x00000000L;
			target_protocol_address.node_id._ushort = 0x0000;
			target_protocol_address.node_id._ulong = 0x00000000L;

			lsl_control (PROTOCOL_STACK_VIRTUAL_PORT,virtual_port_number,frame_relay.ipx_stack_id,
				GET_PROTOCOL_ADDRESS,(ULONG) &source_protocol_address);

			send_inverse_arp_packet (frame_relay.ipx_stack_id,frame_relay.ipx_dlci_table.entry[virtual_port_number].dlci,
				SNAP_IPX_PROTOCOL_ID,virtual_port_number,sizeof (IPX_PROTOCOL_ADDRESS),
				sizeof (FRAME_RELAY_INVERSE_ARP_HEADER) + sizeof (IPX_HARDWARE_AND_PROTOCOL_ADDRESS),
				(BYTE *) &source_protocol_address,(BYTE *) &target_protocol_address,INVERSE_ARP_REQUEST,0x0000);
			}
		}
}
/*************************************************************************/
void send_inverse_arp_packet (ULONG protocol_stack_id,USHORT dlci,enum SNAP_PROTOCOL_ID protocol_id,
	USHORT virtual_port_number,BYTE protocol_address_length,USHORT size_of_packet,BYTE *bptr_source_protocol_address,
	BYTE *bptr_target_protocol_address,enum INVERSE_ARP_COMMAND command,USHORT destination_dlci)
{
	INVERSE_ARP_PACKET *sptr_inverse_arp_message;
	USHORT real_port_number;
	BYTE *bptr_address;

	protocol_stack_id <<= OFFSET_OF_STACK_ID;

	real_port_number = (USHORT) lsl_control (CONVERT_STACK_VIRTUAL_TO_REAL_PORT_NUMBER,protocol_stack_id,virtual_port_number);

	real_port_number -= (USHORT) frame_relay.number_of_lan_ports;

	sptr_inverse_arp_message = (INVERSE_ARP_PACKET *) get_a_frame_relay_send_packet (virtual_port_number,size_of_packet);

	if (sptr_inverse_arp_message == NULL)
		{
		++frame_relay.port[real_port_number].annex_d.statistics.number_of_out_of_memory_sends;

		return;
		}

 	frame_relay_printf (FRAME_RELAY_INVERSE_ARP_PRINTF,
		"Frame Relay: Send Inverse Arp DLCI %04x, Protocol ID %04x\r\n",dlci,protocol_id);

	sptr_inverse_arp_message->header.dlci._ushort = dlci;

	convert_dlci ((UNION_USEABLE_DLCI *) &sptr_inverse_arp_message->header.dlci._ushort);

	sptr_inverse_arp_message->header.control = UNNUMBERED_INFORMATION;
	sptr_inverse_arp_message->header.pad_byte = 0x00;
	sptr_inverse_arp_message->header.nlpid = 0x80;
	sptr_inverse_arp_message->header.oui[0] = 0x00;
	sptr_inverse_arp_message->header.oui[1] = 0x00;
	sptr_inverse_arp_message->header.oui[2] = 0x00;						
	sptr_inverse_arp_message->header.arp_protocol_id = SNAP_IP_ARP_PACKET;

	sptr_inverse_arp_message->header.hardware_type = FRAME_RELAY_INVERSE_ARP_HARDWARE_TYPE;
	sptr_inverse_arp_message->header.snap_protocol_id = protocol_id;
	sptr_inverse_arp_message->header.length_of_hardware_address = 2; /* we only support 2 */
	sptr_inverse_arp_message->header.length_of_protocol_address = protocol_address_length;
	sptr_inverse_arp_message->header.command = command;

	if (command == INVERSE_ARP_REQUEST)
		{
		if (protocol_id == SNAP_IPX_PROTOCOL_ID)
			{
			sptr_inverse_arp_message->hardware_and_protocol_address.ipx.target_hardware_address._ushort =
				sptr_inverse_arp_message->header.dlci._ushort;
			}
		else
			{
			sptr_inverse_arp_message->hardware_and_protocol_address.ip.target_hardware_address._ushort =
				sptr_inverse_arp_message->header.dlci._ushort;
			}
		}
	else
		{
		if (protocol_id == SNAP_IPX_PROTOCOL_ID)
			{
			sptr_inverse_arp_message->hardware_and_protocol_address.ipx.source_hardware_address._ushort =
				sptr_inverse_arp_message->header.dlci._ushort;

			sptr_inverse_arp_message->hardware_and_protocol_address.ipx.target_hardware_address._ushort =
				destination_dlci;
			}
		else
			{
			sptr_inverse_arp_message->hardware_and_protocol_address.ip.source_hardware_address._ushort =
				sptr_inverse_arp_message->header.dlci._ushort;

			sptr_inverse_arp_message->hardware_and_protocol_address.ip.target_hardware_address._ushort =
				destination_dlci;
			}
		}

	bptr_address = (BYTE *) &sptr_inverse_arp_message->hardware_and_protocol_address.ipx.source_protocol_address;

	memcpy (bptr_address,bptr_source_protocol_address,protocol_address_length);

	bptr_address = (BYTE *) bptr_address +	sptr_inverse_arp_message->header.length_of_hardware_address + protocol_address_length;

	memcpy (bptr_address,bptr_target_protocol_address,protocol_address_length);

	if (frame_relay.port[real_port_number].enabled == TRUE)
		{
		if (frame_relay.port[real_port_number].serial_driver.fptr_tx_routine != NULL)
			{
			(*frame_relay.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,
				virtual_port_number,
				(FRAME_RELAY_PACKET *)sptr_inverse_arp_message,
				size_of_packet,
				FALSE,
				FALSE,
				(void (*) (USHORT port_number,void *sptr_buffer)) frame_relay_tx_completion_routine,
				(char *)sptr_inverse_arp_message);
			}
		}
}
/*************************************************************************/
USHORT get_frame_relay_real_port_number(enum PROTOCOL_STACK_TYPE proto_type, USHORT virtual_port_number)
{
	if (frame_relay.enabled == FALSE)
		return (ILLEGAL_VIRTUAL_PORT_NUMBER);

	if ((frame_relay.ipx_stack_id != ILLEGAL_STACK_ID) && (proto_type == IPX_PROTOCOL_STACK))
		{
		return (frame_relay.number_of_lan_ports);
		}

	if ((frame_relay.ip_stack_id != ILLEGAL_STACK_ID) && (proto_type == IP_PROTOCOL_STACK))
		{
		return (frame_relay.number_of_lan_ports);
		}

	if ((frame_relay.stp_stack_id != ILLEGAL_STACK_ID) && (proto_type == SPANNING_TREE_STACK))
		{
		return (frame_relay.number_of_lan_ports);
		}

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
