#include	"defs.h"
#include <stdlib.h>
#include "fr.h"

extern ULONG mux_control (enum DEVICE_CONTROL_OPERATION command, int param0, int param1, int param2);

/****************************************************************************/
static enum TEST send_lmi_message (USHORT port_number,UNION_LMI_MESSAGE *sptr_txed_frame,USHORT number_of_bytes);
static LMI_ENQUIRY_MESSAGE *build_lmi_status_enquiry_message (USHORT port_number);
static LMI_ENQUIRY_MESSAGE *build_lmi_full_status_enquiry_message (USHORT port_number);
static void build_lmi_message_header (UNION_LMI_MESSAGE *sptr_message,
	enum LMI_STATUS_MESSAGE_TYPE status_message,
	enum LMI_REPORT_TYPE report_type,BYTE report_length);

/****************************************************************************/
static void lmi_full_status_message_rxed (USHORT port_number,UNION_LMI_MESSAGE *sptr_rxed_frame,USHORT number_of_bytes_rxed);
static void lmi_status_message_rxed (USHORT port_number,UNION_LMI_MESSAGE *sptr_rxed_frame);
static void lmi_process_full_status_response (USHORT port_number,
	LMI_RESPONSE_MESSAGE *sptr_full_status_response,USHORT number_of_bytes_rxed);
static void lmi_process_status_response (USHORT port_number,LMI_RESPONSE_MESSAGE *sptr_status_response);

/****************************************************************************/
void send_lmi_status_enquiry_message (USHORT port_number)
{
	LMI_ENQUIRY_MESSAGE *sptr_txed_frame;

	frame_relay.port[port_number].lmi.user.number_of_polling_cycles += (BYTE) 1;

	if (frame_relay.timer > (frame_relay.port[port_number].lmi.user.time_since_last_status_enquiry_message_sent +
		frame_relay.port[port_number].lmi.frUserPollingTimer))
	{
#if 0
		frame_relay.port[port_number].lmi.user.time_since_last_status_enquiry_message_sent = frame_relay.timer;

		sptr_txed_frame = build_lmi_status_enquiry_message (port_number);
		if (sptr_txed_frame == NULL)
			return;

		++frame_relay.port[port_number].lmi.statistics.stats.number_of_status_enquiries;
		frame_relay.port[port_number].lmi.user.number_of_status_enquiries_sent += (BYTE) 1;

		if (frame_relay.port[port_number].lmi.user.liv_response_received == FALSE)
		{
			frame_relay.port[port_number].lmi.total_number_of_monitored_events += (BYTE) 1;
			frame_relay.port[port_number].lmi.total_number_of_error_events += (BYTE) 1;
			frame_relay.port[port_number].lmi.user.number_of_missed_status_response_messages += (BYTE) 1;

			++frame_relay.port[port_number].lmi.statistics.number_of_missed_status_response_messages;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Missed Liv Status Enquiry Response on port %04x\n",port_number);
		}
		else
			frame_relay.port[port_number].lmi.user.liv_response_received = FALSE;

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Liv Status Enquiry on port %04x\n",port_number);

		if (frame_relay.port[port_number].lmi.user.number_of_polling_cycles <
			frame_relay.port[port_number].lmi.frEnquiryInterval)
		{
			send_lmi_message (port_number, (UNION_LMI_MESSAGE *)sptr_txed_frame, sizeof(LMI_ENQUIRY_MESSAGE));
		}
		else
		{
			frame_relay.port[port_number].lmi.tx_sequence_number -= (BYTE) 1;
			if (frame_relay.port[port_number].lmi.tx_sequence_number == 0)
				frame_relay.port[port_number].lmi.tx_sequence_number = (BYTE)0xFF;

			frame_relay_tx_completion_routine (port_number,(FRAME_RELAY_PACKET *) sptr_txed_frame);
		}
#else
		if (frame_relay.port[port_number].lmi.user.number_of_polling_cycles <
			frame_relay.port[port_number].lmi.frEnquiryInterval)
		{
			frame_relay.port[port_number].lmi.user.time_since_last_status_enquiry_message_sent = frame_relay.timer;

			sptr_txed_frame = build_lmi_status_enquiry_message (port_number);
			if (sptr_txed_frame == NULL)
				return;

			++frame_relay.port[port_number].lmi.statistics.stats.number_of_status_enquiries;
			frame_relay.port[port_number].lmi.user.number_of_status_enquiries_sent += (BYTE) 1;

			if (frame_relay.port[port_number].lmi.user.liv_response_received == FALSE)
			{
				frame_relay.port[port_number].lmi.total_number_of_monitored_events += (BYTE) 1;
				frame_relay.port[port_number].lmi.total_number_of_error_events += (BYTE) 1;
				frame_relay.port[port_number].lmi.user.number_of_missed_status_response_messages += (BYTE) 1;

				++frame_relay.port[port_number].lmi.statistics.number_of_missed_status_response_messages;

				frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Missed Liv Status Enquiry Response on port %04x\n",port_number);
			}
			else
				frame_relay.port[port_number].lmi.user.liv_response_received = FALSE;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Liv Status Enquiry on port %04x\n",port_number);

			send_lmi_message (port_number, (UNION_LMI_MESSAGE *)sptr_txed_frame, sizeof(LMI_ENQUIRY_MESSAGE));
		}
#endif
	}
}
/****************************************************************************/
void send_lmi_full_status_enquiry_message (USHORT port_number)
{
	LMI_ENQUIRY_MESSAGE *sptr_txed_frame;

	if (frame_relay.port[port_number].lmi.user.number_of_polling_cycles >=
		frame_relay.port[port_number].lmi.frEnquiryInterval)
	{
		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Tx Full Status Enquiry on port %04x\n",port_number);

		frame_relay.port[port_number].lmi.user.number_of_polling_cycles = 0x0000;

		sptr_txed_frame = build_lmi_full_status_enquiry_message (port_number);
		if (sptr_txed_frame == NULL)
			return;

		++frame_relay.port[port_number].lmi.statistics.stats.number_of_full_status_enquiries;

		send_lmi_message (port_number, (UNION_LMI_MESSAGE *)sptr_txed_frame, sizeof(LMI_ENQUIRY_MESSAGE));
	}
}
/****************************************************************************/
static enum TEST send_lmi_message (USHORT port_number,UNION_LMI_MESSAGE *sptr_tx_frame,USHORT number_of_bytes)
{
	convert_dlci ((UNION_USEABLE_DLCI *)&sptr_tx_frame->header.dlci._ushort);

	if (frame_relay.port[port_number].enabled == TRUE)
	{
		if (frame_relay.port[port_number].serial_driver.fptr_tx_routine == NULL)
			goto TxComplete;

		(*frame_relay.port[port_number].serial_driver.fptr_tx_routine) (port_number,
			port_number,
			(FRAME_RELAY_PACKET *)sptr_tx_frame,
			number_of_bytes,
			FALSE,
			FALSE,
			(void (*) (USHORT port_number,void *sptr_buffer)) frame_relay_tx_completion_routine,
			(char *)sptr_tx_frame);
	}
	else
	{
TxComplete:
		frame_relay_tx_completion_routine (port_number,(FRAME_RELAY_PACKET *) sptr_tx_frame);
	}

	return (PASS);
}
/****************************************************************************/
static LMI_ENQUIRY_MESSAGE *build_lmi_status_enquiry_message (USHORT port_number)
{
	LMI_ENQUIRY_MESSAGE *sptr_return_message;

	sptr_return_message = (LMI_ENQUIRY_MESSAGE *) get_a_frame_relay_send_packet (port_number,
		sizeof (LMI_ENQUIRY_MESSAGE));

	if (sptr_return_message != NULL)
	{
		build_lmi_message_header ((UNION_LMI_MESSAGE *)sptr_return_message,
			STATUS_ENQUIRY_MESSAGE, SEQ_NUMBERS_EXCHANGE_REPORT,
			sizeof(sptr_return_message->header.report.type));

		sptr_return_message->sequence.id = KEEP_ALIVE_SEQUENCE_ID;
		sptr_return_message->sequence.length =
			sizeof (sptr_return_message->sequence.tx_sequence_number) +
			sizeof (sptr_return_message->sequence.rx_sequence_number);

		frame_relay.port[port_number].lmi.tx_sequence_number += (BYTE) 1;

		/* In LMI, '0' sequence number has to be skipped */
		if (frame_relay.port[port_number].lmi.tx_sequence_number == 0)
			frame_relay.port[port_number].lmi.tx_sequence_number = 1;

		sptr_return_message->sequence.tx_sequence_number =
			frame_relay.port[port_number].lmi.tx_sequence_number;

		sptr_return_message->sequence.rx_sequence_number =
			frame_relay.port[port_number].lmi.rx_sequence_number;
	}

	return (sptr_return_message);
}
/****************************************************************************/
static LMI_ENQUIRY_MESSAGE *build_lmi_full_status_enquiry_message (USHORT port_number)
{
	LMI_ENQUIRY_MESSAGE *sptr_return_message;

	sptr_return_message = (LMI_ENQUIRY_MESSAGE *) get_a_frame_relay_send_packet (port_number,
		sizeof (LMI_ENQUIRY_MESSAGE));

	if (sptr_return_message != NULL)
	{
		build_lmi_message_header ((UNION_LMI_MESSAGE *)sptr_return_message,
			STATUS_ENQUIRY_MESSAGE, FULL_STATUS_MESSAGE_REPORT,
			sizeof (sptr_return_message->header.report.type));

		sptr_return_message->sequence.id = KEEP_ALIVE_SEQUENCE_ID;
		sptr_return_message->sequence.length =
			sizeof (sptr_return_message->sequence.tx_sequence_number) +
			sizeof (sptr_return_message->sequence.rx_sequence_number);

		frame_relay.port[port_number].lmi.tx_sequence_number += (BYTE) 1;

		/* In LMI, '0' sequence number has to be skipped */
		if (frame_relay.port[port_number].lmi.tx_sequence_number == 0)
			frame_relay.port[port_number].lmi.tx_sequence_number = 1;

		sptr_return_message->sequence.tx_sequence_number =
			frame_relay.port[port_number].lmi.tx_sequence_number;

		sptr_return_message->sequence.rx_sequence_number =
			frame_relay.port[port_number].lmi.rx_sequence_number;
	}

	return (sptr_return_message);
}
/****************************************************************************/
static void build_lmi_message_header (UNION_LMI_MESSAGE *sptr_message,
	enum LMI_STATUS_MESSAGE_TYPE status_message,
	enum LMI_REPORT_TYPE report_type, BYTE report_length)
{
	sptr_message->header.dlci._ushort = LMI_DLCI;
	sptr_message->header.unnumbered_frame_info = UNNUMBERED_INFORMATION;
	sptr_message->header.protocol_discriminator = LMI_DISCRIMINATOR;
	sptr_message->header.call_reference = 0x00;
	sptr_message->header.status_message = status_message;
	sptr_message->header.report.id = REPORT_TYPE_ID;
	sptr_message->header.report.length = report_length;
	sptr_message->header.report.type = report_type;
}
/****************************************************************************/
enum RX_PACKET_STATE lmi_frame_received (USHORT port_number,
	UNION_LMI_MESSAGE *sptr_rxed_frame, USHORT number_of_bytes_rxed)
{
	switch (sptr_rxed_frame->header.report.type)
	{
		case FULL_STATUS_MESSAGE_REPORT:
			lmi_full_status_message_rxed (port_number,sptr_rxed_frame,number_of_bytes_rxed);
			break;
		case SEQ_NUMBERS_EXCHANGE_REPORT:
			lmi_status_message_rxed (port_number,sptr_rxed_frame);
			break;
		default:
			++frame_relay.port[port_number].lmi.statistics.number_of_illegal_report_types_rxed;
			break;
	}

	return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
}
/****************************************************************************/
static void lmi_full_status_message_rxed (USHORT port_number,UNION_LMI_MESSAGE *sptr_rxed_frame,USHORT number_of_bytes_rxed)
{
	if (frame_relay.port[port_number].lmi.user.enabled == TRUE)
	{
		if (sptr_rxed_frame->header.status_message == STATUS_MESSAGE)
		{
			++frame_relay.port[port_number].lmi.statistics.stats.number_of_full_status_responses;

			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Full Status Response received on port %04x\n",port_number);

			lmi_process_full_status_response (port_number,&sptr_rxed_frame->full_status_response,number_of_bytes_rxed);
		}
	}
}
/****************************************************************************/
static void lmi_status_message_rxed (USHORT port_number,UNION_LMI_MESSAGE *sptr_rxed_frame)
{
	if (frame_relay.port[port_number].lmi.user.enabled == TRUE)
	{
		if (sptr_rxed_frame->header.status_message == STATUS_MESSAGE)
		{
			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Liv Status Response received on port %04x\n",port_number);

			++frame_relay.port[port_number].lmi.statistics.stats.number_of_status_responses;

			lmi_process_status_response (port_number,&sptr_rxed_frame->full_status_response);
		}
	}
}
/****************************************************************************/
static void lmi_process_full_status_response (USHORT port_number,LMI_RESPONSE_MESSAGE *sptr_full_status_response,
	USHORT number_of_bytes_rxed)
{
	USHORT dlci;
	USHORT pvc_index;
	USHORT number_of_pvcs_rxed;
	DLCI_LIST_ENTRY *sptr_current_connection_entry;
	LMI_PVC_STATUS_INFORMATION_ELEMENT *sptr_pvc_status_array;

	lsl_control (LSL_PORT,port_number,TRUE);

	pvc_index = 0x0000;

	sptr_pvc_status_array = &sptr_full_status_response->pvc_status[0];

	number_of_pvcs_rxed = (USHORT) ((number_of_bytes_rxed - sizeof (LMI_HEADER) - sizeof (LMI_KEEP_ALIVE_SEQUENCE_IE))/
		sizeof (LMI_PVC_STATUS_INFORMATION_ELEMENT));

	while ((pvc_index < number_of_pvcs_rxed) && (pvc_index < NUMBER_OF_FRAME_RELAY_PVCS) && (number_of_pvcs_rxed != 0x0000))
	{
		dlci = get_lmi_ushort_dlci (sptr_pvc_status_array->dlci);

		frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: PVC for dlci %04x\n",dlci);

		sptr_current_connection_entry = get_dlci_connection_entry (port_number,dlci);

		if (sptr_current_connection_entry != NULL)
		{
			if ((sptr_pvc_status_array->type._bit.active == TRUE) &&
				sptr_current_connection_entry->mib.frCircuitState == INACTIVE_FRAME_RELAY_CIRCUIT_STATE)
			{
				sptr_current_connection_entry->mib.frCircuitState = ACTIVE_FRAME_RELAY_CIRCUIT_STATE;
				printf ("FR: PVC with DLCI - %d, became active\r\n", dlci);
				sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;

#ifdef MUX
				mux_control (LOWER_DEVICE_DRIVER_UP, port_number, dlci, 0);
#endif
				sptr_current_connection_entry->stop_sending = FALSE;
			}
			else if ((sptr_pvc_status_array->type._bit.active == FALSE) &&
				sptr_current_connection_entry->mib.frCircuitState == ACTIVE_FRAME_RELAY_CIRCUIT_STATE)
			{
				sptr_current_connection_entry->mib.frCircuitState = INACTIVE_FRAME_RELAY_CIRCUIT_STATE;
				printf ("FR: PVC with DLCI - %d, became Inactive\r\n", dlci);
				sptr_current_connection_entry->mib.frCircuitLastTimeChange = frame_relay.timer;
#ifdef DLCI_STATS
				sptr_current_connection_entry->dlci_down_count++;
#endif

#ifdef MUX
				reset_mux_raw_dlci (dlci);
#endif
#ifdef FR_COMP
				reset_compression_on_dlci (dlci);
#endif
				sptr_current_connection_entry->stop_sending = TRUE;
#ifdef MUX
				mux_control (LOWER_DEVICE_DRIVER_DOWN, port_number, dlci, 0);
#endif
			}

			sptr_current_connection_entry->new = (enum BOOLEAN) sptr_pvc_status_array->type._bit.new;
		}
		else
		{
			frame_relay_printf (FRAME_RELAY_DATA_PRINTF,"Frame Relay: Created New Connection Entry for dlci %04x\n",dlci);

			create_dlci_connection_entry (port_number,dlci,(enum BOOLEAN) sptr_pvc_status_array->type._bit.active,
				(enum BOOLEAN) sptr_pvc_status_array->type._bit.new);

			get_dlci_connection_entry (port_number,dlci);
		}

		set_protocol_stacks_virtual_port (dlci,(enum BOOLEAN) sptr_pvc_status_array->type._bit.active);

		++sptr_pvc_status_array;
		++pvc_index;
	}

	if (sptr_full_status_response->sequence.tx_sequence_number !=
		(BYTE) frame_relay.port[port_number].lmi.rx_sequence_number + 1)
	{
		++frame_relay.port[port_number].lmi.statistics.number_of_sequence_number_errors;

		frame_relay.port[port_number].lmi.total_number_of_error_events += (BYTE) 1;
	}

	frame_relay.port[port_number].lmi.rx_sequence_number =
		sptr_full_status_response->sequence.tx_sequence_number;
}
/****************************************************************************/
static void lmi_process_status_response (USHORT port_number,LMI_RESPONSE_MESSAGE *sptr_status_response)
{
	frame_relay.port[port_number].lmi.user.number_of_status_responses_rxed += (BYTE) 1;
	frame_relay.port[port_number].lmi.total_number_of_monitored_events += (BYTE) 1;

	if (sptr_status_response->sequence.tx_sequence_number !=
		(BYTE) frame_relay.port[port_number].lmi.rx_sequence_number + 1)
	{
		++frame_relay.port[port_number].lmi.statistics.number_of_sequence_number_errors;

		frame_relay.port[port_number].lmi.total_number_of_error_events += (BYTE) 1;
	}

	frame_relay.port[port_number].lmi.rx_sequence_number =
		sptr_status_response->sequence.tx_sequence_number;

	if (frame_relay.port[port_number].lmi.user.liv_response_received == FALSE)
	{
		frame_relay.port[port_number].lmi.user.liv_response_received = TRUE;
	}
}
/****************************************************************************/
USHORT get_lmi_ushort_dlci (UNION_LMI_DLCI lmi_format_dlci)
{
	USHORT	dlci = 0x0000;

	dlci = lmi_format_dlci._bit.dlci_lsb;
	dlci |= (lmi_format_dlci._bit.dlci_msb << 8);

	return (dlci);
}
