/*	$Modname: vfrstr.h$  $version: 1.25$      $date: 04/21/95$   */
/*
* 	$lgb$
1.0 05/14/92 ross
1.1 07/28/92 ross
1.2 10/27/92 ross
1.3 12/09/92 ross adding support for SNMP
1.4 12/27/92 ross
1.5 01/02/93 ross
1.6 01/02/93 ross
1.7 01/10/93 ross changing to symmetric dlci's - IBM way
1.8 01/17/93 ross added function to store ipx dlci
1.9 01/23/93 ross moved lsl code into frtx and frrx
1.10 01/27/93 ross fixed a cisco encap format bug and took out pad bytes for other router vendors
1.11 01/27/93 ross changed ethernet_header to ethernet
1.12 01/30/93 ross removed stack calls from ipx and stp
1.13 02/07/93 ross added external call to check for cisco encapsulation.
1.14 10/11/93 ross update for changes in LSL, changed some CRC handling.
1.15 12/03/93 ross fixes for lsl version 3.0
1.16 02/01/94 ross put ifdef wrapper around wan crc.
1.17 02/27/94 ross added support for new ip
1.18 03/01/94 ross testing with cisco frame relay and pacific bell.
1.19 03/19/94 ross fixes for cisco conformance testing
1.20 03/27/94 ross added inverse arp, frutil.c, rfc1315 naming, and serial device driver function pointers.
1.21 05/02/94 ross more inverse arp fixes.
1.22 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.23 08/17/94 ross fixes for dlci up/down effects on virtual ports
1.24 01/12/95 ross added USHORT and BYTE_ENUM.
1.25 04/21/95 ross Increased size of stack_id.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

typedef	struct	STACK_NAME_ARRAY
{
	char						name[30];

	ULONG						*usptr_stack_id;

} STACK_NAME_ARRAY;

typedef	struct	FRAME_RELAY_STATISTICS
{
	ULONG	number_of_tx_frames;
	ULONG	number_of_tx_bytes;
	ULONG	number_of_tx_frames_discarded;
	ULONG	number_of_unknown_dlcis;
	ULONG	number_of_illegal_dlcis;
	ULONG	number_rxed_greater_than_maximum_size;
	ULONG	number_rxed_less_than_minumum_size;
	ULONG	number_rxed_in_disabled_port;
	ULONG	number_txed_on_disabled_port;
	ULONG	number_of_rx_frames;
	ULONG	number_of_rx_bytes;
	ULONG	number_of_rx_frames_discarded;

	ULONG	number_of_invalid_ipx_frames; /* temporary */

} FRAME_RELAY_STATISTICS;

typedef	struct	ANNEX_D_TX_RX_STATISTICS
{
	ULONG	number_of_liv_status_enquiries;		   
	ULONG number_of_liv_status_responses;		  
	ULONG number_of_full_status_enquiries; 
	ULONG number_of_full_status_responses;	  
	ULONG number_of_async_status_enquiries; 
	ULONG number_of_async_status_responses;	  

} ANNEX_D_TX_RX_STATISTICS;

typedef struct ANNEX_D_STATISTICS
{
	ANNEX_D_TX_RX_STATISTICS	tx;
	ANNEX_D_TX_RX_STATISTICS	rx;

	ULONG  							number_of_sequence_number_errors;
	ULONG  							number_of_illegal_report_types_rxed;			 
	ULONG  							number_of_missed_status_enquiry_messages;
	ULONG  							number_of_missed_status_response_messages;
	ULONG  							number_of_link_ups;		  
	ULONG  							number_of_link_downs;		  
	ULONG								number_of_out_of_memory_sends;

	FRAME_RELAY_STATISTICS		general;

} ANNEX_D_STATISTICS;				

typedef	struct	LMI_TX_RX_STATISTICS
{
	ULONG	number_of_status_enquiries;		   
	ULONG number_of_status_responses;		  
	ULONG number_of_full_status_enquiries; 
	ULONG number_of_full_status_responses;	  

} LMI_TX_RX_STATISTICS;

typedef struct LMI_STATISTICS
{
	LMI_TX_RX_STATISTICS		stats;

	ULONG  						number_of_sequence_number_errors;
	ULONG  						number_of_illegal_report_types_rxed;			 
	ULONG  						number_of_missed_status_enquiry_messages;
	ULONG  						number_of_missed_status_response_messages;
	ULONG  						number_of_link_ups;		  
	ULONG  						number_of_link_downs;		  
	ULONG							number_of_out_of_memory_sends;

	FRAME_RELAY_STATISTICS	general;

} LMI_STATISTICS;				

typedef	struct	USER_CLASS
{
	BYTE_ENUM (BOOLEAN) 	enabled;
	enum BOOLEAN 	liv_response_received;

	BYTE				number_of_status_enquiries_sent;
	BYTE				number_of_status_responses_rxed;
	BYTE				number_of_polling_cycles;

	BYTE				number_of_missed_status_response_messages;
	ULONG				time_since_last_status_enquiry_message_sent;		  

} USER_CLASS;

typedef	struct	NETWORK_CLASS
{
	BYTE_ENUM 	(BOOLEAN) 	enabled;

	BYTE				number_of_missed_status_enquiry_messages;

	ULONG				time_since_last_status_enquiry_message_received;		  

} NETWORK_CLASS;

typedef struct ANNEX_D_CLASS
{
	BYTE_ENUM 	(BOOLEAN) 			enabled;		 							

	NETWORK_CLASS						network;
	USER_CLASS							user;

	enum FRAME_RELAY_LINK_STATE	link_state;

	BYTE									tx_sequence_number;
	BYTE									rx_sequence_number;

	BYTE									total_number_of_monitored_events;
	BYTE									total_number_of_error_events;

	BYTE									frDlcmiFullEnquiryInterval;			/* 1 - 255 values valid */
	BYTE									frDlcmiErrorThreshold;				  	/* 1 - 10 values valid */
	BYTE									frDlcmiMonitoredEvents;				  	/* 1 - 10 values valid */		
	BYTE									frDlcmiPollingInterval;				  	/* 5 - 30 values valid */
	USHORT								polling_verification_timer_T392;				  			

	ANNEX_D_STATISTICS				statistics;

} ANNEX_D_CLASS;

typedef struct LMI_CLASS
{
	BYTE_ENUM 	(BOOLEAN) 			enabled;		 							

	USER_CLASS							user;

	enum FRAME_RELAY_LINK_STATE	link_state;

	BYTE									tx_sequence_number;
	BYTE									rx_sequence_number;

	BYTE									total_number_of_monitored_events;
	BYTE									total_number_of_error_events;

	BYTE									frEnquiryInterval;
	BYTE									frErrorThreshold;
	BYTE									frMonitoredEvents;
	BYTE									frUserPollingTimer;
	BYTE									frNetworkFrequencyInterval;

	LMI_STATISTICS						statistics;

} LMI_CLASS;

typedef	struct	DLCI
{
#ifndef BIG_ENDIAN
	unsigned int	extended_address:1;
	unsigned int	command_or_response:1;
	unsigned int	dlci_msb:6;

	unsigned int	extended_address_1:1;
	unsigned int	discard_eligibility:1;
#if 0
	/* AMAZING !! RouterWare defined these two bits, just the other way */
	unsigned int	forward_explicit_congestion_notification:1;
	unsigned int	backward_explicit_congestion_notification:1;
#else
	unsigned int	backward_explicit_congestion_notification:1;
	unsigned int	forward_explicit_congestion_notification:1;
#endif
	unsigned int	dlci_lsb:4;
#else
	unsigned int	dlci_msb:6;
	unsigned int	command_or_response:1;
	unsigned int	extended_address:1;

	unsigned int	dlci_lsb:4;
#if 0
	/* AMAZING !! RouterWare defined these two bits, just the other way */
	unsigned int	backward_explicit_congestion_notification:1;
	unsigned int	forward_explicit_congestion_notification:1;
#else
	unsigned int	forward_explicit_congestion_notification:1;
	unsigned int	backward_explicit_congestion_notification:1;
#endif
	unsigned int	discard_eligibility:1;
	unsigned int	extended_address_1:1;
#endif

} DLCI;

typedef	union	UNION_DLCI
{
	DLCI		_bit;
	USHORT	_ushort;

} UNION_DLCI;

typedef	struct	USEABLE_DLCI
{
#ifndef BIG_ENDIAN
	unsigned int	dlci_lsb:4;
	unsigned int	dlci_msb:6;

	unsigned int	filler:6;
#else
	unsigned int	filler:6;

	unsigned int	dlci_msb:6;
	unsigned int	dlci_lsb:4;
#endif

} USEABLE_DLCI;

typedef	union	UNION_USEABLE_DLCI
{
	USEABLE_DLCI	_bit;
	USHORT			_ushort;

} UNION_USEABLE_DLCI;

typedef	struct	DLCI_LIST_ENTRY_LINK
{
	struct	DLCI_LIST_ENTRY	*sptr_forward_link;
	struct	DLCI_LIST_ENTRY	*sptr_backward_link;

} DLCI_LIST_ENTRY_LINK;

#ifndef WAN_CRC_DEFINED

#define WAN_CRC_DEFINED

typedef	struct	WAN_CRC
{
	USHORT crc;

} WAN_CRC;

#endif

typedef	struct	DLCI_RFC1315_MIB
{
#if 0	/* temporary SNMP fix */
	ULONG									frCircuitIfIndex;

	ULONG									frCircuitDlci;
#else
	BYTE									frCircuitIfIndex;

	BYTE									frCircuitDlci;
#endif

	ULONG_ENUM (FR_CIRCUIT_STATE)	frCircuitState;

	ULONG 								frCircuitReceivedFECNs;
   ULONG 								frCircuitReceivedBECNs;
   ULONG 								frCircuitSentFrames;
   ULONG 								frCircuitSentOctets;
   ULONG 								frCircuitReceivedFrames;
   ULONG 								frCircuitReceivedOctets;
   ULONG 								frCircuitCreationTime;
   ULONG 								frCircuitLastTimeChange;
   ULONG 								frCircuitCommittedBurst;
   ULONG 								frCircuitExcessBurst;
   ULONG 								frCircuitThroughput;

} DLCI_RFC1315_MIB;

/* KVSP */

#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;

} LINK;

#endif

typedef	struct	WAN_TX_DESCRIPTOR
{
	LINK					links;

	ULONG 				protocol_stack_id;

	USHORT 				real_port_number;

	USHORT 				virtual_port_number;

	BYTE  				*sptr_tx_frame;

	USHORT 				number_of_bytes;

	enum BOOLEAN 		do_not_calculate_crc;

	enum BOOLEAN 		device_driver_buffer;

	void 					(*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer);

} WAN_TX_DESCRIPTOR;

/* KVSP */

typedef struct DLCI_TRAFFIC {
	ULONG		IP_data;
	ULONG		IPX_data;
	ULONG		STP_data;
	ULONG		Channel_1_data;
	ULONG		Channel_2_data;
	ULONG		Other_data;
} DLCI_TRAFFIC;

typedef struct DLCI_STATISTICS {
	USHORT			dlci;
	BYTE				dlci_state;		/* active - 1, inactive - 0 */
	ULONG				thruput;			/* bytes/sec */

	ULONG				BECNS_received;
	ULONG				FECNS_received;

	USHORT			dlci_down_count;
	ULONG				dlci_uptime;

	DLCI_TRAFFIC	bytes_sent;
	DLCI_TRAFFIC	frames_sent;

	DLCI_TRAFFIC	bytes_received;
	DLCI_TRAFFIC	frames_received;

	BYTE				reserved[15];

} DLCI_STATISTICS;

typedef struct MANAGEMENT_STATISTICS {
	BYTE		management_type;
	ULONG		status_enquiries_sent;
	ULONG		status_responses_received;
	ULONG		full_status_enquiries_sent;
	ULONG		full_status_responses_received;
	ULONG		number_of_missed_status_responses;
	ULONG		number_of_sequence_number_errors;
	ULONG		number_of_link_ups;
	ULONG		number_of_link_downs;
} MANAGEMENT_STATISTICS;

typedef struct DLCI_LIST_ENTRY
{
	DLCI_LIST_ENTRY_LINK				links;

	USHORT								dlci; /* please note this name is not changed to frCircuitDlci */

	enum BOOLEAN						new;

	USHORT								mode;	/* adhere to CIR, CIR+Be or ASAP */

	ULONG									CIR;	/* Committed burst rate */
	ULONG									Be;	/* Excess burst rate */

	ULONG									committed_burst_size;	/* in bytes over Tc */
	ULONG									excess_burst_size;		/* in bytes over Tc */

	ULONG									start_time_of_measurement_interval;
	ULONG									bytes_sent_in_this_interval;

	ULONG									access_rate;		/* in bytes */
	ULONG									current_rate;		/* in bytes */
	ULONG									minimum_rate;		/* in bytes */
	ULONG									step_up_rate;		/* in bytes */
	ULONG									step_down_rate;	/* in bytes */

	enum BOOLEAN						stop_sending;

	enum BOOLEAN						BECN_set;
	enum BOOLEAN						FECN_set;

	USHORT								BECN_count;

	WAN_TX_DESCRIPTOR					tx_free_list;
	WAN_TX_DESCRIPTOR					tx_wait_list;

	WAN_TX_DESCRIPTOR					*wan_tx_buffers;

	DLCI_RFC1315_MIB					mib;

	USHORT								ipx_virtual_port_number;
	USHORT								ip_virtual_port_number;
	USHORT								stp_virtual_port_number;

	/* compression related variables - KVSP */
	enum BOOLEAN						compression;		/* enabled or disabled */
	BYTE									bsd_context_id;	/* context indentifier */
	BYTE									mode_1_state;		/* state of operation */
	BYTE									p_retry_count;
	BYTE									p_retry_timer;
	BYTE									tx_sequence_number;
	BYTE									rx_sequence_number;
	BYTE									sent_control_code;
	BYTE									got_control_code;
	enum BOOLEAN						sent_reset_ack;
	enum BOOLEAN						waiting_for_reset_ack;
	USHORT								wait_timer;

	/* DLCI specific statistics */
	USHORT								dlci_down_count;
	ULONG									dlci_uptime;
	ULONG									bytes_sent_till_last_sec;
	ULONG									thruput;
	DLCI_TRAFFIC						bytes_sent;
	DLCI_TRAFFIC						frames_sent;
	DLCI_TRAFFIC						bytes_received;
	DLCI_TRAFFIC						frames_received;

} DLCI_LIST_ENTRY;

typedef	struct	FRAME_RELAY_IPX_HEADER
{
	UNION_DLCI								dlci;
	BYTE										control;
	BYTE										pad_byte;

	BYTE										nlpid;
	BYTE										oui[3];
	USHORT_ENUM (SNAP_PROTOCOL_ID) 	snap_protocol_id;

} FRAME_RELAY_IPX_HEADER;

typedef	struct	FRAME_RELAY_IP_HEADER
{
	UNION_DLCI								dlci;
	BYTE										control;
	BYTE										nlpid;

} FRAME_RELAY_IP_HEADER;

typedef	struct	FRAME_RELAY_SNAP_IP_HEADER
{
	UNION_DLCI								dlci;
	BYTE										control;
	BYTE										pad_byte;

	BYTE										nlpid;
	BYTE										oui[3];
	USHORT_ENUM (SNAP_PROTOCOL_ID) 	snap_protocol_id;

} FRAME_RELAY_SNAP_IP_HEADER;

typedef	struct	FRAME_RELAY_STP_HEADER
{
	UNION_DLCI								dlci;
	BYTE										control;
	BYTE										pad_byte;

	BYTE										nlpid;
	BYTE										oui[3];
	USHORT_ENUM (SNAP_PROTOCOL_ID) 	snap_protocol_id;

} FRAME_RELAY_STP_HEADER;

typedef	struct	FRAME_RELAY_SNAP_HEADER
{
	BYTE										oui[3];
	USHORT_ENUM (SNAP_PROTOCOL_ID) 	snap_protocol_id;

} FRAME_RELAY_SNAP_HEADER;

typedef	struct	FRAME_RELAY_CISCO_HEADER
{
	UNION_DLCI								dlci;
	USHORT_ENUM (SNAP_PROTOCOL_ID) 	snap_protocol_id;

} FRAME_RELAY_CISCO_HEADER;

typedef	struct	FRAME_RELAY_GENERIC_HEADER
{
	UNION_DLCI	dlci;
	BYTE			control;

} FRAME_RELAY_GENERIC_HEADER;

typedef	struct	FRAME_RELAY_INVERSE_ARP_HEADER
{
	UNION_DLCI									dlci;
	BYTE											control;
	BYTE											pad_byte;

	BYTE											nlpid;
	BYTE											oui[3];
	USHORT_ENUM (SNAP_PROTOCOL_ID) 		arp_protocol_id;

	USHORT										hardware_type; /* 0x000f */
	USHORT_ENUM (SNAP_PROTOCOL_ID) 		snap_protocol_id;
	BYTE											length_of_hardware_address;
	BYTE											length_of_protocol_address;
	USHORT_ENUM (INVERSE_ARP_COMMAND)	command;

} FRAME_RELAY_INVERSE_ARP_HEADER;

/* added by KVSP to support data MUXing */
/* using Q.933 packet type under UI frame for encapsulating */

#define	Q933_NLPID				0x08
#define	MULTITECH_MUX_PID		0xA55A		/* used for layer 2 ID */
#define	USER_SPECIFIED_PID	0x7000		/* used for layer 3 ID */

typedef	struct	FRAME_RELAY_MUX_HEADER {
	UNION_DLCI				dlci;					/* Q.922 address */
	BYTE						control;				/* 0x03 - control (UI) */
	BYTE						nlpid;				/* 0x08 - NLPID */

	USHORT					L2_protocol_id;	/* Layer 2 protocol ID */
	USHORT					L3_protocol_id;	/* Layer 3 protocol ID */

} FRAME_RELAY_MUX_HEADER;

typedef	union	UNION_FRAME_RELAY_HEADER
{
	ETHERNET_HEADER				ethernet;
	TOKEN_RING_MAC_HEADER		token_ring;
	FRAME_RELAY_GENERIC_HEADER	generic;
	FRAME_RELAY_IPX_HEADER		ipx;
	FRAME_RELAY_SNAP_IP_HEADER	ip;
	FRAME_RELAY_IP_HEADER		ip_short;
	FRAME_RELAY_STP_HEADER		stp;
	FRAME_RELAY_CISCO_HEADER	cisco;
	FRAME_RELAY_MUX_HEADER		mux;

} UNION_FRAME_RELAY_HEADER;

typedef	struct	FRAME_RELAY_PACKET
{
	UNION_FRAME_RELAY_HEADER	header;
	BYTE 								data[MAXIMUM_FRAME_SIZE];

} FRAME_RELAY_PACKET;

typedef	struct	RFC1315_ERROR_TABLE
{
#if 0	/* temporary SNMP fix */
	ULONG									frErrIfIndex;
#else
	BYTE									frErrIfIndex;
#endif
	enum FRAME_RELAY_ALARM_TYPE 	frErrType;
#if 0	/* KVSP - the order of entries in table has been changed */
	ULONG 								frErrTime;	  							
	BYTE									length;							
	BYTE									frErrData[NUMBER_OF_ERROR_BYTES]; 	   
#else
	BYTE									frErrData[NUMBER_OF_ERROR_BYTES]; 	   
	ULONG 								frErrTime;	  							
	BYTE									length;							
#endif

} RFC1315_ERROR_TABLE;

typedef	struct	SERIAL_DRIVER_CLASS
{
	char							name[20];

	enum SERIAL_DRIVER_TYPE	type;

	enum TEST 					(*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN device_driver_buffer,
		void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer), void *vptr_free_buffer);

	void 							(*fptr_tx_complete) (USHORT port_number);

	enum BOOLEAN 				(*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed);

	void 							(*fptr_timer_routine) (void);

	enum TEST 					(*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,ULONG parameter_1);

	void 							(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer);

} SERIAL_DRIVER_CLASS;

typedef	struct	IP_HARDWARE_AND_PROTOCOL_ADDRESS
{
	UNION_DLCI	source_hardware_address;
	ULONG		 	source_protocol_address;
	UNION_DLCI	target_hardware_address;
	ULONG		 	target_protocol_address;

} IP_HARDWARE_AND_PROTOCOL_ADDRESS;

typedef	struct	IPX_PROTOCOL_ADDRESS
{
	ULONG 		network_number;
	MAC_ADDRESS	node_id;

} IPX_PROTOCOL_ADDRESS;

typedef	struct	IPX_HARDWARE_AND_PROTOCOL_ADDRESS
{
	UNION_DLCI				source_hardware_address;
	IPX_PROTOCOL_ADDRESS	source_protocol_address;
	UNION_DLCI				target_hardware_address;
	IPX_PROTOCOL_ADDRESS	target_protocol_address;

} IPX_HARDWARE_AND_PROTOCOL_ADDRESS;

typedef	union	UNION_HARDWARE_AND_PROTOCOL_ADDRESSES
{
	IPX_HARDWARE_AND_PROTOCOL_ADDRESS	ipx;
	IP_HARDWARE_AND_PROTOCOL_ADDRESS		ip;

} UNION_HARDWARE_AND_PROTOCOL_ADDRESSES;

typedef	struct	INVERSE_ARP_PACKET
{
	FRAME_RELAY_INVERSE_ARP_HEADER			header;

	UNION_HARDWARE_AND_PROTOCOL_ADDRESSES	hardware_and_protocol_address;

} INVERSE_ARP_PACKET;

typedef	struct	MIB_RFC1315
{
#if 0	/* temporary SNMP fix */
	ULONG								frDlcmiIfIndex;
#else
	BYTE								frDlcmiIfIndex;
#endif

	enum FR_DLCMI_STATE			frDlcmiState;
	enum FR_DLCMI_ADDRESS		frDlcmiAddress;
	enum FR_DLCMI_ADDRESS_LEN	frDlcmiAddressLen;

	ULONG								frDlcmiMaxSupportedVCs;

	enum FR_DLCMI_MULTICAST		frDlcmiMulticast;

#if 0	/* KVSP - these SNMP variables are supposed to be per DLCI */
		/* no need to have them defined here */
	ULONG								frCircuitCommittedBurst; /* used by each dlci allocated for port */
	ULONG								frCircuitExcessBurst;
	ULONG								frCircuitThroughput;
#endif

} MIB_RFC1315;

typedef	struct	FRAME_RELAY_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN) 				enabled;
	enum ENCAPSULATION_TYPE			encapsulation_type;

	USHORT								maximum_frame_size;
	USHORT								minimum_frame_size;

	ULONG 								port_speed;

	RFC1315_ERROR_TABLE				last_error_packet;

	BYTE_ENUM (BOOLEAN) 				enable_ip_snap;		 							

	ANNEX_D_CLASS						annex_d;

	LMI_CLASS							lmi;

	USHORT								management_type;

	DLCI_LIST_ENTRY_LINK				dlci_list;

	USHORT								port_number;

	USHORT								number_of_current_dlcis;

	ULONG									device_driver_id;

	SERIAL_DRIVER_CLASS				serial_driver;

	MIB_RFC1315							mib;

	FRAME_RELAY_STATISTICS			statistics;

} FRAME_RELAY_PORT_CLASS;

typedef	struct	PROTOCOL_STACK_DLCI_ENTRY
{
	BYTE_ENUM 	(BOOLEAN)	inverse_arp_enabled;
	enum BOOLEAN				address_found;

	USHORT						dlci;

	ULONG							network_number;
	MAC_ADDRESS					node_id;			 /* here strictly for Novell */

} PROTOCOL_STACK_DLCI_ENTRY;

typedef	struct	PROTOCOL_STACK_DLCI_TABLE
{
	PROTOCOL_STACK_DLCI_ENTRY			entry[MAXIMUM_NUMBER_OF_PROTOCOL_STACK_VIRTUAL_PORT_NUMBERS_WITH_DLCI];

} PROTOCOL_STACK_DLCI_TABLE;

typedef	struct	FRAME_RELAY_CLASS
{
	ULONG								total_number_of_frame_relay_ports;
	ULONG								total_number_of_dlci_connections;
	ULONG 							number_of_lan_ports;

	FRAME_RELAY_PORT_CLASS		port[NUMBER_OF_FRAME_RELAY_PORTS];

	enum BOOLEAN					enabled;
	BYTE_ENUM	(BOOLEAN) 		printing_enabled;

	BYTE_ENUM	(BOOLEAN)		memory_printing_enabled;
	BYTE_ENUM	(BOOLEAN)		alarm_printing_enabled;
	BYTE_ENUM	(BOOLEAN)		snmp_printing_enabled;
	BYTE_ENUM	(BOOLEAN)		data_printing_enabled;
	BYTE_ENUM	(BOOLEAN)		inverse_arp_printing_enabled;
	BYTE_ENUM	(BOOLEAN)		tunnel_printing_enabled;

	USHORT							inverse_arp_timer;
	USHORT							current_arp_timer;

	ULONG								timer;

	ULONG								clock_ticks_per_second;
	ULONG								_1_second_counter;

	USHORT							CIR_interval;	/* in ms */
	USHORT							CIR_ticks;		/* no.of ms ticks */
	ULONG								CIR_timer;		/* time in ticks of interval */
	enum BOOLEAN					check_CIR_timeout;

	ULONG								stp_stack_id;
	PROTOCOL_STACK_DLCI_TABLE	stp_dlci_table;

	ULONG								ipx_stack_id;
	PROTOCOL_STACK_DLCI_TABLE	ipx_dlci_table;

	ULONG								source_routing_stack_id;
	PROTOCOL_STACK_DLCI_TABLE	source_routing_dlci_table;

	ULONG								ip_stack_id;
	PROTOCOL_STACK_DLCI_TABLE	ip_dlci_table;

	void 								(*fptr_alarm_function) (enum FRAME_RELAY_ALARM_TYPE error_type,
											USHORT port_number,ULONG parameter_1,ULONG parameter_2);

	void 								(*fptr_snmp_trap_function) (ULONG index,USHORT dlci,enum FR_CIRCUIT_STATE state);
} FRAME_RELAY_CLASS;

/* frinit.c */

void frame_relay_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer);
void set_protocol_stacks_virtual_port (USHORT dlci,enum BOOLEAN up_or_down);
void set_inverse_arp_protocol_stack_virtual_port (USHORT dlci,enum BOOLEAN up_or_down,void *vptr_protocol_address,
	enum PROTOCOL_STACK_TYPE protocol_stack_type);
void check_for_inverse_arp_packets_to_send (void);

/* frtx.c */

enum TEST send_frame_relay_frame (ULONG protocol_stack_id,USHORT real_port_number,USHORT virtual_port_number,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer));

enum TEST queue_frame_relay_frame (ULONG protocol_stack_id,USHORT real_port_number,USHORT virtual_port_number,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer),
	DLCI_LIST_ENTRY *sptr_dlci_connection_entry);

void queue_pending_tx_buffers (DLCI_LIST_ENTRY *sptr_dlci_connection_entry);

void frame_relay_packet_transmitted (USHORT port_number);
void send_periodic_inverse_arp_packets (void);

void send_inverse_arp_packet (ULONG protocol_stack_id,USHORT dlci,enum SNAP_PROTOCOL_ID protocol_id,
	USHORT virtual_port_number,BYTE protocol_address_length,USHORT size_of_packet,BYTE *bptr_source_protocol_address,
	BYTE *bptr_target_protocol_address,enum INVERSE_ARP_COMMAND command,USHORT destination_dlci);

USHORT get_frame_relay_real_port_number(enum PROTOCOL_STACK_TYPE proto_type, USHORT virtual_port_number);

/* frrx.c */

enum BOOLEAN frame_relay_receive (USHORT port_number,
	FRAME_RELAY_PACKET **sptr_return_frame,USHORT *usptr_number_of_bytes_received);

USHORT get_frame_relay_virtual_port_number (enum PROTOCOL_STACK_TYPE proto_type);

void do_frame_relay_congestion_mgmt (USHORT port_number,FRAME_RELAY_PACKET *sptr_rxed_frame,USHORT number_of_bytes);
void check_congestion_on_ports (void);
void send_congestion_awareness_pkt (USHORT port_number);

void check_dlci_timeouts (void);
void check_dlci_congestion (DLCI_LIST_ENTRY *sptr_dlci_connection_entry, USHORT number_of_bytes);
void update_dlci_data_sent (DLCI_LIST_ENTRY *sptr_dlci_connection_entry, USHORT number_of_bytes);

void CheckFrameRelayTimer (void);

/* frutil.c */

USHORT get_dlci_from_protocol_stack_virtual_port_number (ULONG protocol_stack_id,USHORT protocol_stack_virtual_port_number);
USHORT get_virtual_port_number_from_dlci (USHORT dlci,PROTOCOL_STACK_DLCI_TABLE *sptr_dlci_table);
void convert_dlci (UNION_USEABLE_DLCI *uptr_dlci);
USHORT convert_dlci_to_bit_format (USHORT dlci);
void convert_dlci_to_ushort (UNION_DLCI *uptr_dlci);
USHORT get_ushort_dlci (UNION_DLCI dlci);
void enable_or_disable_frame_relay_printing (enum BOOLEAN enable_or_disable);
void enable_or_disable_frame_relay_group_printing (enum BOOLEAN enable_or_disable,enum FRAME_RELAY_PRINTF_GROUPS printf_group);
void frame_relay_printf (enum FRAME_RELAY_PRINTF_GROUPS printf_group,const char *cptr_format, ...);
USHORT delete_extended_address_bit (UNION_DLCI dlci);
USHORT get_port_number_from_dlci (USHORT dlci);

/* frdlci.c */

enum TEST create_dlci_connection_entry (USHORT port_number,USHORT dlci,enum BOOLEAN active,enum BOOLEAN new);
DLCI_LIST_ENTRY *get_dlci_connection_entry (USHORT port_number,USHORT dlci);
void set_all_dlcis_active_flag (USHORT port_number,enum BOOLEAN active_flag);
void set_all_dlcis_new_flag (USHORT port_number,enum BOOLEAN new_flag);
void stop_sending_on_all_dlcis (USHORT port_number);
void start_sending_on_all_dlcis (USHORT port_number);

/* frsnmp.c */

void frame_relay_management_alarm (enum FRAME_RELAY_ALARM_TYPE error_type,enum BOOLEAN annex_d_frame,
	USHORT port_number,void *sptr_frame,USHORT number_of_bytes);
void set_frame_relay_snmp_trap_function (void (*fptr_snmp_trap_function) (ULONG index,USHORT dlci,enum FR_CIRCUIT_STATE state));
void set_frame_relay_snmp_alarm_function (void (*fptr_alarm_function) (enum FRAME_RELAY_ALARM_TYPE error_type,
	USHORT port_number,ULONG parameter_1,ULONG parameter_2));

/* frmuxrx.c */

enum BOOLEAN receive_mux_frame_relay_frame (USHORT port_number, FRAME_RELAY_PACKET *sptr_rxed_frame,
	FRAME_RELAY_PACKET **sptr_return_frame, USHORT *usptr_number_of_bytes_received);
enum BOOLEAN receive_mux_raw_frame_relay_frame (USHORT port_number, FRAME_RELAY_PACKET *sptr_rxed_frame,
	FRAME_RELAY_PACKET **sptr_return_frame, USHORT *usptr_number_of_bytes_received);
void init_mux_raw_dlci (USHORT ch_DLCI);
void reset_mux_raw_dlci (USHORT ch_DLCI);
enum BOOLEAN is_mux_raw_dlci (USHORT ch_DLCI);

/* frmuxtx.c */

enum TEST send_mux_frame_relay_frame (USHORT mux_port_number,
	USHORT mux_channel_number, USHORT dlci,
	USHORT mode, USHORT frame_discardable,
	UNION_FRAME_RELAY_HEADER *sptr_tx_frame,
	USHORT number_of_bytes, USHORT org_number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number,void *sptr_mux_buffer));

/* frmem.c */

void fr_init_mem (void);
void *fr_malloc (int size);
void fr_free (void *memptr);

/* frstats.c */

void  clear_dlci_stats (USHORT dlci);
int   get_dlci_stats (USHORT dlci, BYTE *buf);
void  update_dlci_uptime (void);
ULONG calculate_thruput (DLCI_LIST_ENTRY *sptr_dlci_entry);
void  update_thruput (DLCI_LIST_ENTRY *sptr_dlci_entry);
int   get_management_stats (BYTE *buffer);
