/************************************************************************/
/************************************************************************/

typedef struct LMI_KEEP_ALIVE_SEQUENCE_IE
{
	BYTE			id;
	BYTE			length;
	BYTE			tx_sequence_number;	/* current_sequence_number */
	BYTE			rx_sequence_number;  /* last_received_sequence_number */
} LMI_KEEP_ALIVE_SEQUENCE_IE;

typedef	struct	LMI_PVC_STATUS_FLAGS
{
#ifndef BIG_ENDIAN
	unsigned	int	reserved:1;
	unsigned	int	active:1;
	unsigned	int	reserved_1:1;
	unsigned	int	new:1;
	unsigned	int	reserved_2:4;
#else
	unsigned	int	reserved_2:4;
	unsigned	int	new:1;
	unsigned	int	reserved_1:1;
	unsigned	int	active:1;
	unsigned	int	reserved:1;
#endif
} LMI_PVC_STATUS_FLAGS;

typedef	union	UNION_LMI_PVC_STATUS_FLAGS
{
	LMI_PVC_STATUS_FLAGS		_bit;
	BYTE							_byte;
} UNION_LMI_PVC_STATUS_FLAGS;

typedef	struct	LMI_DLCI_BIT_STRUCTURE
{
#ifndef BIG_ENDIAN
	unsigned int	dlci_msb:2;
	unsigned int	reserved:6;

	unsigned int	dlci_lsb:8;
#else
	unsigned int	reserved:6;
	unsigned int	dlci_msb:2;

	unsigned int	dlci_lsb:8;
#endif
} LMI_DLCI_BIT_STRUCTURE;

typedef	union	UNION_LMI_DLCI
{
	LMI_DLCI_BIT_STRUCTURE	_bit;
	USHORT						_ushort;
} UNION_LMI_DLCI;

typedef struct LMI_PVC_STATUS_INFORMATION_ELEMENT
{
	BYTE								id;
	BYTE								length;
	UNION_LMI_DLCI					dlci;
	UNION_LMI_PVC_STATUS_FLAGS	type;
	BYTE								reserved_1;
	BYTE								reserved_2;
	BYTE								reserved_3;
} LMI_PVC_STATUS_INFORMATION_ELEMENT;

typedef	struct	LMI_HEADER
{
	UNION_DLCI												dlci;
	BYTE														unnumbered_frame_info;
	BYTE_ENUM (LMI_PROTOCOL_DISCRIMINATOR_TYPE)	protocol_discriminator;
	BYTE														call_reference;
	BYTE_ENUM (LMI_STATUS_MESSAGE_TYPE)				status_message;
	REPORT_TYPE_INFORMATION_ELEMENT					report;
} LMI_HEADER;

typedef struct LMI_ENQUIRY_MESSAGE
{
	LMI_HEADER								header;
	LMI_KEEP_ALIVE_SEQUENCE_IE			sequence;
} LMI_ENQUIRY_MESSAGE;				

typedef struct LMI_RESPONSE_MESSAGE
{
	LMI_HEADER									header;
	LMI_KEEP_ALIVE_SEQUENCE_IE				sequence;
	LMI_PVC_STATUS_INFORMATION_ELEMENT  pvc_status[MAXIMUM_NUMBER_OF_PLLS];
} LMI_RESPONSE_MESSAGE;

typedef	union	UNION_LMI_MESSAGE
{
	LMI_ENQUIRY_MESSAGE		full_status_enquiry;
	LMI_RESPONSE_MESSAGE		full_status_response;
	LMI_HEADER					header;
} UNION_LMI_MESSAGE;

/* lmimain.c */

void initialize_lmi (void);
void check_for_lmi_timeouts (void);

/* lmitxrx.c */

void send_lmi_status_enquiry_message (USHORT port_number);
void send_lmi_full_status_enquiry_message (USHORT port_number);
enum RX_PACKET_STATE lmi_frame_received (USHORT port_number,
		UNION_LMI_MESSAGE *sptr_rxed_frame, USHORT number_of_bytes_rxed);
USHORT get_lmi_ushort_dlci (UNION_LMI_DLCI lmi_format_dlci);
