/*	$Modname: vnvfr.h$  $version: 1.4$      $date: 06/29/95$   */
/*
* 	$lgb$
1.0 03/27/94 ross new config file.
1.1 03/27/94 ross added copyright.
1.2 06/13/94 ross added snmp access routines, fixed bug with ip header tx's.  Courtesy of Rick.
1.3 01/12/95 ross conversion warnings.
1.4 06/29/95 ross fixed size problems.  Courtesy of Hung.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
void map_port_numbers_to_dlci_numbers (char *cptr_port_number_dlci_string);
void set_frame_relay_encapsulation_type (char *cptr_port_number_and_encapsulation_type);
void map_ipx_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci);
void map_ip_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci);
void map_stp_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci);
void map_source_routing_protocol_stack_virtual_port_numbers_to_dlci_numbers (char *cptr_virtual_port_number_and_dlci);
void set_dlci_number_function (char *cptr_dlci_number);
void set_dlci_CIR_function (char *cptr_string);
void set_dlci_Be_function (char *cptr_string);
void set_dlci_mode_function (char *cptr_string);
void set_dlci_compression_function (char *cptr_string);
void set_dlci_value_function (char *cptr_string, USHORT index);

CONFIGURATION_TABLE frame_relay_configuration_table =
{
	{TRUE},
	{
/* _________________________Frame Relay_________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"Frame Relay =",
		(ULONG) offsetof (FRAME_RELAY_CLASS, enabled),
		(ULONG) &frame_relay,
		(ULONG) NULL
	},

	{
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Port =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].enabled),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"Frame Relay Number of Ports =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,total_number_of_frame_relay_ports),
		(ULONG ) &frame_relay,
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"Frame Relay Number of Lan Ports =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,number_of_lan_ports),
		(ULONG ) &frame_relay,
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"Frame Relay Number of DLCIs =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,total_number_of_dlci_connections),
		(ULONG ) &frame_relay,
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"Frame Relay CIR Measurement Interval =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,CIR_interval),
		(ULONG ) &frame_relay,
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"Frame Relay Port WAN Speed =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].port_speed),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_port_numbers_to_dlci_numbers,
		NULL,
	"Frame Relay Port to DLCI =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_ipx_protocol_stack_virtual_port_numbers_to_dlci_numbers,
		NULL,
	"Frame Relay IPX Virtual Port to DLCI =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_ip_protocol_stack_virtual_port_numbers_to_dlci_numbers,
		NULL,
	"Frame Relay IP Virtual Port to DLCI =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_stp_protocol_stack_virtual_port_numbers_to_dlci_numbers,
		NULL,
	"Frame Relay STP Virtual Port to DLCI =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		map_source_routing_protocol_stack_virtual_port_numbers_to_dlci_numbers,
		NULL,
	"Frame Relay Source Routing Virtual Port to DLCI =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_frame_relay_encapsulation_type,
		NULL,
	"Frame Relay Port Encapsulation Type =",
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Frame Relay Port Maximum Frame Size =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].maximum_frame_size),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Frame Relay Port Minimum Frame Size =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].minimum_frame_size),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Port Annex D =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.enabled),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Frame Relay Port Management Type =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].management_type),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Port User Mode =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.user.enabled),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Port Network Mode =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.network.enabled),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Inverse Arp for IPX Virtual Port =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,ipx_dlci_table.entry[0].inverse_arp_enabled),
		(ULONG ) &frame_relay,
		sizeof (PROTOCOL_STACK_DLCI_ENTRY)
	},

/* _____________________________________________________________________________________________ */

	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Inverse Arp for IP Virtual Port =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,ip_dlci_table.entry[0].inverse_arp_enabled),
		(ULONG ) &frame_relay,
		sizeof (PROTOCOL_STACK_DLCI_ENTRY)
	},

#if 0
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"Frame Relay Number of Ports =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,inverse_arp_timer),
		(ULONG ) &frame_relay,
	},
#endif

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"Frame Relay Inverse Arp Timer =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,inverse_arp_timer),
		(ULONG ) &frame_relay,
	},


/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_byte_decimal_value,
		NULL,
	"Frame Relay Port Full Enquiry Interval =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.frDlcmiFullEnquiryInterval),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_byte_decimal_value,
		NULL,
	"Frame Relay Port Error Threshold =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.frDlcmiErrorThreshold),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_byte_decimal_value,
		NULL,
	"Frame Relay Port Monitor Events =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.frDlcmiMonitoredEvents),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_byte_decimal_value,
		NULL,
	"Frame Relay Port Polling Interval =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.frDlcmiPollingInterval),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"Frame Relay Port Polling Verification Timer Interval =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].annex_d.polling_verification_timer_T392),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
	"Frame Relay Port Enable IP Snap =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,port[0].enable_ip_snap),
		(ULONG ) &frame_relay,
		sizeof (FRAME_RELAY_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,printing_enabled),
		(ULONG ) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf Data =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,data_printing_enabled),
		(ULONG ) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf Memory =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,memory_printing_enabled),
		(ULONG ) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf Inverse Arp =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,inverse_arp_printing_enabled),
		(ULONG ) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf Alarm =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,alarm_printing_enabled),
		(ULONG ) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"Frame Relay Printf SNMP =",
		(ULONG) offsetof (FRAME_RELAY_CLASS,snmp_printing_enabled),
		(ULONG) &frame_relay,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_dlci_number_function,
		NULL,
	"Frame Relay DLCI Number =",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_dlci_CIR_function,
		NULL,
	"Frame Relay DLCI CIR =",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_dlci_Be_function,
		NULL,
	"Frame Relay DLCI Be =",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_dlci_mode_function,
		NULL,
	"Frame Relay DLCI Mode =",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_dlci_compression_function,
		NULL,
	"Frame Relay DLCI Compression =",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

	}	
};
