*NOTE: ### are the places where it is required to check for new values (Naveen)
*************************************************************************
*									*
*			a360def.h					*
*									*
*			ace360 monitor definition file			*
*									*
*			8/5/94						*
*									*
*************************************************************************

MBAR		equ	$3FF00

*		QUICC SIM Register Addresses

ModBaseAdr	equ	$0FFFF0000
DPR_Base		equ	ModBaseAdr
SPIRXBD		equ	ModBaseAdr+$50
SPITXBD		equ	ModBaseAdr+$58


*	select a default debug port
		
;DebugBD		equ	SCC4RXBD

;DebugRxStat	equ	DebugBD
;DebugRxLen	equ	DebugBD+2
;DebugRxPntr	equ	DebugBD+4
;DebugTxStat	equ	DebugBD+8
;DebugTxLen	equ	DebugBD+$A
;DebugTxPntr	equ	DebugBD+$C
TxRdy			equ	$8000

SCC1PB		equ	ModBaseAdr+$0C00
MiscBase	equ	ModBaseAdr+$0CB0
SCC2PB		equ	ModBaseAdr+$0D00
SCC3PB		equ	ModBaseAdr+$0E00
SCC4PB		equ	ModBaseAdr+$0F00
SPIPB			equ	ModBaseAdr+$0D80
SMC1PB		equ	ModBaseAdr+$0E80
SMC2PB		equ	ModBaseAdr+$0F80
IDMA1Base	equ	ModBaseAdr+$0E70
IDMA2Base	equ	ModBaseAdr+$0F70

RBase		equ	ModBaseAdr+$1000
MCR		equ	RBase+0
AVR		equ	RBase+8
CLKOCR	equ	RBase+$C
PLLCR		equ	RBase+$10
SYPCR		equ	RBase+$22
PEPAR		equ	RBase+$16

PICR		equ	RBase+$26
PITR		equ	RBase+$2a
SWSR		equ	RBase+$2f

CR			equ	RBase+$5C0
GMR		equ	RBase+$40
BR0		equ	RBase+$50
OR0		equ	RBase+$54
BR1		equ	RBase+$60
OR1		equ	RBase+$64
BR2		equ	RBase+$70
OR2		equ	RBase+$74
BR3		equ	RBase+$80
OR3		equ	RBase+$84
BR4		equ	RBase+$90
OR4		equ	RBase+$94

CICR		equ	RBase+$540
CIPR		equ	RBase+$544
CIMR		equ	RBase+$548
CISR		equ	RBase+$54C

;The Following constants are for SCC1 ...

SDCR 	 	equ	RBase+$051E
PADIR		equ	RBase+$0550
PAPAR		equ	RBase+$0552
PAODR		equ	RBase+$0554
PADAT		equ	RBase+$0556

CPCR1		equ	RBase+$5CC
CPCR2		equ	RBase+$5CE
CPCR3		equ	RBase+$5D0
CPCR4		equ	RBase+$5D2

PBDIR		equ	RBase+$06B8
PBPAR		equ	RBase+$06BC
PBODR		equ	RBase+$06C0
PBDAT		equ	RBase+$06C4

PCDIR		equ	RBase+$0560
PCPAR		equ	RBase+$0562
PCSO		equ	RBase+$0564
PCDAT		equ	RBase+$0566
PCINT		equ	RBase+$0568

; ... End of constant declerations for SCC1 

; The Following constants are for SCC2 ...  ###  (Not Reqd)

;SDCRSCC2 	 	equ	RBase+$051E
;PADIRSCC2		equ	RBase+$0550
;PAPARSCC2		equ	RBase+$0552
;PAODRSCC2		equ	RBase+$0554
;PADATSCC2		equ	RBase+$0556
;
;PBDIRSCC2		equ	RBase+$06B8
;PBPARSCC2		equ	RBase+$06BC
;PBODRSCC2		equ	RBase+$06C0
;PBDATSCC2		equ	RBase+$06C4
;
;PCDIRSCC2		equ	RBase+$0560
;PCPARSCC2		equ	RBase+$0562
;PCSOSCC2 		equ	RBase+$0564
;PCDATSCC2		equ	RBase+$0566
;PCINTSCC2 		equ	RBase+$0568
; ... End of constant declerations for SCC2  (Not Reqd)


*		External Addresses

* Bank1Base	equ	$100000
* Bank2Base	equ	$200000
* SramBase	equ	$800000

* SysMem		equ	Bank1Base	
* SysMemSize	equ	$400000

* SramSize	equ	$80000
LocalIOSCC1		equ	$FF000000
LocalIOSCC2		equ	LocalIOSCC1+4 ;$FF000004 
InitVBR		equ	0	
* SMC1RBuf	equ	SysMem+SysMemSize-$100
* SCC4RBuf	equ	SMC1RBuf-$100		*256 byte buffer
* SCC3RBuf	equ	SCC4RBuf-$100
* SCC2RBuf	equ	SCC3RBuf-$100
* SCC1RBuf	equ	SCC2RBuf-$1000
* EepromCmd	equ	SCC1RBuf-$100
* EepromWrBuf	equ	EepromCmd-$100
* EepromRdBuf	equ	EepromWrBuf-$100
* InitSP		equ	EepromRdBuf-4
* buffer		equ	SysMem

* FlPROMBuf       equ     SysMem+SysMemSize-(64*1024)
* BridgeModeLoc   equ     FlPROMBuf-$c

*		constants		

Rtn		equ	$D
LF		equ	$A

NumBanks	equ	2		*# of DRAM banks

CPU_FC		equ	7
PllCtl		equ	$0		*24.576 MHz
ClkCtl		equ	$0
InitSysProt	equ	$20
RstCR		equ	$8001

GAMX		equ	$20		*enable internal DRAM adr mux
DWQ		equ	$80
PageSz256K	equ	$040000
PageSz1M	equ	$0C0000
PageSz4M	equ	$140000
RfshEn		equ	$800000
RfshCnt25	equ	$18000000	*15.4usec refresh at 25MHz
RfshCyc3	equ	0		*3 clock refresh
RfshCyc4	equ	$200000		*4 clock refresh

* Base register bits
BootWP		equ	2
Valid		equ	1

* Option register bits
			
PortWidth8	equ	4	*PortWidth32 = 0
PortWidth16	equ	2
DramSel		equ	1
PageMode	equ	8
BootAdrMask	equ	$FF80000	*allows 512K prom
SramAdrMask	equ	$FF80000	*allows 2 Mbytes
*Bank1Mask	equ	$F800000	;for 1M x 32 SIMM	
*Bank2Mask	equ	$F800000
Bank1Mask	equ	$FF00000	;for 256K x 32 SIMM	
Bank2Mask	equ	$FF00000
LocalIOMask	equ	$FFFF800	;only use 4 kbytes
FastTerm	equ	0
Wait0		equ	$10000000
Wait1		equ	$20000000
Wait2		equ	$30000000
Wait3		equ	$40000000
Wait4		equ	$50000000
Wait5		equ	$60000000

RAS2DD		equ	$600
RAS1DD		equ	$100
WeSel		equ	$80

PortAConfig	equ	$4FFF
PortADir	equ	0

*** Timer 1, 2, 3, 4
TGCR    EQU     RBase+$0580      ; Timer Global Configuration
*
TMR1    EQU     RBase+$0590      ; Timer1 Mode
TMR2    EQU     RBase+$0592      ; Timer2 Mode
TRR1    EQU     RBase+$0594      ; Timer1 Reference
TRR2    EQU     RBase+$0596      ; Timer2 Reference
TCR1    EQU     RBase+$0598      ; Timer1 Capture
TCR2    EQU     RBase+$059A      ; Timer2 Capture
TCN1    EQU     RBase+$059C      ; Timer1 Counter
TCN2    EQU     RBase+$059E      ; Timer2 Counter
*
TMR3    EQU     RBase+$05A0      ; Timer3 Mode
TMR4    EQU     RBase+$05A2      ; Timer4 Mode
TRR3    EQU     RBase+$05A4      ; Timer3 Reference
TRR4    EQU     RBase+$05A6      ; Timer4 Reference
TCR3    EQU     RBase+$05A8      ; Timer3 Capture
TCR4    EQU     RBase+$05AA      ; Timer4 Capture
TCN3    EQU     RBase+$05AC      ; Timer3 Counter
TCN4    EQU     RBase+$05AE      ; Timer4 Counter
*
TER1    EQU     RBase+$05B0      ; Timer1 Event
TER2    EQU     RBase+$05B2      ; Timer2 Event
TER3    EQU     RBase+$05B4      ; Timer3 Event
TER4    EQU     RBase+$05B6      ; Timer4 Event
*** CP
RCCR    EQU     RBase+$05C4      ; RISC Configuration
RTER    EQU     RBase+$05D6      ; RISC Timer Event Register
RTMR    EQU     RBase+$05DA      ; RISC Timer Mask Register
* BRG 1, 2, 3, 4
BRGC1   EQU     RBase+$05F0      ; BRG1 Configuration
BRGC2   EQU     RBase+$05F4      ; BRG2 Configuration
BRGC3   EQU     RBase+$05F8      ; BRG3 Configuration
BRGC4   EQU     RBase+$05FC      ; BRG4 Configuration
*** SCC 1, 2, 3, 4
* SCC1
GSMR_LSCC1 EQU     RBase+$0600      ; SCC1 General Mode
GSMR_HSCC1 EQU     RBase+$0604      ; SCC1 General Mode
PSMRSCC1   EQU     RBase+$0608      ; SCC1 Protocol Specific Mode
TODRSCC1   EQU     RBase+$060C      ; SCC1 Transmit On Demand
DSRSCC1    EQU     RBase+$060E      ; SCC1 Data Sync
SCCE1   EQU     RBase+$0610      ; SCC1 Event
SCCM1   EQU     RBase+$0614      ; SCC1 Mask
SCCS1   EQU     RBase+$0617      ; SCC1 Status
* SCC2
GSMR_LSCC2 EQU     RBase+$0620      ; SCC2 General Mode
GSMR_HSCC2 EQU     RBase+$0624      ; SCC2 General Mode
PSMRSCC2   EQU     RBase+$0628      ; SCC2 Protocol Specific Mode
TODRSCC2   EQU     RBase+$062C      ; SCC2 Transmit On Demand
DSRSCC2    EQU     RBase+$062E      ; SCC2 Data Sync
SCCE2   EQU     RBase+$0630      ; SCC2 Event
SCCM2   EQU     RBase+$0634      ; SCC2 Mask
SCCS2   EQU     RBase+$0637      ; SCC2 Status
* SCC3
GSMR_L3 EQU     RBase+$0640      ; SCC3 General Mode
GSMR_H3 EQU     RBase+$0644      ; SCC3 General Mode
PSMR3   EQU     RBase+$0648      ; SCC3 Protocol Specific Mode
TODR3   EQU     RBase+$064C      ; SCC3 Transmit On Demand
DSR3    EQU     RBase+$064E      ; SCC3 Data Sync
SCCE3   EQU     RBase+$0650      ; SCC3 Event
SCCM3   EQU     RBase+$0654      ; SCC3 Mask
SCCS3   EQU     RBase+$0657      ; SCC3 Status
* SCC4
GSMR_L4 EQU     RBase+$0660      ; SCC4 General Mode
GSMR_H4 EQU     RBase+$0664      ; SCC4 General Mode
PSMR4   EQU     RBase+$0668      ; SCC4 Protocol Specific Mode
TODR4   EQU     RBase+$066C      ; SCC4 Transmit On Demand
DSR4    EQU     RBase+$066E      ; SCC4 Data Sync
SCCE4   EQU     RBase+$0670      ; SCC4 Event
SCCM4   EQU     RBase+$0674      ; SCC4 Mask
SCCS4   EQU     RBase+$0677      ; SCC4 Status
*** SMC 1, 2
SMCMR1  EQU     RBase+$0682      ; SMC1 Mode
SMCE1   EQU     RBase+$0686      ; SMC1 Event
SMCM1   EQU     RBase+$068A      ; SMC1 Mask
*
SMCMR2  EQU     RBase+$0692      ; SMC2 Mode
SMCE2   EQU     RBase+$0696      ; SMC2 Event
SMCM2   EQU     RBase+$069A      ; SMC2 Mask
*** SPI
SPMODE  EQU     RBase+$06A0      ; SPI Mode
SPIE    EQU     RBase+$06A6      ; SPI Event
SPIM    EQU     RBase+$06AA      ; SPI Mask
SPCOM   EQU     RBase+$06AC      ; SPI Command
*** PIP
PIPC    EQU     RBase+$06B2      ; PIP Configuration
PTRR    EQU     RBase+$06B6      ; PIP Timing Parameter
*** Serial Interface
SIMODE  EQU     RBase+$06E0      ; SI Mode
SIGMR   EQU     RBase+$06E4      ; SI Global Mode
SISTR   EQU     RBase+$06E6      ; SI Status
SICMR   EQU     RBase+$06E7      ; SI Command
SICR    EQU     RBase+$06EC      ; SI Clock Routing for SCC1 

;SICRSCC2    EQU     RBase+$06EC      ; SI Clock Routing for SCC2 ### (Not Reqd)

SIRP    EQU     RBase+$06F0      ; SI RAM Pointer
SIRAM   EQU     RBase+$0700      ; SI Routing RAM

************************ END of SIM/CPM Register MAP *******************

************************ SCC Parameters ********************************

RBASESCC1  EQU     SCC1PB+$000     ; SCC1 RX BD Base Address
TBASESCC1  EQU     SCC1PB+$002     ; SCC1 TX BD Base Address
RFCRSCC1   EQU     SCC1PB+$004     ; SCC1 RX Function Code
TFCRSCC1   EQU     SCC1PB+$005     ; SCC1 TX Function Code
MRBLRSCC1  EQU     SCC1PB+$006     ; SCC1 MAX Buffer Length - RX
RSTATESCC1 EQU     SCC1PB+$008     ; SCC1 RX Internal State
RBPRTSCC1  EQU     SCC1PB+$010     ; SCC1 RX BD Pointer
TSTATESCC1 EQU     SCC1PB+$018     ; SCC1 TX Internal State
TBPRTSCC1  EQU     SCC1PB+$020     ; SCC1 TX BD Pointer
RCRCSCC1   EQU     SCC1PB+$028     ; SCC1 Temp Receive CRC
TCRCSCC1   EQU     SCC1PB+$02C     ; SCC1 Temp Transmit CRC

* SCC1, Ethernet Specific Parameter
C_PRESSCC1      EQU     SCC1PB+$30   ; SCC1 Preset CRC ($FFFFFFFF)
C_MASKSCC1      EQU     SCC1PB+$34   ; SCC1 Constant mask for CRC($20E3DEBB)
CRCECSCC1       EQU     SCC1PB+$38   ; SCC1 CRC error counter
ALECSCC1        EQU     SCC1PB+$3C   ; SCC1 alignment error counter
DISFCSCC1       EQU     SCC1PB+$40   ; SCC1 discard frame counter
PADSSCC1        EQU     SCC1PB+$44   ; SCC1 short frame PAD counter
RET_LimSCC1     EQU     SCC1PB+$46   ; SCC1 retry limit threshold
RET_cntSCC1     EQU     SCC1PB+$48   ; SCC1 retry limit counter
MFLRSCC1        EQU     SCC1PB+$4A   ; SCC1 max. frame length reg.
MINFLRSCC1      EQU     SCC1PB+$4C   ; SCC1 min. frame length reg.
MAXD1SCC1       EQU     SCC1PB+$4E   ; SCC1 max. DMA1 length reg.
MAXD2SCC1       EQU     SCC1PB+$50   ; SCC1 max. DMA2 length reg.
MAXDSCC1        EQU     SCC1PB+$52   ; SCC1 Rx max DMA
DMA_cntSCC1     EQU     SCC1PB+$54   ; SCC1 Rx DMA count
MAX_bSCC1       EQU     SCC1PB+$56   ; SCC1 max BD byte count
GADDR1SCC1      EQU     SCC1PB+$58   ; SCC1 Group Addr. Filter 1
GADDR2SCC1      EQU     SCC1PB+$5A   ; SCC1 Group Addr. Filter 2
GADDR3SCC1      EQU     SCC1PB+$5C   ; SCC1 Group Addr. Filter 3
GADDR4SCC1      EQU     SCC1PB+$5E   ; SCC1 Group Addr. Filter 4
TBUF0.data0SCC1 EQU     SCC1PB+$60   ; SCC1 save area 0 - current frame
TBUF0.data1SCC1 EQU     SCC1PB+$64   ; SCC1 save area 1 - current frame
TBUF0.rba0SCC1  EQU     SCC1PB+$68   ; SCC1
TBUF0.crcSCC1   EQU     SCC1PB+$6C   ; SCC1
TBUF0.bcntSCC1  EQU     SCC1PB+$70   ; SCC1
PADDRSCC1_H1    EQU     SCC1PB+$72   ; physical address 1 (MSB)
PADDRSCC1_M1    EQU     SCC1PB+$74   ; physical address 1
PADDRSCC1_L1    EQU     SCC1PB+$76   ; physical address 1 (LSB)
P_PERSCC1       EQU     SCC1PB+$78   ; persistence
RFBD_ptrSCC1    EQU     SCC1PB+$7A   ; Rx first BD pointer
TFBD_ptrSCC1    EQU     SCC1PB+$7C   ; Tx first BD pointer
TLBD_ptrSCC1    EQU     SCC1PB+$7E   ; Tx last BD pointer
TBUF1.data0SCC1 EQU     SCC1PB+$80   ; SCC1 save area 0 - next frame
TBUF1.data1SCC1 EQU     SCC1PB+$84   ; SCC1 save area 1 - next frame
TBUF1.rba0SCC1  EQU     SCC1PB+$88   ; SCC1
TBUF1.crcSCC1   EQU     SCC1PB+$8C   ; SCC1
TBUF1.bcntSCC1  EQU     SCC1PB+$90   ; SCC1
TX_lenSCC1      EQU     SCC1PB+$92   ; SCC1 Tx frame length counter
IADDR1SCC1      EQU     SCC1PB+$94   ; SCC1 Individual Addr. Filter 1
IADDR2SCC1      EQU     SCC1PB+$96   ; SCC1 Individual Addr. Filter 2
IADDR3SCC1      EQU     SCC1PB+$98   ; SCC1 Individual Addr. Filter 3
IADDR4SCC1      EQU     SCC1PB+$9A   ; SCC1 Individual Addr. Filter 4
BOFF_CNTSCC1    EQU     SCC1PB+$9C   ; back off counter
TADDRSCC1_H1    EQU     SCC1PB+$9E   ; temp address  (MSB)
TADDRSCC1_M1    EQU     SCC1PB+$A0   ; temp address
TADDRSCC1_L1    EQU     SCC1PB+$A2   ; temp address  (LSB)


****** SCC2
RBASESCC2  EQU     SCC2PB+$000     ; SCC2 RX BD Base Address
TBASESCC2  EQU     SCC2PB+$002     ; SCC2 TX BD Base Address
RFCRSCC2   EQU     SCC2PB+$004     ; SCC2 RX Function Code
TFCRSCC2   EQU     SCC2PB+$005     ; SCC2 TX Function Code
MRBLRSCC2  EQU     SCC2PB+$006     ; SCC2 MAX Buffer Length - RX
RSTATESCC2 EQU     SCC2PB+$008     ; SCC2 RX Internal State
RBPRTSCC2  EQU     SCC2PB+$010     ; SCC2 RX BD Pointer
TSTATESCC2 EQU     SCC2PB+$018     ; SCC2 TX Internal State
TBPRTSCC2  EQU     SCC2PB+$020     ; SCC2 TX BD Pointer
RCRCSCC2   EQU     SCC2PB+$028     ; SCC2 Temp Receive CRC
TCRCSCC2   EQU     SCC2PB+$02C     ; SCC2 Temp Transmit CRC

* SCC2, Ethernet Specific Parameter
C_PRESSCC2      EQU     SCC2PB+$30   ; SCC2 Preset CRC ($FFFFFFFF)
C_MASKSCC2      EQU     SCC2PB+$34   ; SCC2 Constant mask for CRC($20E3DEBB)
CRCECSCC2       EQU     SCC2PB+$38   ; SCC2 CRC error counter
ALECSCC2        EQU     SCC2PB+$3C   ; SCC2 alignment error counter
DISFCSCC2       EQU     SCC2PB+$40   ; SCC2 discard frame counter
PADSSCC2        EQU     SCC2PB+$44   ; SCC2 short frame PAD counter
RET_LimSCC2     EQU     SCC2PB+$46   ; SCC2 retry limit threshold
RET_cntSCC2     EQU     SCC2PB+$48   ; SCC2 retry limit counter
MFLRSCC2        EQU     SCC2PB+$4A   ; SCC2 max. frame length reg.
MINFLRSCC2      EQU     SCC2PB+$4C   ; SCC2 min. frame length reg.
MAXD1SCC2       EQU     SCC2PB+$4E   ; SCC2 max. DMA1 length reg.
MAXD2SCC2       EQU     SCC2PB+$50   ; SCC2 max. DMA2 length reg.
MAXDSCC2        EQU     SCC2PB+$52   ; SCC2 Rx max DMA
DMA_cntSCC2     EQU     SCC2PB+$54   ; SCC2 Rx DMA count
MAX_bSCC2       EQU     SCC2PB+$56   ; SCC2 max BD byte count
GADDR1SCC2      EQU     SCC2PB+$58   ; SCC2 Group Addr. Filter 1
GADDR2SCC2      EQU     SCC2PB+$5A   ; SCC2 Group Addr. Filter 2
GADDR3SCC2      EQU     SCC2PB+$5C   ; SCC2 Group Addr. Filter 3
GADDR4SCC2      EQU     SCC2PB+$5E   ; SCC2 Group Addr. Filter 4
TBUF0.data0SCC2 EQU     SCC2PB+$60   ; SCC2 save area 0 - current frame
TBUF0.data1SCC2 EQU     SCC2PB+$64   ; SCC2 save area 1 - current frame
TBUF0.rba0SCC2  EQU     SCC2PB+$68   ; SCC2
TBUF0.crcSCC2   EQU     SCC2PB+$6C   ; SCC2
TBUF0.bcntSCC2  EQU     SCC2PB+$70   ; SCC2
PADDRSCC2_H1    EQU     SCC2PB+$72   ; physical address 1 (MSB)
PADDRSCC2_M1    EQU     SCC2PB+$74   ; physical address 1
PADDRSCC2_L1    EQU     SCC2PB+$76   ; physical address 1 (LSB)
P_PERSCC2       EQU     SCC2PB+$78   ; persistence
RFBD_ptrSCC2    EQU     SCC2PB+$7A   ; Rx first BD pointer
TFBD_ptrSCC2    EQU     SCC2PB+$7C   ; Tx first BD pointer
TLBD_ptrSCC2    EQU     SCC2PB+$7E   ; Tx last BD pointer
TBUF1.data0SCC2 EQU     SCC2PB+$80   ; SCC2 save area 0 - next frame
TBUF1.data1SCC2 EQU     SCC2PB+$84   ; SCC2 save area 1 - next frame
TBUF1.rba0SCC2  EQU     SCC2PB+$88   ; SCC2
TBUF1.crcSCC2   EQU     SCC2PB+$8C   ; SCC2
TBUF1.bcntSCC2  EQU     SCC2PB+$90   ; SCC2
TX_lenSCC2      EQU     SCC2PB+$92   ; SCC2 Tx frame length counter
IADDR1SCC2      EQU     SCC2PB+$94   ; SCC2 Individual Addr. Filter 1
IADDR2SCC2      EQU     SCC2PB+$96   ; SCC2 Individual Addr. Filter 2
IADDR3SCC2      EQU     SCC2PB+$98   ; SCC2 Individual Addr. Filter 3
IADDR4SCC2      EQU     SCC2PB+$9A   ; SCC2 Individual Addr. Filter 4
BOFF_CNTSCC2    EQU     SCC2PB+$9C   ; back off counter
TADDRSCC2_H1    EQU     SCC2PB+$9E   ; temp address  (MSB)
TADDRSCC2_M1    EQU     SCC2PB+$A0   ; temp address
TADDRSCC2_L1    EQU     SCC2PB+$A2   ; temp address  (LSB)


****** SCC3
RBASE3  EQU     SCC3PB+$000     ; SCC3 RX BD Base Address
TBASE3  EQU     SCC3PB+$002     ; SCC3 TX BD Base Address
RFCR3   EQU     SCC3PB+$004     ; SCC3 RX Function Code
TFCR3   EQU     SCC3PB+$005     ; SCC3 TX Function Code
MRBLR3  EQU     SCC3PB+$006     ; SCC3 MAX Buffer Length - RX
RSTATE3 EQU     SCC3PB+$008     ; SCC3 RX Internal State
RBPRT3  EQU     SCC3PB+$010     ; SCC3 RX BD Pointer
TSTATE3 EQU     SCC3PB+$018     ; SCC3 TX Internal State
TBPRT3  EQU     SCC3PB+$020     ; SCC3 TX BD Pointer
RCRC3   EQU     SCC3PB+$028     ; SCC3 Temp Receive CRC
TCRC3   EQU     SCC3PB+$02C     ; SCC3 Temp Transmit CRC

****** SCC4
RBASE4  EQU     SCC4PB+$000     ; SCC4 RX BD Base Address
TBASE4  EQU     SCC4PB+$002     ; SCC4 TX BD Base Address
RFCR4   EQU     SCC4PB+$004     ; SCC4 RX Function Code
TFCR4   EQU     SCC4PB+$005     ; SCC4 TX Function Code
MRBLR4  EQU     SCC4PB+$006     ; SCC4 MAX Buffer Length - RX
RSTATE4 EQU     SCC4PB+$008     ; SCC4 RX Internal State
RBPRT4  EQU     SCC4PB+$010     ; SCC4 RX BD Pointer
TSTATE4 EQU     SCC4PB+$018     ; SCC4 TX Internal State
TBPRT4  EQU     SCC4PB+$020     ; SCC4 TX BD Pointer
RCRC4   EQU     SCC4PB+$028     ; SCC4 Temp Receive CRC
TCRC4   EQU     SCC4PB+$02C     ; SCC4 Temp Transmit CRC
CRC_C4  EQU     SCC4PB+$030     ; SCC4 CRC Constant Total-Transparent
CRC_P4  EQU     SCC4PB+$034     ; SCC4 CRC Preset Total-Transparent

****** SMC1 => SMCA, simplify assembly coding
RBASEA  EQU     SMC1PB+$000     ; SMC1 RX BD Base Address
TBASEA  EQU     SMC1PB+$002     ; SMC1 TX BD Base Address
RFCRA   EQU     SMC1PB+$004     ; SMC1 RX Function Code
TFCRA   EQU     SMC1PB+$005     ; SMC1 TX Function Code
MRBLRA  EQU     SMC1PB+$006     ; SMC1 MAX Buffer Length - RX
RSTATEA EQU     SMC1PB+$008     ; SMC1 RX Internal State
RBPRTA  EQU     SMC1PB+$010     ; SMC1 RX BD Pointer
TSTATEA EQU     SMC1PB+$018     ; SMC1 TX Internal State
TDPTRA  EQU     SMC1PB+$01C     ; SMC1 TX Internal Data Ptr
TBPRTA  EQU     SMC1PB+$020     ; SMC1 TX BD Pointer
TBCNTA  EQU     SMC1PB+$022     ; SMC1 TX Internal Byte Count

****** SMC2 => SMCB
RBASEB  EQU     SMC2PB+$000     ; SMC2 RX BD Base Address
TBASEB  EQU     SMC2PB+$002     ; SMC2 TX BD Base Address
RFCRB   EQU     SMC2PB+$004     ; SMC2 RX Function Code
TFCRB   EQU     SMC2PB+$005     ; SMC2 TX Function Code
MRBLRB  EQU     SMC2PB+$006     ; SMC2 MAX Buffer Length - RX
RSTATEB EQU     SMC2PB+$008     ; SMC2 RX Internal State
RBPRTB  EQU     SMC2PB+$010     ; SMC2 RX BD Pointer
TSTATEB EQU     SMC2PB+$018     ; SMC2 TX Internal State
TDPTRB  EQU     SMC1PB+$01C     ; SMC2 TX Internal Data Ptr
TBPRTB  EQU     SMC2PB+$020     ; SMC2 TX BD Pointer
TBCNTB  EQU     SMC2PB+$022     ; SMC2 TX Internal Byte Count

* SPI PARAMETERS

RBASEI	equ	SPIPB+$000
TBASEI	equ	SPIPB+$002
RFCRI	equ	SPIPB+$004
TFCRI	equ	SPIPB+$005
MRBRLI	equ	SPIPB+$006

************************** Specific Parameters ******************************

* SCC2, UART Specific Parameters      ### Following Parameters
MAXIDL2 EQU     SCC2PB+$38      ; SCC2 MAX IDLe cchars
IDLC2   EQU     SCC2PB+$3A      ; SCC2 temp IDLe Counter
BRKCR2  EQU     SCC2PB+$3C      ; SCC2 BReaK Count Register (TX)
PAREC2  EQU     SCC2PB+$3E      ; SCC2 Parity Error Counter (RX)
FRMER2  EQU     SCC2PB+$40      ; SCC2 Framing Error Counter (RX)
NOSEC2  EQU     SCC2PB+$42      ; SCC2 Noise Counter (RX)
BRKEC2  EQU     SCC2PB+$44      ; SCC2 BReaK Condition Counter (RX)
BRKLN2  EQU     SCC2PB+$46      ; SCC2 Last BReaK Length (RX)
UADDR12 EQU     SCC2PB+$48      ; SCC2 UART Address Character 1
UADDR22 EQU     SCC2PB+$4A      ; SCC2 UART Address Character 2
RETMP2  EQU     SCC2PB+$4C      ; SCC2 Temp storage
TOSEQ2  EQU     SCC2PB+$4E      ; SCC2 TX out of sequence Character
CCHAR12 EQU     SCC2PB+$50      ; SCC2 Control Character 1
CCHAR22 EQU     SCC2PB+$52      ; SCC2 Control Character 2
CCHAR32 EQU     SCC2PB+$54      ; SCC2 Control Character 3
CCHAR42 EQU     SCC2PB+$56      ; SCC2 Control Character 4
CCHAR52 EQU     SCC2PB+$58      ; SCC2 Control Character 5
CCHAR62 EQU     SCC2PB+$5A      ; SCC2 Control Character 6
CCHAR72 EQU     SCC2PB+$5C      ; SCC2 Control Character 7
CCHAR82 EQU     SCC2PB+$5E      ; SCC2 Control Character 8
RCCM2   EQU     SCC2PB+$60      ; SCC2 RX Control Character Mask
RCCR2   EQU     SCC2PB+$62      ; SCC2 RX Control Character
RLBC2   EQU     SCC2PB+$64      ; SCC2 RX Last Break Character

* SCC3, UART Specific Parameters
MAXIDL3 EQU     SCC3PB+$38      ; SCC3 MAX IDLe cchars
IDLC3   EQU     SCC3PB+$3A      ; SCC3 temp IDLe Counter
BRKCR3  EQU     SCC3PB+$3C      ; SCC3 BReaK Count Register (TX)
PAREC3  EQU     SCC3PB+$3E      ; SCC3 Parity Error Counter (RX)
FRMER3  EQU     SCC3PB+$40      ; SCC3 Framing Error Counter (RX)
NOSEC3  EQU     SCC3PB+$42      ; SCC3 Noise Counter (RX)
BRKEC3  EQU     SCC3PB+$44      ; SCC3 BReaK Condition Counter (RX)
BRKLN3  EQU     SCC3PB+$46      ; SCC3 Last BReaK Length (RX)
UADDR13 EQU     SCC3PB+$48      ; SCC3 UART Address Character 1
UADDR23 EQU     SCC3PB+$4A      ; SCC3 UART Address Character 2
RETMP3  EQU     SCC3PB+$4C      ; SCC3 Temp storage
TOSEQ3  EQU     SCC3PB+$4E      ; SCC3 TX out of sequence Character
CCHAR13 EQU     SCC3PB+$50      ; SCC3 Control Character 1
CCHAR23 EQU     SCC3PB+$52      ; SCC3 Control Character 2
CCHAR33 EQU     SCC3PB+$54      ; SCC3 Control Character 3
CCHAR43 EQU     SCC3PB+$56      ; SCC3 Control Character 4
CCHAR53 EQU     SCC3PB+$58      ; SCC3 Control Character 5
CCHAR63 EQU     SCC3PB+$5A      ; SCC3 Control Character 6
CCHAR73 EQU     SCC3PB+$5C      ; SCC3 Control Character 7
CCHAR83 EQU     SCC3PB+$5E      ; SCC3 Control Character 8
RCCM3   EQU     SCC3PB+$60      ; SCC3 RX Control Character Mask
RCCR3   EQU     SCC3PB+$62      ; SCC3 RX Control Character
RLBC3   EQU     SCC3PB+$64      ; SCC3 RX Last Break Character

* SCC4, UART Specific Parameters
MAXIDL4 EQU     SCC4PB+$38      ; SCC4 MAX IDLe cchars
IDLC4   EQU     SCC4PB+$3A      ; SCC4 temp IDLe Counter
BRKCR4  EQU     SCC4PB+$3C      ; SCC4 BReaK Count Register (TX)
PAREC4  EQU     SCC4PB+$3E      ; SCC4 Parity Error Counter (RX)
FRMER4  EQU     SCC4PB+$40      ; SCC4 Framing Error Counter (RX)
NOSEC4  EQU     SCC4PB+$42      ; SCC4 Noise Counter (RX)
BRKEC4  EQU     SCC4PB+$44      ; SCC4 BReaK Condition Counter (RX)
BRKLN4  EQU     SCC4PB+$46      ; SCC4 Last BReaK Length (RX)
UADDR14 EQU     SCC4PB+$48      ; SCC4 UART Address Character 1
UADDR24 EQU     SCC4PB+$4A      ; SCC4 UART Address Character 2
RETMP4  EQU     SCC4PB+$4C      ; SCC4 Temp storage
TOSEQ4  EQU     SCC4PB+$4E      ; SCC4 TX out of sequence Character
CCHAR14 EQU     SCC4PB+$50      ; SCC4 Control Character 1
CCHAR24 EQU     SCC4PB+$52      ; SCC4 Control Character 2
CCHAR34 EQU     SCC4PB+$54      ; SCC4 Control Character 3
CCHAR44 EQU     SCC4PB+$56      ; SCC4 Control Character 4
CCHAR54 EQU     SCC4PB+$58      ; SCC4 Control Character 5
CCHAR64 EQU     SCC4PB+$5A      ; SCC4 Control Character 6
CCHAR74 EQU     SCC4PB+$5C      ; SCC4 Control Character 7
CCHAR84 EQU     SCC4PB+$5E      ; SCC4 Control Character 8
RCCM4   EQU     SCC4PB+$60      ; SCC4 RX Control Character Mask
RCCR4   EQU     SCC4PB+$62      ; SCC4 RX Control Character
RLBC4   EQU     SCC4PB+$64      ; SCC4 RX Last Break Character

* SMC1, UART Specific Parameters
MAXIDLA EQU     SMC1PB+$28      ; SMC1 MAX IDLe cchars
IDLCA   EQU     SMC1PB+$2A      ; SMC1 temp IDLe Counter
BRKLA   EQU     SMC1PB+$2C      ; SMC1 last Received BReaK char length
BRKECA  EQU     SMC1PB+$2E      ; SMC1 receive BReaK Condition Counter
BRKCRA  EQU     SMC1PB+$30      ; SMC1 BReaK Count Register (TX)

*	CPM Interrupt Mask Bits (written to CIMR)

SCC1IEn		equ	$40000000
SCC2IEn		equ	$20000000
SCC3IEn		equ	$10000000
SCC4IEn		equ	$08000000

SCC1IDb		equ	$BFFFFFFF
SCC2IDb		equ	$DFFFFFFF
SCC3IDb		equ	$EFFFFFFF
SCC4IDb		equ	$F7FFFFFF

SPIIEn		equ	$20
SMC1IEn		equ	$10

*	Interrupt Vectors

SCC1IV	equ	$9E
SCC2IV	equ	$9D
SCC3IV	equ	$9C
SCC4IV	equ	$9B
SMC1IV	equ	$84
SPIIV	equ	$85
SDMA_BE	equ	$96


TIMER1IEn	EQU	$02000000
TIMER2IEn	EQU	$00040000
TIMER3IEn	EQU	$00001000
TIMER4IEn	equ	$00000080

TIMER1VEC	equ	$19
TIMER2VEC	equ	$12
TIMER3VEC	equ	$0C
TIMER4VEC	equ	$07
ERRORVEC	equ	$0


* SCC2, HDLC Specific Parameters
C_MASK2		EQU	SCC2PB+$34			;SCC2 CRC Constant
C_PRES2		EQU	SCC2PB+$38			;SCC2 CRC Preset
DISFC2		EQU	SCC2PB+$3C			;SCC2 Discard Frame Counter
CRCEC2		EQU	SCC2PB+$3E			;SCC2 CRC Error Counter
ABTSC2		EQU	SCC2PB+$40			;SCC2 Abort Sequnce Counter
NMARC2		EQU	SCC2PB+$42			;SCC2 Nonmatching Address Rx Counter
RETRC2		EQU	SCC2PB+$44			;SCC2 Frame Transmission Counter
MFLR2			EQU	SCC2PB+$46			;SCC2 Max Frame Length Register
RFTHR2		EQU	SCC2PB+$4A			;SCC2 Received Frames Threshold
HMASK2		EQU	SCC2PB+$4E			;SCC2 User Defined Frame Address Mask
HADDR12		EQU	SCC2PB+$50			;SCC2 User Defined Frame Address
HADDR22		EQU	SCC2PB+$52			;SCC2 User Defined Frame Address
HADDR32		EQU	SCC2PB+$54			;SCC2 User Defined Frame Address
HADDR42		EQU	SCC2PB+$56			;SCC2 User Defined Frame Address


* SCC3, HDLC Specific Parameters
C_MASK3		EQU	SCC3PB+$34			;SCC3 CRC Constant
C_PRES3		EQU	SCC3PB+$38			;SCC3 CRC Preset
DISFC3		EQU	SCC3PB+$3C			;SCC3 Discard Frame Counter
CRCEC3		EQU	SCC3PB+$3E			;SCC3 CRC Error Counter
ABTSC3		EQU	SCC3PB+$40			;SCC3 Abort Sequnce Counter
NMARC3		EQU	SCC3PB+$42			;SCC3 Nonmatching Address Rx Counter
RETRC3		EQU	SCC3PB+$44			;SCC3 Frame Transmission Counter
MFLR3			EQU	SCC3PB+$46			;SCC3 Max Frame Length Register
RFTHR3		EQU	SCC3PB+$4A			;SCC3 Received Frames Threshold
HMASK3		EQU	SCC3PB+$4E			;SCC3 User Defined Frame Address Mask
HADDR13		EQU	SCC3PB+$50			;SCC3 User Defined Frame Address
HADDR23		EQU	SCC3PB+$52			;SCC3 User Defined Frame Address
HADDR33		EQU	SCC3PB+$54			;SCC3 User Defined Frame Address
HADDR43		EQU	SCC3PB+$56			;SCC3 User Defined Frame Address


* SCC4, HDLC Specific Parameters
C_MASK4		EQU	SCC4PB+$34			;SCC4 CRC Constant
C_PRES4		EQU	SCC4PB+$38			;SCC4 CRC Preset
DISFC4		EQU	SCC4PB+$3C			;SCC4 Discard Frame Counter
CRCEC4		EQU	SCC4PB+$3E			;SCC4 CRC Error Counter
ABTSC4		EQU	SCC4PB+$40			;SCC4 Abort Sequnce Counter
NMARC4		EQU	SCC4PB+$42			;SCC4 Nonmatching Address Rx Counter
RETRC4		EQU	SCC4PB+$44			;SCC4 Frame Transmission Counter
MFLR4			EQU	SCC4PB+$46			;SCC4 Max Frame Length Register
RFTHR4		EQU	SCC4PB+$4A			;SCC4 Received Frames Threshold
HMASK4		EQU	SCC4PB+$4E			;SCC4 User Defined Frame Address Mask
HADDR14		EQU	SCC4PB+$50			;SCC4 User Defined Frame Address
HADDR24		EQU	SCC4PB+$52			;SCC4 User Defined Frame Address
HADDR34		EQU	SCC4PB+$54			;SCC4 User Defined Frame Address
HADDR44		EQU	SCC4PB+$56			;SCC4 User Defined Frame Address
