;     21/july/97 Chetan made the initialization of IVT using the VBR
;		contents. See the comments NEW_BOOT.
; 		Thus old assumptions of VBR are made away now
;     Also Boot Mode locations in DPRAM and DRAM are added

RX_BUF_SIZE_SCC1	EQU	$0600	; Max Buffer Size = 1520 bytes
SCC1VEC 	EQU	$1e		; Vector for SCC1 (5 bits)

RX_BUF_SIZE_SCC2	EQU	$0600	; Max Buffer Size = 1520 bytes ### (O.K.)
SCC2VEC 	        EQU	$1d	; Vector for SCC2 (5 bits) ###(O.K.)

;The following line commented out by Naveen
;URT1VEC 	EQU	$1d		; Vector for URT1 (5 bits)

URT2VEC 	EQU	$1c		; Vector for URT2 (5 bits)
URT3VEC 	EQU	$1b		; Vector for URT2 (5 bits)

MAX_NO_RX_BD	equ	$8
MAX_NO_TX_BD	equ	$4

;for SCC1
ETH_NO_RX_BD_SCC1	equ	$8
ETH_NO_TX_BD_SCC1	equ	$4

;for SCC2
ETH_NO_RX_BD_SCC2	equ	$8 ;### (O.K.)
ETH_NO_TX_BD_SCC2	equ	$4 ;### (O.K.)

ASYNC_HDLC_NO_RX_BD	equ	$8
ASYNC_HDLC_NO_TX_BD	equ	$4

SYNC_WAN_NO_RX_BD	equ	$8
SYNC_WAN_NO_TX_BD	equ	$4

; the ASYNC HDLC micro code is to be located from DPRBASE+0 till DPRBASE+400h
; also the DPRBASE+600h to DPRBASE+6ffh is not to be used for it is the
; micro code scratch. So all the buffer descriptors for the different SCC's are 
; to be located within the boundary DPRBASE+400 to DPRBASE+5ff. SMC port 
; requires one rxbd and one txbd. the SCC BD's are located after this.
; maximum of only 64 bd's can be allocated.

SccBufferDescs	EQU	ModBaseAdr+$400
;For SCC1
SMC1RxBD		equ	SccBufferDescs
SMC1TxBD		equ	SccBufferDescs+$8

;For SCC2
;SMC2RxBD		equ	SccBufferDescs ### (Not Reqd)
;SMC2TxBD		equ	SccBufferDescs+$8 ### (Not Reqd)

OFFSETSMC1RXBD	equ	SMC1RxBD-ModBaseAdr
OFFSETSMC1TXBD	equ	SMC1TxBD-ModBaseAdr

;OFFSETSMC2RXBD	equ	SMC2RxBD-ModBaseAdr ; ### (Not Reqd)
;OFFSETSMC2TXBD	equ	SMC2TxBD-ModBaseAdr ; ### (Not Reqd)

OFFSETSCC1RXBD	EQU	OFFSETSMC1TXBD+8
OFFSETSCC1TXBD	EQU	OFFSETSCC1RXBD+8*MAX_NO_RX_BD	;50	

OFFSETSCC2RXBD	EQU	OFFSETSCC1TXBD+8*MAX_NO_TX_BD 	;70
OFFSETSCC2TXBD	EQU	OFFSETSCC2RXBD+8*MAX_NO_RX_BD 	;B0

OFFSETWAN1RXBD	EQU	OFFSETSCC1TXBD+8*MAX_NO_TX_BD 	;70
OFFSETWAN1TXBD	EQU	OFFSETWAN1RXBD+8*MAX_NO_RX_BD 	;B0

OFFSETWAN2RXBD	EQU	OFFSETWAN1TXBD+8*MAX_NO_TX_BD 	;D0
OFFSETWAN2TXBD	EQU	OFFSETWAN2RXBD+8*MAX_NO_RX_BD 	;110

OFFSETWAN3RXBD	EQU	OFFSETWAN2TXBD+8*MAX_NO_TX_BD 	;130
OFFSETWAN3TXBD	EQU	OFFSETWAN3RXBD+8*MAX_NO_RX_BD 	;170

WAN_RX_BUF_SIZE	EQU	3200		; Max Buffer Size = 3k bytes

;SCC1
SCC1RXBD	EQU	ModBaseAdr+OFFSETSCC1RXBD
SCC1TXBD	EQU	ModBaseAdr+OFFSETSCC1TXBD

;SCC2
SCC2RXBD	EQU	ModBaseAdr+OFFSETSCC2RXBD ;
SCC2TXBD	EQU	ModBaseAdr+OFFSETSCC2TXBD ;

* The Following line is commented by Naveen 
WAN1RXBD	EQU	ModBaseAdr+OFFSETWAN1RXBD
WAN1TXBD	EQU	ModBaseAdr+OFFSETWAN1TXBD

WAN2RXBD	EQU	ModBaseAdr+OFFSETWAN2RXBD
WAN2TXBD	EQU	ModBaseAdr+OFFSETWAN2TXBD

WAN3RXBD	EQU	ModBaseAdr+OFFSETWAN3RXBD
WAN3TXBD	EQU	ModBaseAdr+OFFSETWAN3TXBD

; Kamalnath SLIP 14\03\1997 
PPP_DELIMITER	 	EQU		$7E
SLIP_DELIMITER		EQU		$C0
; Kamalnath SLIP 14\03\1997
SAFE_LEVEL			EQU		7


; NEW_BOOT
;SCC2VECOFFSET	equ	$100274	
;SCC3VECOFFSET	equ	$100270
;SCC4VECOFFSET	equ	$10026c
; NEW_BOOT
OFFSETBOOTMODELOC	EQU OFFSETWAN3TXBD+8*MAX_NO_TX_BD 	;190
BootModeLocationInDPRAM EQU ModBaseAdr+OFFSETBOOTMODELOC
BootModeLocationInSIMMDRAM EQU $1C10

