
RX_BUF_SIZE_SCC1	EQU	$0600	; Max Buffer Size = 1520 bytes
SCC1VEC 	        EQU	$1e		; Vector for SCC1 (5 bits)

RX_BUF_SIZE_SCC2	EQU	$0600	; Max Buffer Size = 1520 bytes ### (O.K.)
SCC2VEC 	        EQU	$1d	; Vector for SCC2 (5 bits) ###(O.K.)

;The following line commented out by Naveen
;URT1VEC 	EQU	$1d		; Vector for URT1 (5 bits)

URT2VEC 	EQU	$1c		; Vector for URT2 (5 bits)
URT3VEC 	EQU	$1b		; Vector for URT2 (5 bits)

MAX_NO_RX_BD	equ	$8
MAX_NO_TX_BD	equ	$4

;for SCC1
ETH_NO_RX_BD_SCC1	equ	$8
ETH_NO_TX_BD_SCC1	equ	$4

;for SCC2
ETH_NO_RX_BD_SCC2	equ	$8 ;### (O.K.)
ETH_NO_TX_BD_SCC2	equ	$4 ;### (O.K.)

ASYNC_HDLC_NO_RX_BD	equ	$8
ASYNC_HDLC_NO_TX_BD	equ	$4

SYNC_WAN_NO_RX_BD	equ	$8
SYNC_WAN_NO_TX_BD	equ	$4

; the ASYNC HDLC micro code is to be located from DPRBASE+0 till DPRBASE+400h
; also the DPRBASE+600h to DPRBASE+6ffh is not to be used for it is the
; micro code scratch. So all the buffer descriptors for the different SCC's are 
; to be located within the boundary DPRBASE+400 to DPRBASE+5ff. SMC port 
; requires one rxbd and one txbd. the SCC BD's are located after this.
; maximum of only 64 bd's can be allocated.

SccBufferDescs	EQU	FFFF 0400
;For SCC1
SMC1RxBD		equ	FFFF 0400
SMC1TxBD		equ	FFFF 0408 

OFFSETSMC1RXBD	equ	FFFF 0400 - FFFF 0000 = 0000 0400
OFFSETSMC1TXBD	equ	FFFF 0408 - FFFF 0000 = 0000 0408

OFFSETSCC1RXBD	EQU	0000 0408 + 8 = 0000 0410
OFFSETSCC1TXBD	EQU	0000 0410 + 8 * 8 = 0000 0450

OFFSETSCC2RXBD	EQU	0000 0450 + 8 * 4  =  0000 0470 ;70
OFFSETSCC2TXBD	EQU	0000 0470 + 8 * 8  =  0000 04B0 ;B0

OFFSETWAN1RXBD	EQU	0000 0470 	;70
OFFSETWAN1TXBD	EQU	0000 04B0 	;B0

OFFSETWAN2RXBD	EQU	OFFSETWAN1TXBD+8*MAX_NO_TX_BD 	;D0
OFFSETWAN2TXBD	EQU	OFFSETWAN2RXBD+8*MAX_NO_RX_BD 	;110

OFFSETWAN3RXBD	EQU	OFFSETWAN2TXBD+8*MAX_NO_TX_BD 	;130
OFFSETWAN3TXBD	EQU	OFFSETWAN3RXBD+8*MAX_NO_RX_BD 	;170

WAN_RX_BUF_SIZE	EQU	3200		; Max Buffer Size = 3k bytes

;SCC1
SCC1RXBD	EQU	FFFF 0000 + 0000 0410 = FFFF 0410 
SCC1TXBD	EQU	FFFF 0000 + 0000 0450 = FFFF 0450

;SCC2
SCC2RXBD	EQU	FFFF 0000 + 0000 0470 = FFFF 0470;
SCC2TXBD	EQU	FFFF 0000 + 0000 04B0 = FFFF 04B0; 

* The Following line is commented by Naveen 
WAN1RXBD	EQU	ModBaseAdr+OFFSETWAN1RXBD
WAN1TXBD	EQU	ModBaseAdr+OFFSETWAN1TXBD

WAN2RXBD	EQU	ModBaseAdr+OFFSETWAN2RXBD
WAN2TXBD	EQU	ModBaseAdr+OFFSETWAN2TXBD

WAN3RXBD	EQU	ModBaseAdr+OFFSETWAN3RXBD
WAN3TXBD	EQU	ModBaseAdr+OFFSETWAN3TXBD

; Kamalnath SLIP 14\03\1997 
PPP_DELIMITER	 	EQU		$7E
SLIP_DELIMITER		EQU		$C0
; Kamalnath SLIP 14\03\1997
SAFE_LEVEL			EQU		7


; NEW_BOOT
;SCC2VECOFFSET	equ	$100274	
;SCC3VECOFFSET	equ	$100270
;SCC4VECOFFSET	equ	$10026c
; NEW_BOOT
OFFSETBOOTMODELOC	EQU OFFSETWAN3TXBD+8*MAX_NO_TX_BD 	;190
BootModeLocationInDPRAM EQU ModBaseAdr+OFFSETBOOTMODELOC
BootModeLocationInSIMMDRAM EQU $1C10

