/* KMSM.H -- Constants and structure declarations for the MSM module (MSM.C)
*/

#define MAX_WAN_PORTS					3
#define MODEM_INIT_STRING_LENGTH		41	/* 40 + 1 */
#define CONV_MODEM_INIT_STRING_LENGTH	65	/* 64 + 1 */

/* Possible modem state machine states */

/* Init states */
#define MSM_SEND_A				0
#define MSM_SEND_T				1
#define MSM_SEND_REST			2
#define MSM_WAIT_OK				3

/* Hangup states */
#define MSM_DTR_DOWN			4
#define MSM_HUP_CHECK_CD		5
#define MSM_SEND_HUP_STRING		6
#define MSM_WAIT_BREAK			7
#define MSM_END_HUP_STRING		8

/* Break states */
#define MSM_WAIT_SEND_BREAK		9


/* Delays for each state. Before doing state actions, the state has to
** wait for this much time. Basically this is a wait after the previous
** actions. Delay is in seconds.
*/

/* Init state delays */
#define MSM_SEND_A_DELAY		0
#define MSM_SEND_T_DELAY		1
#define MSM_SEND_REST_DELAY		0
#define MSM_WAIT_OK_DELAY		4

/* Hangup state delays */
#define MSM_DTR_DOWN_DELAY			0
#define MSM_HUP_CHECK_CD_DELAY		2
#define MSM_SEND_HUP_STRING_DELAY	0
#define MSM_WAIT_BREAK_DELAY		0
#define MSM_END_HUP_STRING_DELAY	2

/* Break state delays */
#define MSM_WAIT_SEND_BREAK_DELAY	0


#define MODEM_COMMAND_PAUSE_TIME		1
#define MODEM_COMMAND_BREAK_TIME		5


#define MODEM_COMMAND_PAUSE_CHAR		'~'

typedef struct MSM_CLASS {
	ULONG application_id;
	enum BOOLEAN msm_timer_enabled;
	ULONG clock_ticks_per_second;

	enum BOOLEAN enabled[MAX_WAN_PORTS];
	int current_state[MAX_WAN_PORTS];
	ULONG current_state_wait[MAX_WAN_PORTS];

	/* 5 init strings */
	char modem_init_string[MAX_WAN_PORTS][5][CONV_MODEM_INIT_STRING_LENGTH];	
	BYTE current_init_string[MAX_WAN_PORTS];
	void (*fptr_modem_init_complete[MAX_WAN_PORTS])(USHORT, enum BOOLEAN);
	enum BOOLEAN ok_received[MAX_WAN_PORTS];

	char modem_hangup_string[MAX_WAN_PORTS][64]; /* Hangup string of max 63 bytes */
	char *sptr_command_str[MAX_WAN_PORTS];
	void (*fptr_modem_hangup_complete[MAX_WAN_PORTS])(USHORT);

	void (*fptr_write_function[MAX_WAN_PORTS])(USHORT, BYTE *, USHORT);
} MSM_CLASS;

typedef void (*MSM_CALLBACK)(USHORT, BYTE *, USHORT);
