#include	".\defs.h"
/* $modname: bsdcomp.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ccp.h"

/* Because this code is derived from the 4.3BSD compress source:
 *
 *
 * Copyright (c) 1985, 1986 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * James A. Woods, derived from original work by Spencer Thomas
 * and Joseph Orost.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*************************************************************************/
/* turn off Microsoft Visual C++ 2.2 Waring C4018 (signed/unsigned mismatch) */
#if defined (_MSC_VER)
	#pragma warning (disable: 4018)
#endif
/*************************************************************************/
enum BOOLEAN check_to_reset_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database);
static void *BSD_set_hash_table_size_and_hash_table_shift_value (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	USHORT largest_code_size_used, ULONG *ulptr_hash_table_size, ULONG *ulptr_hash_table_shift_value);
static BSD_COMPRESSION_DATABASE *create_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	ULONG hash_table_size, ULONG largest_valid_code, USHORT **ptr_usptr_lengths_of_codes);
void allocate_new_code_and_keep_hash_table_correct (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	BSD_COMPRESSION_DICTIONARY **ptr_sptr_dictionary, ULONG old_code, ULONG final_character, ULONG *ulptr_largest_code_in_use, 
	ULONG *ulptr_current_bits_or_code, ULONG *ulptr_bit_number_when_accumulator_is_full);
enum TEST handle_clear_code (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	BYTE *bptr_BSD_compressed_data, BYTE *bptr_end_of_BSD_compressed_data, BYTE **ptr_bptr_first_write_position, 
	BYTE *bptr_current_write_position);
/*************************************************************************/
void BSD_clear_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database)
{
	sptr_BSD_compression_database->number_of_times_the_dictionary_get_cleared++;
	sptr_BSD_compression_database->largest_code_in_use = FIRST_CODE - 1;
	sptr_BSD_compression_database->current_bits_or_code = BSD_INITIAL_BITS;
	sptr_BSD_compression_database->recent_compression_ratio = 0x00000000L;
	sptr_BSD_compression_database->number_of_compressed_bytes = 0x00000000L;
	sptr_BSD_compression_database->number_of_uncompressed_bytes = 0x00000000L;
	sptr_BSD_compression_database->number_of_incompressible_packets = 0x00000000L;
	sptr_BSD_compression_database->number_of_packets_decompressed = 0x00000000L;
	sptr_BSD_compression_database->ratio_check_point = CHECK_GAP;
}
/*************************************************************************/
enum BOOLEAN check_to_reset_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database)
{
	ULONG new_compression_ratio;

	if (sptr_BSD_compression_database->number_of_uncompressed_bytes >= sptr_BSD_compression_database->ratio_check_point) 
		{
		/* age the ratio by limiting the size of the counts */
		if ((sptr_BSD_compression_database->number_of_uncompressed_bytes >= MAXIMUM_RATIO)	|| 
			(sptr_BSD_compression_database->number_of_compressed_bytes >= MAXIMUM_RATIO)) 
			{
			sptr_BSD_compression_database->number_of_uncompressed_bytes 
				-= (sptr_BSD_compression_database->number_of_uncompressed_bytes / 4);
			sptr_BSD_compression_database->number_of_compressed_bytes 
				-= (sptr_BSD_compression_database->number_of_compressed_bytes / 4);
			}

		sptr_BSD_compression_database->ratio_check_point = sptr_BSD_compression_database->number_of_uncompressed_bytes + CHECK_GAP;

		if (sptr_BSD_compression_database->largest_code_in_use >= sptr_BSD_compression_database->largest_valid_code) 
			{
			/* Reset the dictionary only if the ratio is worse, or if it looks as if it has been poisoned by incompressible data.
			   This does not overflow, because sptr_BSD_compression_database->number_of_uncompressed_bytes <= MAXIMUM_RATIO. */
			new_compression_ratio = sptr_BSD_compression_database->number_of_uncompressed_bytes << RATIO_SCALE_LOG;
			
			if (sptr_BSD_compression_database->number_of_compressed_bytes != 0x00000000L)
				{
				new_compression_ratio /= sptr_BSD_compression_database->number_of_compressed_bytes;
				}

			if ((new_compression_ratio < sptr_BSD_compression_database->recent_compression_ratio) || 
				(new_compression_ratio < 1 * RATIO_SCALE)) 
				{
				BSD_clear_database (sptr_BSD_compression_database);
				
				ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Compression Database Is Reset on Port %04x", 
				sptr_BSD_compression_database->real_port_number);
				
				return (TRUE);
				}
			
			sptr_BSD_compression_database->recent_compression_ratio = new_compression_ratio;
			}
		}
	
	return (FALSE);
}
/****************************************************************************/
static void *BSD_set_hash_table_size_and_hash_table_shift_value (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	USHORT largest_code_size_used, ULONG *ulptr_hash_table_size, ULONG *ulptr_hash_table_shift_value)
{
	switch (largest_code_size_used)
		{
		case 9:          /* needs 82152 for both directions */
		case 10:         /* needs 84144 */
		case 11:         /* needs 88240 */
		case 12:         /* needs 96432 */
		   
			*ulptr_hash_table_size = 5003;
			*ulptr_hash_table_shift_value = 4;
			
			break;

		case 13:
		                 /* needs 176784 */
			*ulptr_hash_table_size = 9001;
			*ulptr_hash_table_shift_value = 5;
			
			break;

		case 14:
		                 /* needs 353744 */
			*ulptr_hash_table_size = 18013;
			*ulptr_hash_table_shift_value = 6;
			
			break;

		case 15:   
		                 /* needs 691440 */
			*ulptr_hash_table_size = 35023;
			*ulptr_hash_table_shift_value = 7;
			
			break;

		default:
		   
			if (sptr_BSD_compression_database != NULL)
				{
				if (sptr_BSD_compression_database->lengths_of_codes != NULL)
					{
					buffer_free ((void *) sptr_BSD_compression_database->lengths_of_codes);
					}

				buffer_free ((void *) sptr_BSD_compression_database);
				}

			return (NULL);
		}
		return (1);
}
/****************************************************************************/
static BSD_COMPRESSION_DATABASE *create_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	ULONG hash_table_size, ULONG largest_valid_code, USHORT **ptr_usptr_lengths_of_codes)
{
	ULONG new_length;
	ULONG index;

	new_length = sizeof (*sptr_BSD_compression_database) + 
		(hash_table_size - 1) * (sizeof (sptr_BSD_compression_database->dictionary[0]));

	if (sptr_BSD_compression_database != NULL) 
		{
		*ptr_usptr_lengths_of_codes = sptr_BSD_compression_database->lengths_of_codes;
		
		if (sptr_BSD_compression_database->total_length_of_database != new_length) 
			{
			if (*ptr_usptr_lengths_of_codes != NULL)
				{
				buffer_free ((void *) *ptr_usptr_lengths_of_codes);
				}
			
			buffer_free ((void *) sptr_BSD_compression_database);
			
			sptr_BSD_compression_database = NULL;
			}
		}
	
	if (sptr_BSD_compression_database == NULL) 
		{
		sptr_BSD_compression_database = (BSD_COMPRESSION_DATABASE*) buffer_malloc (new_length);
		
		if (sptr_BSD_compression_database == NULL)
			{
			ccp_printf (CCP_ALARM_PRINTF, "CCP:BSD LZW: create_BSD_compression_database () buffer_malloc () failed\n");
			
			return (NULL);
			}
		
      *ptr_usptr_lengths_of_codes = 
      	(USHORT *) buffer_malloc ((largest_valid_code + 1) * sizeof (**ptr_usptr_lengths_of_codes));
      
      if (*ptr_usptr_lengths_of_codes == NULL) 
      	{
			ccp_printf (CCP_ALARM_PRINTF, "CCP:BSD LZW: create_BSD_compression_database () buffer_malloc () failed\n");
      	
      	buffer_free ((void *) sptr_BSD_compression_database);
      	
      	return (NULL);
      	}
      
      index = LAST_CODE + 1;
      
      while (index != 0x00000000L)
			{
      	(*ptr_usptr_lengths_of_codes)[--index] = 1;
			}
		
		index = hash_table_size;
		
		while (index != 0x00000000L) 
			{
			sptr_BSD_compression_database->dictionary[--index].output_of_hash_table_minus_one = BAD_CODE_MINUS_ONE;
			sptr_BSD_compression_database->dictionary[index].code_to_hash_table_entry = 0x0000;
			}
	}

	memset ((void *) sptr_BSD_compression_database, '\0', 
		sizeof (*sptr_BSD_compression_database) - sizeof (sptr_BSD_compression_database->dictionary));
	
	return (sptr_BSD_compression_database);
}	
/****************************************************************************/
BSD_COMPRESSION_DATABASE *create_and_initialize_BSD_compression_database (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	USHORT real_port_number, USHORT largest_code_size_used)
{
	ULONG largest_valid_code;
	USHORT *usptr_lengths_of_codes;
	ULONG hash_table_size;
	ULONG hash_table_shift_value;

	if (BSD_set_hash_table_size_and_hash_table_shift_value (sptr_BSD_compression_database, largest_code_size_used, &hash_table_size, 
		&hash_table_shift_value)	== NULL)
		{
		return (NULL); 
		}
	
	largest_valid_code = MAXIMUM_CODE (largest_code_size_used);
	
	sptr_BSD_compression_database = create_BSD_compression_database (sptr_BSD_compression_database, hash_table_size, 
		largest_valid_code, &usptr_lengths_of_codes);

	if (sptr_BSD_compression_database == NULL)
		{
		return (NULL);
		}

	sptr_BSD_compression_database->lengths_of_codes = usptr_lengths_of_codes;
	sptr_BSD_compression_database->real_port_number = real_port_number;
	sptr_BSD_compression_database->hash_table_size = hash_table_size;
	sptr_BSD_compression_database->hash_table_shift_value = (BYTE) hash_table_shift_value;
	sptr_BSD_compression_database->largest_valid_code = largest_valid_code;
	sptr_BSD_compression_database->number_of_times_the_dictionary_get_cleared = -1;
	
	BSD_clear_database (sptr_BSD_compression_database);
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Compression Database Is Reset on Port %04x", real_port_number);

	return (sptr_BSD_compression_database);
}
/****************************************************************************/
void	BSD_compress_incompressible_data (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database, 
	BYTE *bptr_incompressible_data, USHORT incompressible_data_length)
{
	ULONG hash_table_shift_value;
	ULONG largest_code_in_use;
	ULONG current_bits_or_code;
	ULONG bit_number;
	ULONG hash_value_code;
	ULONG code;
	USHORT length_of_data_to_be_processed;
	BYTE current_character;
	BSD_COMPRESSION_DICTIONARY *sptr_dictionary;
	BYTE *bptr_end_of_incompressible_data;
	
	int hash_value;
	int displacement;

	hash_table_shift_value = sptr_BSD_compression_database->hash_table_shift_value;
	largest_code_in_use = sptr_BSD_compression_database->largest_code_in_use;
	current_bits_or_code = sptr_BSD_compression_database->current_bits_or_code;
	bit_number = 7;
	
	sptr_BSD_compression_database->number_of_incompressible_packets++;

	code = *bptr_incompressible_data++;
	--incompressible_data_length;

	sptr_BSD_compression_database->number_of_uncompressed_bytes++;	/* count the protocol as 1 byte */
	sptr_BSD_compression_database->sequence_number++;
	bptr_end_of_incompressible_data = bptr_incompressible_data + incompressible_data_length;

	for (length_of_data_to_be_processed = (USHORT) (bptr_end_of_incompressible_data - bptr_incompressible_data); 
		length_of_data_to_be_processed != 0x0000; 
		length_of_data_to_be_processed = (USHORT) (bptr_end_of_incompressible_data - bptr_incompressible_data)) 
		{
		sptr_BSD_compression_database->number_of_uncompressed_bytes += length_of_data_to_be_processed;

		do 
			{
			current_character = *bptr_incompressible_data++;
			hash_value_code = BSD_KEY (code, current_character);
			hash_value = BSD_HASH (code, current_character, hash_table_shift_value);
			sptr_dictionary = &sptr_BSD_compression_database->dictionary[hash_value];

			if (sptr_dictionary->output_of_hash_table_minus_one >= largest_code_in_use)	/* validate and then check the entry */
				{
				goto nomatch;
				}
			if (sptr_dictionary->union_hash_value.hash_value_code == hash_value_code) 
				{
				code = sptr_dictionary->output_of_hash_table_minus_one + 1;
				
				continue;   /* found (prefix,suffix) */
				}

			displacement = (hash_value == 0) ? 1 : hash_value;	/* continue probing until a match or invalid entry */
			
			do 
				{
				hash_value += displacement;
				
				if (hash_value >= sptr_BSD_compression_database->hash_table_size)
					{
					hash_value -= sptr_BSD_compression_database->hash_table_size;
					}
				
				sptr_dictionary = &sptr_BSD_compression_database->dictionary[hash_value];
				
				if (sptr_dictionary->output_of_hash_table_minus_one >= largest_code_in_use)
					{
					goto nomatch;
					}
				
				} while (sptr_dictionary->union_hash_value.hash_value_code != hash_value_code);
			
			code = sptr_dictionary->output_of_hash_table_minus_one + 1;
			
			continue;	/* finally found (prefix,suffix) */

		nomatch:	/* output (count) the prefix */
			
			bit_number += current_bits_or_code;

			if (largest_code_in_use < sptr_BSD_compression_database->largest_valid_code)	/* code -> hashtable */ 
				{
				BSD_COMPRESSION_DICTIONARY *sptr_dictionary_2;
				
				if (largest_code_in_use >= MAXIMUM_CODE (current_bits_or_code))	/* expand code size if needed */
					{
					sptr_BSD_compression_database->current_bits_or_code = (BYTE) ++current_bits_or_code;
					}       

				/* Invalidate previous hash table entry assigned this code, and then take it over. */
				sptr_dictionary_2 = &sptr_BSD_compression_database->dictionary[largest_code_in_use + 1];
				
				if (sptr_BSD_compression_database->dictionary[sptr_dictionary_2->code_to_hash_table_entry].\
					output_of_hash_table_minus_one == largest_code_in_use)
					{
					sptr_BSD_compression_database->dictionary[sptr_dictionary_2->code_to_hash_table_entry].output_of_hash_table_minus_one
						 = BAD_CODE_MINUS_ONE;
					}
				
				sptr_dictionary_2->code_to_hash_table_entry = (USHORT) hash_value;
				sptr_dictionary->output_of_hash_table_minus_one = (USHORT) largest_code_in_use;
				sptr_dictionary->union_hash_value.hash_value_code = hash_value_code;
				sptr_BSD_compression_database->largest_code_in_use = ++largest_code_in_use;
				sptr_BSD_compression_database->lengths_of_codes[largest_code_in_use] = 
					(USHORT) (sptr_BSD_compression_database->lengths_of_codes[code] + 1);
				}
			
			code = current_character;
			
			} while (--length_of_data_to_be_processed != 0x0000);
		}
	
	bit_number += current_bits_or_code;	/* output (count) the last code */
	sptr_BSD_compression_database->number_of_compressed_bytes += bit_number/8;

	(void) check_to_reset_BSD_compression_database (sptr_BSD_compression_database);
	
	/* Increase code size if we would have without the packet boundary and as the decompressor will. */
	if ((largest_code_in_use >= MAXIMUM_CODE (current_bits_or_code)) && 
		(largest_code_in_use < sptr_BSD_compression_database->largest_valid_code))
		{
		sptr_BSD_compression_database->current_bits_or_code++;
		}
}
/****************************************************************************/
enum TEST handle_clear_code (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	BYTE *bptr_BSD_compressed_data, BYTE *bptr_end_of_BSD_compressed_data, BYTE **ptr_bptr_first_write_position, 
	BYTE *bptr_current_write_position)
{
	/* The dictionary must only be cleared at	the end of a packet. But there could be an
	 * empty message block at the end. */
	if (bptr_BSD_compressed_data != bptr_end_of_BSD_compressed_data) 
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:BSD LZW: Bad CLEAR Received on Port %04x\n",
			sptr_BSD_compression_database->real_port_number);

		return (FAIL);
		}
	
	BSD_clear_database (sptr_BSD_compression_database);
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Compression Database Is Reset on Port %04x", 
		sptr_BSD_compression_database->real_port_number);

	*ptr_bptr_first_write_position = bptr_current_write_position;

	return (PASS);
}
/****************************************************************************/
void allocate_new_code_and_keep_hash_table_correct (BSD_COMPRESSION_DATABASE *sptr_BSD_compression_database,
	BSD_COMPRESSION_DICTIONARY **ptr_sptr_dictionary, ULONG old_code, ULONG final_character, ULONG *ulptr_largest_code_in_use, 
	ULONG *ulptr_current_bits_or_code, ULONG *ulptr_bit_number_when_accumulator_is_full)
{
	BSD_COMPRESSION_DICTIONARY *sptr_dictionary_2;
	ULONG hash_value_code;
	
	int hash_value; 
	int displacement;

	hash_value_code = BSD_KEY (old_code, final_character);

	hash_value = BSD_HASH (old_code, final_character, sptr_BSD_compression_database->hash_table_shift_value);

	*ptr_sptr_dictionary = &sptr_BSD_compression_database->dictionary[hash_value];

	if ((*ptr_sptr_dictionary)->output_of_hash_table_minus_one < *ulptr_largest_code_in_use) 	/* look for a free hash table entry */
		{
		displacement = (hash_value == 0) ? 1 : hash_value;
		
		do 
			{
			hash_value += displacement;
			
			if (hash_value >= sptr_BSD_compression_database->hash_table_size)
				{
				hash_value -= sptr_BSD_compression_database->hash_table_size;
				}
			
			*ptr_sptr_dictionary = &sptr_BSD_compression_database->dictionary[hash_value];
			
			} while ((*ptr_sptr_dictionary)->output_of_hash_table_minus_one < *ulptr_largest_code_in_use);
		}

	/* Invalidate previous hash table entry assigned this code, and then take it over */
	sptr_dictionary_2 = &sptr_BSD_compression_database->dictionary[*ulptr_largest_code_in_use + 1];
	
	if (sptr_BSD_compression_database->dictionary[sptr_dictionary_2->code_to_hash_table_entry].output_of_hash_table_minus_one ==
		 *ulptr_largest_code_in_use) 
		{
		sptr_BSD_compression_database->dictionary[sptr_dictionary_2->code_to_hash_table_entry].output_of_hash_table_minus_one = 
			BAD_CODE_MINUS_ONE;
		}
	
	sptr_dictionary_2->code_to_hash_table_entry = (USHORT) hash_value;
	(*ptr_sptr_dictionary)->output_of_hash_table_minus_one = (USHORT) *ulptr_largest_code_in_use;
	(*ptr_sptr_dictionary)->union_hash_value.hash_value_code = hash_value_code;

	sptr_BSD_compression_database->largest_code_in_use = ++(*ulptr_largest_code_in_use);
	sptr_BSD_compression_database->lengths_of_codes[*ulptr_largest_code_in_use] = 
		(USHORT) (sptr_BSD_compression_database->lengths_of_codes[old_code] + 1);

	if ((*ulptr_largest_code_in_use >= MAXIMUM_CODE (*ulptr_current_bits_or_code)) && 
		(*ulptr_largest_code_in_use < sptr_BSD_compression_database->largest_valid_code))	/* Expand code size if needed. */
		{
		sptr_BSD_compression_database->current_bits_or_code = (BYTE) ++(*ulptr_current_bits_or_code);
		*ulptr_bit_number_when_accumulator_is_full = 32 - *ulptr_current_bits_or_code;
		}
}
