#include	".\defs.h"
/* $modname: ccpinit.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define GLOBAL_FILE

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ccp.h"
/****************************************************************************/
static enum TEST initialize_sender_predictor_compression_database (USHORT real_port_number);
static enum TEST initialize_receiver_predictor_compression_database (USHORT real_port_number);
static enum TEST initialize_sender_BSD_compression_database (USHORT real_port_number);
static enum TEST initialize_receiver_BSD_compression_database (USHORT real_port_number);

#ifdef STAC_LZS	
static enum TEST initialize_sender_and_receiver_stacker_compression_database (USHORT real_port_number);
#endif	/* STAC_LZS	*/

static enum TEST initialize_no_compression_database (USHORT real_port_number);
static PPP_PACKET_WITH_MAC_HEADER *nothing_compress_ppp (USHORT real_port_number, USHORT protocol_virtual_port_number, 
	enum BOOLEAN device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer));
static UNION_PPP_PACKET *nothing_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length);
static void predictor_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void stacker_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void BSD_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void predictor_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void stacker_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void BSD_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet);
static void initialize_ccp_statistics_counters (USHORT real_port_number);
static void initialize_ccp_mibs (USHORT real_port_number);
static void initialize_ccp_class (USHORT real_port_number);
static OPTION_LISTS *get_ccp_option_lists (USHORT real_port_number);
static PPP_PACKET_WITH_MAC_HEADER *(*get_sender_comression_function (USHORT real_port_number)) (USHORT real_port_number, 
	USHORT protocol_virtual_port_number, enum BOOLEAN device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length,	void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer));	
static UNION_PPP_PACKET *(*get_receiver_decompression_function (USHORT real_port_number)) (USHORT real_port_number, 
	UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length);
static enum PPP_STATE get_ccp_state (USHORT real_port_number); 
static enum BOOLEAN get_sender_compression_database_initialization_status (USHORT real_port_number);
static enum BOOLEAN get_receiver_compression_database_initialization_status (USHORT real_port_number);
static BYTE get_last_id_of_ccp_packet_sent (USHORT real_port_number);
static enum BOOLEAN get_ccp_port_status (USHORT real_port_number);
static void initialize_ccp_functions (void); 
static void ccp_register_event_upcall (ULONG (*fptr_event_upcall) (USHORT real_port_number, USHORT event,...));
/*************************************************************************/ 
#if defined (_MSC_VER)
/*************************************************************************/ 
ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...)
{
	va_list argptr;
	ULONG return_value;
	ULONG parameter[10];
	BYTE parameter_index;

	check_for_ccp_initialization_breakpoint ();

	va_start (argptr,command);

	for (parameter_index = 0x00; parameter_index < 6; parameter_index = (BYTE) (parameter_index + 1))
		{
		parameter[parameter_index] = va_arg (argptr,ULONG);
		}

	return_value = 0x00000000L;

	switch (command)
		{
		case RW_INITIALIZE:
			
			return_value = (ULONG) PASS;	/* ccp is initialized by ppp */
			
			break;
		
		case RW_GET_CLASS_ADDRESS:
			
			return_value = (ULONG) &ccp;
			
			break;
		
		case RW_GET_CLASS_SIZE:
			
			return_value = sizeof (ccp);
			
			break;
		
		case RW_GET_CONFIGURATION_TABLE_ADDRESS:
			
			return_value = get_ccp_configuration_table_address ();
			
			break;
		}

	return (return_value);
}
#endif
/****************************************************************************/
void initialize_ccp 
(
	USHORT number_of_ppp_ports, 
	
	void (**ptr_fptr_execute_ccp_state_machine_function) (enum PPP_EVENT ppp_event, USHORT real_port_number, 
		void *vptr_packet, USHORT number_of_bytes),

	PPP_PACKET_WITH_MAC_HEADER	*(*(**ptr_fptr_get_sender_compression_function_function) (USHORT real_port_number)) 
		(USHORT real_port_number, USHORT protocol_virtual_port_number, enum BOOLEAN device_driver_buffer, 
		PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,	
		void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer)),

	UNION_PPP_PACKET *(*(**ptr_fptr_get_receiver_decompression_function_function) (USHORT real_port_number)) 
		(USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length),

	void (**ptr_fptr_ccp_timer_routine) (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
		ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests, 
		ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests),

	enum TEST (**ptr_fptr_ccp_packet_received_function) (USHORT real_port_number, void *vptr_ccp_rx_packet, 
		USHORT number_of_bytes_rxed),
	
	OPTION_LISTS *(**ptr_fptr_get_ccp_option_lists_function) (USHORT real_port_number),

	enum PPP_STATE (**ptr_fptr_get_ccp_state_function) (USHORT real_port_number), 

	enum BOOLEAN (**ptr_fptr_get_sender_compression_database_initialization_status_function) (USHORT real_port_number),

	enum BOOLEAN (**ptr_fptr_get_receiver_compression_database_initialization_status_function) (USHORT real_port_number),

	enum BOOLEAN (**ptr_fptr_get_ccp_port_status_function) (USHORT real_port_number),

	BYTE (**ptr_fptr_get_last_id_of_ccp_packet_sent_function) (USHORT real_port_number),

	ULONG (*fptr_get_device_driver_id_function) (USHORT real_port_number),
	ULONG (*fptr_get_maximum_number_of_termination_requests_function) (void),
	ULONG (*fptr_get_ppp_remote_MRU_function) (USHORT real_port_number),
	OPTION_LISTS *(*fptr_get_ccp_option_lists_created_by_ppp_function) (USHORT real_port_number)
)
{
	OPTION_LISTS *sptr_ppp_option_list;
	USHORT real_port_number;

	for (real_port_number = 0x0000; real_port_number < number_of_ppp_ports; ++real_port_number)
		{
		sptr_ppp_option_list = (*fptr_get_ccp_option_lists_created_by_ppp_function) (real_port_number);

		ccp.ports[real_port_number].option_lists = *sptr_ppp_option_list;

		initialize_ccp_class (real_port_number);

		ccp_printf (CCP_DATA_PRINTF, "\nCCP: Initialized CCP Port %04x\n", real_port_number); 
		}
	
	initialize_ccp_functions (); 
	
	ccp_register_event_upcall (ccp_event_upcall_example);

	*ptr_fptr_execute_ccp_state_machine_function = execute_ccp_state_machine;
	*ptr_fptr_get_sender_compression_function_function = get_sender_comression_function;
	*ptr_fptr_get_receiver_decompression_function_function = get_receiver_decompression_function;
	*ptr_fptr_ccp_timer_routine = ccp_timer_routine;
	*ptr_fptr_ccp_packet_received_function = ccp_packet_received;

	*ptr_fptr_get_ccp_option_lists_function = get_ccp_option_lists;
	*ptr_fptr_get_ccp_state_function = get_ccp_state;
	*ptr_fptr_get_sender_compression_database_initialization_status_function = 
		get_sender_compression_database_initialization_status;
	*ptr_fptr_get_receiver_compression_database_initialization_status_function	= 
		get_receiver_compression_database_initialization_status;
	*ptr_fptr_get_ccp_port_status_function = get_ccp_port_status;
	*ptr_fptr_get_last_id_of_ccp_packet_sent_function = get_last_id_of_ccp_packet_sent;

	ccp.ppp.fptr_get_device_driver_id_function =	fptr_get_device_driver_id_function;
	ccp.ppp.fptr_get_maximum_number_of_termination_requests_function = fptr_get_maximum_number_of_termination_requests_function;
	ccp.ppp.fptr_get_ppp_remote_MRU_function = fptr_get_ppp_remote_MRU_function;
}
/****************************************************************************/
static void initialize_ccp_class (USHORT real_port_number)
{
	initialize_ccp_statistics_counters (real_port_number);

	initialize_ccp_mibs (real_port_number);

	ccp.ports[real_port_number].state = PPP_OPENED_STATE;
	ccp.ports[real_port_number].port_number = real_port_number;
	ccp.ports[real_port_number].state = PPP_INITIAL_STATE;
	ccp.ports[real_port_number].old_state = PPP_INITIAL_STATE;

	ccp.ports[real_port_number].fptr_ccp_packet_received[CONFIGURE_REQUEST] = ccp_configure_request_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[CONFIGURE_ACK] = ccp_configure_ack_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[CONFIGURE_NAK] = ccp_configure_nak_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[CONFIGURE_REJECT] = ccp_configure_reject_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[TERMINATION_REQUEST] = ccp_termination_request_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[TERMINATION_ACK] =	ccp_termination_ack_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[CODE_REJECT] = ccp_code_reject_received;

	ccp.ports[real_port_number].fptr_ccp_packet_received[RESET_REQUEST] =	ccp_reset_request_received;
	ccp.ports[real_port_number].fptr_ccp_packet_received[RESET_ACK] =	ccp_reset_ack_received;

	ccp.ports[real_port_number].receive.fptr_process_receive_options[CCP_PREDICTOR_TYPE_I] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_request_option_processor;
	ccp.ports[real_port_number].receive_nak.fptr_process_receive_options[CCP_PREDICTOR_TYPE_I] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_nak_option_processor;
	
	ccp.ports[real_port_number].receive.fptr_process_receive_options[CCP_PREDICTOR_TYPE_II] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_request_option_processor;
	ccp.ports[real_port_number].receive_nak.fptr_process_receive_options[CCP_PREDICTOR_TYPE_II] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_nak_option_processor;
	
	ccp.ports[real_port_number].receive.fptr_process_receive_options[CCP_BSD_LZW_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_request_option_processor;
	ccp.ports[real_port_number].receive_nak.fptr_process_receive_options[CCP_BSD_LZW_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_nak_option_processor;

#ifdef STAC_LZS	
	ccp.ports[real_port_number].receive.fptr_process_receive_options[CCP_STACKER_LZS_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_request_option_processor;
	ccp.ports[real_port_number].receive_nak.fptr_process_receive_options[CCP_STACKER_LZS_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ccp_configure_nak_option_processor;
#endif /* STAC_LZS */
	
	copy_configuration_options_to_tx_accepted_options (&ccp.ports[real_port_number].option_lists);
}
/******************************************************************************/
static void initialize_ccp_statistics_counters (USHORT real_port_number)
{
	memset (&ccp.ports[real_port_number].ccp_statistics, (int) NULL, sizeof (PPP_CCP_STATISTICS));
}
/******************************************************************************/
static void initialize_ccp_mibs (USHORT real_port_number)
{
	PARAMETER_NOT_USED (real_port_number);
}
/****************************************************************************/
static void initialize_ccp_functions (void) 
{
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_initialize_sender_compression_database =
		initialize_sender_predictor_compression_database;
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_initialize_receiver_compression_database =
		initialize_receiver_predictor_compression_database;
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_sender_compress_ppp = predictor_type_I_compress_ppp;
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_receiver_decompress_ppp = predictor_type_I_decompress_ppp;
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_receiver_handle_reset_ack = predictor_handle_reset_ack;
	ccp.functions[CCP_PREDICTOR_TYPE_I].fptr_sender_handle_reset_request = predictor_handle_reset_request;

	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_initialize_sender_compression_database =
		initialize_sender_predictor_compression_database;
	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_initialize_receiver_compression_database =
		initialize_receiver_predictor_compression_database;
	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_sender_compress_ppp = predictor_type_II_compress_ppp;
	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_receiver_decompress_ppp = predictor_type_II_decompress_ppp;
	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_receiver_handle_reset_ack = predictor_handle_reset_ack;
	ccp.functions[CCP_PREDICTOR_TYPE_II].fptr_sender_handle_reset_request = predictor_handle_reset_request;

#ifdef STAC_LZS	
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_initialize_sender_compression_database =
		initialize_sender_and_receiver_stacker_compression_database;
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_initialize_receiver_compression_database =
		initialize_sender_and_receiver_stacker_compression_database;
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_sender_compress_ppp = stacker_compress_ppp;
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_receiver_decompress_ppp = stacker_decompress_ppp;
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_receiver_handle_reset_ack = stacker_handle_reset_ack;
	ccp.functions[CCP_STACKER_LZS_COMPRESSION].fptr_sender_handle_reset_request = stacker_handle_reset_request;
#endif	/*  STAC_LZS	*/
			 
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_initialize_sender_compression_database =
		initialize_sender_BSD_compression_database;
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_initialize_receiver_compression_database =
		initialize_receiver_BSD_compression_database;
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_sender_compress_ppp = BSD_compress_ppp;
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_receiver_decompress_ppp = BSD_decompress_ppp;
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_receiver_handle_reset_ack = BSD_handle_reset_ack;
	ccp.functions[CCP_BSD_LZW_COMPRESSION].fptr_sender_handle_reset_request = BSD_handle_reset_request;
	
	ccp.functions[CCP_NO_COMPRESSION_NEGOTIATED].fptr_initialize_sender_compression_database = 
		initialize_no_compression_database;
	ccp.functions[CCP_NO_COMPRESSION_NEGOTIATED].fptr_initialize_receiver_compression_database = 
		initialize_no_compression_database;
	ccp.functions[CCP_NO_COMPRESSION_NEGOTIATED].fptr_sender_compress_ppp = nothing_compress_ppp;
	ccp.functions[CCP_NO_COMPRESSION_NEGOTIATED].fptr_receiver_decompress_ppp = nothing_decompress_ppp;
}
/****************************************************************************/
static enum TEST initialize_sender_predictor_compression_database (USHORT real_port_number)
{
	ccp.ports[real_port_number].predictor.compression_hash_value = 0x0000;
 
	if	(ccp.ports[real_port_number].predictor.bptr_compression_guess_table == NULL)
		{
		ccp.ports[real_port_number].predictor.bptr_compression_guess_table = (BYTE *) buffer_malloc (SIZE_OF_PREDICTOR_GUESS_TABLE);
	
		if (ccp.ports[real_port_number].predictor.bptr_compression_guess_table == NULL)
			{
			return (FAIL);
			}
		}
	
	memset (ccp.ports[real_port_number].predictor.bptr_compression_guess_table, (BYTE) '\0', SIZE_OF_PREDICTOR_GUESS_TABLE);
		
	ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor: Sender Compression Guess Table and Hash Value Are Reset on Port %04x", 
		real_port_number);
	
	return (PASS);
}
/****************************************************************************/
static enum TEST initialize_receiver_predictor_compression_database (USHORT real_port_number)
{
	ccp.ports[real_port_number].predictor.decompression_hash_value = 0x0000;
 
	if (ccp.ports[real_port_number].predictor.bptr_decompression_guess_table == NULL)
		{
		ccp.ports[real_port_number].predictor.bptr_decompression_guess_table = (BYTE *) buffer_malloc (SIZE_OF_PREDICTOR_GUESS_TABLE);

		if (ccp.ports[real_port_number].predictor.bptr_decompression_guess_table == NULL)
			{
			return (FAIL);
			}
		}
	
	memset (ccp.ports[real_port_number].predictor.bptr_decompression_guess_table, (BYTE) '\0', SIZE_OF_PREDICTOR_GUESS_TABLE);

	ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor: Receiver Compression Guess Table and Hash Value Are Reset on Port %04x", 
		real_port_number);

	return (PASS);
}
/****************************************************************************/
static enum TEST initialize_receiver_BSD_compression_database (USHORT real_port_number)
{
	USHORT receiver_code_size;
	
	receiver_code_size = (USHORT) (ccp.ports[real_port_number].BSD.receiver_compression_vers_and_dict & 0x0f);

	ccp.ports[real_port_number].BSD.sptr_receiver_compression_database = 
		create_and_initialize_BSD_compression_database (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database, 
			real_port_number, receiver_code_size);

	if (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database == NULL)
		{
		return (FAIL);
		}

/* Sowmya 7/2/96 */	
	ccp.ports[real_port_number].BSD.sptr_receiver_compression_database->sequence_number = 0x0000;
/* Sowmya 7/2/96 */	

	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Receiver Compression Database Created And Initialized on Port %04x", 
		real_port_number);

	return (PASS);
}
/****************************************************************************/
static enum TEST initialize_sender_BSD_compression_database (USHORT real_port_number)
{
	USHORT sender_code_size;
	
	sender_code_size = (USHORT) (ccp.ports[real_port_number].BSD.sender_compression_vers_and_dict & 0x0f); 
 
	ccp.ports[real_port_number].BSD.sptr_sender_compression_database = 
		create_and_initialize_BSD_compression_database (ccp.ports[real_port_number].BSD.sptr_sender_compression_database, 
			real_port_number, sender_code_size);

	if (ccp.ports[real_port_number].BSD.sptr_sender_compression_database == NULL)
		{
		return (FAIL);
		}

/* Sowmya 7/2/96 */	
	ccp.ports[real_port_number].BSD.sptr_sender_compression_database->sequence_number = 0x0000;
/* Sowmya 7/2/96 */	

	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Sender Compression Database Created And Initialized on Port %04x", 
		real_port_number);

	return (PASS);
}
/****************************************************************************/
static enum TEST initialize_no_compression_database (USHORT real_port_number)
{
	PARAMETER_NOT_USED (real_port_number);

	return (PASS); 
}
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *nothing_compress_ppp (USHORT real_port_number, USHORT protocol_virtual_port_number, 
	enum BOOLEAN device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer))
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (protocol_virtual_port_number);
	PARAMETER_NOT_USED (device_driver_buffer);
	PARAMETER_NOT_USED (usptr_ppp_packet_length);
	PARAMETER_NOT_USED (ptr_fptr_tx_completion);

	return (sptr_ppp_packet);
}
/*************************************************************************/
static UNION_PPP_PACKET *nothing_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (usptr_ppp_packet_length);

	return (uptr_ppp_packet);
}
/****************************************************************************/
static void predictor_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (sptr_ccp_rx_packet);
}
/****************************************************************************/
static void BSD_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	ccp.ports[real_port_number].BSD.sptr_sender_compression_database->sequence_number = 0x0000;
	
	BSD_clear_database (ccp.ports[real_port_number].BSD.sptr_sender_compression_database);
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Sender Compression Database Is Reset on Port %04x", real_port_number);
	
	send_ccp_reset_ack (real_port_number, sptr_ccp_rx_packet);
}
/****************************************************************************/
static void predictor_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (sptr_ccp_rx_packet);
}
/****************************************************************************/
static void BSD_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	PARAMETER_NOT_USED (sptr_ccp_rx_packet);
	
	ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = FALSE;

	ccp.ports[real_port_number].BSD.sptr_receiver_compression_database->sequence_number = 0x0000;
	
	BSD_clear_database (ccp.ports[real_port_number].BSD.sptr_receiver_compression_database);

	ccp_printf (CCP_DATA_PRINTF, "CCP:BSD LZW: Receiver Compression Database Is Reset on Port %04x", real_port_number);
}
/****************************************************************************/
static OPTION_LISTS *get_ccp_option_lists (USHORT real_port_number)
{
	return (&ccp.ports[real_port_number].option_lists); 
}
/****************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *(*get_sender_comression_function (USHORT real_port_number)) (USHORT real_port_number, 
	USHORT protocol_virtual_port_number, enum BOOLEAN device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length,	void (**ptr_fptr_tx_completion) (USHORT port_number, void *vptr_buffer))	
{
	return (ccp.functions[ccp.ports[real_port_number].sender_primary_compression_algorithm].fptr_sender_compress_ppp); 
}
/****************************************************************************/
static UNION_PPP_PACKET *(*get_receiver_decompression_function (USHORT real_port_number)) (USHORT real_port_number, 
	UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length)
{
	return (ccp.functions[ccp.ports[real_port_number].receiver_primary_compression_algorithm].fptr_receiver_decompress_ppp); 
}
/****************************************************************************/
static enum PPP_STATE get_ccp_state (USHORT real_port_number) 
{
	return (ccp.ports[real_port_number].state); 
}
/****************************************************************************/
static enum BOOLEAN get_sender_compression_database_initialization_status (USHORT real_port_number)
{
	return (ccp.ports[real_port_number].sender_compression_database_initialization_failure);	
}
/****************************************************************************/
static enum BOOLEAN get_receiver_compression_database_initialization_status (USHORT real_port_number)
{
	return (ccp.ports[real_port_number].receiver_compression_database_initialization_failure);	
}
/****************************************************************************/
static BYTE get_last_id_of_ccp_packet_sent (USHORT real_port_number)
{
	return (ccp.ports[real_port_number].last_id_of_ccp_packet_sent);
}
/****************************************************************************/
static enum BOOLEAN get_ccp_port_status (USHORT real_port_number)
{
	return (ccp.ports[real_port_number].enabled); 
}
/****************************************************************************/
static void ccp_register_event_upcall (ULONG (*fptr_event_upcall) (USHORT real_port_number,USHORT event,...))
{
	ccp.fptr_event_upcall = fptr_event_upcall; 
}

/****************************************************************************/
#ifdef STAC_LZS	

static enum TEST initialize_sender_and_receiver_stacker_compression_database (USHORT real_port_number)
{
	if (ccp.ports[real_port_number].stacker.bptr_scratch_RAM == NULL)
		{
		ccp.ports[real_port_number].stacker.bptr_scratch_RAM = (BYTE *) buffer_malloc (LZS_HISTORY_SIZE);
		
		if (ccp.ports[real_port_number].stacker.bptr_scratch_RAM == NULL)
			{
			return (FAIL);
			}
		}
		
	LZS_InitHistory (ccp.ports[real_port_number].stacker.bptr_scratch_RAM);
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: Compression History Is Reset on Port %04x", real_port_number);
	
	return (PASS);	 
}
/****************************************************************************/
static void stacker_handle_reset_request (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	CCP_RESET_REQUEST_WITH_HISTORY_NUMBER *sptr_reset_request_packet;
	USHORT history_number;

	sptr_reset_request_packet = (CCP_RESET_REQUEST_WITH_HISTORY_NUMBER *) sptr_ccp_rx_packet;

	if (net_to_host_short (sptr_reset_request_packet->length) == 
		(sizeof (CCP_RESET_REQUEST_WITH_HISTORY_NUMBER) - sizeof (PPP_HEADER)))
		{
		history_number = net_to_host_short (sptr_reset_request_packet->history_number);

		if (history_number != 0x0001)
			{
			ccp_printf (CCP_ALARM_PRINTF, "CCP:STACKER LZS: Invalid History Number Received on Port: %04x\n", real_port_number);
			}
		}
	
	LZS_InitHistory (ccp.ports[real_port_number].stacker.bptr_scratch_RAM);

	ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: Compression History Is Reset on Port %04x", real_port_number);
	
	send_ccp_reset_ack_with_history_number (real_port_number, sptr_ccp_rx_packet);
}
/****************************************************************************/
static void stacker_handle_reset_ack (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet)
{
	CCP_RESET_ACK_WITH_HISTORY_NUMBER *sptr_reset_ack_packet;
	USHORT history_number;

	sptr_reset_ack_packet = (CCP_RESET_ACK_WITH_HISTORY_NUMBER *) sptr_ccp_rx_packet;

	if (net_to_host_short (sptr_reset_ack_packet->length) == (sizeof (CCP_RESET_ACK_WITH_HISTORY_NUMBER) - sizeof (PPP_HEADER)))
		{
		history_number = net_to_host_short (sptr_reset_ack_packet->history_number);

		if (history_number != 0x0001)
			{
			ccp_printf (CCP_ALARM_PRINTF, "CCP:STACKER LZS: Invalid History Number Received on Port: %04x\n", real_port_number);
			}
		}
	
	if (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.structure.check_mode == SEQUENCE_NUMBER)
		{
		if (sptr_ccp_rx_packet->ccp_header.id != ccp.ports[real_port_number].last_id_of_ccp_packet_sent)
			{
			ccp_printf (CCP_ALARM_PRINTF,
				"CCP:STACKER LZS: Reset Ack received with wrong id on port: %04x, expected %02x, received %02x\n",	
				real_port_number, ccp.ports[real_port_number].last_id_of_ccp_packet_sent, sptr_ccp_rx_packet->ccp_header.id);
			
			return;
			}
		
		ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = FALSE;
		ccp.ports[real_port_number].stacker.receiver_sequence_number = 
			(BYTE) (ccp.ports[real_port_number].stacker.sequence_number_of_latest_received_packet + 1);
		}
	else
		{
		ccp.ports[real_port_number].receiver_is_waiting_for_reset_ack = FALSE;
		
		LZS_InitHistory (ccp.ports[real_port_number].stacker.bptr_scratch_RAM);
		
		ccp_printf (CCP_DATA_PRINTF, "CCP:Stacker LZS: Compression History Is Reset on Port %04x", real_port_number);
		}
}
#endif /* STAC_LZS	*/

extern	enum BOOLEAN ccp_state_machine_inited[];

void	reset_ccp_state_machine(USHORT port_number)
{
	ccp.ports[port_number].old_state = PPP_INITIAL_STATE;
	ccp.ports[port_number].state = PPP_STARTING_STATE;

	ccp_state_machine_inited[port_number] = FALSE;
}

