#include	".\defs.h"
/* $modname: ccppred2.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ccp.h"
/*************************************************************************/
static USHORT predictor_type_II_decompress_compression_stream (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet, PREDICTOR_TYPE_II_PACKET* sptr_predictor_type_II_packet, 
	USHORT predictor_type_II_packet_length, ULONG device_driver_id);
static USHORT predictor_type_II_decompress_compressed_frame (USHORT real_port_number, PREDICTOR_TYPE_I_PACKET* sptr_current_frame,
	BYTE *bptr_current_location_to_decompress_to, USHORT compressed_data_length, ULONG device_driver_id, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet);
static PPP_PACKET_WITH_MAC_HEADER *predictor_type_II_prepare_a_ppp_receive_packet (USHORT real_port_number, 
	PREDICTOR_TYPE_II_PACKET* sptr_predictor_type_II_packet, USHORT predictor_type_II_packet_length, ULONG device_driver_id);

extern	USHORT compress_uncompressible_predictor_type_data (USHORT real_port_number, BYTE *bptr_source, BYTE *bptr_destination, USHORT source_length);
/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *predictor_type_II_compress_ppp (USHORT real_port_number,USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	ccp_printf (CCP_DATA_PRINTF, "CCP:Predictor_type_II: Predictor_type_II uses Predictor_type_I to compress packet\n");

	return predictor_type_I_compress_ppp (real_port_number, protocol_virtual_port_number, eptr_device_driver_buffer, sptr_ppp_packet, 
		usptr_ppp_packet_length, ptr_fptr_tx_completion);
}
/*************************************************************************/
UNION_PPP_PACKET *predictor_type_II_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
	USHORT *usptr_ppp_packet_length)
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	PREDICTOR_TYPE_II_PACKET* sptr_predictor_type_II_packet;
	USHORT predictor_type_II_packet_length;
	USHORT decompressed_data_length;
	ULONG device_driver_id;
	
	if (uptr_ppp_packet->generic.header.protocol_type != FIRST_CHOICE_COMPRESSION_PROTOCOL)
		{
		return (uptr_ppp_packet); 
		}
	
	device_driver_id = (*ccp.ppp.fptr_get_device_driver_id_function) (real_port_number);

	sptr_predictor_type_II_packet = (PREDICTOR_TYPE_II_PACKET *) ((BYTE *) uptr_ppp_packet + sizeof (PPP_HEADER));
	predictor_type_II_packet_length = (USHORT) (*usptr_ppp_packet_length - sizeof (PPP_HEADER));

	sptr_decompressed_ppp_packet = predictor_type_II_prepare_a_ppp_receive_packet (real_port_number, sptr_predictor_type_II_packet,
		predictor_type_II_packet_length, device_driver_id);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		return (NULL);
		}
	
	decompressed_data_length = predictor_type_II_decompress_compression_stream (real_port_number, sptr_decompressed_ppp_packet, 
		sptr_predictor_type_II_packet, predictor_type_II_packet_length, device_driver_id);

	if (decompressed_data_length == 0x0000)
		{
		return (NULL);
		}

	*usptr_ppp_packet_length = (USHORT) (decompressed_data_length + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS);
	
	/* now that we are done with the original PPP packet, we free it. */
	device_driver_free (real_port_number, device_driver_id, (void *) uptr_ppp_packet);
	
	return ((UNION_PPP_PACKET *) &(sptr_decompressed_ppp_packet->header));
}
/*************************************************************************/
static USHORT predictor_type_II_decompress_compression_stream (USHORT real_port_number, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet, PREDICTOR_TYPE_II_PACKET* sptr_predictor_type_II_packet, 
	USHORT predictor_type_II_packet_length, ULONG device_driver_id)
{
	BYTE *bptr_current_location_to_decompress_to;
	PREDICTOR_TYPE_I_PACKET* sptr_current_frame;
	BYTE *bptr_end_of_predictor_type_II_packet;
	USHORT current_frame_compressed_data_length;
	USHORT current_frame_decompressed_data_length;
	USHORT total_decompressed_data_length;

/* Sowmya 15/3/96 */	
	USHORT	longest_possible_compressed_data_length;
	PPP_PACKET_WITH_MAC_HEADER *sptr_compressed_ppp_packet;
/* Sowmya 15/3/96 */	

	total_decompressed_data_length = 0x0000;
	bptr_end_of_predictor_type_II_packet = (BYTE *) sptr_predictor_type_II_packet	+ predictor_type_II_packet_length;
	
	bptr_current_location_to_decompress_to = (BYTE *) (&(sptr_decompressed_ppp_packet->header)) + 
		SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS;
	
	for (sptr_current_frame = &(sptr_predictor_type_II_packet->frames[0]); 
		(BYTE *) sptr_current_frame < bptr_end_of_predictor_type_II_packet; 
		sptr_current_frame = 
			(PREDICTOR_TYPE_I_PACKET *) ((BYTE *) sptr_current_frame + current_frame_compressed_data_length + 
			SIZE_OF_WAN_CRC + SIZE_OF_PREDICTOR_COMPRESSION_FLAG_AND_LENGTH ))
		{
		current_frame_compressed_data_length = sptr_current_frame->compression_flag_and_length.compressed_data_length;		

		if (sptr_current_frame->compression_flag_and_length.compression_flag == UNCOMPRESSED)
			{
/* Sowmya 15/3/96 */	
			/* call compress routine to update the decompression hash value */
			longest_possible_compressed_data_length = (USHORT) (current_frame_compressed_data_length/ 8 * 9 + 9);
	
			sptr_compressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
				device_driver_id, longest_possible_compressed_data_length);

			if (sptr_compressed_ppp_packet != NULL)
			{
				compress_uncompressible_predictor_type_data (real_port_number, sptr_current_frame->compressed_data,
					sptr_compressed_ppp_packet, current_frame_compressed_data_length );

				/* Now free up the buffer */
				device_driver_free (real_port_number, device_driver_id, (void *) sptr_compressed_ppp_packet);
			}
/* Sowmya 15/3/96 */	

			memcpy ((void *) bptr_current_location_to_decompress_to, (void *) sptr_current_frame->compressed_data,
				current_frame_compressed_data_length);
			
			current_frame_decompressed_data_length = current_frame_compressed_data_length;
			}
		else
			{	
			current_frame_decompressed_data_length = predictor_type_II_decompress_compressed_frame (real_port_number, 
				sptr_current_frame, bptr_current_location_to_decompress_to, current_frame_compressed_data_length, 
				device_driver_id, sptr_decompressed_ppp_packet);

			if (current_frame_decompressed_data_length == 0x0000)
				{
				return (0x0000);
				}
			}
		
		total_decompressed_data_length = (USHORT) (total_decompressed_data_length + current_frame_decompressed_data_length);
		bptr_current_location_to_decompress_to += current_frame_decompressed_data_length;
		}
	
	return (total_decompressed_data_length);
}
/*************************************************************************/
static USHORT predictor_type_II_decompress_compressed_frame (USHORT real_port_number, PREDICTOR_TYPE_I_PACKET* sptr_current_frame,
	BYTE *bptr_current_location_to_decompress_to, USHORT compressed_data_length, ULONG device_driver_id, 
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet)
{ 
	USHORT new_checksum;
	USHORT decompressed_data_length;
	USHORT compressed_data_length_used_by_the_compression_function;

	compressed_data_length_used_by_the_compression_function = compressed_data_length;
		
	decompressed_data_length = decompress (real_port_number, sptr_current_frame->compressed_data, 
		bptr_current_location_to_decompress_to, &compressed_data_length_used_by_the_compression_function, TRUE);

	ccp_printf (CCP_DATA_PRINTF, 
		"CCP:Predictor_type_II: PPP Packet Decompressed on Port %04x, Ratio(Compressed/Decompressed) = %d/%d\n",
		real_port_number, compressed_data_length, decompressed_data_length);

	bptr_current_location_to_decompress_to[decompressed_data_length] = 
		(sptr_current_frame->compressed_data)[compressed_data_length];
	bptr_current_location_to_decompress_to[decompressed_data_length + 1] = 
		(sptr_current_frame->compressed_data)[compressed_data_length + 1];
	
	new_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE, bptr_current_location_to_decompress_to,
		(USHORT) (decompressed_data_length + SIZE_OF_WAN_CRC));

	if (new_checksum != FINAL_GOOD_FRAME_CHECK_SEQUENCE)
		{
		ccp_printf (CCP_ALARM_PRINTF,"CCP:Predictor_type_II: CRC Check Failed on Port %04x\n",real_port_number);

		device_driver_free (real_port_number, device_driver_id, sptr_decompressed_ppp_packet);
		
		send_ccp_configuration_request (real_port_number);
		
		return (0x0000);
		}
	
	return (decompressed_data_length);
}		
/*************************************************************************/
static PPP_PACKET_WITH_MAC_HEADER *predictor_type_II_prepare_a_ppp_receive_packet (USHORT real_port_number, 
	PREDICTOR_TYPE_II_PACKET* sptr_predictor_type_II_packet, USHORT predictor_type_II_packet_length, ULONG device_driver_id)
{	
	PPP_PACKET_WITH_MAC_HEADER *sptr_decompressed_ppp_packet;
	PREDICTOR_TYPE_I_PACKET *sptr_current_frame;
	BYTE *bptr_end_of_predictor_type_II_packet;
	USHORT longest_possible_decompressed_data_length;
	USHORT decompressed_ppp_packet_length;
	USHORT current_frame_length;
	
	longest_possible_decompressed_data_length = 0x0000;
	bptr_end_of_predictor_type_II_packet = (BYTE *) sptr_predictor_type_II_packet	+ predictor_type_II_packet_length;

	for (sptr_current_frame = &(sptr_predictor_type_II_packet->frames[0]); 
		(BYTE *) sptr_current_frame < bptr_end_of_predictor_type_II_packet;
		sptr_current_frame = (PREDICTOR_TYPE_I_PACKET *) ((BYTE *) sptr_current_frame + current_frame_length + 
			SIZE_OF_WAN_CRC + SIZE_OF_PREDICTOR_COMPRESSION_FLAG_AND_LENGTH))
		{
		swap_in_place ((USHORT *) sptr_current_frame);
		
		current_frame_length = sptr_current_frame->compression_flag_and_length.compressed_data_length;
		
		longest_possible_decompressed_data_length = 
			(USHORT) (longest_possible_decompressed_data_length + (current_frame_length * 9 + 9));
		}
	
	decompressed_ppp_packet_length = (USHORT) (SIZE_OF_MAC_HEADER + SIZE_OF_PPP_CONTROL_AND_ADDRESS_FIELDS + 
		longest_possible_decompressed_data_length + SIZE_OF_WAN_CRC);
	
	sptr_decompressed_ppp_packet = (PPP_PACKET_WITH_MAC_HEADER *) device_driver_malloc (real_port_number, 
			device_driver_id, decompressed_ppp_packet_length);

	if (sptr_decompressed_ppp_packet == NULL)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Predictor_type_II: prepare_a_ppp_receive_packet () buffer_malloc () failed\n");
		
		return (NULL);
		}

	sptr_decompressed_ppp_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_decompressed_ppp_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

	return (sptr_decompressed_ppp_packet);
}
