#include	".\defs.h"
/* $modname: ccprx.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "ccp.h"
/****************************************************************************/
static enum TEST process_ccp_configuration_options (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet,
	USHORT number_of_bytes_rxed, USHORT number_of_bytes_processed);
static enum TEST process_ccp_configuration_nak_options (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, 
	USHORT number_of_bytes_rxed, USHORT number_of_bytes_processed);
/****************************************************************************/
enum TEST ccp_packet_received (USHORT real_port_number, void *vptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	CCP_PACKET *sptr_ccp_rx_packet;

	sptr_ccp_rx_packet = (CCP_PACKET *) vptr_ccp_rx_packet;
	
	ccp_printf (CCP_DATA_PRINTF, "CCP:Code: %02x, ID: %02x, Length %04x\n", sptr_ccp_rx_packet->ccp_header.code,
		sptr_ccp_rx_packet->ccp_header.id, swap (sptr_ccp_rx_packet->ccp_header.length));

	if (((sptr_ccp_rx_packet->ccp_header.code > CODE_REJECT) ||
		(sptr_ccp_rx_packet->ccp_header.code == (BYTE_ENUM (PPP_CONTROL_CODE)) 0x00)) && 
		(sptr_ccp_rx_packet->ccp_header.code != RESET_REQUEST) &&
		(sptr_ccp_rx_packet->ccp_header.code != RESET_ACK))
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP:Illegal CCP Received on port: %04x\n", real_port_number);

		execute_ccp_state_machine (PPP_RECEIVE_UNKNOWN_CODE_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);

		++ccp.ports[real_port_number].link_quality_counters.ifInErrors;

		ccp.ports[real_port_number].link_quality_counters.InGoodOctets -= number_of_bytes_rxed;

		return (FAIL);
		}

	(*ccp.ports[real_port_number].fptr_ccp_packet_received[sptr_ccp_rx_packet->ccp_header.code])
		(real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);

	++ccp.ports[real_port_number].ccp_statistics.number_of_rx_packets;
	++ccp.ports[real_port_number].ccp_statistics.number_of_control_rx_packets[sptr_ccp_rx_packet->ccp_header.code];

	ccp.ports[real_port_number].ccp_statistics.number_of_rx_bytes += number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
void ccp_configure_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	USHORT number_of_bytes_without_options;

	ccp_printf (CCP_DATA_PRINTF, "CCP:Configure Request Received on port: %04x\n", real_port_number);

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);

	ccp.ports[real_port_number].length_of_last_rxed_ccp_configuration_packet = number_of_bytes_rxed;

	memcpy (&ccp.ports[real_port_number].last_rxed_ccp_configuration_request_packet, sptr_ccp_rx_packet,number_of_bytes_rxed);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		if (process_ccp_configuration_options (real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed,
			number_of_bytes_without_options)	== FAIL)
				{
				ccp_printf (CCP_ALARM_PRINTF, "CCP:ERROR in receiving CCP Options on port: %04x\n", real_port_number);
		
				return;
				}
		}

	execute_ccp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_GOOD_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);
}
/****************************************************************************/
static enum TEST process_ccp_configuration_options (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet,
	USHORT number_of_bytes_rxed, USHORT number_of_bytes_processed)
{
	CCP_PORT_CLASS *sptr_port;
	enum OPTION_PARSE_RESULT parse_result;
	USHORT length_of_options_to_be_processed;

	sptr_port = &ccp.ports[real_port_number];

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_result = parse_ppp_options_from_configure_request (&sptr_port->option_lists,
		(PPP_OPTION *) &sptr_ccp_rx_packet->options, length_of_options_to_be_processed, 
		(RECEIVE_OPTION_FUNCTIONS *) &sptr_port->receive, sptr_port);

	if (parse_result == SOME_OPTIONS_ARE_REJECTED)
		{
		execute_ccp_state_machine (PPP_RECEIVE_CONFIG_REQUEST_BAD_OPTION_EVENT, real_port_number, sptr_ccp_rx_packet,
			number_of_bytes_rxed);

		return (FAIL);
		}
	else if (parse_result == SOME_OPTIONS_ARE_NACKED)
		{
		execute_ccp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_BAD_EVENT, real_port_number, sptr_ccp_rx_packet,
			number_of_bytes_rxed);

		return (FAIL);
		}
	else
		{
		return (PASS);
		}
}
/****************************************************************************/
void ccp_configure_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, 
	USHORT number_of_bytes_rxed)
{
	ccp_printf (CCP_DATA_PRINTF, "CCP:Configure ACK Received on port: %04x\n", real_port_number);

	if (number_of_bytes_rxed != ccp.ports[real_port_number].length_of_last_txed_ccp_packet)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Configuration ACK received with wrong length of packet on port: %04x\n", 
			real_port_number);

		return;
		}

	sptr_ccp_rx_packet->ccp_header.code = CONFIGURE_REQUEST;
	
	if (memcmp (sptr_ccp_rx_packet, &ccp.ports[real_port_number].last_txed_ccp_configuration_request_packet, 
		ccp.ports[real_port_number].length_of_last_txed_ccp_packet) != 0x00)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP:Configuration ACK received with wrong order of options on port: %04x\n", 
			real_port_number);

		return;
		}

	execute_ccp_state_machine (PPP_RECEIVE_CONFIGURE_ACK_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);
}
/****************************************************************************/
void ccp_configure_nak_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	USHORT number_of_bytes_without_options;

	ccp_printf (CCP_DATA_PRINTF, "CCP:Configure NAK Received on port: %04x\n", real_port_number);

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		if (process_ccp_configuration_nak_options (real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed, 
			number_of_bytes_without_options) == FAIL)
			{
			ccp_printf (CCP_ALARM_PRINTF, "CCP:Configuration NAK received with wrong order of options on port: %04x\n", 
				real_port_number);

			return;
			}
		}

	execute_ccp_state_machine (PPP_RECEIVE_CONFIGURE_NAK_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);

	ccp.ports[real_port_number].number_of_configuration_requests = 0x0000;
}
/****************************************************************************/
static enum TEST process_ccp_configuration_nak_options (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, 
	USHORT number_of_bytes_rxed, USHORT number_of_bytes_processed)
{
	CCP_PORT_CLASS *sptr_port;
	USHORT length_of_options_to_be_processed;

	sptr_port = &ccp.ports[real_port_number];

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_ppp_options_from_nak_configure (&sptr_port->option_lists, 
		(PPP_OPTION *) &sptr_ccp_rx_packet->options, length_of_options_to_be_processed, 
		(RECEIVE_OPTION_FUNCTIONS *) &sptr_port->receive_nak, sptr_port);

	return (PASS);
}
/****************************************************************************/
void ccp_configure_reject_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	USHORT length_of_options_to_be_processed;
	USHORT number_of_bytes_without_options;

	ccp_printf (CCP_DATA_PRINTF, "CCP:Configure Reject Received on port: %04x\n", real_port_number);

	if (sptr_ccp_rx_packet->ccp_header.id == ccp.ports[real_port_number].last_id_of_ccp_packet_sent)
		{
		number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (CCP_HEADER);

		length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_without_options);

		if (length_of_options_to_be_processed > 0x0000)
			{
			parse_ppp_options_from_reject_configure (&ccp.ports[real_port_number].option_lists, 
				(PPP_OPTION *) &sptr_ccp_rx_packet->options, length_of_options_to_be_processed);
			}

		execute_ccp_state_machine (PPP_RECEIVE_CONFIGURE_REJECT_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);

		ccp.ports[real_port_number].number_of_configuration_requests = 0x0000;
		}
}
/****************************************************************************/
void ccp_termination_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	ccp_printf (CCP_DATA_PRINTF, "CCP:Terminate REQUEST Received on port: %04x\n", real_port_number);

	execute_ccp_state_machine (PPP_RECEIVE_TERMINATE_REQUEST_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);

	/* wait 1 cycle for other side to terminate the link before trying to reset so we can come back up. rfc 1661 sect. 3.7*/

	execute_ccp_state_machine (PPP_CLOSE_EVENT, real_port_number, NULL, 0x0000);

	ccp.ports[real_port_number].number_of_termination_requests = 
		(USHORT) (*ccp.ppp.fptr_get_maximum_number_of_termination_requests_function) ();

	ccp.ports[real_port_number].termination_request_send_interval = 0x00000000L;
}
/****************************************************************************/
void ccp_termination_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	ccp_printf (CCP_DATA_PRINTF, "CCP:Terminate ACK Received on port: %04x\n", real_port_number);

	execute_ccp_state_machine (PPP_RECEIVE_TERMINATE_ACK_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);
}
/****************************************************************************/
void ccp_code_reject_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	ccp_printf (CCP_DATA_PRINTF, "CCP:Code Reject Received on port: %04x\n", real_port_number);

	execute_ccp_state_machine (PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT, real_port_number, sptr_ccp_rx_packet, number_of_bytes_rxed);
}
/****************************************************************************/
void ccp_reset_request_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	PARAMETER_NOT_USED (number_of_bytes_rxed);

	(*ccp.functions[ccp.ports[real_port_number].sender_primary_compression_algorithm].fptr_sender_handle_reset_request)
		(real_port_number, sptr_ccp_rx_packet);	
}
/****************************************************************************/
void ccp_reset_ack_received (USHORT real_port_number, CCP_PACKET *sptr_ccp_rx_packet, USHORT number_of_bytes_rxed)
{
	PARAMETER_NOT_USED (number_of_bytes_rxed);

	(*ccp.functions[ccp.ports[real_port_number].receiver_primary_compression_algorithm].fptr_receiver_handle_reset_ack)
		(real_port_number, sptr_ccp_rx_packet);	
}
