#include	".\defs.h"
/* $modname: ccpstate.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "ccp.h"
#include "vccpstat.h"
/****************************************************************************/
static void reset_predictor_hash_value_and_guess_table (USHORT real_port_number);
static void copy_negotiated_ccp_options_to_ccp_class (USHORT real_port_number);
static void initialize_BSD_lzw_compression_tables (USHORT real_port_number);
static enum CCP_OPTION_TYPE get_primary_compression_algorithm (OPTION_LIST *sptr_option_list);
static char *ccp_option_to_string (enum CCP_OPTION_TYPE ccp_option_type);
/****************************************************************************/
void execute_ccp_state_machine (enum PPP_EVENT ppp_event, USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes)
{
	enum PPP_STATE original_state;

	original_state = ccp.ports[real_port_number].state;

	ccp_printf (CCP_DATA_PRINTF, "CCP: Current State on Port %04x = %d\n", real_port_number, original_state); 

	if (ccp_state_machine_table[original_state][ppp_event].end_state == ILLEGAL_PPP_STATE)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP: Error in state machine %04x, Event %04x\n", real_port_number, (USHORT) ppp_event);

		return;
		}

	if (ccp_state_machine_table[original_state][ppp_event].fptr_state_function != NULL)
		{
		(*ccp_state_machine_table[original_state][ppp_event].fptr_state_function) (real_port_number, vptr_packet, number_of_bytes,
			ccp_state_machine_table[original_state][ppp_event].end_state);

		if ((ccp_state_machine_table[original_state][ppp_event].end_state != NO_CHANGE_TO_PPP_STATE) &&
			(ccp_state_machine_table[original_state][ppp_event].fptr_state_function != set_ccp_state))
			{
			set_ccp_state (real_port_number, NULL, 0x0000, ccp_state_machine_table[original_state][ppp_event].end_state);
			}
		}

	if (ccp_state_machine_table[original_state][ppp_event].fptr_state_function_1 != NULL)
		{
		(*ccp_state_machine_table[original_state][ppp_event].fptr_state_function_1) (real_port_number, vptr_packet, number_of_bytes,
			ccp_state_machine_table[original_state][ppp_event].end_state_1);

		if ((ccp_state_machine_table[original_state][ppp_event].end_state_1 != NO_CHANGE_TO_PPP_STATE) &&
			(ccp_state_machine_table[original_state][ppp_event].fptr_state_function_1 != set_ccp_state))
			{
			set_ccp_state (real_port_number, NULL, 0x0000, ccp_state_machine_table[original_state][ppp_event].end_state_1);
			}
		}

	if (ccp_state_machine_table[original_state][ppp_event].fptr_state_function_2 != NULL)
		{
		(*ccp_state_machine_table[original_state][ppp_event].fptr_state_function_2) (real_port_number, vptr_packet, number_of_bytes,
			ccp_state_machine_table[original_state][ppp_event].end_state_2);

		if ((ccp_state_machine_table[original_state][ppp_event].end_state_2 != NO_CHANGE_TO_PPP_STATE) &&
			(ccp_state_machine_table[original_state][ppp_event].fptr_state_function_2 != set_ccp_state))
			{
			set_ccp_state (real_port_number, NULL, 0x0000, ccp_state_machine_table[original_state][ppp_event].end_state_2);
			}
		}

	ccp.ports[real_port_number].old_state = (BYTE_ENUM (PPP_STATE)) original_state;

}
/****************************************************************************/
void set_ccp_state (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	if (end_state == ILLEGAL_PPP_STATE)
		{
		ccp_printf (CCP_ALARM_PRINTF, "CCP: Error in state machine %04x, end state %04x\n", real_port_number, (USHORT) end_state);
		return;
		}

	ccp_printf (CCP_DATA_PRINTF, "CCP: Port %04x - New State %04x\n", real_port_number, (USHORT) end_state);

	ccp.ports[real_port_number].state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void ccp_null_state (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
}
/****************************************************************************/
void ccp_this_layer_start (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	ccp.ports[real_port_number].state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void ccp_this_layer_finished (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	if (ccp.fptr_event_upcall != NULL)
		{
		(*ccp.fptr_event_upcall) (CCP_EVENT_THIS_LAYER_FINISHED, real_port_number, &ccp.ports[real_port_number].option_lists);
		}
}
/****************************************************************************/
void ccp_this_layer_up (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	enum CCP_OPTION_TYPE receiver_primary_compression_algorithm;
	enum CCP_OPTION_TYPE sender_primary_compression_algorithm;

	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (vptr_packet);

	if (ccp.fptr_event_upcall != NULL)
		{
		(*ccp.fptr_event_upcall) (CCP_EVENT_THIS_LAYER_UP, real_port_number, &ccp.ports[real_port_number].option_lists);
		}
	
	copy_negotiated_ccp_options_to_ccp_class (real_port_number);

	receiver_primary_compression_algorithm = 
		get_primary_compression_algorithm (&ccp.ports[real_port_number].option_lists.tx_accepted);
	sender_primary_compression_algorithm = 
		get_primary_compression_algorithm (&ccp.ports[real_port_number].option_lists.rx_accepted);
	
	ccp_printf (CCP_DATA_PRINTF, "CCP: The Negotiated Primary Compression Algorithm for	Sending is %s\n", 
		ccp_option_to_string (sender_primary_compression_algorithm));
	ccp_printf (CCP_DATA_PRINTF, "CCP: The Negotiated Primary Compression Algorithm for	Receiving is %s\n", 
		ccp_option_to_string (receiver_primary_compression_algorithm));

	ccp.ports[real_port_number].receiver_primary_compression_algorithm = 
		(BYTE_ENUM (CCP_OPTION_TYPE)) receiver_primary_compression_algorithm;
	ccp.ports[real_port_number].sender_primary_compression_algorithm = 
		(BYTE_ENUM (CCP_OPTION_TYPE)) sender_primary_compression_algorithm;
	
	if ((*ccp.functions[receiver_primary_compression_algorithm].fptr_initialize_receiver_compression_database)
		(real_port_number) == FAIL)
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP: Receiver Compression Database Initialization Failed on Port %04x\n", real_port_number);
		 
		ccp.ports[real_port_number].receiver_compression_database_initialization_failure = TRUE;
		}
	
	if ((*ccp.functions[sender_primary_compression_algorithm].fptr_initialize_sender_compression_database)
		(real_port_number) == FAIL)
		{
		ccp_printf (CCP_DATA_PRINTF, "CCP: Sender Compression Database Initialization Failed on Port %04x\n", real_port_number);

		ccp.ports[real_port_number].sender_compression_database_initialization_failure = TRUE;
		}
}
/****************************************************************************/
void ccp_this_layer_down (USHORT real_port_number, void *vptr_packet, USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	if (ccp.fptr_event_upcall != NULL)
		{
		(*ccp.fptr_event_upcall) (CCP_EVENT_THIS_LAYER_DOWN, real_port_number, &ccp.ports[real_port_number].option_lists);
		}

	ccp.ports[real_port_number].number_of_configuration_requests = 0x0000;
	ccp.ports[real_port_number].number_of_termination_requests = 0x0000;
	
	ccp.ports[real_port_number].configuration_request_send_interval = 0x0000;
	ccp.ports[real_port_number].termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void ccp_initialize_restart_counter (USHORT real_port_number, void *vptr_packet,USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);

	ccp.ports[real_port_number].number_of_configuration_requests = 0x0000;
	ccp.ports[real_port_number].configuration_request_send_interval = 0x0000;
	ccp.ports[real_port_number].configuration_request_backoff_interval = 0x0000;
	ccp.ports[real_port_number].termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void ccp_zero_restart_counter (USHORT real_port_number, void *vptr_packet,USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);

	ccp.ports[real_port_number].number_of_configuration_requests = 0x0000;
	ccp.ports[real_port_number].configuration_request_send_interval = 0x0000;
	ccp.ports[real_port_number].configuration_request_backoff_interval = 0x0000;
	ccp.ports[real_port_number].termination_request_send_interval = 0x0000;
}
/****************************************************************************/
static void copy_negotiated_ccp_options_to_ccp_class (USHORT real_port_number)
{
	copy_option (&ccp.ports[real_port_number].option_lists.tx_accepted, CCP_BSD_LZW_COMPRESSION,
		&ccp.ports[real_port_number].BSD.receiver_compression_vers_and_dict,
		sizeof (ccp.ports[real_port_number].BSD.receiver_compression_vers_and_dict));

	copy_option (&ccp.ports[real_port_number].option_lists.rx_accepted, CCP_BSD_LZW_COMPRESSION,
		&ccp.ports[real_port_number].BSD.sender_compression_vers_and_dict,
		sizeof (ccp.ports[real_port_number].BSD.sender_compression_vers_and_dict));

#ifdef STAC_LZS	
	copy_option (&ccp.ports[real_port_number].option_lists.tx_accepted, CCP_STACKER_LZS_COMPRESSION,
		&ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.ulong,
		sizeof (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.ulong));

	ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.ulong =
		swap_long (ccp.ports[real_port_number].stacker.receiver_history_count_and_check_mode.ulong << 8);

	copy_option (&ccp.ports[real_port_number].option_lists.rx_accepted, CCP_STACKER_LZS_COMPRESSION,
		&ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.ulong,
		sizeof (ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.ulong));

	ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.ulong =
		swap_long (ccp.ports[real_port_number].stacker.sender_history_count_and_check_mode.ulong << 8);
#endif	/* STAC_LZS	*/
}
/****************************************************************************/
static enum CCP_OPTION_TYPE get_primary_compression_algorithm (OPTION_LIST *sptr_option_list)
{
	if (sptr_option_list->sptr_forward_link == NULL)
		{
		return (CCP_NO_COMPRESSION_NEGOTIATED);
		}
	else
		{
		return ((enum CCP_OPTION_TYPE) sptr_option_list->sptr_forward_link->type.generic);
		}
}
/****************************************************************************/
static char *ccp_option_to_string (enum CCP_OPTION_TYPE ccp_option_type)
{
	switch (ccp_option_type)
		{
		case CCP_PREDICTOR_TYPE_I :
		
			return ("Predictor Type I");

		case CCP_PREDICTOR_TYPE_II :
		
			return ("Predictor Type II");

#ifdef STAC_LZS	
		case CCP_STACKER_LZS_COMPRESSION :
		
			return ("Stacker LZS Compression");
#endif	/* STAC_LZS	*/
		case CCP_BSD_LZW_COMPRESSION :
		
			return ("BSD LZW Compression");

		case CCP_NO_COMPRESSION_NEGOTIATED :
		
			return ("None");
		
		default :
			
			return ("None");
		} 
}
