#include	".\defs.h"
/* $modname: ccptimer.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "ccp.h"
/****************************************************************************/
static void periodic_ccp_configure_or_termination_request (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
	ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests,
	ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests);
/****************************************************************************/
void ccp_timer_routine (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
	ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests,
	ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests)
{
	periodic_ccp_configure_or_termination_request (real_port_number, number_of_protocol_stacks_loaded, 
		maximum_configuration_request_send_interval, maximum_number_of_configuration_requests,
		maximum_termination_request_send_interval, maximum_number_of_termination_requests);
}
/****************************************************************************/
static void periodic_ccp_configure_or_termination_request (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
	ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests,
	ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests)
{
	if ((number_of_protocol_stacks_loaded > 0x0000) &&
		(ccp.ports[real_port_number].state > PPP_STOPPING_STATE) && (ccp.ports[real_port_number].state < PPP_OPENED_STATE))
		{
		if (++ccp.ports[real_port_number].configuration_request_send_interval >= maximum_configuration_request_send_interval)
			{
			ccp.ports[real_port_number].configuration_request_send_interval = 0x00000000L;

			if (++ccp.ports[real_port_number].number_of_configuration_requests <= maximum_number_of_configuration_requests)
				{
				execute_ccp_state_machine (PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT, real_port_number, NULL, 0x0000);
				}
			else
				{
				execute_ccp_state_machine (PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT, real_port_number, NULL, 0x0000);

				ccp.ports[real_port_number].number_of_configuration_requests = 0x00000000L;
				}
			}
		}

	if ((number_of_protocol_stacks_loaded > 0x0000) &&
		((ccp.ports[real_port_number].state == PPP_CLOSING_STATE) || (ccp.ports[real_port_number].state == PPP_STOPPING_STATE)))
		{
		if (++ccp.ports[real_port_number].termination_request_send_interval >= maximum_termination_request_send_interval)
			{
			if (ccp.ports[real_port_number].number_of_termination_requests < maximum_number_of_termination_requests)
				{
				execute_ccp_state_machine (PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT, real_port_number, NULL, 0x0000);

				ccp.ports[real_port_number].termination_request_send_interval = 0x00000000L;
				}
			else
				{
				execute_ccp_state_machine (PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT, real_port_number, NULL, 0x0000);

				ccp.ports[real_port_number].termination_request_send_interval = 0x00000000L;
				}
			}
		}
}
