#include	".\defs.h"
/* $modname: predict.c$ $version: 1.0$ $date: 10/19/95$ */
/*
$lgb$
1.0 10/19/95 biao Compression Control Protocol (CCP) Initial Release.
$lge$
*/
/************************************************************************/
/*	Copyright (C) 1995 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include "ccp.h"
/*************************************************************************/
USHORT compress (USHORT real_port_number, BYTE *bptr_source, BYTE *bptr_destination, USHORT source_length)
{
	USHORT bit_index;
	USHORT bitmask;
	USHORT compression_hash_value;
	BYTE flags;
	BYTE *bptr_destination_flag;
	BYTE *bptr_original_destination;

	bptr_original_destination = bptr_destination;
    
	while (source_length != 0x0000) 
		{
			bptr_destination_flag = bptr_destination++; 
			flags = 0x00;	/* All guess wrong initially */
        
			for (bitmask = 0x0001, bit_index = 0x0000; (bit_index < 8) && (source_length != 0x0000); ++bit_index, bitmask <<= 1) 
				{
            compression_hash_value = ccp.ports[real_port_number].predictor.compression_hash_value;

            if (ccp.ports[real_port_number].predictor.bptr_compression_guess_table[compression_hash_value] == *bptr_source) 
            	{
					flags |= bitmask;	/* Guess was right - don't output */
					} 
				else 
					{
					ccp.ports[real_port_number].predictor.bptr_compression_guess_table[compression_hash_value] = *bptr_source;
					*bptr_destination++ = *bptr_source;	/* Guess wrong, output char */
					}
				
				COMPRESS_HASH (*bptr_source++);
				
				--source_length;
				}
			*bptr_destination_flag = flags;
		}

	return (USHORT) ((bptr_destination - bptr_original_destination));
}
/*************************************************************************/
USHORT decompress (USHORT real_port_number, BYTE *bptr_source, BYTE *bptr_destination, 
	USHORT *usptr_processed_length,  enum BOOLEAN final)
{
	USHORT bit_index;
	USHORT bitmask;
	USHORT decompression_hash_value;
	BYTE flags;
	BYTE *original_destination;
	USHORT source_length;

	original_destination = bptr_destination;
	source_length = *usptr_processed_length;    
    
	while (source_length >= 9) 
		{
		flags = *bptr_source++;

		for (bit_index = 0x0000, bitmask = 0x0001; bit_index < 8; ++bit_index, bitmask <<= 1) 
			{
			decompression_hash_value = ccp.ports[real_port_number].predictor.decompression_hash_value;
			
			if ((flags & bitmask) != 0x0000) 
				{
				*bptr_destination = ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value];
				/* Guess correct */
				} 
			else 
				{
				ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value] = *bptr_source;
				/* Guess wrong */
				*bptr_destination = *bptr_source++;	/* Read from source */
				--source_length;
				}

			DECOMPRESS_HASH (*bptr_destination++);
			}
		
		--source_length;
		}

	while ((final == TRUE) && (source_length != 0x0000)) 
		{
		flags = *bptr_source++;
		--source_length;

		for (bit_index = 0x0000, bitmask = 0x0001; bit_index < 8; ++bit_index, bitmask <<= 1) 
			{
			decompression_hash_value = ccp.ports[real_port_number].predictor.decompression_hash_value;
			
			if ((flags & bitmask) != 0x0000) 
				{
				*bptr_destination = ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value];
				/* Guess correct */
				} 
			else 
				{
				if (source_length == 0x0000)
					{
					break;	/* we seem to be really done -- cabo */
					}

				ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value] = *bptr_source;
				/* Guess wrong */
				*bptr_destination = *bptr_source++;	/* Read from source */
				--source_length;
				}

			DECOMPRESS_HASH (*bptr_destination++);
			}
		}

	*usptr_processed_length = source_length;
	
	return (USHORT) ((bptr_destination - original_destination));
}

/* Sowmya 15/3/96 */	
/*************************************************************************/
/* To update the decompression guess table */
/*************************************************************************/
USHORT compress_uncompressible_predictor_type_data (USHORT real_port_number, BYTE *bptr_source, BYTE *bptr_destination, USHORT source_length)
{
	USHORT bit_index;
	USHORT bitmask;
	USHORT decompression_hash_value;
	BYTE flags;
	BYTE *bptr_destination_flag;
	BYTE *bptr_original_destination;

	bptr_original_destination = bptr_destination;
    
	while (source_length != 0x0000) 
		{
			bptr_destination_flag = bptr_destination++; 
			flags = 0x00;	/* All guess wrong initially */
        
			for (bitmask = 0x0001, bit_index = 0x0000; (bit_index < 8) && (source_length != 0x0000); ++bit_index, bitmask <<= 1) 
				{
            decompression_hash_value = ccp.ports[real_port_number].predictor.decompression_hash_value;

            if (ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value] == *bptr_source) 
            	{
					flags |= bitmask;	/* Guess was right - don't output */
					} 
				else 
					{
					ccp.ports[real_port_number].predictor.bptr_decompression_guess_table[decompression_hash_value] = *bptr_source;
					*bptr_destination++ = *bptr_source;	/* Guess wrong, output char */
					}
				
				DECOMPRESS_HASH (*bptr_source++);
				
				--source_length;
				}
			*bptr_destination_flag = flags;
		}

	return (USHORT) ((bptr_destination - bptr_original_destination));
}
/* Sowmya 15/3/96 */	

