#include	"defs.h"
/*	$Modname: pppasync.c$  $version: 1.26$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 03/26/94 keyur New File for asynchronous PPP support.
1.1 03/26/94 keyur Added support for version control.
1.2 03/26/94 keyur Ran Lint compiler and code style program and got rid of unnecessary warnings
1.3 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.4 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.5 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.6 05/02/94 keyur took out memcheck header file.
1.7 06/15/94 keyur cosmetic changes.
1.8 06/16/94 ross added free in return fail case.
1.9 06/16/94 ross changed number of bytes to usptr number of bytes in process tx.
1.10 07/18/94 ross general cleanup with options, added header compression, accm features.
1.11 08/11/94 ross adding rfc1570 lcp support
1.12 08/24/94 ross adding new ncps.
1.13 08/26/94 ross Removed check for zero mask and pointer manipulation on call back.  Courtesy of Danny.
1.14 09/06/94 ross enum sizing problem fixed in decompress.  Courtesy of Danny.
1.15 09/26/94 ross testing async.
1.16 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.17 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.18 11/04/94 ross Testing against net manage ppp.	VJC testing.
1.19 12/13/94 ross connected to NT RAS with Netbios
1.20 01/25/95 ross fixed parens in send_complete.  Courtesy of Dan.
1.21 01/30/95 ross removing duplicate configuration options
1.22 03/03/95 ross added up calls.
1.23 03/10/95 ross general fixes.  see change.doc
1.24 03/11/95 ross changed async ACCM handling.  Courtesy of Dan.
1.25 05/15/95 ross removed check for unnumbered info.
1.26 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "ppp.h"
/****************************************************************************/
static PPP_PACKET *process_tx_asynchronous_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT *usptr_number_of_bytes,void **vptr_async_buffer);
static USHORT async_encode (ULONG async_control_character_map,BYTE *bptr_source_tx_packet,BYTE *bptr_destination_tx_packet,
	USHORT number_of_bytes);
static PPP_PACKET *compress_ppp_header_with_out_mac_header (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT *usptr_number_of_bytes_tx);

PPP_PACKET_WITH_MAC_HEADER *compress_ppp_header (PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,
	USHORT *usptr_number_of_bytes_tx, enum BOOLEAN address_and_control_fields_compression_enabled,
	enum BOOLEAN protocol_field_compression_enabled);

#if 0 /* Old ProtoType */
static PPP_PACKET *decompress_ppp_header (USHORT real_port_number,PPP_PACKET *sptr_rxed_packet,
	USHORT *usptr_number_of_bytes_rxed);
#endif

PPP_PACKET *decompress_ppp_header (PPP_PACKET *sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed,
	enum BOOLEAN address_and_control_fields_compression_enabled, enum BOOLEAN protocol_field_compression_enabled);

static enum BOOLEAN encode_byte (ULONG async_control_character_map,BYTE byte_to_encode);
/****************************************************************************/
USHORT async_protocol_packet_tx (USHORT real_port_number,PPP_PACKET_WITH_MAC_HEADER **sptr_tx_packet,
	USHORT number_of_bytes,USHORT protocol_virtual_port_number,enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion)
	(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer)
{
	USHORT total_number_of_bytes;
	PPP_PACKET_WITH_MAC_HEADER *sptr_original_tx_packet;

	total_number_of_bytes = number_of_bytes;
	sptr_original_tx_packet = *sptr_tx_packet;

	*sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) process_tx_asynchronous_packet (real_port_number,
		(PPP_PACKET *) &sptr_original_tx_packet->header,&total_number_of_bytes,vptr_async_buffer);

	if (fptr_tx_completion != NULL)
		{
		(fptr_tx_completion) (protocol_virtual_port_number,sptr_original_tx_packet);
		}

	if (device_driver_buffer == TRUE)
		{
		packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
			(void *) ((ULONG) sptr_original_tx_packet));
		}

	if (*sptr_tx_packet == NULL)
		{
		return (0x0000);
		}

	*sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *)((ULONG) *sptr_tx_packet - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

	number_of_bytes = total_number_of_bytes;

	return (number_of_bytes);
}
/****************************************************************************/
USHORT async_native_packet_tx (USHORT real_port_number,PPP_PACKET **sptr_tx_packet,USHORT number_of_bytes,
	void (*fptr_tx_completion)(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer)
{
	USHORT total_number_of_bytes;
	PPP_PACKET *sptr_original_tx_packet;

	total_number_of_bytes = number_of_bytes;

	sptr_original_tx_packet = *sptr_tx_packet;

	*sptr_tx_packet = process_tx_asynchronous_packet (real_port_number,sptr_original_tx_packet,&total_number_of_bytes,
		vptr_async_buffer);

	if (fptr_tx_completion != NULL)
			{
			sptr_original_tx_packet = (PPP_PACKET *) ((ULONG) sptr_original_tx_packet - sizeof (MAC_HEADER) + sizeof (PPP_HEADER));

			(fptr_tx_completion) (real_port_number,sptr_original_tx_packet);
			}

	if (*sptr_tx_packet == NULL)
		{
		return (0x0000);
		}
	
	number_of_bytes = total_number_of_bytes;

	return (number_of_bytes);
}
/****************************************************************************/
static PPP_PACKET *process_tx_asynchronous_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT *usptr_number_of_bytes,void **vptr_async_buffer)
{
	BYTE *bptr_async_packet;
	USHORT calculated_checksum;
	ULONG async_control_character_map;
	ASYNC_BUFFER_LIST_ENTRY *sptr_async_buffer_list_entry;
	BYTE checksum[2];

	async_control_character_map = ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToPeerACCMap;

	if ((ppp.port[real_port_number].state == PPP_OPENED_STATE) &&
		((is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
		(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE) ||
		(is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
		(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE)))
		{
		sptr_tx_packet = compress_ppp_header_with_out_mac_header (real_port_number,sptr_tx_packet,usptr_number_of_bytes);
		}

	calculated_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE,(BYTE *) sptr_tx_packet,
		*usptr_number_of_bytes);

	calculated_checksum = (USHORT) ~calculated_checksum;

	checksum[0] = (BYTE) (0x00ff & calculated_checksum);
	checksum[1] = (BYTE) (0x00ff & (calculated_checksum >> 8));

	if (ppp.port[real_port_number].async.enabled == TRUE)
		{
		sptr_async_buffer_list_entry = (ASYNC_BUFFER_LIST_ENTRY *)
			get_entry_from_list (&ppp.port[real_port_number].async.buffer_free_list);

		*vptr_async_buffer = sptr_async_buffer_list_entry;

		ppp_printf (PPP_MEMORY_PRINTF,"PPP: Asynchronous: get entry from %08lx\r\n",(ULONG) sptr_async_buffer_list_entry);

		if (sptr_async_buffer_list_entry == NULL)
			{
			return (NULL);
			}

		bptr_async_packet = &sptr_async_buffer_list_entry->data[0];

 		*usptr_number_of_bytes = async_encode (async_control_character_map,(BYTE *) sptr_tx_packet,bptr_async_packet,
			*usptr_number_of_bytes);

		bptr_async_packet = (BYTE *) ((ULONG) bptr_async_packet + *usptr_number_of_bytes);

		*usptr_number_of_bytes = (USHORT) (*usptr_number_of_bytes + async_encode (async_control_character_map,(BYTE *)&checksum[0],
			bptr_async_packet,sizeof (calculated_checksum)));

		return ((PPP_PACKET *)&sptr_async_buffer_list_entry->data[0]);
		}
	else
		{
		return (NULL);
		}
}
/*************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *compress_ppp_header (PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,
	USHORT *usptr_number_of_bytes_tx, enum BOOLEAN address_and_control_fields_compression_enabled,
	enum BOOLEAN protocol_field_compression_enabled)
{
/*we should  check if the protocol field is compressable. This is not done
we straight away discard the first byte.*/

	if ((sptr_tx_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_tx_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		((sptr_tx_packet->header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000))
		{
		return (sptr_tx_packet);
		}

	if (address_and_control_fields_compression_enabled == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		*usptr_number_of_bytes_tx -= (USHORT) (sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		if (protocol_field_compression_enabled == TRUE)
			{
			sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + 1);

			*usptr_number_of_bytes_tx -= (USHORT) 1;
			}
		}
	else if (protocol_field_compression_enabled == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) ((ULONG) sptr_tx_packet + 1);

		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		*usptr_number_of_bytes_tx -= (USHORT) 1;
		}

	return (sptr_tx_packet);
}

static PPP_PACKET *compress_ppp_header_with_out_mac_header (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT *usptr_number_of_bytes_tx)
{
	if ((sptr_tx_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_tx_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		((sptr_tx_packet->header.protocol_type & BIG_ENDIAN_CONSTANT (0xff00)) != 0x0000))
		{
		return (sptr_tx_packet);
		}

	if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,
		(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET *) ((ULONG) sptr_tx_packet + sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		*usptr_number_of_bytes_tx -= (USHORT) (sizeof (sptr_tx_packet->header.hdlc_address) +
			sizeof (sptr_tx_packet->header.hdlc_control));

		if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE)
			{
			sptr_tx_packet = (PPP_PACKET *) ((ULONG) sptr_tx_packet + 1);

			*usptr_number_of_bytes_tx -= (USHORT) 1;
			}
		}
	else if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,
		(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE)
		{
		sptr_tx_packet = (PPP_PACKET *) ((ULONG) sptr_tx_packet + 1);

		sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
		sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

		*usptr_number_of_bytes_tx -= (USHORT) 1;
		}

	return (sptr_tx_packet);
}
/****************************************************************************/
static USHORT async_encode (ULONG async_control_character_map,BYTE *bptr_source_tx_packet,BYTE *bptr_destination_tx_packet,
	USHORT number_of_bytes)
{
 	BYTE actual_byte;
	USHORT byte_counter;
	USHORT number_of_escape_sequences;
	
 	number_of_escape_sequences = 0x0000;

	for (byte_counter = 0x0000; byte_counter < number_of_bytes; ++byte_counter,++bptr_destination_tx_packet)
		{
		actual_byte = *((BYTE *) ((ULONG) bptr_source_tx_packet + byte_counter));

		if ((encode_byte (async_control_character_map,actual_byte) == TRUE) || (actual_byte == HDLC_FLAG_SEQUENCE) ||
			(actual_byte == ASYNC_CONTROL_ESCAPE_SEQUENCE))
			{
			*bptr_destination_tx_packet = ASYNC_CONTROL_ESCAPE_SEQUENCE;

			++bptr_destination_tx_packet;
			++number_of_escape_sequences;

			actual_byte ^= ASYNC_SIXTH_BIT_COMPLEMENT;
			}

		*bptr_destination_tx_packet = actual_byte;
		}

	number_of_bytes = (USHORT) (number_of_bytes + number_of_escape_sequences);

	return (number_of_bytes);
}
/****************************************************************************/
static enum BOOLEAN encode_byte (ULONG async_control_character_map,BYTE byte_to_encode)
{
	if ( (byte_to_encode >= 0x20) || (async_control_character_map == 0x00000000L) )
		{
		return (FALSE);
		}

	if (async_control_character_map == DEFAULT_ASYNC_CONTROL_CHARACTER_MAP)
		{
		if (byte_to_encode < 0x20)
			{
			return (TRUE);
			}
		}

	if ((((ULONG) 1 << byte_to_encode) & swap_long (async_control_character_map)) == TRUE)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/****************************************************************************/
void ppp_async_packet_transmitted (USHORT real_port_number,void *vptr_txed_packet)
{
#if defined (__REMOVE_PPP_ASYNC_HEADER__)
	USHORT header_difference;

	header_difference = sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER);

	vptr_txed_packet = (void *) ((ULONG) vptr_txed_packet - sizeof (LINK) + header_difference);
#endif

	ppp_printf (PPP_MEMORY_PRINTF,"PPP: Asynchronous: Free of %08lx\r\n",(ULONG) vptr_txed_packet);

	add_entry_to_list ((LINK *) &ppp.port[real_port_number].async.buffer_free_list,(LINK *) vptr_txed_packet);
}
/****************************************************************************/
PPP_PACKET *asynchronous_packet_received (USHORT real_port_number,PPP_PACKET *sptr_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	BYTE actual_byte;
	BYTE *bptr_async_packet;
	USHORT byte_counter;
	USHORT number_of_escape_sequences;
	USHORT new_checksum;
	USHORT offset_of_checksum;
	
	number_of_escape_sequences = 0x0000;

	if (*((BYTE *) ((ULONG) sptr_rxed_packet + *usptr_number_of_bytes_rxed - 1)) == ASYNC_CONTROL_ESCAPE_SEQUENCE)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Error: Bad Asynchronous frame received on port %04x\r\n",real_port_number);

		return (NULL);
		}

	bptr_async_packet = (BYTE *) buffer_malloc (*usptr_number_of_bytes_rxed);

	for (byte_counter = 0x0000; byte_counter < *usptr_number_of_bytes_rxed ; ++byte_counter,++bptr_async_packet)
		{
		actual_byte = *((BYTE *) ((ULONG) sptr_rxed_packet + byte_counter));

		if (actual_byte == HDLC_FLAG_SEQUENCE)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Error: Flag Sequence found in packet on the Asynchronous port %04x\r\n",
				real_port_number);

			return (NULL);
			}

		if (actual_byte == ASYNC_CONTROL_ESCAPE_SEQUENCE)
			{
			++number_of_escape_sequences;
			++byte_counter;

			actual_byte = (*(BYTE *) ((ULONG) sptr_rxed_packet + byte_counter));

			if (actual_byte == ASYNC_CONTROL_ESCAPE_SEQUENCE)
				{
				ppp_printf (PPP_ALARM_PRINTF,
					"PPP: Error: Consecutive control escape sequences found in packet on Async port %04x\r\n",real_port_number);

				return (NULL);
				}

			actual_byte ^= ASYNC_SIXTH_BIT_COMPLEMENT;
			}

		*bptr_async_packet = actual_byte;
		}

	bptr_async_packet = (BYTE *)(((ULONG) bptr_async_packet) - (*usptr_number_of_bytes_rxed - number_of_escape_sequences));

	offset_of_checksum = (USHORT) (*usptr_number_of_bytes_rxed - number_of_escape_sequences - SIZE_OF_WAN_CRC);

	new_checksum = calculate_frame_check_sequence (INIT_FRAME_CHECK_SEQUENCE,bptr_async_packet,
		(USHORT) (offset_of_checksum + SIZE_OF_WAN_CRC));

	if (new_checksum != FINAL_GOOD_FRAME_CHECK_SEQUENCE)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Error: Bad Checksum on Asynchronous port %04x\r\n",real_port_number);

		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusBadFCSs;

		buffer_free (bptr_async_packet);

		return (NULL);
		}

	*usptr_number_of_bytes_rxed = offset_of_checksum;

	memcpy (sptr_rxed_packet,bptr_async_packet,*usptr_number_of_bytes_rxed);

	if ((ppp.port[real_port_number].state == PPP_OPENED_STATE) &&
		((is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
		(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE) ||
		(is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
		(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE)))
		{
/*		sptr_rxed_packet = decompress_ppp_header (real_port_number,sptr_rxed_packet,usptr_number_of_bytes_rxed);*/
		sptr_rxed_packet = decompress_ppp_header (sptr_rxed_packet,usptr_number_of_bytes_rxed, TRUE, TRUE);
		}

	buffer_free (bptr_async_packet);

	return (sptr_rxed_packet);
}
/*************************************************************************/
#if 0  /* Old Code Before Integrating MLPPP */
static PPP_PACKET *decompress_ppp_header (USHORT real_port_number,PPP_PACKET *sptr_rxed_packet,
	USHORT *usptr_number_of_bytes_rxed)
{
	BYTE protocol_type_in_bytes[sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE))];
	enum BOOLEAN address_and_control_fields_are_compressed;
	enum BOOLEAN protocol_field_is_compressed;
	PPP_HEADER ppp_header;

	if ((sptr_rxed_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_rxed_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		(sptr_rxed_packet->header.protocol_type == LCP_PROTOCOL))
		{
		return (sptr_rxed_packet);
		}

	address_and_control_fields_are_compressed = FALSE;
	protocol_field_is_compressed = FALSE;

	ppp_header.hdlc_address = HDLC_ADDRESS;
	ppp_header.hdlc_control = UNNUMBERED_INFORMATION;

	if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
		(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE)
		{
		if (sptr_rxed_packet->header.hdlc_address != HDLC_ADDRESS) 
/*	&&		(sptr_rxed_packet->header.hdlc_control != UNNUMBERED_INFORMATION)) */
			{
			address_and_control_fields_are_compressed = TRUE;

			memcpy (&protocol_type_in_bytes[0],sptr_rxed_packet,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
			}
		else
			{
			memcpy (&protocol_type_in_bytes[0],&sptr_rxed_packet->header.protocol_type,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
			}
		}
	else
		{
		memcpy (&protocol_type_in_bytes[0],&sptr_rxed_packet->header.protocol_type,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
		}

	if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,
	   (BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE)
		{
		if ((protocol_type_in_bytes[0] != 0x80) && (protocol_type_in_bytes[0] != 0xc0) &&
			(protocol_type_in_bytes[0] != 0x00) &&	(protocol_type_in_bytes[0] != 0xc2) &&
			(protocol_type_in_bytes[0] != 0x02))
			{
			protocol_field_is_compressed = TRUE;

			*((BYTE *) &ppp_header.protocol_type) = 0x00;
			*((BYTE *) &ppp_header.protocol_type + 1) = protocol_type_in_bytes[0];
			}
		else
			{
			memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
			}
		}
	else
		{
		memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
		}

	if (address_and_control_fields_are_compressed == TRUE)
		{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet -
			(sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control)));

		*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control));
		}

	if (protocol_field_is_compressed == TRUE)
		{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (BYTE));

		*usptr_number_of_bytes_rxed += (USHORT) sizeof (BYTE);
		}

	memcpy (sptr_rxed_packet,&ppp_header,sizeof (PPP_HEADER));

	return (sptr_rxed_packet);
}
#endif /* Old Code Before Integrating MLPPP */

PPP_PACKET *decompress_ppp_header (PPP_PACKET *sptr_rxed_packet, USHORT *usptr_number_of_bytes_rxed,
	enum BOOLEAN address_and_control_fields_compression_enabled, enum BOOLEAN protocol_field_compression_enabled)
{

/*we should  check if the protocol field is compressed. This is not done
we straight away add a first byte of 00.*/

	BYTE protocol_type_in_bytes[sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE))];
	enum BOOLEAN address_and_control_fields_are_compressed;
	enum BOOLEAN protocol_field_is_compressed;
	PPP_HEADER ppp_header;

	if ((sptr_rxed_packet->header.hdlc_address == HDLC_ADDRESS) &&
		(sptr_rxed_packet->header.hdlc_control == UNNUMBERED_INFORMATION) &&
		(sptr_rxed_packet->header.protocol_type == LCP_PROTOCOL))
		{
		return (sptr_rxed_packet);
		}

	address_and_control_fields_are_compressed = FALSE;
	protocol_field_is_compressed = FALSE;

	ppp_header.hdlc_address = HDLC_ADDRESS;
	ppp_header.hdlc_control = UNNUMBERED_INFORMATION;

	if ((address_and_control_fields_compression_enabled == TRUE) &&
		 (sptr_rxed_packet->header.hdlc_address != HDLC_ADDRESS))
/*	&&		(sptr_rxed_packet->header.hdlc_control != UNNUMBERED_INFORMATION)) */
		{
		address_and_control_fields_are_compressed = TRUE;

		memcpy (&protocol_type_in_bytes[0],sptr_rxed_packet,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
		}
	else
		{
		memcpy (&protocol_type_in_bytes[0],&sptr_rxed_packet->header.protocol_type,sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
		}

	if (protocol_field_compression_enabled == TRUE)
		{
		if ((protocol_type_in_bytes[0] != 0x80) && (protocol_type_in_bytes[0] != 0xc0) &&
			(protocol_type_in_bytes[0] != 0x00) &&	(protocol_type_in_bytes[0] != 0xc2) &&
			(protocol_type_in_bytes[0] != 0x02))
			{
			protocol_field_is_compressed = TRUE;

			*((BYTE *) &ppp_header.protocol_type) = 0x00;
			*((BYTE *) &ppp_header.protocol_type + 1) = protocol_type_in_bytes[0];
			}
		else
			{
			memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
			}
		}
	else
		{
		memcpy (&ppp_header.protocol_type,&protocol_type_in_bytes[0],sizeof (USHORT_ENUM (PPP_PROTOCOL_TYPE)));
		}

	if (address_and_control_fields_are_compressed == TRUE)
		{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet -
			(sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control)));

		*usptr_number_of_bytes_rxed += (USHORT) (sizeof (ppp_header.hdlc_address) + sizeof (ppp_header.hdlc_control));
		}

	if (protocol_field_is_compressed == TRUE)
		{
		sptr_rxed_packet = (PPP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (BYTE));

		*usptr_number_of_bytes_rxed += (USHORT) sizeof (BYTE);
		}

	memcpy (sptr_rxed_packet,&ppp_header,sizeof (PPP_HEADER));

	return (sptr_rxed_packet);
}

/*************************************************************************/
void build_async_buffer_list (USHORT real_port_number)
{
	ASYNC_BUFFER_LIST_ENTRY *sptr_async_buffer_list_entry;
	USHORT index_number_of_buffers;
	ULONG total_size_of_async_buffers;

	ppp.port[real_port_number].async.actual_size_of_tx_buffer =  (USHORT) (ASYNC_MAXIMUM_TX_ENCODED_PACKET_MULTIPLIER *
		(ppp.port[real_port_number].async.size_of_buffers + SIZE_OF_WAN_CRC));

	total_size_of_async_buffers =	ppp.port[real_port_number].async.number_of_buffers *
		ppp.port[real_port_number].async.actual_size_of_tx_buffer;

	ppp_printf (PPP_MEMORY_PRINTF,"PPP: Asynchronous: build buffer list size of each async buffer %08x\r\n",
		ppp.port[real_port_number].async.actual_size_of_tx_buffer);

	ppp_printf (PPP_MEMORY_PRINTF,"PPP: Asynchronous: build buffer list total size of all async buffers %08x\r\n",
		total_size_of_async_buffers);

	for (index_number_of_buffers = 0x0000;	index_number_of_buffers < ppp.port[real_port_number].async.number_of_buffers;
		++index_number_of_buffers)
		{
	 	sptr_async_buffer_list_entry = (ASYNC_BUFFER_LIST_ENTRY *)
			buffer_malloc (ppp.port[real_port_number].async.actual_size_of_tx_buffer);

		if (sptr_async_buffer_list_entry == NULL)
			{
			if (index_number_of_buffers != 0x0000)
				{
				ppp.port[real_port_number].async.number_of_buffers = (USHORT) (index_number_of_buffers - 1);
				}
			else
				{
				ppp.port[real_port_number].async.number_of_buffers = 0x0000;
				}

			break;
			}

		ppp_printf (PPP_MEMORY_PRINTF,"PPP: build list entry number %04x entry is %08lx\r\n",index_number_of_buffers,
			(ULONG) sptr_async_buffer_list_entry);

		add_entry_to_list ((LINK *) &ppp.port[real_port_number].async.buffer_free_list,&sptr_async_buffer_list_entry->links);
		}
}
/****************************************************************************/
void free_async_buffer_list (USHORT real_port_number)
{
	ASYNC_BUFFER_LIST_ENTRY *sptr_async_buffer_list_entry;
	USHORT index_number_of_buffers;

	for (index_number_of_buffers = 0x0000;	index_number_of_buffers < ppp.port[real_port_number].async.number_of_buffers;
		++index_number_of_buffers)
		{
		sptr_async_buffer_list_entry = get_entry_from_list ((LINK *) &ppp.port[real_port_number].async.buffer_free_list);

		if (sptr_async_buffer_list_entry == NULL)
			{
			break;
			}

		buffer_free (sptr_async_buffer_list_entry);
		}
}
/******************************************************************************/
USHORT calculate_frame_check_sequence (USHORT checksum,BYTE *bptr_async_packet,USHORT number_of_bytes)
{
	while (number_of_bytes > 0)
		{
		checksum = (USHORT) ((checksum >> 8) ^ checksum_table[(checksum ^ *bptr_async_packet++) & 0xff]);

		--number_of_bytes;
		}

	return (checksum);
}

