/*--------------------------------------------------------------------------
	File   : PPPCOMP.C
	Author : Sachin, Courtesy of Sanjay, Vidy & Hemanth
	Date   : 9th May, 1996
--------------------------------------------------------------------------*/
#include "defs.h"


extern void *malloc(ULONG) ;
extern void *calloc(ULONG) ;
extern void *memset(void *dest, int init_value, int count) ;
extern void *memcpy(void *dest, void *src, int count) ;
extern char *strcpy(char *dest, char *src) ;
extern int strcmpi(char *source, char *dest) ;
extern int strlen(char *str) ;


#define BITS				15
#define MAX_CODE 			(((unsigned short)1 << BITS) - 1 )
#define TABLE_SIZE		((unsigned short)35023)
#define TABLE_BANKS		((TABLE_SIZE >> 8) + 1 )
#define END_OF_STREAM	256
#define BUMP_CODE			257
#define FLUSH_CODE		258
#define FIRST_CODE		259
#define UNUSED				((unsigned short)-1)

#define DICT(i)         (dict_array[i>>8][i & 0xFF])
#define MAX_EXPAND_SIZE	(10 * 1024)

struct dictionary
{
	unsigned short code_value;
	unsigned short parent_code;
	unsigned char character;
};

struct bit_buf_index
{
	unsigned char *index;
	unsigned long length ;
	unsigned short bit_offset;
};


unsigned short next_code, next_bump_code, current_code_bits ;
#pragma separate decode_stack
/* unsigned char decode_stack[TABLE_SIZE] ; */
/* struct dictionary *dict_array[TABLE_BANKS] ; */
unsigned char *decode_stack ;
struct dictionary **dict_array ;

unsigned short input_bits (struct bit_buf_index *buffer, unsigned short bit_length) ;
short initialize_storage (void) ;
void initialize_dictionary (void) ;
unsigned short decode_string (unsigned short count, unsigned short code) ;
long LZ15V_expand_buf (unsigned char *compressed_buffer, long compressed_buffer_length,
                       unsigned char *uncompressed_buffer, long uncompressed_buffer_length) ;
short LZW_expand (unsigned char *input, unsigned char *output, unsigned long total_packed_size) ;



unsigned short input_bits (struct bit_buf_index *buffer, unsigned short bit_length)
{
	unsigned short bits, byte_length ;

	bits = 0 ;
	while ((buffer->bit_offset + bit_length) > 8)
	{
		byte_length = 8 - buffer->bit_offset ;
		bits <<= byte_length ;
		bits |= *buffer->index & ((1 << byte_length) - 1) ;
		bit_length -= byte_length ;
		buffer->bit_offset = 0 ;
		buffer->index++ ;
		buffer->length-- ;
	}
	bits <<= bit_length ;
	bits |= (*buffer->index >> (8 - bit_length)) ;
	buffer->bit_offset += bit_length ;
	return (bits) ;
}


short initialize_storage ()
{
	short i, j ;

	decode_stack = (char *) calloc (TABLE_SIZE, sizeof (char)) ;
	if (decode_stack == (char *)0)
	{
		return (0) ;
	}

	dict_array = (struct dictionary **) calloc (TABLE_BANKS, sizeof (struct dictionary *)) ;
	if (dict_array == (struct dictionary **)0)
	{
		return (0) ;
	}

	for (i = 0 ; i < TABLE_BANKS ; i++)
	{
		dict_array[i] = (struct dictionary *) calloc (256, sizeof (struct dictionary)) ;
		if (dict_array[i] == (struct dictionary *)0)
		{
			printf ("Compression, Initialize storage failed\n") ;
			for (j = 0 ; j < i ; j++)
				free (dict_array[i]) ;
			return (0) ;
		}
	}
	/* printf ("Compression, Initialize storage succeeded\n") ; */
	return (1) ;
}


void free_storage ()
{
	short i ;

	for (i = 0 ; i < TABLE_BANKS ; i++)
		free (dict_array[i]) ;
}


void initialize_dictionary ()
{
	unsigned short i ;

	for (i = 0 ; i < TABLE_SIZE ; i++)
		DICT(i).code_value = UNUSED ;

	next_code = FIRST_CODE ;
	current_code_bits = 9 ;
	next_bump_code = 511 ;
}


unsigned short decode_string (unsigned short count, unsigned short code)
{
	while (code > 255)
	{
		decode_stack[count++] = DICT(code).character ;
		code = DICT(code).parent_code ;
	}
	decode_stack[count++] = (unsigned char)code ;
	return (count) ;
}


long LZ15V_expand_buf(unsigned char *compressed_buffer, long compressed_buffer_length,
								unsigned char *expand_buffer, long expand_buffer_length)
{
	unsigned short new_code ;
	unsigned short old_code ;
	unsigned short character ;
	unsigned short count ;
	struct bit_buf_index input_buf ;
	unsigned char *output_ix ;
	unsigned long output_count ;

	output_ix = expand_buffer ;
	output_count = expand_buffer_length ;
	input_buf.index = (unsigned char *)compressed_buffer ;
	input_buf.length= compressed_buffer_length ;
	input_buf.bit_offset = 0 ;

	/* printf ("Compression, Initializing storage\n") ; */
	if (initialize_storage() == 0)
		return 0 ;

	for ( ; ; )
	{
		/* printf ("Compression, Initializing Dictionary\n") ; */
		initialize_dictionary () ;
		old_code = input_bits (&input_buf, current_code_bits) ;
		if (old_code == END_OF_STREAM)
			goto return_output_length ;
		character = old_code ;
		*output_ix++ = (unsigned char)old_code ;
		output_count-- ;
		for ( ; ; )
		{
			new_code = input_bits(&input_buf, current_code_bits) ;
			if (new_code == END_OF_STREAM)
				goto return_output_length ;
			if (new_code == FLUSH_CODE)
				break ;
			if (new_code == BUMP_CODE)
			{
				current_code_bits++ ;
				continue ;
			}
			if (new_code >= next_code)
			{
				decode_stack[0] = (unsigned char)character ;
				count = decode_string(1, old_code) ;
			}
			else
			{
				count = decode_string(0, new_code) ;
			}
			character = decode_stack[count - 1] ;
			while ((count > 0) && (output_count > 0))
			{
				*output_ix++ = decode_stack[--count] ;
				output_count-- ;
			}
			if (count > 0)
			{
				goto return_error ;
			}
			DICT(next_code).parent_code = old_code ;
			DICT(next_code).character   = (unsigned char)character ;
			next_code++ ;
			old_code = new_code ;
		}
	}

return_error:
	/* printf ("Compression, freeing storage\n") ; */
	free_storage () ;
	return 0 ;

return_output_length:
	/* printf ("Compression, freeing storage\n") ; */
	free_storage () ;
	return (expand_buffer_length - output_count) ;
}

/*
	It takes the compressed_buffer pointer,
	         the buffer to output it to and the length
				of the compressed buffer. Note that
				there is no output buffer length parameter.
				The output buffer is assumed to be big enough
				to hold the expanded buffer.
*/
short LZW_expand(unsigned char *input, unsigned char *output, unsigned long total_packed_size)
{
	short cur_count, nxt_count ;
	unsigned char *cur_src_ptr, *nxt_src_ptr, *ptr_target ;
	short expanded_size ;
	unsigned long total_compressed_size ;

	nxt_src_ptr = input + sizeof(cur_count) ;
	nxt_count = *(short *) input ;
	ptr_target = output ;
	total_compressed_size = total_packed_size ;

	while (total_compressed_size)
	{
		cur_src_ptr = nxt_src_ptr ;
		cur_count = nxt_count ;

		nxt_src_ptr += nxt_count + sizeof(cur_count) ;
		nxt_count = *(short *)(nxt_src_ptr - sizeof(cur_count)) ;
		total_compressed_size -= (cur_count + sizeof(cur_count)) ;
		if (cur_count < 0)
		{
			expanded_size = (short)-cur_count ;
			memcpy(ptr_target, cur_src_ptr, expanded_size) ;
		}
		else
		{
			expanded_size = LZ15V_expand_buf(cur_src_ptr, cur_count, ptr_target, MAX_EXPAND_SIZE) ;
			if (expanded_size == 0)
				return (0) ;
		}
		ptr_target += expanded_size ;
	}
	return 1 ;
}


/* Sachin 16th Dec */

unsigned output_bits (struct bit_buf_index *buffer, unsigned short bits, unsigned short bit_length)
{
	while ((buffer->bit_offset + bit_length) > 8)
	{
		if (buffer->length == 0)
			return 0  ;

		bit_length -= 8 - buffer->bit_offset ;
		if (buffer->bit_offset != 0)
			*buffer->index |= (unsigned char)(bits >> bit_length) ;
		else
			*buffer->index  = (unsigned char)(bits >> bit_length) ;
		buffer->index++ ;
		buffer->length-- ;
		buffer->bit_offset = 0 ;
		bits &= (1 << bit_length) - 1 ;
	}

	if (buffer->length == 0)
		return 0 ;

	if (buffer->bit_offset != 0)
		*buffer->index |= (unsigned char) (bits << (8 - bit_length)) ;
	else
		*buffer->index  = (unsigned char)(bits << (8 - bit_length)) ;

	buffer->bit_offset += bit_length ;
	
	return 1 ;
}


unsigned find_child_node (unsigned parent_code, unsigned child_character)
{
	unsigned short index ;
	unsigned short offset ;
	
	index = (child_character << (BITS - 8)) ^ parent_code ;
	if (index == 0)
		offset = 1 ;
	else
		if (index < TABLE_SIZE)
			offset = TABLE_SIZE - index ;
		else
			return 0 ;

	for ( ; ; )
	{
		if (DICT(index).code_value == UNUSED)
			return index ;

		if ((DICT(index).parent_code== parent_code) &&
			 (DICT(index).character  == child_character))
				return index ;

		if (index >= offset)
			index -= offset ;
		else
			index += TABLE_SIZE - offset ;
	}
}


long LZ15V_compress (unsigned char *input, unsigned long input_length, unsigned char *output, unsigned long output_buffer_length)
{
	unsigned short character ;
	unsigned short string_code ;
	unsigned short index ;

	unsigned long original_length ;
	const unsigned char *input_ix ;
	unsigned long input_count ;
	struct bit_buf_index output_buf ;

	input_ix = (unsigned char *) input ;
	input_count = input_length ;

	if (!(initialize_storage()))
	{
		printf ("LZ15V_compress() : initialize_storage() failed\n\r") ;
		return 0 ;
	}

	initialize_dictionary () ;

	output_buf.index = (unsigned char *) output ;
	output_buf.length = original_length = ((output_buffer_length <= input_length) ? output_buffer_length : input_length) ;
	output_buf.bit_offset = 0 ;

	if (input_count == 0)
		string_code = END_OF_STREAM ;
	else
	{
		string_code = *input_ix++ ;
		input_count-- ;
	}

	while (input_count > 0)
	{
		character = *input_ix++ ;
		input_count-- ;

		index = find_child_node (string_code, character) ;		
		if (DICT(index).code_value != UNUSED)
			string_code = DICT(index).code_value ;
		else
		{
			DICT(index).code_value = next_code++ ;
			DICT(index).parent_code = string_code ;
			DICT(index).character  = (unsigned char) character ;

			if (output_bits (&output_buf, string_code, current_code_bits) == 0)
				break ;

			string_code = character ;
			if (next_code > MAX_CODE)
			{
				if (output_bits (&output_buf, FLUSH_CODE, current_code_bits) == 0)
					break;

				initialize_dictionary () ;
			}
			else if (next_code > next_bump_code)
			{
				if (output_bits  (&output_buf, BUMP_CODE, current_code_bits) == 0)
					break ;

				current_code_bits++;
				next_bump_code = (next_bump_code << 1) | 1 ;
			}
		}
	}

	free_storage () ;

	if (output_buf.length != 0)
	{
		if (output_bits (&output_buf, string_code, current_code_bits) != 0)
			if (output_bits (&output_buf, END_OF_STREAM, current_code_bits) != 0)
				return (original_length - output_buf.length + 1) ;
	}

	if (output_buffer_length < input_length)
		return 0 ;
}

/* Sachin Dec 16th */

