#include	"defs.h"
/*	$Modname: pppconfg.c$  $version: 1.25$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 03/09/94 keyur new nvram file.
1.1 03/09/94 keyur added support for version control.
1.2 03/23/94 keyur Cosmetic changes.
1.3 03/26/94 keyur Ran Lint compiler and code style program and got rid of unnecessary warnings
1.4 04/12/94 keyur Added cast for scanf.
1.5 04/12/94 keyur Added cast for scanf.
1.6 04/13/94 keyur Added support for NCP state machine
1.7 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.8 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.9 05/02/94 keyur took out memcheck header file.
1.10 08/11/94 ross adding rfc1570 lcp support
1.11 08/25/94 ross fixed scanf bug.  Courtesy of Danny.
1.12 08/25/94 ross deleted unnecessary files.
1.13 09/06/94 ross fixed sscanf big endian bug.  Courtesy of Danny.
1.14 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.15 12/02/94 ross testing NT3.5 RAS
1.16 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.17 12/11/94 ross adding multiple value option support
1.18 12/13/94 ross connected to NT RAS with Netbios
1.19 12/13/94 ross added copyrights in some files
1.20 01/26/95 ross changes for rwutils
1.21 01/30/95 ross removing duplicate configuration options
1.22 01/30/95 ross moved magic number generation routine here from pppinit.
1.23 02/27/95 ross dynamic load changes including lsl_control.
1.24 03/10/95 ross general fixes.  see change.doc
1.25 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include	<stddef.h>
#include	<stdio.h>
#include	<string.h>
#include "ppp.h"
#include	<vnvrmstr.h>
#include	"vnvppp.h"
/****************************************************************************/
static void add_option_type (OPTION_LISTS *sptr_option_lists,char *cptr_port_number_and_option_string,
	char *cptr_option_string,enum BOOLEAN remote_configuration);
static enum TEST get_configuration_option_values (char *cptr_option_string,char *cptr_return_ncp_name,
	char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped,
	enum BOOLEAN *eptr_negotiation_required,enum BOOLEAN *eptr_negotiable,enum BOOLEAN *eptr_automatic_nak_processing);
static char *parse_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_automatic_nak_processing_string,char *cptr_negotiation_required_string,
	char *cptr_negotiable_string,BYTE *bptr_number_of_parameters_processed);
static void parse_option_value (char *cptr_value,BYTE *bptr_option_data,BYTE *bptr_length_of_all_options,
	enum BOOLEAN *eptr_return_value_swapped);
static ULONG get_ip_address_string (char *cptr_ip_address_string);
static enum NCP_STACK_INDEX get_stack_index (char *option_string);
static enum BOOLEAN get_option_value_type (char *value_type_string,char *value_string,BYTE *bptr_return_data,
	BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped);
static BYTE get_size_of_numeric_string (char *value_type_string);
static ULONG get_my_magic_number (void);

/* Kamlnath  29/08/1996 */
static void ip_bring_down_ncp (int real_port_number) ;
/* Kamalnath 29/08/1996 */
/* Srikar, Mar 17, 1997. Added the prototypes for the added functions */
enum BOOLEAN set_port_ipx_operational_state(USHORT port_number, enum BOOLEAN new_state);
/* Srikar, Apr 11, 1997. Added the prototypes for the added function */
enum BOOLEAN get_port_ipx_operational_state(USHORT port_number);

#if defined (CCP)
	static enum BOOLEAN is_ccp_option (char *option_string);
	static char *cptr_ccp_option = "CCP";
#endif

static char *cptr_ncp_types[] = {"IPCP","IPXCP","ATCP","NBFCP","BCP"};
static char *cptr_hex_values[] =	{"","%02jx","%02jx%02jx","%02jx%02jx%02jx","%02jx%02jx%02jx%02jx","%02jx%02jx%02jx%02jx%02jx",
	"%02jx%02jx%02jx%02jx%02jx%02jx", "%02jx%02jx%02jx%02jx%02jx%02jx%02jx"};
/****************************************************************************/
/* H is hex, D is decimal, # is size in bytes, S is little-endian swapped 
"IP","IPS","H6","H4","D4","H2","D2""H4S","D4S","H2S","D2S","H1","D1","String","Netbios String"
*/
/* PPP Port Option = 00,IPCP Address,3,Auto,Negotiation Not Required,Negotiable,IP,128.1.60.1 */
/* PPP Port Option = 00,IPCP Address,3,Auto,Alternate,IP,128.1.60.2 */
/* PPP Port Option = 00,IPCP Address,3,Auto,Range,IP,128.1.60.2,128.1.60.3,0.0.0.1 */
/****************************************************************************/
void add_ppp_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
		{
#if defined (CCP)
		if (is_ccp_option (port_option_string) == TRUE)
			{
			sptr_option_lists = &ppp.port[port_number].ccp.option_lists;
			}
		else
			{
			sptr_option_lists = &ppp.port[port_number].option_lists;
			}
#else
		sptr_option_lists = &ppp.port[port_number].option_lists;
#endif
		}
	else
		{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].option_lists;
#endif
		}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,FALSE);
}
#if defined (CCP)
/****************************************************************************/
static enum BOOLEAN is_ccp_option (char *option_string)
{
	if (strstr (option_string, cptr_ccp_option) != NULL)
		{
		return (TRUE); 
		}
	else
		{
		return (FALSE);
		}

}
#endif
/****************************************************************************/
static enum NCP_STACK_INDEX get_stack_index (char *option_string)
{
	enum NCP_STACK_INDEX stack_index;

	for (stack_index = 0x00; stack_index < NUMBER_OF_NCP_STACKS; stack_index = (enum NCP_STACK_INDEX) (stack_index + 1))
		{
		if (strstr (option_string,cptr_ncp_types[stack_index]) != NULL)
			{
			break;
			}
		}

	return (stack_index);
}
/****************************************************************************/
void add_remote_ppp_option (char *cptr_port_number_and_option_string)
{
	enum NCP_STACK_INDEX stack_index;
	USHORT port_number;
	char port_option_string[256];
	char *cptr_value_portion;
	OPTION_LISTS *sptr_option_lists;

	port_number = get_port_number_and_string (cptr_port_number_and_option_string,port_option_string);

	stack_index = get_stack_index (port_option_string);

	if (stack_index == NUMBER_OF_NCP_STACKS)
	{
#if defined (CCP)
		if (is_ccp_option (port_option_string) == TRUE)
		{
			sptr_option_lists = &ppp.port[port_number].ccp.option_lists;
		}
		else
		{
			sptr_option_lists = &ppp.port[port_number].option_lists;
		}
#else
		sptr_option_lists = &ppp.port[port_number].option_lists;
#endif
	}
	else
	{
#ifdef __MLPPP__
		sptr_option_lists = &mlppp.port[port_number].ncp[stack_index].option_lists;
#else
		sptr_option_lists = &ppp.port[port_number].ncp[stack_index].option_lists;
#endif
	}

	cptr_value_portion = strchr (cptr_port_number_and_option_string,',');

	strcpy (port_option_string,cptr_value_portion + 1);

	add_option_type (sptr_option_lists,cptr_port_number_and_option_string,port_option_string,TRUE);
}
/****************************************************************************/
#ifdef __MLPPP__
extern char ethernet_address[] ;
#endif
static void add_option_type (OPTION_LISTS *sptr_option_lists,char *cptr_port_number_and_option_string,char *cptr_option_string,
	enum BOOLEAN remote_configuration)
{
	BYTE option_data[128];
	BYTE length;
	char ncp_name[16];
	char option_name[80];
	enum BOOLEAN value_swapped;
	BYTE option_number;
	enum BOOLEAN negotiation_required;
	enum BOOLEAN negotiable;
	enum BOOLEAN automatic_nak_processing;
	enum TEST return_value;
	OPTION_LIST *sptr_option_list;
	ULONG magic_number;

	if (remote_configuration == TRUE)
	{
		sptr_option_list = &sptr_option_lists->remote_configured;
	}
	else
	{
		sptr_option_list = &sptr_option_lists->configured;
	}

	if (strstr (cptr_port_number_and_option_string,"Negotia") != NULL)
	{
		return_value = get_configuration_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped,&negotiation_required,&negotiable,&automatic_nak_processing);

		if (return_value == FAIL)
		{
			return;
		}

		if (remote_configuration == FALSE)
		{
			if (strstr (cptr_port_number_and_option_string,"Magic Number") != NULL)
			{
				magic_number = get_my_magic_number ();

				memcpy (&option_data[0],&magic_number,sizeof (magic_number));
			}
#ifdef __MLPPP__
         else
         {
            if (strstr (cptr_port_number_and_option_string,"EPD") != NULL)
            {
               if (option_data[0] == 3) /* The EPD class is Ethernet Address */
                  memcpy (&option_data[1], &ethernet_address[0], 6) ;
            }
         }
#endif
		}

		add_configuration_option (sptr_option_list,OPTION_DEFAULT_STATE,option_number,length,
			&option_data[0],&option_name[0],&ncp_name[0],value_swapped,negotiation_required,negotiable,automatic_nak_processing);
	}
	else
	if (strstr (cptr_port_number_and_option_string,"Alternate") != NULL)
	{
		return_value = get_alternate_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped);

		if (return_value == FAIL)
		{
			return;
		}

		add_alternate_to_configuration_option (sptr_option_list,option_number,length,&option_data[0],&option_name[0],
			&ncp_name[0],value_swapped);
	}
	else
	if (strstr (cptr_port_number_and_option_string,"Range") != NULL)
	{
		return_value = get_range_option_values (cptr_option_string,&ncp_name[0],&option_name[0],&option_number,
			&option_data[0],&length,&value_swapped);

		if (return_value == FAIL)
		{
			return;
		}

		add_configuration_option_range (sptr_option_list,option_number,length,&option_data[0],&option_name[0],&ncp_name[0],
			value_swapped);
	}
	else
	{
		ppp_printf (PPP_ALARM_PRINTF,"Unknown Configuration String %s\r\n",cptr_port_number_and_option_string);
	}
}
/****************************************************************************/
/* IPCP Address,3,Auto,Negotiation Not Required,Negotiable,IP,128.1.60.1 */
/****************************************************************************/
static enum TEST get_configuration_option_values (char *cptr_option_string,char *cptr_return_ncp_name,
	char *cptr_return_option_name,BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,
	enum BOOLEAN *eptr_return_value_swapped,enum BOOLEAN *eptr_negotiation_required,enum BOOLEAN *eptr_negotiable,
	enum BOOLEAN *eptr_automatic_nak_processing)
{
	char negotiation_required_string[30];
	char automatic_nak_processing_string[14];
	char negotiable_string[14];
	BYTE number_of_fields_scanned;
	char *cptr_value;

	number_of_fields_scanned = 0x00;

	cptr_value = parse_ppp_option_line (cptr_option_string,cptr_return_ncp_name,cptr_return_option_name,
		bptr_return_option_number,automatic_nak_processing_string,negotiation_required_string,negotiable_string,
		&number_of_fields_scanned);

	if (number_of_fields_scanned != 6)
		{
		ppp_printf (PPP_ALARM_PRINTF,"Illegal Number of PPP Options %02x Entered %s!!!\r\n",number_of_fields_scanned,
			cptr_option_string);

		return (FAIL);
		}

	if (strstr (negotiation_required_string,"Not") != NULL)
		{
		*eptr_negotiation_required = FALSE;
		}
	else
		{
		*eptr_negotiation_required = TRUE;
		}

	if (strstr (negotiable_string,"Not") != NULL)
		{
		*eptr_negotiable = FALSE;
		}
	else
		{
		*eptr_negotiable = TRUE;
		}

	if (strstr (automatic_nak_processing_string,"Not") != NULL)
		{
		*eptr_automatic_nak_processing = FALSE;
		}
	else
		{
		*eptr_automatic_nak_processing = TRUE;
		}

	parse_option_value (cptr_value,bptr_return_data,bptr_return_length,eptr_return_value_swapped);

	return (PASS);
}
/****************************************************************************/
static char *parse_ppp_option_line (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,char *cptr_automatic_nak_processing_string,char *cptr_negotiation_required_string,
	char *cptr_negotiable_string,BYTE *bptr_number_of_parameters_processed)
{
	char *cptr_parameter;
	char option_number_string[4];
	ULONG option_number;

	cptr_parameter = strtok (cptr_option_string,",\n");

	cptr_parameter = copy_parameter (cptr_return_ncp_name,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_return_option_name,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (&option_number_string[0],cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_automatic_nak_processing_string,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_negotiation_required_string,cptr_parameter,bptr_number_of_parameters_processed);
	cptr_parameter = copy_parameter (cptr_negotiable_string,cptr_parameter,bptr_number_of_parameters_processed);

	sscanf (option_number_string,"%d",&option_number);
	*bptr_return_option_number = (BYTE) option_number;

	return (cptr_parameter);
}
/****************************************************************************/
char *copy_parameter (char *cptr_parameter,char *cptr_option,BYTE *bptr_number_of_parameters_processed)
{
	char *cptr_next_option;

	cptr_next_option = strtok (NULL,",\n");

	if (cptr_option != NULL)
		{
		strcpy (cptr_parameter,cptr_option);

		*bptr_number_of_parameters_processed = (BYTE) (*bptr_number_of_parameters_processed + 1);
		}

	return (cptr_next_option);
}
/****************************************************************************/
static void parse_option_value (char *cptr_value,BYTE *bptr_option_data,BYTE *bptr_length_of_all_options,
	enum BOOLEAN *eptr_return_value_swapped)
{
	char *cptr_parameter;
	BYTE number_of_value_strings_processed;
	char value_type_string[12];
	char value_string[80];
	BYTE option_length;

	number_of_value_strings_processed = 0x00;
	option_length = 0x00;
	*bptr_length_of_all_options = 0x00;

	cptr_parameter = copy_parameter (&value_type_string[0],cptr_value,&number_of_value_strings_processed);
	cptr_parameter = copy_parameter (&value_string[0],cptr_parameter,&number_of_value_strings_processed);

	while (cptr_parameter != NULL)
		{
		get_option_value (&value_type_string[0],&value_string[0],bptr_option_data,&option_length,eptr_return_value_swapped);

		*bptr_length_of_all_options = (BYTE) (*bptr_length_of_all_options + option_length);

		bptr_option_data += option_length;

		cptr_parameter = copy_parameter (&value_type_string[0],cptr_parameter,&number_of_value_strings_processed);
		cptr_parameter = copy_parameter (&value_string[0],cptr_parameter,&number_of_value_strings_processed);
		}

	get_option_value (&value_type_string[0],&value_string[0],bptr_option_data,&option_length,eptr_return_value_swapped);

	*bptr_length_of_all_options = (BYTE) (*bptr_length_of_all_options + option_length);
}
/****************************************************************************/
void get_option_value (char *value_type_string,char *value_string,BYTE *bptr_return_data,BYTE *bptr_return_length,
	enum BOOLEAN *eptr_return_value_swapped)
{
	char *value_format_string;

	if (get_option_value_type (value_type_string,value_string,bptr_return_data,bptr_return_length,eptr_return_value_swapped) ==
		TRUE)
		{
		return;
		}

	*bptr_return_length = get_size_of_numeric_string (value_type_string);

	if (strstr (value_type_string,"H") != NULL)
		{
		value_format_string = cptr_hex_values[*bptr_return_length];
		}
	else
		{
		value_format_string = "%hu";
		}

	if (*bptr_return_length > 0x00)
		{
		sscanf (value_string,value_format_string,(int *) &bptr_return_data[0],(int *) &bptr_return_data[1],
			(int *) &bptr_return_data[2],(int *) &bptr_return_data[3],(int *) &bptr_return_data[4],(int *) &bptr_return_data[5],
			(int *) &bptr_return_data[6],(int *) &bptr_return_data[7]);
		}
}
/****************************************************************************/
static enum BOOLEAN get_option_value_type (char *value_type_string,char *value_string,BYTE *bptr_return_data,
	BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped)
{
	ULONG ip_address;
	ULONG size_of_string;

	if (strstr (value_type_string,"String") != NULL)
		{
		if (strlen (value_type_string) != strlen ("String"))
			{
			size_of_string = 0x00000000L;

			sscanf (value_type_string + strlen ("String"),"%u",(int *) &size_of_string);

			memset (bptr_return_data,(int) NULL,size_of_string);

			*bptr_return_length = (BYTE) size_of_string;
			}
		else
			{
			*bptr_return_length = (BYTE) strlen (value_string);
			}

		strcpy ((char *) bptr_return_data,value_string);

		return (TRUE);
		}
	else if (strstr (value_type_string,"S") != NULL)
		{
		*eptr_return_value_swapped = TRUE;
		}
	else
		{
		*eptr_return_value_swapped = FALSE;
		}

	if (strstr (value_type_string,"IP") != NULL)
		{
		ip_address = get_ip_address_string (value_string);

		memcpy (bptr_return_data,&ip_address,sizeof (ULONG));

		*bptr_return_length = sizeof (ULONG);

		return (TRUE);
		}

	return (FALSE);
}
/****************************************************************************/
static BYTE get_size_of_numeric_string (char *value_type_string)
{
	BYTE size_of_string;

	if (strstr (value_type_string,"0") != NULL)
		{
		size_of_string = 0x00;
		}
	else if (strstr (value_type_string,"1") != NULL)
		{
		size_of_string = 0x01;
		}
	else if (strstr (value_type_string,"2") != NULL)
		{
		size_of_string = 0x02;
		}
	else if (strstr (value_type_string,"3") != NULL)
		{
		size_of_string = 0x03;
		}
	else if (strstr (value_type_string,"4") != NULL)
		{
		size_of_string = 0x04;
		}
	else if (strstr (value_type_string,"5") != NULL)
		{
		size_of_string = 0x05;
		}
	else if (strstr (value_type_string,"6") != NULL)
		{
		size_of_string = 0x06;
		}
	else if (strstr (value_type_string,"7") != NULL)
		{
		size_of_string = 0x07;
		}
	else if (strstr (value_type_string,"8") != NULL)
		{
		size_of_string = 0x08;
		}
	else if (strstr (value_type_string,"9") != NULL)
		{
		size_of_string = 0x09;
		}
	else
		{
		size_of_string = 0x00;
		}

	return (size_of_string);
}
/****************************************************************************/
static ULONG get_ip_address_string (char *cptr_ip_address_string)
{
	USHORT ip_address_array[4];
	ULONG   ret_value;

	sscanf (cptr_ip_address_string,"%03hu.%03hu.%03hu.%03hu",(int *) &ip_address_array[0],(int *) &ip_address_array[1],
		(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

#ifdef RTRERROR
	ip_address_array[0] = convert_4_bytes_to_ulong ((BYTE) ip_address_array[0],(BYTE) ip_address_array[1],
		(BYTE) ip_address_array[2],(BYTE) ip_address_array[3]);
	return (ip_address_array[0]);
#endif

	ret_value = convert_4_bytes_to_ulong ((BYTE) ip_address_array[0],(BYTE) ip_address_array[1],
		(BYTE) ip_address_array[2],(BYTE) ip_address_array[3]);

	return (ret_value);

}
/****************************************************************************/
static ULONG get_my_magic_number (void)
{
	ULONG my_magic_number;

	while (TRUE)
		{
		my_magic_number = lsl_control (GET_RANDOM_NUMBER);

		if (my_magic_number != 0x00000000L)
			{
			break;
			}
		}

	return (my_magic_number);
}
/****************************************************************************/
ULONG get_ppp_configuration_table_address (void)
{
	return ((ULONG) (&ppp_configuration_table));
}

/* Kamalanath 16\08\1996 */

void ppp_dhcp_control_function (int port_num, ULONG dhcp_command, ULONG parameter_0)
{
	OPTION_LIST_ENTRY *sptr_configured_option;
   ULONG ip_address;
   port_num = port_num - ppp.number_of_lan_ports;
	
	switch (dhcp_command)
	{
		case (DHCP_SERVER_NOT_FOUND) :
			printf ("DHCP_SERVER_NOT_FOUND command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status = DHCP_STATUS_DISCOVER_REQUEST_MADE);
				{
					ppp.port[port_num].dhcp_status = DHCP_STATUS_NO_OPERATION ;
				}
			}
			break ;
		
		case (DHCP_IP_ADDRESS_OBTAINED) :
			printf ("DHCP_IP_ADDRESS_OBTAINED command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status == DHCP_STATUS_DISCOVER_REQUEST_MADE)
				{
					ip_address = parameter_0 ;
#ifdef __MLPPP__
					sptr_configured_option = find_matching_option (&mlppp.port[port_num].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
                                                   IP_ADDRESS_OPTION_TYPE) ;
#else
					sptr_configured_option = find_matching_option (&ppp.port[port_num].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured,
                                                   IP_ADDRESS_OPTION_TYPE) ;
#endif
					memcpy (sptr_configured_option->uptr_data, &ip_address, sizeof(ULONG)) ;
					ppp.port[port_num].dhcp_status = DHCP_STATUS_IP_ADDRESS_OBTAINED ;
				}
			}	
			break ;

		case (DHCP_LEASE_TIME_EXPIRED) :
			printf ("DHCP_LEASE_TIME_EXPIRED command to ppp_dhcp_control()\n") ;
			if (is_dhcp_client_enabled(port_num + ppp.number_of_lan_ports)) 
			{
				if (ppp.port[port_num].dhcp_status == DHCP_STATUS_IP_ADDRESS_OBTAINED)
				{
					ppp.port[port_num].dhcp_status = DHCP_STATUS_LEASE_TIME_EXPIRED ;
					ip_bring_down_ncp (port_num) ;
				}
			}
			break ;

		default :
			break ;
	}
}

static void ip_bring_down_ncp (int real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp ;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX] ;
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX] ;
#endif

	if ((sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID) &&
	    (sptr_ncp->enabled))
	{
		execute_ncp_state_machine (PPP_DOWN_EVENT, sptr_ncp, real_port_number, NULL, 0) ;
	}
}

/* Kamalanath 16\08\1996 */

/* Srikar, Mar 17, 1997. Added the following function to inform ncp state machine from IPX module */
/* when a circuit's operational status is set to down */
enum BOOLEAN set_port_ipx_operational_state(USHORT port_number, enum BOOLEAN new_state)
{
	PPP_NCP_CLASS	*sptr_ncp;

#ifdef __MLPPP__
	 sptr_ncp = &mlppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#else
	 sptr_ncp = &ppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX];
#endif

	 if (sptr_ncp->enabled && ppp.port[port_number].state == PPP_OPENED_STATE)
	 {
		if (sptr_ncp->state == PPP_OPENED_STATE && new_state == FALSE)
		{
		 	execute_ncp_state_machine(PPP_DOWN_EVENT, sptr_ncp, port_number, NULL, 0);
			return TRUE;
		}
		else if (sptr_ncp->state == PPP_STARTING_STATE && new_state == TRUE)
		{
		 	execute_ncp_state_machine(PPP_UP_EVENT, sptr_ncp, port_number, NULL, 0);
			return TRUE;
		}
		else
			return FALSE;
	 }
	 else
	 	return FALSE;
}

/* Srikar, Apr 11, 1997. Added the following function to access the operational state of wan ports */
enum BOOLEAN get_port_ipx_operational_state(USHORT port_number)
{
#ifdef __MLPPP__
	 if (mlppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX].state == PPP_OPENED_STATE)
#else
	 if (ppp.port[port_number].ncp[PPP_IPX_NCP_STACK_INDEX].state == PPP_OPENED_STATE)
#endif
	 	return TRUE;
	else
		return FALSE;
}

