/* 
	File Name : PPPDBNVR.C	- Dial Backup NVRam related
	Contents  : Routines related to PPP-Dial Back up configuration reading routines 
	Author 	 : Chidananda Murthy R  
	Date	 : 1st October 1996
*/
#include "defs.h"
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ppp.h"

#define DLBK_STN_LINK_NO 10

/* Additional routines to take care of initializing fields of links of PPP stations */
/* These routines are based on the routines in file \rtrware\nvram\nvram.c */
/*
	Function : DLBK_STNLINK_set_variable_port_and_enable()
	Comments :
		This is a version of the original routine set_variable_port_and_enable()
		to handle a requirement encountered while incorporating PPP Dial Backup.
		This routine will be called to parse a line in configuration such as
			PPP Port Link = 12, enabled
		to place TRUE in 
			ppp.station[1].link[2].enable 
		In the parameter 12, the higher digit is taken as Station No, and 
			the lower digit is taken as Link No.
*/
void DLBK_set_variable_port_and_enable (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter )
{
	USHORT combined_number, station_no, link_no;
	char enable_string[20];

	sscanf (cptr_value_string,"%03hu,%s",(int *) &combined_number, enable_string);
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	*(BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + 
  		(station_no * sizeof(STATION_DEFINITION)) +
  		(link_no * sizeof(LINK_DEFINITION))) = is_parameter_enabled (enable_string);
}

void DLBK_set_variable_port_and_enable_enumBOOL (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter )
{
	USHORT combined_number, station_no, link_no;
	char enable_string[20];

	sscanf (cptr_value_string,"%03hu,%s",(int *) &combined_number, enable_string);
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	*(enum BOOLEAN *)(vptr_parameter_1 + ulptr_parameter_2 + 
  		(station_no * sizeof(STATION_DEFINITION)) +
  		(link_no * sizeof(LINK_DEFINITION))) = (enum BOOLEAN) is_parameter_enabled (enable_string);
}

void DLBK_set_ulong_decimal_value (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter )
{
	USHORT combined_number, station_no, link_no;
	ULONG  decimal_value[2];

	memset (&decimal_value[0], (int) NULL, 8);

	sscanf (cptr_value_string,"%hu,%08lu",(int *) &combined_number, &decimal_value[0]);

#ifdef DLBK_DEBUG
	printf ("DLBK_set_ulong...() : %hu %hu\n", combined_number, decimal_value[0]);
#endif

/*	sscanf (cptr_value_string,"%03hu,%011lu",(int *) &combined_number, &decimal_value); */
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	*(ULONG *)(vptr_parameter_1 + ulptr_parameter_2 + 
  		(station_no * sizeof(STATION_DEFINITION)) +
  		(link_no * sizeof(LINK_DEFINITION))) = decimal_value[0];
}

void DLBK_set_ushort_decimal_value (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter )
{
	USHORT combined_number, station_no, link_no;
	USHORT  decimal_value;

	sscanf (cptr_value_string,"%03hu,%03hu",(int *) &combined_number, &decimal_value);
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + 
  		(station_no * sizeof(STATION_DEFINITION)) +
  		(link_no * sizeof(LINK_DEFINITION))) = decimal_value;
}

void DLBK_set_variable_port_and_string (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter )
{
	USHORT combined_number, station_no, link_no;
	char variable_string[20];
	char *cptr_line_feed;

	sscanf (cptr_value_string,"%03hu,%s",(int *) &combined_number, variable_string);
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	cptr_line_feed = strchr (&variable_string[0],0x0a);
	if (cptr_line_feed != NULL)
		*cptr_line_feed = (char) NULL;

	strcpy ((void *)(vptr_parameter_1 + ulptr_parameter_2 + 
  			(station_no * sizeof(STATION_DEFINITION)) +
  			(link_no * sizeof(LINK_DEFINITION))),
			variable_string);
}

void DLBK_set_ushort_decimal_value_2 (char *cptr_value_string, ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2, ULONG size_of_parameter)
{
	USHORT combined_number, station_no, link_no;
	USHORT  decimal_value;

	sscanf (cptr_value_string,"%03hu,%03hu",(int *) &combined_number, &decimal_value);
	station_no = combined_number / DLBK_STN_LINK_NO;
	link_no = combined_number % DLBK_STN_LINK_NO;

	ppp.station[station_no].link_id_list[link_no] = decimal_value;
}




