/* 
	File Name : PPPDBSWI.C	- Dial Backup SWItching related
	Contents  : Routines related to PPP-Dial Back up ( Switching links )
	Author 	 : Chidananda Murthy R 
	Date	 : 1st October 1996
*/
#include "defs.h"
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "ppp.h"
#include "wanmgr.h"

/* Chidanand - 26 June 1997 - Just for testing */
/* #define DLBK_DEBUG_EN */
/* Chidanand - 26 June 1997 - Just for testing */

void DLBK_initialize_ppp_port_parameters (USHORT station_no)
{
	/* 
		Purpose		:	Initialize parameters of this PPP port/station.
							Introduced while incorporating PPP Dial Backup
		Called By	:	Called usually after switching a link.
	*/
	int protocol_stack_index ;
	USHORT link_no;

	link_no = ppp.station[station_no].active_link_id;
	if (link_no == MAXIMUM_NUMBER_OF_PPP_LINKS)
		link_no = ppp.station[station_no].link_id_list[0];

	/* Do for every protocol stack */
	for (protocol_stack_index = 0x00 ; protocol_stack_index < NUMBER_OF_NCP_STACKS ;
	     protocol_stack_index = (BYTE) (protocol_stack_index + 1))
	{
		/* Save enabled flag (master config). enabled will be modified 
				during Authentication phase. */
		ppp.port[station_no].ncp[protocol_stack_index].enabled =
			ppp.station[station_no].link[link_no].ncp[protocol_stack_index].configured ;
	}

	ppp.station[station_no].link[ppp.station[station_no].active_link_id].ppp_configuration.authentication.status = UNSUCCESSFUL;
	ppp.station[station_no].link[ppp.station[station_no].active_link_id].ppp_configuration.authentication.rxed_authentication_ack = FALSE;
	ppp.station[station_no].link[ppp.station[station_no].active_link_id].ppp_configuration.authentication.txed_authentication_ack = FALSE;

	ppp.port[station_no].number_of_configuration_requests = 0x0000;
	ppp.port[station_no].number_of_echo_requests = 0x0000;
	ppp.port[station_no].number_of_lcp_termination_requests = 0x0000;

	ppp.port[station_no].configuration_request_send_interval = 0x0000;
	ppp.port[station_no].configuration_request_backoff_interval = 0x0000;

	ppp.port[station_no].time_to_send_LQR = 0x0000;
}

/* Allocates backup port to one of the waiting stations with the highest priority.
	Specified station "exclude_station" will not be considered for allocation.
	If not, it returns MAXIMUM_NUMBER_OF_PPP_STATIONS */
USHORT DLBK_allocate_backup_wan_port (USHORT wan_port_no, USHORT exclude_station_no)
{
	USHORT i, station_no;
	station_no = MAXIMUM_NUMBER_OF_PPP_STATIONS;
						
	for (i = 0 ; i < MAXIMUM_NUMBER_OF_PPP_STATIONS ; i++)
	{
		/* Scan thru' all station's backup links */
		if ( (i != exclude_station_no) && (ppp.station[i].status == WAITING)
				&& (wan_port_no == station_to_backup_port(i)))
		{	
	    	if (station_no == MAXIMUM_NUMBER_OF_PPP_STATIONS
		    		|| ppp.station[i].priority > ppp.station[station_no].priority)
    			station_no = i;
	    }
	}

#ifdef DLBK_DEBUG_EN
	if (station_no != MAXIMUM_NUMBER_OF_PPP_STATIONS)
		printf ("Allocating free WAN %d to station %d\n", wan_port_no, station_no);
	else
		printf ("WAN %d free. No stn requires it\n", wan_port_no);
#endif

	return station_no;
}

void DLBK_suspend_wan_port (USHORT wan_port_no)
{
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
		(*ppp.port[wan_port_no].serial_driver.fptr_control_routine)
							(DLBK_SUSPEND_WAN_PORT, (ULONG)wan_port_no, 0) ;
}

void DLBK_resume_wan_port (USHORT wan_port_no)
{
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
		(*ppp.port[wan_port_no].serial_driver.fptr_control_routine)
			(DLBK_RESUME_WAN_PORT, (ULONG)wan_port_no, 0) ;
}

void DLBK_init_wan_port ( USHORT wan_port_no, enum BOOLEAN for_DLBK_dial )
{
	if (ppp.wan_port_inittable[wan_port_no] == FALSE)
	{
		if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
		{
			(*ppp.port[wan_port_no].serial_driver.fptr_control_routine) (INIT_SERIAL_PORT,
				(ULONG) wan_port_no,(ULONG) ppp.port[wan_port_no].device_driver_id);
			ppp.wan_port_inittable[wan_port_no] = TRUE;
		}
	}

/* Chidanand	- PPP Dial Backup  - 1st October 1996 
			Dialing thru' backup port for PPP. */
/*
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
	{
		if (for_DLBK_dial == TRUE)
			set_wan_port_owner ((USHORT)wan_port_no, OWNED_BY_PPP) ;
	}
*/

}

void DLBK_attach_wan_to_station_and_open (USHORT station_no, USHORT link_no, USHORT wan_port_no)
{
#ifdef DLBK_DEBUG_EN
	printf ("Trying to bring Stn %d on Link %d WAN %d\n", station_no, link_no, wan_port_no);
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine == NULL)
		printf ("ERROR : WAN %d Missing control\n", wan_port_no);
#endif

	ppp.station[station_no].status = WAITING;
	ppp.wan_port_status[wan_port_no] = OPENING_FOR_DLBK;
	ppp.down_station[wan_port_no] = MAXIMUM_NUMBER_OF_PPP_STATIONS;
   ppp.up_station [wan_port_no] = station_no;
   ppp.up_link_no [wan_port_no] = link_no;
   ppp.up_port_no [wan_port_no] = wan_port_no;

	DLBK_init_wan_port (wan_port_no, TRUE);

	/* Suspend WAN port activities */	
	DLBK_suspend_wan_port (wan_port_no);

	/* Apply parameters */					
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine != NULL)
		(*ppp.port[wan_port_no].serial_driver.fptr_control_routine)
			(DLBK_SET_WAN_PARAMETERS, 
		 	(ULONG) wan_port_no,
		 	(ULONG) &(ppp.station[station_no].link[link_no].link_wan_configuration.connection_method)
		);							 
                            
	/* Resume the WAN Port's activities */
	DLBK_resume_wan_port (wan_port_no);

/* Sachin 4th July 1997 to handle the direct connect problem */
   if ((is_wan_direct_connect(wan_port_no)) &&
       (ppp.station[station_no].link[link_no].link_wan_configuration.connection_method.answering_enabled == FALSE))
   {
   }
   else
   {
/* Chidanand - 26 June 1997 - Put for more safety */
	   set_wan_port_owner ((USHORT)wan_port_no, OWNED_BY_NONE) ;
/* Chidanand - 26 June 1997 */
/* 28 June 1997 */
	   DLBK_Initialize_Port (wan_port_no);
   }

	/* Try opening the port */
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
		(*ppp.port[wan_port_no].serial_driver.fptr_control_routine) 
			(OPEN_SERIAL_PORT, (ULONG) wan_port_no,
			(ULONG) ppp.port[wan_port_no].device_driver_id);
}

void DLBK_stop_wan_port (USHORT wan_port_no)
{
#ifdef DLBK_DEBUG_EN
	printf ("No job. Stopping WAN %d\n", wan_port_no);
#endif
/*  26 Feb 1997
		DLBK_suspend_wan_port (wan_port_no);
*/
		DOD_make_port_answering (wan_port_no);

/* Chidanand - 26 June 1997 - Put for more safety */
		set_wan_port_owner ((USHORT)wan_port_no, OWNED_BY_NONE) ;
/* Chidanand - 26 June 1997 */
/* 28 June 1997 */
		DLBK_Initialize_Port (wan_port_no);

		/* Try opening the port */
		if (ppp.port[wan_port_no].serial_driver.fptr_control_routine)
			(*ppp.port[wan_port_no].serial_driver.fptr_control_routine) 
				(OPEN_SERIAL_PORT, (ULONG) wan_port_no, (ULONG) ppp.port[wan_port_no].device_driver_id);

		ppp.down_station [wan_port_no] = MAXIMUM_NUMBER_OF_PPP_STATIONS;
		ppp.up_station [wan_port_no] = MAXIMUM_NUMBER_OF_PPP_STATIONS;
		ppp.wan_port_status[wan_port_no] = DLBK_FREE;
}

void DLBK_bring_down_station (USHORT station_no)
{
   USHORT wan_port_no;
#ifdef DLBK_DEBUG_EN
	printf ("Bringing down Stn %d\n", station_no);
#endif
	execute_ppp_state_machine (PPP_DOWN_EVENT,(USHORT)station_no, NULL, 0x0000);
	ppp_close_device_driver_port ((USHORT) station_no);

   /* Set WAN port owner to NONE on answering - non DOD ports */
   wan_port_no = station_to_wan_port (station_no);

/* Chidanand - 24 June 1997 */			
#if 0
   if ( (ppp.port[station_no].callback_on == FALSE) && 
		wan_port_no != MAXIMUM_NUMBER_OF_PPP_PORTS && (is_wan_port_answering (wan_port_no))
         && (ppp.station[station_no].link[ppp.station[station_no].active_link_id].dial_on_demand == FALSE))
      set_wan_port_owner (wan_port_no, OWNED_BY_NONE);
#endif
/* Chidanand - 24 June 1997 */			

	/* Leave the station in WAITING with default primary link */
	ppp.station[station_no].active_link_id = ppp.station[station_no].link_id_list[0];
	ppp.station[station_no].status = WAITING;

}

void DLBK_bring_up_station (USHORT station_no, USHORT link_no, USHORT wan_port_no)
{
	/* Only after WAN port is UP, this routine has to be called */
#ifdef DLBK_DEBUG_EN
	printf ("Bringing Stn %d on Link %d WAN %d\n", station_no, link_no, wan_port_no);
#endif

	ppp.station[station_no].active_link_id = link_no;

	ppp.station[station_no].status = 
		(ppp.station[station_no].active_link_id == 
			ppp.station[station_no].link_id_list[0]) ? PRIMARY : BACKUP;

	DLBK_initialize_ppp_port_parameters (station_no);
	
#ifdef __DOD__
	ppp.station[station_no].link[link_no].connect_state = LINK_UP;
	ppp.station[station_no].dial_drop_timer = 0;
	reset_ppp_idle_timer (station_no);
#endif /* __DOD__ */

	execute_ppp_state_machine (PPP_UP_EVENT, (USHORT)station_no, NULL, 0x0000);	

	if (ppp.pending_open[wan_port_no] == TRUE)
	{
		execute_ppp_state_machine (PPP_OPEN_EVENT,(USHORT) station_no,NULL,0x0000);
#ifdef DLBK_DEBUG_EN
		printf ("Pending OPEN handled for WAN %d\n", wan_port_no);
#endif
		ppp.pending_open[wan_port_no] = FALSE;
	}

/* Chidanand - 24 June 1997 */			
	set_wan_port_owner ((USHORT)wan_port_no, OWNED_BY_PPP) ;
/* Chidanand - 24 June 1997 */			

	ppp.wan_port_status[wan_port_no] = BUSY;               
}

void DLBK_close_wan_port (USHORT wan_port_no)
{
	if (ppp.port[wan_port_no].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[wan_port_no].serial_driver.fptr_control_routine) 
				(CLOSE_SERIAL_PORT, (ULONG)wan_port_no,
				(ULONG) ppp.port[wan_port_no].device_driver_id);
	}
	ppp.wan_port_status[wan_port_no] = DLBK_FREE;               
}

void DLBK_handle_free_wan_port (USHORT wan_port_no, USHORT up_station_no)
{
	/* WAN port wan_port_no is free. Just now up_station_no is coming up
		on another port. So except for that port, try allocating wan port to
		some other waiting station's backup link. */
	USHORT new_station_no;

	new_station_no = DLBK_allocate_backup_wan_port (wan_port_no, up_station_no);
						
	/* If there is a waiting station, attach this port with that station and bring it up */
	if (new_station_no != MAXIMUM_NUMBER_OF_PPP_STATIONS)
	{
		DLBK_attach_wan_to_station_and_open (new_station_no, ppp.station[new_station_no].link_id_list[1], wan_port_no);
	}
	else
	{
		DLBK_stop_wan_port (wan_port_no);
	}	 
}

USHORT DLBK_get_backup_link_no (USHORT station_no)
{
/* Get backup link number for a station. Only one backup link is assumed */

	USHORT link_no, wan_port_no;

	if (ppp.station[station_no].enable == TRUE)
	{
 		link_no = ppp.station[station_no].link_id_list[1];
		if ((link_no == MAXIMUM_NUMBER_OF_PPP_LINKS) ||
			(ppp.station[station_no].link[link_no].enable == FALSE)	||
			((wan_port_no = ppp.station[station_no].link[link_no].wan_port) == MAXIMUM_NUMBER_OF_PPP_PORTS))
				link_no = MAXIMUM_NUMBER_OF_PPP_LINKS;
	}
	else
		link_no = MAXIMUM_NUMBER_OF_PPP_LINKS;

#ifdef DLBK_DEBUG_EN
	if (link_no == MAXIMUM_NUMBER_OF_PPP_LINKS)
		printf ("No Backup Link for Stn %d\n", station_no);
#endif

	return link_no;
}


void DLBK_switch_stations (USHORT down_station, USHORT down_wan_port_no, USHORT up_station, USHORT up_link, USHORT up_wan_port_no)
{
#ifdef DLBK_DEBUG_EN
	printf ("Bring DOWN WAN %d of Stn %d & UP WAN %d of Stn %d\n", down_wan_port_no, down_station, up_wan_port_no, up_station);
#endif
	ppp.wan_port_status[down_wan_port_no] = CLOSING_FOR_DLBK;
	ppp.down_station[down_wan_port_no] = down_station;
	ppp.up_station[down_wan_port_no] = up_station;
	ppp.up_link_no[down_wan_port_no] = up_link;
	ppp.up_port_no[down_wan_port_no] = up_wan_port_no;

	if (ppp.port[down_wan_port_no].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[down_wan_port_no].serial_driver.fptr_control_routine) 
			(CLOSE_SERIAL_PORT, (ULONG) down_wan_port_no, (ULONG) ppp.port[down_wan_port_no].device_driver_id);
	}
}

void DLBK_handle_dial_attempt (USHORT wan_port_no)
{
	/*
		Called for each dial attempt. wan_port_no - which WAN port is dialing
	*/
	USHORT station_no, backup_link_no, backup_wan_port_no, other_station_no;

	ppp.dial_count [ wan_port_no ] ++ ;

	/* If count has crossed the maximum number of retries and 
		if wan port is primary port & backup is not up, 
		then bring up backup link */

	if ((station_no = primary_port_to_station(wan_port_no)) != MAXIMUM_NUMBER_OF_PPP_STATIONS)	
	{
		if (ppp.station[station_no].max_dial_attempts != 0 &&
			ppp.dial_count [wan_port_no] > ppp.station[station_no].max_dial_attempts &&
			(ppp.station[station_no].status == WAITING ||
				ppp.station[station_no].status == DOWN_BY_DOD) &&
			station_to_wan_port (station_no) == wan_port_no)
		{
#ifdef DLBK_DEBUG
			printf ("Station %d Dial Count %d exceeded for WAN %d\n",
					station_no, ppp.dial_count[wan_port_no], wan_port_no);
#endif
			if ((backup_link_no = DLBK_get_backup_link_no (station_no)) != MAXIMUM_NUMBER_OF_PPP_LINKS)
			{
				backup_wan_port_no = ppp.station[station_no].link[backup_link_no].wan_port;

				if ( ppp.wan_port_status[backup_wan_port_no] == BUSY || 
					  ppp.wan_port_status[backup_wan_port_no] == OPENING_FOR_DLBK	||
					  (ppp.wan_port_status[backup_wan_port_no] == DOWN_BY_DEMAND &&
					    (other_station_no = wan_port_to_station(backup_wan_port_no))!= MAXIMUM_NUMBER_OF_PPP_STATIONS))
				{
					/* Find out the station which it is backing up */
					other_station_no = wan_port_to_station(backup_wan_port_no);

					/* Compare the priorities of that station with this one */
					if (ppp.station[other_station_no].priority < 
												ppp.station[station_no].priority)
					{
						DLBK_switch_stations (other_station_no, backup_wan_port_no, station_no, backup_link_no, backup_wan_port_no);
						DLBK_reset_dial_counter (wan_port_no);
					}
					return; 
				}
				DLBK_attach_wan_to_station_and_open (station_no, backup_link_no, ppp.station[station_no].link[backup_link_no].wan_port);
				DLBK_reset_dial_counter (wan_port_no);
			}
		}
	}
}

void DLBK_reset_dial_counter (USHORT wan_port_no)
{
	ppp.dial_count [wan_port_no] = 0;
}

void ppp_dlbkup_timer (void)
{
	/* Timer routine for PPP-Dial Backup */

	/* Note : This routine was felt necessary. But WAN driver does some amount
		of stability checking in which case this routine will become redundant. 
		So till practical testing & feedback, this routine is left empty */

	
	/* In case if any primary port has gone down, periodically check whether
 			it is consistently down before deciding to switch back to
			backup link */
		

	/* In case if primary port has gone down, and backup link is active,
		and if primary port comes up, periodically check whether it is
		consistently up before deciding to switch back to primary link
			(say for 3 seconds) */
}


/* Sachin 13/07/1997 */
int does_port_have_a_backup (USHORT port_number)
{
   USHORT station_number, link_number ;

   for (station_number = 0 ; station_number < MAXIMUM_NUMBER_OF_PPP_STATIONS ; station_number++)
   {
      if (ppp.station[station_number].enable == FALSE)
         continue ;

      if (ppp.station[station_number].link[0].wan_port != port_number)
         continue ;

      /* station_number is the station, whose primary WAN port is
         port_number */

      link_number = ppp.station[station_number].link_id_list[1] ;

      if (link_number == MAXIMUM_NUMBER_OF_PPP_LINKS)
         return (0) ; /* No backup for this port */

      if (ppp.station[station_number].link[link_number].wan_port == MAXIMUM_NUMBER_OF_PPP_PORTS)
         return (0) ;  /* No backup for this port */

      return (1) ;
   }
   return (0) ;
}
/* Sachin 13/07/1997 */

