/****************************************************************************
File			:	pppdod.c	20/12/95
					Contains routines for Dial-On-Demand 
****************************************************************************/

#include	"defs.h"

#ifdef __DOD__

#include <stdlib.h>
#include <string.h>
#include "ppp.h"
#if EVENT_LOG  /* Imran 7.4.99 */
#include	<logif.h>
#endif


/* Sachin, 3rd Oct. 1997 */
extern void ppp_port_down_by_no_demand (real_port_number) ;
/* Sachin, 3rd Oct. 1997 */


void ppp_link_idle (USHORT real_port_number)
{
   USHORT virtual_port_number, links, link_port_number;

	/* bring down the link cause there is no genuine traffic */

#ifdef __MLPPP__
   virtual_port_number = ppp.port[real_port_number].virtual_port_number;
   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP:Bringing DOWN the Bundle %04X with %04X links by DEMAND...\n", virtual_port_number, mlppp.port[virtual_port_number].NoOfLinks);

   mlppp.dod_enabled_bundle[virtual_port_number].link_down_by_demand = TRUE;
   mlppp.dod_enabled_bundle[virtual_port_number].number_of_links = mlppp.port[virtual_port_number].NoOfLinks;

   for(links = 0 ; links < mlppp.port[virtual_port_number].NoOfLinks ; ++links)
   {
      link_port_number = mlppp.port[virtual_port_number].LinkInfo[links].port->port_number;
      mlppp.dod_enabled_bundle[virtual_port_number].link_port_number[links] = link_port_number;
	   ppp.port[link_port_number].connect_state = LINK_GOING_DOWN;

#if EVENT_LOG  /* Imran 7.4.99 */
	write_log(LOG_EVENT_DOD_PORT_DOWN, (BYTE) (link_port_number + 1)); 
#endif

/* Ravi on 11-jan-2000 ... */
	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (PORT_DOWN_BY_DEMAND,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}
/* ... Ravi on 11-jan-2000 */

	   if (ppp.port[link_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[link_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
			   (ULONG) link_port_number,(ULONG) ppp.port[link_port_number].device_driver_id);
	   }
	   /* Sachin's advivse for Naveen to add this ... */
   	ppp_port_down_by_no_demand (link_port_number+ppp.number_of_lan_ports) ;
   	/* ... Sachin's advivse for Naveen to add this */
   }
#else

	ppp.port[real_port_number].connect_state = LINK_GOING_DOWN;

#if EVENT_LOG /* Imran 7.4.99 */
	write_log(LOG_EVENT_DOD_PORT_DOWN, (BYTE) (real_port_number + 1)); 
#endif

/* Ravi on 11-jan-2000 ... */
	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (PORT_DOWN_BY_DEMAND,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}
/* ... Ravi on 11-jan-2000 */

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}
   /* Sachin, 3rd Oct. 1997 */
   ppp_port_down_by_no_demand (real_port_number+ppp.number_of_lan_ports) ;
   /* Sachin, 3rd Oct. 1997 */
#endif
}


void ppp_link_active (USHORT real_port_number)
{
   USHORT virtual_port_number, links, link_port_number;

	/* bring up the link now that there is some traffic */
#ifdef __MLPPP__  
   virtual_port_number = real_port_number;
   ppp_printf(PPP_MLPPP_PRINTF, "MLPPP: Bringing UP the bundle %04X by DEMAND...\n", virtual_port_number);
   mlppp.dod_enabled_bundle[virtual_port_number].link_down_by_demand = FALSE;

   /* Now it is reqd to bring up all the members of this bundle */
   for(links = 0 ; links < mlppp.dod_enabled_bundle[virtual_port_number].number_of_links ; ++links)
   {
      link_port_number = mlppp.dod_enabled_bundle[virtual_port_number].link_port_number[links];
	   ppp.port[link_port_number].connect_state = LINK_GOING_UP;

#if EVENT_LOG /* Imran 7.4.99 */
	write_log(LOG_EVENT_DOD_PORT_UP, (BYTE) (link_port_number + 1)); 
#endif

	   if (ppp.port[link_port_number].serial_driver.fptr_control_routine != NULL)
	   {
		   (*ppp.port[link_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
			   (ULONG) link_port_number,(ULONG) ppp.port[link_port_number].device_driver_id);
	   }
   }
#else

#if EVENT_LOG /* Imran 7.4.99 */
	write_log(LOG_EVENT_DOD_PORT_UP, (BYTE) (link_port_number + 1)); 
#endif

	ppp.port[real_port_number].connect_state = LINK_GOING_UP;

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
		(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
	}
#endif
}


void	reset_ppp_idle_timer (USHORT real_port_number)
{
	ppp.port[real_port_number].idle_timer = ppp.port[real_port_number].idle_timeout;
}	

#endif /*__DOD__*/

