#include	"defs.h"
/*	$Modname: ppplcprx.c$  $version: 1.34$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added version control support.
1.2 01/20/94 keyur Added link quality monitoring and reshuffled LCP Options.
1.3 01/28/94 keyur Added support for processing all the LCP options.
1.4 02/01/94 keyur Changed LCP to handshaking according to rfc 1332.
1.5 02/02/94 keyur Commented out some code for testing and debugging.
1.6 02/02/94 keyur Added function call to reset the link completely.
1.7 02/22/94 keyur Added some code to prevent infinite looping and exhausting memory in bad pkt.
1.8 03/23/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Co
1.9 04/04/94 keyur Cosmetic Changes while documenting
1.10 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.11 04/12/94 keyur Fixed character pointer in authentication function.
1.12 04/13/94 keyur Added support for NCP state machine
1.13 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.14 05/02/94 keyur
1.15 05/02/94 keyur took out memcheck header file.
1.16 06/15/94 keyur cosmetic changes.
1.17 08/11/94 ross adding rfc1570 lcp support
1.18 08/24/94 ross adding new ncps.
1.19 09/06/94 ross fixed enum sizing bug.  Courtesy of Danny.
1.20 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.21 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.22 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.23 12/02/94 ross testing NT3.5 RAS
1.24 12/03/94 ross testing Windows 95 RAS
1.25 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.26 12/08/94 ross fixed bug in protocol reject with NULL ncp pointer.
1.27 12/13/94 ross Removed option processing.
1.28 01/25/95 ross swap id length.  Courtesy of Dan.
1.29 01/30/95 ross removing duplicate configuration options
1.30 03/03/95 ross added up calls.
1.31 03/10/95 ross general fixes.  see change.doc
1.32 03/11/95 ross echo rx and tx option lists reversed.
1.33 05/15/95 ross fixed termination logic to NOT send termination requests.
1.34 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
/* #include "..\..\store\boot.h" */
/****************************************************************************/
static void lcp_configure_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void lcp_configure_ack_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);
static void lcp_configure_nak_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void lcp_configure_reject_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void code_reject_received (USHORT real_port_number, LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void protocol_reject_received (USHORT real_port_number, PROTOCOL_REJECT_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);
static void lcp_termination_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void lcp_termination_ack_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);
static void echo_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void echo_reply_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void discard_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed);
static void identification_packet_received (USHORT real_port_number,IDENTIFICATION_PACKET *sptr_identification_packet,
	USHORT number_of_bytes_rxed);
static void time_remaining_packet_received (USHORT real_port_number,TIME_REMAINING_PACKET *sptr_time_remaining_packet,
	USHORT number_of_bytes_rxed);
void initialize_lcp_statistics_counters (USHORT real_port_number);
static void initialize_lcp_mibs (USHORT real_port_number);

/* Sachin 01/08/1996 */
extern void fill_mac_address (MAC_ADDRESS *) ;
extern enum TEST ppp_lcp_configure_nak_option_processor_for_epd (OPTION_LIST_ENTRY *sptr_remote_option,PPP_PORT_CLASS *sptr_port);
/* Sachin 01/08/1996 */
/****************************************************************************/
void initialize_lcp (USHORT real_port_number)
{
	OPTION_LIST_ENTRY *sptr_magic_number_option ;
	MAC_ADDRESS temp_mac_address ;

	initialize_lcp_statistics_counters (real_port_number);

	initialize_lcp_mibs (real_port_number);

	ppp.port[real_port_number].fptr_lcp_packet_received[CONFIGURE_REQUEST] = lcp_configure_request_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[CONFIGURE_ACK] = lcp_configure_ack_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[CONFIGURE_NAK] = lcp_configure_nak_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[CONFIGURE_REJECT] = lcp_configure_reject_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[TERMINATION_REQUEST] = lcp_termination_request_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[TERMINATION_ACK] =	lcp_termination_ack_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[CODE_REJECT] = code_reject_received;

	ppp.port[real_port_number].fptr_lcp_packet_received[PROTOCOL_REJECT] =
		(void (*) (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed))	protocol_reject_received;

	ppp.port[real_port_number].fptr_lcp_packet_received[PPP_ECHO_REQUEST] = echo_request_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[PPP_ECHO_REPLY] = echo_reply_received;
	ppp.port[real_port_number].fptr_lcp_packet_received[DISCARD_REQUEST] =	discard_request_received;

#ifdef OLD_PPP
	ppp.port[real_port_number].fptr_lcp_packet_received[LINK_QUALITY] =
		(void (*) (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed))
		link_quality_report_received;
#else
	ppp.port[real_port_number].fptr_lcp_packet_received[IDENTIFICATION] =
		(void (*) (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed))
		identification_packet_received;
#endif

	ppp.port[real_port_number].fptr_lcp_packet_received[TIME_REMAINING] =
		(void (*) (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed))
		time_remaining_packet_received;

	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_MAXIMUM_RECEIVE_UNIT] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_ASYNC_CONTROL_CHARACTER_MAP] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_AUTHENTICATION_PROTOCOL] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_MAGIC_NUMBER] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_QUALITY_PROTOCOL] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_PROTOCOL_FIELD_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_FCS_ALTERNATIVES] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_SELF_DESCRIBING_PADDING] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_CALLBACK] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_COMPOUND_FRAMES] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;


/* Added by Naveen... */
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_MAXIMUM_RECONSTRUCTED_UNIT] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_SHORT_SEQUENCE_NUMBER_HEADER] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_ENDPOINT_DISCRIMINATOR] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive.fptr_process_receive_options[LCP_LINK_DISCRIMINATOR] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
/* ...Added by Naveen */      

	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_MAXIMUM_RECEIVE_UNIT] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_ASYNC_CONTROL_CHARACTER_MAP] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_AUTHENTICATION_PROTOCOL] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_MAGIC_NUMBER] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_QUALITY_PROTOCOL] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_PROTOCOL_FIELD_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_FCS_ALTERNATIVES] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_SELF_DESCRIBING_PADDING] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_CALLBACK] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_COMPOUND_FRAMES] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;

/* Added by Naveen ... */
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_request_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_MAXIMUM_RECONSTRUCTED_UNIT] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_SHORT_SEQUENCE_NUMBER_HEADER] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_ENDPOINT_DISCRIMINATOR] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor_for_epd;
	ppp.port[real_port_number].receive_nak.fptr_process_receive_options[LCP_LINK_DISCRIMINATOR] =
		(enum TEST (*)	(OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_lcp_configure_nak_option_processor;
/* ... Added by Naveen */


/* Sachin 01/08/1996 */

	sptr_magic_number_option = find_matching_option (&ppp.port[real_port_number].option_lists.configured,
		                                              LCP_MAGIC_NUMBER) ;

	if (sptr_magic_number_option != NULL)
	{
		fill_mac_address (&temp_mac_address) ;
		sptr_magic_number_option->uptr_data->_ulong = temp_mac_address._ulong ;
	}
	else
	{
	}

/* Sachin 01/08/1996 */

	copy_configuration_options_to_tx_accepted_options (&ppp.port[real_port_number].option_lists);
}
/******************************************************************************/
void initialize_lcp_statistics_counters (USHORT real_port_number)
{
	memset (&ppp.port[real_port_number].lcp_statistics,(int) NULL,sizeof (PPP_LCP_STATISTICS));
}
/******************************************************************************/
static void initialize_lcp_mibs (USHORT real_port_number)
{
	LINK_QUALITY_OPTION	link_quality_option;

	if (copy_option (&ppp.port[real_port_number].option_lists.configured,LCP_QUALITY_PROTOCOL,
		&link_quality_option.quality_protocol,sizeof (link_quality_option.quality_protocol) +
		sizeof (link_quality_option.reporting_time)) == PASS)
		{
		ppp.port[real_port_number].lcp_mibs.pppLqrConfigPeriod = swap_long (link_quality_option.reporting_time);

		ppp.port[real_port_number].lcp_mibs.pppLqrLocalPeriod = swap_long (link_quality_option.reporting_time);

		/* Srikar, Mar 23, 1997. Changed the LQR configuration value from MIB_ENABLED to PPP_LINK_LQR_ENABLED. */
		ppp.port[real_port_number].lcp_mibs.pppLqrConfigStatus = SNMP_PPP_LINK_LQR_ENABLED;
		}
	else
		{
		/* Srikar, Mar 23, 1997. Changed the LQR configuration value from MIB_DISABLED to PPP_LINK_LQR_DISABLED. */
		ppp.port[real_port_number].lcp_mibs.pppLqrConfigStatus = SNMP_PPP_LINK_LQR_DISABLED;
		}

	/* so that he uses def: value in first pack */
	ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToPeerACCMap = 
				DEFAULT_ASYNC_CONTROL_CHARACTER_MAP;

	ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU = 
				(ULONG)DEFAULT_MAXIMUM_MRU;

}
/****************************************************************************/
enum TEST lcp_packet_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Code: %02x, ID: %02x, Length %04x\r\n",sptr_lcp_rx_packet->lcp_header.code,
		sptr_lcp_rx_packet->lcp_header.id,swap (sptr_lcp_rx_packet->lcp_header.length));

	if ((sptr_lcp_rx_packet->lcp_header.code > NUMBER_OF_PPP_CONTROL_CODES) ||
		(sptr_lcp_rx_packet->lcp_header.code == (BYTE_ENUM (PPP_CONTROL_CODE)) 0x00))
		{
		ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Illegal LCP Received on port: %04x\r\n",real_port_number);

		execute_ppp_state_machine (PPP_RECEIVE_UNKNOWN_CODE_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

		++ppp.port[real_port_number].link_quality_counters.ifInErrors;

		ppp.port[real_port_number].link_quality_counters.InGoodOctets -= number_of_bytes_rxed;

		return (PASS);
		}

	(*ppp.port[real_port_number].fptr_lcp_packet_received[sptr_lcp_rx_packet->lcp_header.code])
		(real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	++ppp.port[real_port_number].lcp_statistics.number_of_rx_packets;
	++ppp.port[real_port_number].lcp_statistics.number_of_control_rx_packets[sptr_lcp_rx_packet->lcp_header.code];

	ppp.port[real_port_number].lcp_statistics.number_of_rx_bytes += number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
static void lcp_configure_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	USHORT number_of_bytes_without_options;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Configure Request Received on port: %04x\r\n",real_port_number);

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);

	ppp.port[real_port_number].length_of_last_rxed_lcp_configuration_packet = number_of_bytes_rxed;

	memcpy (&ppp.port[real_port_number].last_rxed_lcp_configuration_request_packet,sptr_lcp_rx_packet,number_of_bytes_rxed);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		if (process_configuration_options (real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed,
			number_of_bytes_without_options)	== FAIL)
				{
				ppp_printf (PPP_ALARM_PRINTF,"PPP LCP:ERROR in receiving LCP Options on port: %04x\r\n",real_port_number);

				return;
				}
		}

	execute_ppp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_GOOD_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static void lcp_configure_ack_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Configure ACK Received on port: %04x\r\n",real_port_number);

	if (number_of_bytes_rxed != ppp.port[real_port_number].length_of_last_txed_lcp_packet)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP LCP:Configuration ACK received with wrong length of packet on port: %04x\r\n",
			real_port_number);

		return;
		}

	sptr_lcp_rx_packet->lcp_header.code = CONFIGURE_REQUEST;
	
	if (memcmp (sptr_lcp_rx_packet,&ppp.port[real_port_number].last_txed_lcp_configuration_request_packet,
		ppp.port[real_port_number].length_of_last_txed_lcp_packet) != 0x00)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP LCP:Configuration ACK received with wrong order of options on port: %04x\r\n",
			real_port_number);

		return;
		}

	execute_ppp_state_machine (PPP_RECEIVE_CONFIGURE_ACK_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static void lcp_configure_nak_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	USHORT number_of_bytes_without_options;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Configure NAK Received on port: %04x\r\n",real_port_number);

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		if (process_configuration_nak_options (real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed,
			number_of_bytes_without_options) == FAIL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP LCP:Configuration NAK received with wrong order of options on port: %04x\r\n",
				real_port_number);

			return;
			}
		}

	execute_ppp_state_machine (PPP_RECEIVE_CONFIGURE_NAK_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	ppp.port[real_port_number].number_of_configuration_requests = 0x0000;
}
/****************************************************************************/
static void lcp_configure_reject_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	USHORT length_of_options_to_be_processed;
	USHORT number_of_bytes_without_options;
	enum   OPTION_PARSE_RESULT  parse_result;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Configure Reject Received on port: %04x\r\n",real_port_number);

	if (sptr_lcp_rx_packet->lcp_header.id == ppp.port[real_port_number].last_id_of_lcp_packet_sent)
		{
/*	Sowmya 26/4/96
		if (ppp.port[real_port_number].configuration.enabled.send_id == TRUE)
			{
			send_lcp_id_packet (real_port_number);
			}
Sowmya 26/4/96 */

		number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (LCP_HEADER);

		length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_without_options);

		if (length_of_options_to_be_processed > 0x0000)
			{
			parse_result = parse_ppp_lcp_options_from_reject_configure (real_port_number,&ppp.port[real_port_number].option_lists,
				(PPP_OPTION *) &sptr_lcp_rx_packet->options,length_of_options_to_be_processed);
			}

		if(parse_result == OPTION_PARSING_FATAL){

				ppp.port[real_port_number].state = PPP_OPENED_STATE;
				execute_ppp_state_machine (PPP_CLOSE_EVENT,real_port_number,NULL,(USHORT) NULL);
				ppp.port[real_port_number].authentication.current_number_of_retries = 0;
			ppp.port[real_port_number].authentication.status = UNSUCCESSFUL;

			ppp.port[real_port_number].authentication.rxed_authentication_ack = FALSE;
			ppp.port[real_port_number].authentication.txed_authentication_ack = FALSE;

			return;
		}
		execute_ppp_state_machine (PPP_RECEIVE_CONFIGURE_REJECT_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

		ppp.port[real_port_number].number_of_configuration_requests = 0x0000;
		}
}
/****************************************************************************/
static void lcp_termination_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Terminate REQUEST Received on port: %04x\r\n",real_port_number);

	execute_ppp_state_machine (PPP_RECEIVE_TERMINATE_REQUEST_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	/* wait 1 cycle for other side to terminate the link before trying to reset so we can come back up. rfc 1661 sect. 3.7*/

	ppp.port[real_port_number].number_of_lcp_termination_requests = (USHORT) ppp.maximum_number_of_termination_requests;

	ppp.port[real_port_number].termination_request_send_interval = 0x00000000L;
}
/****************************************************************************/
static void lcp_termination_ack_received (USHORT real_port_number, LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Terminate ACK Received on port: %04x\r\n",real_port_number);
	/* printf ("PPP : Terminate ACK received on port %d\n", real_port_number) ; */

	execute_ppp_state_machine (PPP_RECEIVE_TERMINATE_ACK_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);
	ppp.port[real_port_number].state = PPP_INITIAL_STATE;
	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
				(ULONG) real_port_number,
				(ULONG) &ppp.port[real_port_number].device_driver_id) ;
	}
	execute_ppp_state_machine (PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT,real_port_number,NULL,(USHORT) NULL);
	/* printf ("lcp_termination_ack_received(), PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT\n") ; */
	ppp.port[real_port_number].number_of_configuration_requests = 0x00000000L;

}
/****************************************************************************/
static void code_reject_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Code Reject Received on port: %04x\r\n",real_port_number);

	execute_ppp_state_machine (PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);
}
/******************************************************************************/
static void protocol_reject_received (USHORT real_port_number, PROTOCOL_REJECT_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Protocol Reject Received on port: %04x\r\n",real_port_number);

	execute_ppp_state_machine (PPP_RECEIVE_PROTOCOL_REJECT_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

#ifndef __MLPPP__
	sptr_ncp = find_ppp_ncp_using_protocol_type (real_port_number,sptr_lcp_rx_packet->rejected_protocol_and_information.protocol);
#else
	sptr_ncp = find_ppp_ncp_using_protocol_type (ppp.port[real_port_number].virtual_port_number,
				sptr_lcp_rx_packet->rejected_protocol_and_information.protocol);
#endif /* __MLPPP__ */

	if (sptr_ncp != NULL)
		{
		++sptr_ncp->number_of_protocol_rejects_rxed;

		if (sptr_ncp->fptr_protocol_reject_alarm != NULL)
			{
#ifndef __MLPPP__
			(*sptr_ncp->fptr_protocol_reject_alarm) (real_port_number,sptr_ncp);
#else
			(*sptr_ncp->fptr_protocol_reject_alarm) (ppp.port[real_port_number].virtual_port_number,sptr_ncp);
#endif /* __MLPPP__ */
			}

#ifndef __MLPPP__
		execute_ncp_state_machine (PPP_CLOSE_EVENT,sptr_ncp,real_port_number,NULL,0x0000);
#else
		execute_ncp_state_machine (PPP_CLOSE_EVENT,sptr_ncp,ppp.port[real_port_number].virtual_port_number,NULL,0x0000);
#endif
		}
}
/****************************************************************************/
static void echo_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ULONG magic_number;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Echo Request Received on port: %04x\r\n",real_port_number);

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_MAGIC_NUMBER,
		&magic_number,sizeof (magic_number)) == FAIL)
		{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != DEFAULT_MAGIC_NUMBER)
			{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Echo Request Received on port: %04x\r\n",real_port_number);

			return;
			}
		}
	else
		{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != magic_number)
			{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Echo Request Received on port: %04x\r\n",real_port_number);

			return;
			}
		}

	execute_ppp_state_machine (PPP_RECEIVE_ECHO_REQUEST_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	ppp.port[real_port_number].number_of_echo_requests = 0x0000;
}
/******************************************************************************/
static void echo_reply_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ULONG magic_number;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Echo Reply Received on port: %04x\r\n",real_port_number);

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_MAGIC_NUMBER,
		&magic_number,sizeof (magic_number)) == FAIL)
	{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != DEFAULT_MAGIC_NUMBER)
		{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Echo Reply Received on port: %04x\r\n",real_port_number);

			return;
		}
	}
	else
	{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != magic_number)
		{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Echo Reply Received on port: %04x\r\n",real_port_number);

			return;
		}
	}
	ppp_printf (PPP_LCP_PRINTF, "PPP LCP : Valid Echo Reply Received on port: %04x\r\n", real_port_number) ;

	execute_ppp_state_machine (PPP_RECEIVE_ECHO_REPLY_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	ppp.port[real_port_number].number_of_echo_requests = 0x0000;
}
/******************************************************************************/
static void discard_request_received (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,USHORT number_of_bytes_rxed)
{
	ULONG magic_number;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Discard Request Received on port: %04x\r\n",real_port_number);

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_MAGIC_NUMBER,
		&magic_number,sizeof (magic_number)) == FAIL)
		{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != DEFAULT_MAGIC_NUMBER)
			{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Discard Request Received on port: %04x\r\n",real_port_number);

			return;
			}
		}
	else
		{
		if (((ECHO_REQUEST_PACKET *) sptr_lcp_rx_packet)->magic_number != magic_number)
			{
			ppp_printf (PPP_LCP_PRINTF,"PPP LCP:Bad Discard Request Received on port: %04x\r\n",real_port_number);

			return;
			}
		}

	execute_ppp_state_machine (PPP_RECEIVE_DISCARD_REQUEST_EVENT,real_port_number,sptr_lcp_rx_packet,number_of_bytes_rxed);

	++ppp.port[real_port_number].link_quality_counters.ifInDiscards;

	ppp.port[real_port_number].link_quality_counters.InGoodOctets -= number_of_bytes_rxed;
}
/******************************************************************************/
void link_quality_report_received (USHORT real_port_number,LINK_QUALITY_REPORT *sptr_link_quality_report,
	USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:LINK_QUALITY_PROTOCOL Packet Received: %04x\r\n",real_port_number);

	PARAMETER_NOT_USED (number_of_bytes_rxed);

	++ppp.port[real_port_number].lcp_mibs.pppLqrInLQRs;
	++ppp.port[real_port_number].link_quality_counters.InLQRs;

	ppp.port[real_port_number].most_recently_received_LQR = *sptr_link_quality_report;
	ppp.port[real_port_number].most_recently_received_LQR.SaveInLQRs = ppp.port[real_port_number].link_quality_counters.InLQRs;
	ppp.port[real_port_number].most_recently_received_LQR.SaveInPackets = 
		ppp.port[real_port_number].link_quality_counters.ifInUniPackets;
	ppp.port[real_port_number].most_recently_received_LQR.SaveInDiscards = 
		ppp.port[real_port_number].link_quality_counters.ifInDiscards;
	ppp.port[real_port_number].most_recently_received_LQR.SaveInErrors = 
		ppp.port[real_port_number].link_quality_counters.ifInErrors;
	ppp.port[real_port_number].most_recently_received_LQR.SaveInOctets = 
		ppp.port[real_port_number].link_quality_counters.InGoodOctets;

	ppp.port[real_port_number].lcp_mibs.pppLqrExtnsLastReceivedLqrPacket = *sptr_link_quality_report;
}
/******************************************************************************/
static void identification_packet_received (USHORT real_port_number,IDENTIFICATION_PACKET *sptr_identification_packet,
	USHORT number_of_bytes_rxed)
{
	USHORT number_of_bytes_in_message;

	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:ID Packet Received: %04x\r\n",real_port_number);

	number_of_bytes_in_message =
		(USHORT) (swap (sptr_identification_packet->length) -
		sizeof (sptr_identification_packet->magic_number) - sizeof (LCP_HEADER));

	if (number_of_bytes_in_message <= sizeof (ppp.port[real_port_number].configuration.rx_identification_message))
		{
		number_of_bytes_in_message = sizeof (ppp.port[real_port_number].configuration.rx_identification_message);
		}

	memcpy (ppp.port[real_port_number].configuration.rx_identification_message,sptr_identification_packet,
		number_of_bytes_in_message);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_ID_REQUEST_RECEIVED,real_port_number,&sptr_identification_packet->message[0]);
		}

	execute_ppp_state_machine (PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT,real_port_number,sptr_identification_packet,
		number_of_bytes_rxed);

	/* Send an identification packet in response for the one received */

/*	Sowmya 26/4/96
	if (ppp.port[real_port_number].configuration.enabled.send_id == TRUE)
Sowmya 26/4/96 */

		{
		send_lcp_id_packet (real_port_number);
		}

}
/******************************************************************************/
static void time_remaining_packet_received (USHORT real_port_number,TIME_REMAINING_PACKET *sptr_time_remaining_packet,
	USHORT number_of_bytes_rxed)
{
	ppp_printf (PPP_LCP_PRINTF,"PPP LCP:ID Packet Received: %04x\r\n",real_port_number);

	ppp.port[real_port_number].client_time_remaining = sptr_time_remaining_packet->seconds_remaining;

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_TIME_REMAINING_RECEIVED,real_port_number,
			&sptr_time_remaining_packet->seconds_remaining);
		}

	execute_ppp_state_machine (PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT,real_port_number,sptr_time_remaining_packet,
		number_of_bytes_rxed);
}

void initialize_lcp_tx_accepted_option_list(USHORT real_port_number)
{
	copy_configuration_options_to_tx_accepted_options (&ppp.port[real_port_number].option_lists);
}

