#include	"defs.h"
/*	$Modname: ppplrxop.c$  $version: 1.17$      $date: 12/13/94$   */
/*
* 	$lgb$
1.0 04/19/94 keyur
1.1 04/19/94 keyur Added support for version control.
1.2 04/19/94 keyur More cosmetic Changes
1.3 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.4 05/02/94 keyur took out memcheck header file.
1.5 06/15/94 keyur cosmetic changes.
1.6 06/23/94 ross process all bad configuration options.  Courtesy of John.
1.7 06/23/94 ross Put in more printfs.
1.8 07/18/94 ross general cleanup with options, added header compression, accm features.
1.9 08/11/94 ross adding rfc1570 lcp support
1.10 08/24/94 ross adding new ncps.
1.11 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.12 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.13 12/02/94 ross testing NT3.5 RAS
1.14 12/03/94 ross testing Windows 95	RAS
1.15 12/13/94 ross connected to NT RAS with Netbios
1.17 12/13/94 ross removed options processing.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ppp.h"
/****************************************************************************/
enum TEST process_configuration_options (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed)
{
	PPP_PORT_CLASS *sptr_port;
	enum OPTION_PARSE_RESULT parse_result;
	USHORT length_of_options_to_be_processed;

	sptr_port = &ppp.port[real_port_number];

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_result = parse_ppp_options_from_configure_request (&sptr_port->option_lists,
		(PPP_OPTION *) &sptr_lcp_rx_packet->options,length_of_options_to_be_processed,&sptr_port->receive,sptr_port);

	if (parse_result == SOME_OPTIONS_ARE_REJECTED)
		{
		execute_ppp_state_machine (PPP_RECEIVE_CONFIG_REQUEST_BAD_OPTION_EVENT,real_port_number,sptr_lcp_rx_packet,
			number_of_bytes_rxed);

		return (FAIL);
		}
	else if (parse_result == SOME_OPTIONS_ARE_NACKED)
		{
		execute_ppp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_BAD_EVENT,real_port_number,sptr_lcp_rx_packet,
			number_of_bytes_rxed);

		return (FAIL);
		}
	else
		{
		return (PASS);
		}
}
/****************************************************************************/
enum TEST process_configuration_nak_options (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed)
{
	PPP_PORT_CLASS *sptr_port;
	USHORT length_of_options_to_be_processed;

	sptr_port = &ppp.port[real_port_number];

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_ppp_options_from_nak_configure (&sptr_port->option_lists,
		(PPP_OPTION *) &sptr_lcp_rx_packet->options,length_of_options_to_be_processed,&sptr_port->receive_nak,sptr_port);

	return (PASS);
}

