#include	"defs.h"
/*	$Modname: pppncpst.c$  $version: 1.10$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.1 05/02/94 keyur took out memcheck header file.
1.2 06/15/94 keyur cosmetic changes.
1.3 07/18/94 ross general cleanup with options, added header compression, accm features.
1.4 08/11/94 ross adding rfc1570 lcp support
1.5 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.6 12/03/94 ross testing Windows 95	RAS
1.7 12/13/94 ross connected to NT RAS with Netbios
1.8 01/26/95 ross changes for rwutils
1.9 02/27/95 ross dynamic load changes including lsl_control.
1.10 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993-1994 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ppp.h"
#include "vncpstat.h"
#if EVENT_LOG /* Imran 7.4.99 */
#include <logif.h>
#endif

/****************************************************************************/
void execute_ncp_state_machine (enum PPP_EVENT ppp_event,PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,
	void *vptr_packet,USHORT number_of_bytes)
{
	enum PPP_STATE original_state;

	original_state = sptr_ncp->state;

	if (ncp_state_machine_table[original_state][ppp_event].end_state == ILLEGAL_PPP_STATE)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP NCP:Error in state machine %04x, Event %04x \r\n",real_port_number,(USHORT) ppp_event);

		return;
		}

	if (ncp_state_machine_table[original_state][ppp_event].fptr_state_function != NULL)
		{
		(*ncp_state_machine_table[original_state][ppp_event].fptr_state_function) (sptr_ncp,real_port_number,vptr_packet,
			number_of_bytes,ncp_state_machine_table[original_state][ppp_event].end_state);

		if ((ncp_state_machine_table[original_state][ppp_event].end_state != NO_CHANGE_TO_PPP_STATE) &&
			(ncp_state_machine_table[original_state][ppp_event].fptr_state_function != set_ncp_state))
			{
			set_ncp_state (sptr_ncp,real_port_number,NULL,0x0000,
				ncp_state_machine_table[original_state][ppp_event].end_state);
			}
		}

	if (ncp_state_machine_table[original_state][ppp_event].fptr_state_function_1 != NULL)
		{
		(*ncp_state_machine_table[original_state][ppp_event].fptr_state_function_1) (sptr_ncp,real_port_number,vptr_packet,
			number_of_bytes,ncp_state_machine_table[original_state][ppp_event].end_state_1);

		if ((ncp_state_machine_table[original_state][ppp_event].end_state_1 != NO_CHANGE_TO_PPP_STATE) &&
			(ncp_state_machine_table[original_state][ppp_event].fptr_state_function_1 != set_ncp_state))
			{
			set_ncp_state (sptr_ncp,real_port_number,NULL,0x0000,
				ncp_state_machine_table[original_state][ppp_event].end_state_1);
			}
		}

	if (ncp_state_machine_table[original_state][ppp_event].fptr_state_function_2 != NULL)
		{
		(*ncp_state_machine_table[original_state][ppp_event].fptr_state_function_2) (sptr_ncp,real_port_number,vptr_packet,
			number_of_bytes,ncp_state_machine_table[original_state][ppp_event].end_state_2);

		if ((ncp_state_machine_table[original_state][ppp_event].end_state_2 != NO_CHANGE_TO_PPP_STATE) &&
			(ncp_state_machine_table[original_state][ppp_event].fptr_state_function_2 != set_ncp_state))
			{
			set_ncp_state (sptr_ncp,real_port_number,NULL,0x0000,
				ncp_state_machine_table[original_state][ppp_event].end_state_2);
			}
		}

	sptr_ncp->old_state = (BYTE_ENUM (PPP_STATE)) original_state;
}
/****************************************************************************/
void set_ncp_state (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	if (end_state == ILLEGAL_PPP_STATE)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP NCP:Error in state machine %04x, end state %04x\r\n",real_port_number,
			(USHORT) end_state);

		return;
		}

	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Port %04x - New State %04x\r\n",real_port_number,(USHORT) end_state);

	sptr_ncp->state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void ncp_this_layer_start (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	sptr_ncp->state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void ncp_this_layer_finished (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_ncp);

#if EVENT_LOG /* Imran 7.4.99 */
	write_log(LOG_EVENT_WAN_PROTOCOLS_UP , (BYTE) (real_port_number + 1)); 
#endif

	/* printf ("ncp_this_layer_finished() for port %d\n", real_port_number) ; */

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_NCP_THIS_LAYER_FINISHED,real_port_number,sptr_ncp);
		}

	/* put async up call to let admin know we have a problem , if there is one */
}
/****************************************************************************/
void ncp_this_layer_up (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	/* Srikar, Mar 23, 1997. Added the following local variable. */
	OPTION_LIST_ENTRY *sptr_option_entry;

	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_NCP_THIS_LAYER_UP,real_port_number,sptr_ncp);

		/* Srikar, Mar 23, 1997. Added the following code for SNMP support. */
		if (sptr_ncp->type == IP_PROTOCOL)
			{
#ifdef __MLPPP__
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus = SNMP_PPP_IP_LINK_OPENED;
#else
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus = SNMP_PPP_IP_LINK_OPENED;
#endif

				/* If the compression module is not loaded no compression is possible. If the compression is enabled */
				/* on the client it is available in the rx_accepted option list. If it is loaded but administratively */
				/* disabled on the server it is in the tx_accepted option list with the admin_status not set to enabled. */
				/* The cache size of the compression module is the third byte in the option data. */

#ifdef __MLPPP__
				if (mlppp.port[real_port_number].vjc.fptr_get_maximum_connection_states)
#else
				if (ppp.port[real_port_number].vjc.fptr_get_maximum_connection_states)
#endif
					{
#ifdef __MLPPP__
					sptr_option_entry = find_matching_option(&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.rx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#else
					sptr_option_entry = find_matching_option(&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.rx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#endif
					if (sptr_option_entry != NULL)
						{
#ifdef __MLPPP__
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_VJ_TCP;
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId =
							sptr_option_entry->uptr_data->byte_array[2];
#else
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_VJ_TCP;
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId =
							sptr_option_entry->uptr_data->byte_array[2];
#endif
						}
					else
						{
#ifdef __MLPPP__
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
#else
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
#endif
						}

#ifdef __MLPPP__
					sptr_option_entry = find_matching_option(&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#else
					sptr_option_entry = find_matching_option(&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#endif
					if (sptr_option_entry != NULL && sptr_option_entry->admin_status == SNMP_PPP_OPTION_ADMIN_ENABLED)
						{
#ifdef __MLPPP__
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_VJ_TCP;
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId =
							sptr_option_entry->uptr_data->byte_array[2];
#else
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_VJ_TCP;
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId =
							sptr_option_entry->uptr_data->byte_array[2];
#endif
						}
					else
						{
#ifdef __MLPPP__
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
						mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#else
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
						ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#endif
						}
					}
				else
					{
#ifdef __MLPPP__
					mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
					mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
					mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
					mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#else
					ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
					ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
					ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
					ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#endif
					}
			}
		}

	signal_up_event_to_ncp (sptr_ncp,real_port_number);
}
/****************************************************************************/
void ncp_this_layer_down (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_NCP_THIS_LAYER_DOWN,real_port_number,sptr_ncp);

		/* Srikar, Mar 23, 1997. Added the following code for SNMP support. */
		if (sptr_ncp->type == IP_PROTOCOL)
			{
#ifdef __MLPPP__
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus = SNMP_PPP_IP_LINK_NOT_OPENED;
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
				mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#else
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus = SNMP_PPP_IP_LINK_NOT_OPENED;
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalToRemoteCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteToLocalCompressionProtocol = SNMP_PPP_IP_COMPRESSION_NONE;
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpRemoteMaxSlotId = 0;
				ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpLocalMaxSlotId = 0;
#endif
			}
		}

	signal_down_event_to_ncp (sptr_ncp,real_port_number);

	sptr_ncp->number_of_configuration_requests = 0x0000;
	sptr_ncp->number_of_termination_requests = 0x0000;
	
	sptr_ncp->configuration_request_send_interval = 0x0000;
	sptr_ncp->termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void ncp_initialize_restart_counter (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,
	USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	sptr_ncp->number_of_configuration_requests = 0x0000;
	sptr_ncp->number_of_termination_requests = 0x0000;
	
	sptr_ncp->configuration_request_send_interval = 0x0000;
	sptr_ncp->termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void ncp_zero_restart_counter (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	sptr_ncp->number_of_configuration_requests = 0x0000;
	sptr_ncp->number_of_termination_requests = 0x0000;
	
	sptr_ncp->configuration_request_send_interval = 0x0000;
	sptr_ncp->termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void ncp_null_state (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_ncp);
}


