#ifndef _PPPUDB_H_

#define _PPPUDB_H_

#define UDB_MAX_USERS              1024
#define UDB_USER_NAME_LENGTH       40
#define UDB_PASSWORD_LENGTH         8
#define UDB_CALLBACK_NUMBER_LENGTH 40

#define UDB_HEADER_ADDRESS     FL_UDB_HDR
#define UDB_ADDRESS            0xC0000


typedef struct
{
	BYTE user_name[UDB_USER_NAME_LENGTH] ;
	BYTE password[UDB_PASSWORD_LENGTH] ;	
	ULONG dial_in_port_mask ;
	ULONG dial_out_port_mask ;
	BYTE protocol_mask ;
	BYTE call_back_security ;
	BYTE call_back_number[UDB_CALLBACK_NUMBER_LENGTH] ;
	USHORT call_back_delay ;
	BYTE call_back_enabled ;
	BYTE reserved[9] ;
} RAS_USER_DATABASE_RECORD ;


extern enum TEST initialize_user_database () ;
extern enum TEST check_if_udb_updated () ;
extern RAS_USER_DATABASE_RECORD *get_ptr_to_udb_record (char *user_name) ;
extern enum BOOLEAN do_passwords_match (RAS_USER_DATABASE_RECORD *udb_record, char *password) ;
extern enum BOOLEAN is_dial_in_permitted_for_port (RAS_USER_DATABASE_RECORD *udb_record, char port_number) ;
extern enum BOOLEAN is_dial_out_permitted_for_port (RAS_USER_DATABASE_RECORD *udb_record, char port_number) ;
extern enum BOOLEAN is_ipx_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;
extern enum BOOLEAN is_ip_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;
extern enum BOOLEAN is_stp_permitted (RAS_USER_DATABASE_RECORD *udb_record) ;
extern int get_ras_number_of_users () ;


#endif
