#include	"defs.h"
/*	$Modname: pppsnmp.c$  $version: 1.17$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added support for version control.
1.2 03/23/94 keyur Tried to fix a codestyle problem of postincrement.
1.3 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.4 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.5 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.6 04/19/94 keyur Cosmetic Changes
1.7 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.8 05/02/94 keyur took out memcheck header file.
1.9 06/15/94 keyur cosmetic changes. snmp access routines fixed.
1.10 06/15/94 keyur got rid of warning messages.
1.11 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.12 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.13 12/13/94 ross connected to NT RAS with Netbios
1.14 01/26/95 ross changes for rwutils
1.15 01/30/95 ross removing duplicate configuration options
1.16 06/22/95 ross new visnpstr.h which also modifies vpppsnmp.h.
1.17 10/19/95 biao fixed bugs. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	<stddef.h>
#include "ppp.h"
#include	<visnpstr.h>
#include "vpppsnmp.h"
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type of the parameter bptr_table_indices from BYTE * to OBJECT_ID * */
/* and its name from bptr_table_indices to sptr_table_indices */
enum TEST get_ppp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_size_of_table_indices,sptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&ppp_snmp_table[0x00]);

	return (return_code);
}
/****************************************************************************/
void display_packet (BYTE *bptr_packet, USHORT packet_length)
{
	USHORT packet_byte_index;

	for (packet_byte_index = 0x0000; packet_byte_index < packet_length; ++packet_byte_index)
		{
		ppp_printf (PPP_DATA_PRINTF,"PPP:%02x ",*bptr_packet++);
		}

	ppp_printf (PPP_DATA_PRINTF,"PPP:\r\n");
}
/**********************************************************************************/
void copy_option_list_values_to_snmp_values ()
{

}
/**********************************************************************************/
void copy_snmp_values_to_option_list_values ()
{

}

/**********************************************************************************/

/* Srikar, Mar 23, 1997. The following function added for validating the set operation. */

enum TEST snmp_get_or_set_pppLinkConfigInitialMRU (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	mru_to_configure;

	if (mib_operation == SET_OPERATION)
		{
		mru_to_configure = * (ULONG *) vptr_mib_value_obtained;
		if (mru_to_configure < SNMP_PPP_LINK_MRU_MINIMUM || mru_to_configure > SNMP_PPP_LINK_MRU_MAXIMUM)
			{
			return (FAIL);
			}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 23, 1997. The following function added for validating the set operation as */
/* well as to translate the internal representation to the values understood by the manager. */

enum TEST snmp_get_or_set_pppLinkConfigMagicNumber (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	/* NOTE : Right now the magic number is not used, and so we fail the operation of a SNMP manager attempts to enable it. */
	if (mib_operation == SET_OPERATION)
		{
		switch ( * (ULONG *) vptr_mib_value_obtained)
			{
			case 1 :		/* To disable. */
/*			case 2 :		// To enable. */
				( * (ULONG *) vptr_mib_value_obtained)--;	/* Adjust the value to 0 (disable) or 1 (enable). */
				break;
			default :
				return (FAIL);
			}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 23, 1997. The following function added for validating the set operation. */

enum TEST snmp_get_or_set_pppLinkConfigFcsSize (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	fcs_size_to_configure;

	/* NOTE : Right now we do not support 32 bit FCS. Hence we fail the operation if a SNMP manager attempts to set the value to 32. */
	if (mib_operation == SET_OPERATION)
		{
		fcs_size_to_configure = * (ULONG *) vptr_mib_value_obtained;
		switch (fcs_size_to_configure)
			{
			case SNMP_PPP_LINK_16_BIT_CRC :
/*			case SNMP_PPP_LINK_32_BIT_CRC : */
				break;
			default :
				return (FAIL);
			}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 23, 1997. The following function added for getting the LqrExtensionPacket. */

enum TEST snmp_get_or_set_pppLqrExtnsLastReceivedLqrPacket (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	vptr_class_variable = (char *) (_class + offset + (size * port_number));
	if  ((mib_operation == GET_OPERATION) || (mib_operation == GET_NEXT_OPERATION))
		{
		memcpy (vptr_mib_value_obtained, vptr_class_variable, sizeof(LINK_QUALITY_REPORT));
		}
	else
		{
		memcpy (vptr_class_variable, vptr_mib_value_obtained, sizeof(LINK_QUALITY_REPORT));
		}
	*usptr_length_of_mib_obtained = sizeof(LINK_QUALITY_REPORT);
	return (PASS);
}

/* CHANGED_SN, Jan 13, 1997. The following function added for validating the LqrConfigStatus. */

enum TEST snmp_get_or_set_pppLqrConfigStatus (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	/* NOTE : Right now we do not implement link quality reporting. Hence we fail the operation if a SNMP manager attempts to enable it. */
	if (mib_operation == SET_OPERATION)
		{
		switch ( * (ULONG *) vptr_mib_value_obtained)
			{
			case SNMP_PPP_LINK_LQR_DISABLED :		/* To disable. */
/*			case SNMP_PPP_LINK_LQR_ENABLED :		// To enable. */
				break;
			default :
				return (FAIL);
			}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 23, 1997. The following function added for validating the IpConfigAdminStatus. The RFC1473 says that */
/* changing the admin status to force IMMEDIATE action on the link. But we will be taking the change into account */
/* only after the current session is closed, if any, for disabling the link for IP. We do not support enabling the */
/* link as expected by RFC1473. */
/* Port number field was not correctly passed. */
/* However the offset is passed correctly. So got the port number from this */
enum TEST snmp_get_or_set_pppIpConfigAdminStatus (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	OPTION_LIST_ENTRY *sptr_option_entry;
	BYTE	admin_status;
#ifdef __MLPPP__
	MLPPP_PORT_CLASS	*sptr_port_class;
#else
	PPP_PORT_CLASS	*sptr_port_class;
#endif

	if (mib_operation == SET_OPERATION)
		{
		/* We cannot enable/disable the port unless it is enabled in the global configuration. */
#ifdef __MLPPP__
		sptr_port_class = (MLPPP_PORT_CLASS *) _class;
#else
		sptr_port_class = (PPP_PORT_CLASS *) _class;
#endif
		if (sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].enabled)
			{
			sptr_option_entry = find_matching_option(&sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured, (BYTE) IP_ADDRESS_OPTION_TYPE);
			if (sptr_option_entry == NULL)
				{
				return (FAIL);
				}
			}
		else
			{
			return (FAIL);
			}

		switch ( * (ULONG *) vptr_mib_value_obtained)
			{
			case SNMP_PPP_IP_LINK_NOT_OPENED :		/* To disable. */
				admin_status = SNMP_PPP_OPTION_ADMIN_DISABLED;
				break;
			case SNMP_PPP_IP_LINK_OPENED :			/* To enable. */
				admin_status = SNMP_PPP_OPTION_ADMIN_ENABLED;
				break;
			default :
				return (FAIL);
			}
			/* If the link is not opened for IP protocol we will update the tx_accepted list also since that is */
			/* used for negotiation at the start of connection. If there is a connection already opened we should */
			/* not modify the tx_accepted list now and it will be updated as soon as the current connection is */
			/* brought down. */

			sptr_option_entry->admin_status = admin_status;
			sptr_option_entry = find_matching_option(&sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].option_lists.remote_configured, (BYTE) IP_ADDRESS_OPTION_TYPE);
			if (sptr_option_entry != NULL)
				{
				sptr_option_entry->admin_status = admin_status;
				}
			if (sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus == SNMP_PPP_IP_LINK_NOT_OPENED)
				{
				sptr_option_entry = find_matching_option(&sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_ADDRESS_OPTION_TYPE);
				if (sptr_option_entry != NULL)
					{
					sptr_option_entry->admin_status = admin_status;
					}
				}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 23, 1997. The following function added for validating the IpConfigCompression. Changing the compression */
/* is not allowed right now. THIS NEEDS TO BE IMPLEMENTED. */
/* Port number field was not correctly passed. */
/* However the offset is passed correctly. So got the port number from this */

enum TEST snmp_get_or_set_pppIpConfigCompression (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	OPTION_LIST_ENTRY *sptr_option_entry;
	BYTE	admin_status;

#ifdef __MLPPP__
	MLPPP_PORT_CLASS	*sptr_port_class;
#else
	PPP_PORT_CLASS	*sptr_port_class;
#endif

	if (mib_operation == SET_OPERATION)
		{
		/* We cannot enable/disable VJ compression unless the VJ compression on the port is enabled in the global configuration. */

#ifdef __MLPPP__
		sptr_port_class = (MLPPP_PORT_CLASS *) _class;
#else
		sptr_port_class = (PPP_PORT_CLASS *) _class;
#endif
		if (sptr_port_class->vjc.fptr_get_maximum_connection_states)
			{
			sptr_option_entry = find_matching_option(&sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].option_lists.configured, (BYTE) IP_COMPRESSION_OPTION_TYPE);
			if (sptr_option_entry == NULL)
				{
				return (FAIL);
				}
			}
		else
			{
			return (FAIL);
			}
		switch ( * (ULONG *) vptr_mib_value_obtained)
			{
			case SNMP_PPP_IP_COMPRESSION_NONE :		/* No compression. */
				admin_status = SNMP_PPP_OPTION_ADMIN_ORIGINATE_NEGOTIATION_OFF;
				break;
			case SNMP_PPP_IP_COMPRESSION_VJ_TCP :	/* VJ compression. */
				admin_status = SNMP_PPP_OPTION_ADMIN_ENABLED;
				break;
			default :
				return (FAIL);
			}
			/* If the link is not opened for IP protocol we will update the tx_accepted list also since that is */
			/* used for negotiation at the start of connection. If there is a connection already opened we should */
			/* not modify the tx_accepted list now and it will be updated as soon as the current connection is */
			/* brought down. */

			sptr_option_entry->admin_status = admin_status;
			if (sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].mib.ipcp.pppIpOperStatus == SNMP_PPP_IP_LINK_NOT_OPENED)
				{
				sptr_option_entry = find_matching_option(&sptr_port_class->ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
				if (sptr_option_entry != NULL)
					{
					sptr_option_entry->admin_status = admin_status;
					}
				}
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

