#include	"defs.h"
/*	$Modname: pppstate.c$  $version: 1.21$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 04/12/94 keyur Initial Release.
1.1 04/12/94 keyur Added support for version control.
1.2 04/12/94 keyur Got rid of the warning for not used variables.
1.3 04/13/94 keyur Added support for NCP state machine
1.4 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.5 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.6 05/02/94 keyur took out memcheck header file.
1.7 06/15/94 keyur cosmetic changes.
1.8 08/11/94 ross adding rfc1570 lcp support
1.9 08/24/94 ross adding new ncps.
1.10 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 12/03/94 ross testing Windows 95 RAS
1.13 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.14 12/13/94 ross connected to NT RAS with Netbios
1.15 02/24/95 ross changed mib check in authentication.
1.16 03/03/95 ross added up calls.
1.17 03/10/95 ross general fixes.  see change.doc
1.18 03/11/95 ross added copy mib routine.  Courtesy of Dan.
1.19 05/15/95 ross fixed problem with authenticating chap.
1.20 09/26/95 ross added changes for dynamic loading
1.21 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ppp.h"
#include "vpppstat.h"
/****************************************************************************/
static void copy_negotiated_lcp_options_to_mib_variables (USHORT real_port_number);

extern void cipx_reset_connection_states (USHORT port_number);
extern void vjc_reset_connection_states (USHORT port_number);
extern void free_ccp_option_lists (USHORT real_port_number);
extern void reset_ccp_state_machine(USHORT port_number);
extern void initialize_ccp_tx_accepted_option_list(USHORT port_number);

void free_lcp_tx_and_ncp_option_lists (USHORT port_number);
/****************************************************************************/
void execute_ppp_state_machine (enum PPP_EVENT ppp_event,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes)
{
	enum PPP_STATE original_state;

	original_state = ppp.port[real_port_number].state;

	if (state_machine_table[original_state][ppp_event].end_state == ILLEGAL_PPP_STATE)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:Error in state machine %04x, Event %04x \r\n",real_port_number,(USHORT) ppp_event);

		return;
		}

	if (state_machine_table[original_state][ppp_event].fptr_state_function != NULL)
		{
		(*state_machine_table[original_state][ppp_event].fptr_state_function) (real_port_number,vptr_packet,number_of_bytes,
			state_machine_table[original_state][ppp_event].end_state);

		if ((state_machine_table[original_state][ppp_event].end_state != NO_CHANGE_TO_PPP_STATE) &&
			(state_machine_table[original_state][ppp_event].fptr_state_function != set_ppp_state))
			{
			set_ppp_state (real_port_number,NULL,0x0000,state_machine_table[original_state][ppp_event].end_state);
			}
		}

	if (state_machine_table[original_state][ppp_event].fptr_state_function_1 != NULL)
		{
		(*state_machine_table[original_state][ppp_event].fptr_state_function_1) (real_port_number,vptr_packet,number_of_bytes,
			state_machine_table[original_state][ppp_event].end_state_1);

		if ((state_machine_table[original_state][ppp_event].end_state_1 != NO_CHANGE_TO_PPP_STATE) &&
			(state_machine_table[original_state][ppp_event].fptr_state_function_1 != set_ppp_state))
			{
			set_ppp_state (real_port_number,NULL,0x0000,state_machine_table[original_state][ppp_event].end_state_1);
			}
		}

	if (state_machine_table[original_state][ppp_event].fptr_state_function_2 != NULL)
		{
		(*state_machine_table[original_state][ppp_event].fptr_state_function_2) (real_port_number,vptr_packet,number_of_bytes,
			state_machine_table[original_state][ppp_event].end_state_2);

		if ((state_machine_table[original_state][ppp_event].end_state_2 != NO_CHANGE_TO_PPP_STATE) &&
			(state_machine_table[original_state][ppp_event].fptr_state_function_2 != set_ppp_state))
			{
			set_ppp_state (real_port_number,NULL,0x0000,state_machine_table[original_state][ppp_event].end_state_2);
			}
		}

	ppp.port[real_port_number].old_state = (BYTE_ENUM (PPP_STATE)) original_state;
}
/****************************************************************************/
void set_ppp_state (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	if (end_state == ILLEGAL_PPP_STATE)
		{
		/* printf ("set_ppp_state()\n") ; */
		ppp_printf (PPP_ALARM_PRINTF,"PPP:Error in state machine %04x, end state %04x\r\n",real_port_number,(USHORT) end_state);
		return;
		}

#ifdef DEBUG
	ppp_printf (PPP_LCP_PRINTF,"PPP:Port %04x - New State %04x\r\n",real_port_number,(USHORT) end_state);
#endif

	ppp.port[real_port_number].state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void null_state (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (real_port_number);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
}
/****************************************************************************/
void this_layer_start (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (vptr_packet);

	ppp.port[real_port_number].state = (BYTE_ENUM (PPP_STATE)) end_state;
}
/****************************************************************************/
void this_layer_finished (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
	{
			/* printf ("this_layer_finished() : calling WAN with CLOSE_SERIAL_PORT\n") ; */
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (CLOSE_SERIAL_PORT,
				(ULONG) real_port_number,
				(ULONG) &ppp.port[real_port_number].device_driver_id) ;
	}

	if (ppp.fptr_event_upcall != NULL)
	{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_THIS_LAYER_FINISHED,real_port_number,&ppp.port[real_port_number].option_lists);
	}

	/* serial_driver should call you back with a down event - RFC1548 */
}
/****************************************************************************/
void this_layer_up (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	OPTION_LIST_ENTRY *sptr_authentication_option; 
	OPTION_LIST_ENTRY *sptr_option;
	OPTION_LISTS *sptr_lcp;

	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);

	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_THIS_LAYER_UP,real_port_number,&ppp.port[real_port_number].option_lists);
		}

	sptr_lcp = &ppp.port[real_port_number].option_lists;

#if 0 /* Sachin, 14/07/1997. This is done now after sending the first NCP request */
	sptr_option = find_matching_option (&sptr_lcp->tx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP);
	if (sptr_option != NULL)
	{
		if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
		{
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (SET_TX_ACCM_SERIAL_PORT,
				(ULONG) real_port_number,(ULONG) sptr_option->uptr_data->_ulong);
		}
	}
#else
   ppp.port[real_port_number].accm_applied = FALSE ;
#endif
   
	sptr_option = find_matching_option (&sptr_lcp->rx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP);
	if (sptr_option != NULL)
	{
		if (ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
		{
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (SET_RX_ACCM_SERIAL_PORT,
				(ULONG) real_port_number,(ULONG) sptr_option->uptr_data->_ulong);
		}
	}
	(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (CHECK_IF_ANSWERING,
		(ULONG) real_port_number,(ULONG) &ppp.port[real_port_number].answering);

	copy_negotiated_lcp_options_to_mib_variables (real_port_number);

	ppp.port[real_port_number].authentication.current_number_of_retries = 0;

   /* If CHAP is the TX accepted protocol, send the challenge packet.
   If PAP is the RX accepted protocol, send the authenticate request */

	if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) == TRUE)
	{
		sptr_authentication_option = find_matching_option (&ppp.port[real_port_number].option_lists.tx_accepted,
			LCP_AUTHENTICATION_PROTOCOL);

		if (sptr_authentication_option != NULL) /* windows 95 problem? ### */
		{
			if (sptr_authentication_option->uptr_data->_ushort == CHAP_PROTOCOL)
			{
					send_lcp_chap_server_packet (real_port_number) ;
			}
         else
         {
            /* We dont need to do anything. The peer needs to
            start sending PAP authenticate requests */
         }
		}
	}

	if (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) == TRUE)
	{
		sptr_authentication_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
			LCP_AUTHENTICATION_PROTOCOL);

		if (sptr_authentication_option != NULL) /* windows 95 problem? ### */
		{
			if (sptr_authentication_option->uptr_data->_ushort == PAP_PROTOCOL)
			{
				send_lcp_authentication_request (real_port_number);
			}
         else
         {
            /* We dont need to do anything. The peer needs to
            start sending CHAP Challenges */
         }
		}
	}
	else	if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted, (BYTE) LCP_AUTHENTICATION_PROTOCOL) == TRUE)
	{
			return;
	}
	else
	{
		bring_ncps_up (real_port_number,NULL,0x0000,PPP_INITIAL_STATE);
		
#if defined (CCP)
/* Sowmya 7/3/96
		if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
			(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);		
			
			bring_ccp_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE);
			}
Sowmya 7/3/96 */
#endif /* CCP */
	}
}
/****************************************************************************/
static void copy_negotiated_lcp_options_to_mib_variables (USHORT real_port_number)
{
	BYTE authentication_option[3];
	USHORT MRU;

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_MAXIMUM_RECEIVE_UNIT,
		&MRU,	sizeof (ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalMRU)) == PASS)
		{
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalMRU =	(ULONG) swap (MRU);
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_MAXIMUM_RECEIVE_UNIT,
		&MRU,	sizeof (ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)) == PASS)
		{
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU = (ULONG) swap (MRU);
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP,
		&ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToPeerACCMap,
		sizeof (ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToPeerACCMap)) == FAIL)
		{
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToPeerACCMap = DEFAULT_ASYNC_CONTROL_CHARACTER_MAP;
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_ASYNC_CONTROL_CHARACTER_MAP,
		&ppp.port[real_port_number].lcp_mibs.pppLinkStatusPeerToLocalACCMap,
		sizeof (ppp.port[real_port_number].lcp_mibs.pppLinkStatusPeerToLocalACCMap)) == FAIL)
		{
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusPeerToLocalACCMap = DEFAULT_ASYNC_CONTROL_CHARACTER_MAP;
		}

	ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToRemoteProtocolCompression =
		(is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE) ?
	 	SNMP_BOOLEAN_ENABLED : SNMP_BOOLEAN_DISABLED;

	ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteToLocalProtocolCompression =
	   (is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,(BYTE) LCP_PROTOCOL_FIELD_COMPRESSION) == TRUE) ?
	 	SNMP_BOOLEAN_ENABLED : SNMP_BOOLEAN_DISABLED;

	ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalToRemoteACCompression =
		(is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE) ?
	 	SNMP_BOOLEAN_ENABLED : SNMP_BOOLEAN_DISABLED;

	ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteToLocalACCompression =
		(is_option_present (&ppp.port[real_port_number].option_lists.rx_accepted,(BYTE) LCP_ADDRESS_AND_CONTROL_FIELD_COMPRESSION) == TRUE) ?
	 	SNMP_BOOLEAN_ENABLED : SNMP_BOOLEAN_DISABLED;

	if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_AUTHENTICATION_PROTOCOL,
		&authentication_option[0],sizeof (ppp.port[real_port_number].lcp_mibs.pppLocalAuthenticationProtocol)) == FAIL)
		{
		ppp.port[real_port_number].lcp_mibs.pppLocalAuthenticationProtocol = (ULONG) NULL;
		}
	else
		{
		ppp.port[real_port_number].lcp_mibs.pppLocalAuthenticationProtocol =
			*((enum PPP_PROTOCOL_TYPE *) &authentication_option[0]);
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_AUTHENTICATION_PROTOCOL,
		&authentication_option[0],sizeof (ppp.port[real_port_number].lcp_mibs.pppRemoteAuthenticationProtocol)) == FAIL)
		{
		ppp.port[real_port_number].lcp_mibs.pppRemoteAuthenticationProtocol = (ULONG) NULL;
		}
	else
		{
		ppp.port[real_port_number].lcp_mibs.pppRemoteAuthenticationProtocol =
			*((enum PPP_PROTOCOL_TYPE *) &authentication_option[0]);
		}
		/* Sanjays code -- we don't negotiate FCS size. Always 16 bits. */
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusTransmitFcsSize = 16;
		ppp.port[real_port_number].lcp_mibs.pppLinkStatusReceiveFcsSize = 16;
		/* Sanjays code */
}
#if defined (CCP)
/****************************************************************************/
void bring_ccp_up (USHORT real_port_number, void *vptr_packet,USHORT number_of_bytes, enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (number_of_bytes);
	PARAMETER_NOT_USED (end_state);

	if (ppp.ccp.fptr_execute_ccp_state_machine_function != NULL)
		{
		(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_UP_EVENT, real_port_number, NULL, 0x0000);
		}
}
#endif
/****************************************************************************/
void bring_ncps_up (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	BYTE protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;
	OPTION_LIST_ENTRY *sptr_option;

#ifdef __MLPPP__
	PPP_PORT_CLASS *sptr_port;
	USHORT virtual_port_number;
#endif

	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);
	  
#ifdef __MLPPP__
	sptr_port = &ppp.port[real_port_number];
#endif

 	initialize_LQR_counters (real_port_number);

	/* RNServer code has the next 6 lines taken out and marked as
	   "Trumpet Winsock problem". Check out. */

/* Sowmya 26/4/96 
	if (ppp.port[real_port_number].configuration.enabled.send_id == TRUE)
		{
		send_lcp_id_packet (real_port_number);
		}
Sowmya 26/4/96 */

#ifdef __MLPPP__
	sptr_port->virtual_port_number = virtual_port_number = 
				join_multilink_if_negotiated(real_port_number,sptr_port->virtual_port_number);
#endif

	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS;
		protocol_stack_index = (BYTE) (protocol_stack_index + 1))
		{
#ifdef __MLPPP__
		sptr_ncp = &mlppp.port[virtual_port_number].ncp[protocol_stack_index];
#else
		sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif

		if ((sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID) && (sptr_ncp->enabled == TRUE))
			{
#ifdef __MLPPP__
			execute_ncp_state_machine (PPP_UP_EVENT,sptr_ncp,virtual_port_number,NULL,0x0000);
#else
			execute_ncp_state_machine (PPP_UP_EVENT,sptr_ncp,real_port_number,NULL,0x0000);
#endif
			}
		}
}
/****************************************************************************/
void this_layer_down (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	BYTE protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;

	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);


	if (ppp.fptr_event_upcall != NULL)
		{
		(*ppp.fptr_event_upcall) (PPP_EVENT_LCP_THIS_LAYER_DOWN,real_port_number,&ppp.port[real_port_number].option_lists);
		}

	reset_counters_on_this_port (real_port_number);

			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (SET_TX_ACCM_SERIAL_PORT,
				(ULONG) real_port_number,(ULONG) 0xffffffff);
			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (SET_RX_ACCM_SERIAL_PORT,
				(ULONG) real_port_number,(ULONG) 0xffffffff);

#ifndef __MLPPP__
	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS;
		protocol_stack_index = (BYTE) (protocol_stack_index + 1))
		{
		sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];

		if (sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID)
			{
			execute_ncp_state_machine (PPP_DOWN_EVENT,sptr_ncp,real_port_number,NULL,0x0000);
			}
		}
	
#endif /* __MLPPP__ */	
#if defined (CCP)
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
		{
		(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_DOWN_EVENT, real_port_number, NULL, 0x0000);
		}
#endif


		free_lcp_tx_and_ncp_option_lists (real_port_number);

#if defined (CCP)
		if (ppp.ccp.enabled == TRUE)
			{
			if ((ppp.ccp.fptr_get_ccp_port_status_function != NULL) && 
				((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
				free_ccp_option_lists (real_port_number);
				reset_ccp_state_machine(real_port_number);
				initialize_ccp_tx_accepted_option_list(real_port_number);
				}
			}
#endif				
		initialize_lcp_statistics_counters (real_port_number);

		initialize_lcp_tx_accepted_option_list(real_port_number);

#ifndef __MLPPP__
		initialize_ncp_tx_accepted_option_list(real_port_number);
		cipx_reset_connection_states (real_port_number);
		vjc_reset_connection_states (real_port_number);
#endif
#ifdef __MLPPP__
   remove_link_from_bundle(real_port_number,ppp.port[real_port_number].virtual_port_number);
   ppp.port[real_port_number].virtual_port_number = 
			map_physical_port_to_virtual_port(real_port_number);
#endif
}
/****************************************************************************/
void initialize_restart_counter (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);

	ppp.port[real_port_number].number_of_configuration_requests = 0x0000;
	ppp.port[real_port_number].configuration_request_send_interval = 0x0000;
	ppp.port[real_port_number].configuration_request_backoff_interval = 0x0000;
	ppp.port[real_port_number].termination_request_send_interval = 0x0000;
}
/****************************************************************************/
void zero_restart_counter (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state)
{
	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (number_of_bytes);

	ppp.port[real_port_number].number_of_configuration_requests = 0x0000;
	ppp.port[real_port_number].configuration_request_send_interval = 0x0000;
	ppp.port[real_port_number].configuration_request_backoff_interval = 0x0000;
	ppp.port[real_port_number].termination_request_send_interval = 0x0000;
}

/****************************************************************************
/* We free up the lcp Transmit related option lists but not the Receive related
lists. This is because, the Receive related lists have just been built because
of the Configure Request received. For NCPs, CCP, CIPX etc the entire state
machine is reset.
NOTE : Receive related lists are freed up when a Config Request comes.
****************************************************************************/
void free_lcp_tx_and_ncp_option_lists (USHORT port_number)
{
	USHORT protocol_stack_index;
	OPTION_LISTS *sptr_option_lists;

	sptr_option_lists =&ppp.port[port_number].option_lists;

	free_ppp_option_list (&sptr_option_lists->rx_nak);
	free_ppp_option_list (&sptr_option_lists->rx_reject);
	free_ppp_option_list (&sptr_option_lists->tx_accepted);

#if 0
	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
		free_ppp_option_lists (&ppp.port[port_number].ncp[protocol_stack_index].option_lists);
		}
#endif

#ifndef __MLPPP__
	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
		free_ppp_option_lists (&ppp.port[port_number].ncp[protocol_stack_index].option_lists);
		}
#endif /* __MLPPP__ */
}
