#include	"defs.h"
/*	$Modname: pppstprx.c$  $version: 1.11$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 08/24/94 ross
1.1 08/24/94 ross cleanup for release
1.2 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.3 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.4 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.5 12/02/94 ross testing NT3.5 RAS
1.6 12/03/94 ross testing Windows 95 RAS
1.7 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.8 12/13/94 ross connected to NT RAS with Netbios
1.9 02/27/95 ross dynamic load changes including lsl_control.
1.10 06/26/95 ross initial version of BCP
1.11 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "ppp.h"
/****************************************************************************/
static void build_stp_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp);
/****************************************************************************/
void initialize_spanning_tree_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;
#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX];
#endif

	strcpy (sptr_ncp->name,"Spanning Tree");

	sptr_ncp->type = SPANNING_TREE_STACK;
	sptr_ncp->ppp_protocol_stack_type = BRIDGING_PROTOCOL;
	sptr_ncp->ncp_protocol_type = BCP_PROTOCOL;
	sptr_ncp->state = PPP_INITIAL_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;
	sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
	sptr_ncp->real_port_number = real_port_number;

	sptr_ncp->receive.fptr_process_receive_options[BRIDGE_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[LINE_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[MAC_SUPPORT_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[TINYGRAM_COMPRESSION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[LAN_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[MAC_ADDRESS_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive.fptr_process_receive_options[SPANNING_TREE_PROTOCOL_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[BRIDGE_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[LINE_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[MAC_SUPPORT_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[TINYGRAM_COMPRESSION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[LAN_IDENTIFICATION_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[MAC_ADDRESS_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[SPANNING_TREE_PROTOCOL_TYPE] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->fptr_protocol_stack_up = build_stp_ppp_accepted_parameters;

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}
/****************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *add_bcp_lan_id (USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT *usptr_number_of_bytes_to_send,enum BOOLEAN do_not_calculate_crc,
	void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	PPP_BRIDGE_PACKET *sptr_bridge_packet;
	UNION_BRIDGE_FLAGS bridge_flags;
	USHORT number_of_bcp_header_bytes;

	if (*fptr_tx_completion != NULL)
		{
		sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ppp_get_a_send_packet (real_port_number,
			*usptr_number_of_bytes_to_send + sizeof (PPP_BRIDGE_PACKET_HEADER));

		if (sptr_bridge_packet == NULL)
			{
			return (NULL);
			}

		sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ((ULONG) sptr_bridge_packet + sizeof (PPP_BRIDGE_PACKET_HEADER));

		memcpy (sptr_bridge_packet,sptr_tx_packet,*usptr_number_of_bytes_to_send);

		(*fptr_tx_completion) (protocol_virtual_port_number,sptr_tx_packet);
		}
	else
		{
		sptr_bridge_packet = (PPP_BRIDGE_PACKET *) sptr_tx_packet;
		}

	sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ((ULONG) sptr_bridge_packet -
		(sizeof (sptr_bridge_packet->flags) + sizeof (sptr_bridge_packet->mac_type)));

	number_of_bcp_header_bytes = sizeof (sptr_bridge_packet->flags) +	sizeof (sptr_bridge_packet->mac_type);

	bridge_flags._byte = 0x00;

#ifdef __MLPPP__
	if (is_option_present (&mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) LAN_IDENTIFICATION_TYPE) == TRUE)
#else
	if (is_option_present (&ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) LAN_IDENTIFICATION_TYPE) == TRUE)
#endif
		{
		number_of_bcp_header_bytes += (USHORT) sizeof (sptr_bridge_packet->lan_id);

		sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ((ULONG) sptr_bridge_packet - sizeof (sptr_bridge_packet->lan_id)
			- sizeof (PPP_HEADER));

		sptr_bridge_packet->lan_id =
			*((ULONG *) ((ULONG) sptr_bridge_packet - (sizeof (sptr_bridge_packet->lan_id) + sizeof (sptr_bridge_packet->mac_type))));

		bridge_flags._bit.lan_id = TRUE;
		}
	else
		{
		sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ((ULONG) sptr_bridge_packet - sizeof (PPP_HEADER));
		}

	bridge_flags._bit.crc = do_not_calculate_crc;
	bridge_flags._bit._8023_zero_filled = FALSE;
	bridge_flags._bit.number_of_pads = 0x0;

	*usptr_number_of_bytes_to_send = 
		(USHORT) (*usptr_number_of_bytes_to_send + sizeof (UNION_MAC_HEADER) + number_of_bcp_header_bytes);

	sptr_bridge_packet->flags._byte = bridge_flags._byte;

	sptr_bridge_packet->mac_type = IEEE_802_3_ETHERNET_CANONICAL;
/*		*((BYTE_ENUM (BRIDGE_MAC_TYPE) *) ((ULONG) sptr_tx_packet - sizeof (sptr_bridge_packet->mac_type))); */

	sptr_bridge_packet = (PPP_BRIDGE_PACKET *) ((ULONG) sptr_bridge_packet - (sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER)));

	return ((PPP_PACKET_WITH_MAC_HEADER *) sptr_bridge_packet);
}
/****************************************************************************/
void ppp_free_a_bridge_send_packet (USHORT real_port_number,void *vptr_tx_packet)
{
	PARAMETER_NOT_USED (real_port_number);

#ifdef __BORLANDC__
	if (((ULONG) vptr_tx_packet) & 0x00000001)
		ppp_printf (PPP_ALARM_PRINTF,"Free Error of %p\r\n",vptr_tx_packet);
#endif

#ifdef NOT_NOW
	if (is_option_present (&ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) LAN_IDENTIFICATION_TYPE) == FALSE)
#endif

#ifdef __MLPPP__
	if (is_option_present (&mlppp.port[real_port_number-1].ncp[PPP_BRIDGING_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) LAN_IDENTIFICATION_TYPE) == FALSE)
#else
	if (is_option_present (&ppp.port[real_port_number-1].ncp[PPP_BRIDGING_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) LAN_IDENTIFICATION_TYPE) == FALSE)
#endif
		{
		vptr_tx_packet = (void *) ((ULONG) vptr_tx_packet - sizeof (ULONG));
		}
	else
		{
		vptr_tx_packet = (void *) ((ULONG) vptr_tx_packet - sizeof (UNION_BRIDGE_FLAGS) - sizeof (BYTE_ENUM (BRIDGE_MAC_TYPE))
			- sizeof (ULONG));
		}


#ifdef DEBUG
	ppp_printf (PPP_MEMORY_PRINTF,"PPP: STP Free of %08lx\r\n",(ULONG) vptr_tx_packet);
#endif

	buffer_free (vptr_tx_packet);
}
/****************************************************************************/
void *extract_bcp_lan_id (UNION_PPP_PACKET *sptr_tx_packet,USHORT *usptr_number_of_bytes_to_send)
{
	PPP_BRIDGE_PACKET *sptr_bridge_packet;
	MAC_HEADER *sptr_lan_packet;
	UNION_BRIDGE_FLAGS bridge_flags;
	ULONG lan_id;
	BYTE_ENUM (BRIDGE_MAC_TYPE) mac_type;

	sptr_bridge_packet = (PPP_BRIDGE_PACKET *) sptr_tx_packet;

	bridge_flags._byte = sptr_bridge_packet->flags._byte;

	mac_type = sptr_bridge_packet->mac_type;

	lan_id = sptr_bridge_packet->lan_id;

	*usptr_number_of_bytes_to_send = (USHORT) (*usptr_number_of_bytes_to_send -
		(sizeof (PPP_HEADER) + sizeof (sptr_bridge_packet->flags) + sizeof (sptr_bridge_packet->mac_type)));

	sptr_lan_packet = (MAC_HEADER *) ((ULONG) sptr_bridge_packet +
		(sizeof (PPP_HEADER) + sizeof (sptr_bridge_packet->flags) + sizeof (sptr_bridge_packet->mac_type)));

	if (bridge_flags._bit.lan_id == TRUE)
		{
		sptr_lan_packet = (MAC_HEADER *) ((ULONG) sptr_lan_packet + sizeof (sptr_bridge_packet->lan_id));

		*((ULONG *) ((ULONG) sptr_lan_packet - (sizeof (lan_id) + sizeof (sptr_bridge_packet->mac_type)))) = lan_id;
			/* store the lan id in the front of the header */
		}

	*((BYTE_ENUM (BRIDGE_MAC_TYPE) *) ((ULONG) sptr_lan_packet - sizeof (sptr_bridge_packet->mac_type))) = mac_type;

	return (sptr_lan_packet);
}
/****************************************************************************/
static void build_stp_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp)
{
	OPTION_LIST_ENTRY *sptr_option;

	sptr_option = find_matching_option (&sptr_ncp->option_lists.tx_accepted,IP_ADDRESS_OPTION_TYPE);

	if (sptr_option != NULL)
		{
		lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,OPEN_VIRTUAL_PORT,
			sptr_option->uptr_data->_ulong,
			NULL);
		}
	else
		{
		lsl_control (PROTOCOL_STACK_PORT,virtual_port_number,sptr_ncp->protocol_stack_id,OPEN_VIRTUAL_PORT,
		(ULONG) NULL,
		NULL);
		}
}

