#include	"defs.h"
/*	$Modname: ppptimer.c$  $version: 1.26$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/02/93 ross Initial release.
1.1 12/10/93 ross Added support for finite state machine (FSM).
1.2 01/05/94 ross Split it into four different functions for clarity.
1.3 01/05/94 keyur Added support for version control.
1.4 01/20/94 keyur Added some robustness for FSM.
1.5 01/28/94 keyur Reshuffled the code for robustness in FSM.
1.6 02/01/94 keyur Added some support for more robust FSM.
1.7 02/02/94 keyur Added some support for FSM.
1.8 02/22/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Th
1.9 03/23/94 keyur Added support for Appletalk (ATCP).
1.10 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.11 04/13/94 keyur Added support for NCP state machine
1.12 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.13 05/02/94 keyur
1.14 05/02/94 keyur took out memcheck header file.
1.15 08/11/94 ross adding rfc1570 lcp support
1.16 08/12/94 ross testing new option support
1.17 08/24/94 ross adding new ncps.
1.18 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.19 12/03/94 ross testing Windows 95	RAS
1.20 12/13/94 ross connected to NT RAS with Netbios
1.21 03/03/95 ross added up calls.
1.22 03/10/95 ross general fixes.  see change.doc
1.23 03/20/95 ross changed ppptimer.c.  Courtesy of Dan.
1.24 04/20/95 ross fixed number of configuration requests max limit.
1.25 04/26/95 ross swapped interval counters with number_of_requests counters in if statement.
1.26 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.							     	*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ppp.h"
/****************************************************************************/
static void periodic_lcp_configure_or_termination_request (USHORT real_port_number);
static void periodic_ncp_configure_or_termination_request (USHORT real_port_number);
static void periodic_lcp_echo_request (USHORT real_port_number);
static void periodic_lcp_link_quality_report (USHORT real_port_number);
static void periodic_time_remaining_packets (USHORT real_port_number);
static void send_periodic_authentication_packets (USHORT real_port_number);

#ifdef __DOD__
static	first_time[MAXIMUM_NUMBER_OF_PPP_PORTS] = {TRUE,TRUE,TRUE};
#endif /* __DOD__ */

#if defined (CCP)
enum BOOLEAN ccp_state_machine_inited[MAXIMUM_NUMBER_OF_PPP_PORTS] = {FALSE,FALSE,FALSE};
void	check_to_bring_ccp_up (USHORT real_port_number);
#endif 
/****************************************************************************/
void ppp_timer_routine (void)
{
	USHORT real_port_number;

#if Ravi
	/* This function is called in USERINIT.C */
#ifdef RAS
	check_if_udb_updated () ;
#endif
#endif

	++ppp.timer;

	if (++ppp._1_second_counter >= (ppp.clock_ticks_per_second * ppp.number_of_ppp_ports))
		{
		for (real_port_number = 0x0000; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
			{
			/* Kamalnath SLIP 08\03\1997 */
			if (ppp.port[real_port_number].slip_on !=TRUE)
			{
				if (ppp.port[real_port_number].enabled == TRUE)
					{
					periodic_lcp_configure_or_termination_request (real_port_number);

#ifdef __DOD__
					if ((ppp.port[real_port_number].dial_on_demand == TRUE)
						&& (ppp.port[real_port_number].connect_state == LINK_UP) 
						&&	(ppp.port[real_port_number].answering != TRUE) 
						&&	(ppp.port[real_port_number].dod_active == TRUE)) /* Added this condition Ravi 10-jan-2000 */
					{
						if (ppp.port[real_port_number].idle_timer)
								ppp.port[real_port_number].idle_timer --;
						else 
						{
#ifdef DOD_DEBUG
							printf("PPP:Port Idle. Deactivating port %04x\r\n", real_port_number);
#endif
							ppp_link_idle(real_port_number);
						}
					}
					 	
#endif /* __DOD__ */

#if defined (CCP)
					if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
					{
						if (ccp_state_machine_inited[real_port_number] == FALSE)
							check_to_bring_ccp_up (real_port_number);
						else
							(*ppp.ccp.fptr_ccp_timer_routine) (real_port_number, ppp.number_of_protocol_stacks_loaded, 
								ppp.maximum_configuration_request_send_interval, ppp.maximum_number_of_configuration_requests, 
								ppp.maximum_termination_request_send_interval, ppp.maximum_number_of_termination_requests);
					}
#endif
					periodic_lcp_echo_request (real_port_number);

					periodic_ncp_configure_or_termination_request (real_port_number);

					periodic_lcp_link_quality_report (real_port_number);

					periodic_time_remaining_packets (real_port_number);

					send_periodic_authentication_packets (real_port_number);
					}
				}	/* Kamalnath SLIP 08\03\1997 */
			}

		ppp._1_second_counter = 0x00000000L;
		}

#ifdef __LLDD_TIMER__
	for (real_port_number = 0x0000; real_port_number < ppp.number_of_ppp_ports; ++real_port_number)
	{

#ifdef __DOD__
/* Kamalnath 09\05\1997 */
#if 0	/* KVSP */
		if ((ppp.port[real_port_number].enabled == FALSE) && (ppp.wan_port_inittable[real_port_number] == FALSE))
#else
		if (ppp.port[real_port_number].enabled == FALSE)
#endif
		{
			if (ppp.port[real_port_number].serial_driver.fptr_control_routine)
			{
				(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (INIT_SERIAL_PORT,
					(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
			
				(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT, 
					(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
			
#if 0	/* KVSP */
				ppp.wan_port_inittable[real_port_number] = TRUE;
#endif
			}
		}
/* Kamalnath 09\05\1997 */

		if (first_time[real_port_number] == TRUE && 
			ppp.port[real_port_number].serial_driver.fptr_control_routine != NULL)
		{
			first_time[real_port_number] = FALSE;

			/* Now that the lower level driver has registered, open the port */
#ifdef DOD_DEBUG
			printf("PPP:LLDD Registered. Going to initialize port.\r\n");
#endif

			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (INIT_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);

			(*ppp.port[real_port_number].serial_driver.fptr_control_routine) (OPEN_SERIAL_PORT,
			(ULONG) real_port_number,(ULONG) ppp.port[real_port_number].device_driver_id);
		}

		if (ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND)
			continue;
#endif /* __DOD__ */

		/* making a call to the lower level device driver timer function
		since LSL does	not directly call it */
		if (ppp.port[real_port_number].serial_driver.fptr_timer_routine != NULL)
	 		(*ppp.port[real_port_number].serial_driver.fptr_timer_routine)();
	}
#endif
}
/****************************************************************************/
static void periodic_lcp_configure_or_termination_request (USHORT real_port_number)
{
	if ((ppp.number_of_protocol_stacks_loaded > 0x0000) &&
		(ppp.port[real_port_number].state > PPP_STOPPING_STATE) && (ppp.port[real_port_number].state < PPP_OPENED_STATE))
		{
		if (++ppp.port[real_port_number].configuration_request_send_interval >= ppp.maximum_configuration_request_send_interval)
			{
			ppp.port[real_port_number].configuration_request_send_interval = 0x00000000L;

			if (++ppp.port[real_port_number].number_of_configuration_requests <= ppp.maximum_number_of_configuration_requests)
				{
				execute_ppp_state_machine (PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT,real_port_number,NULL,0x0000);
				}
			else
				{
				execute_ppp_state_machine (PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT,real_port_number,NULL,0x0000);

				/* printf ("periodic_lcp_conf_or_term_req(), PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT\n") ; */

				ppp.port[real_port_number].number_of_configuration_requests = 0x00000000L;
				}
			}
		}

	if ((ppp.number_of_protocol_stacks_loaded > 0x0000) &&
		((ppp.port[real_port_number].state == PPP_CLOSING_STATE) || (ppp.port[real_port_number].state == PPP_STOPPING_STATE)))
		{
		if (++ppp.port[real_port_number].termination_request_send_interval >= ppp.maximum_termination_request_send_interval)
			{
			if (ppp.port[real_port_number].number_of_lcp_termination_requests < ppp.maximum_number_of_termination_requests)
				{
				execute_ppp_state_machine (PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT,real_port_number,NULL,0x0000);

				ppp.port[real_port_number].termination_request_send_interval = 0x00000000L;
				}
			else
				{
				execute_ppp_state_machine (PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT,real_port_number,NULL,0x0000);

				/* printf ("periodic_ncp_conf_or_term_req(), PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT\n") ; */

				ppp.port[real_port_number].termination_request_send_interval = 0x00000000L;
				}
			}
		}
}
/****************************************************************************/
static void periodic_lcp_echo_request (USHORT real_port_number)
{
		if (!ppp.maximum_echo_request_send_interval)
			return;
	if ((ppp.number_of_protocol_stacks_loaded > 0x0000) && (ppp.port[real_port_number].state == PPP_OPENED_STATE)) 
		{
		if (++ppp.port[real_port_number].echo_request_send_interval >= ppp.maximum_echo_request_send_interval)
			{
			if (ppp.port[real_port_number].number_of_echo_requests < ppp.maximum_number_of_unacknowledged_echo_requests)
				{
				execute_ppp_state_machine (PPP_ECHO_RESPONSE_TIMEOUT,real_port_number,NULL,0x0000);

				ppp.port[real_port_number].echo_request_send_interval = 0x00000000L;
				}
			else
				{
				execute_ppp_state_machine (PPP_ECHO_RESPONSE_TIMEOUT_FAILURE,real_port_number,NULL,0x0000);

				ppp.port[real_port_number].echo_request_send_interval = 0x00000000L;
				}
			}
		}
}
/****************************************************************************/
static void periodic_ncp_configure_or_termination_request (USHORT real_port_number)
{
	USHORT protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;
	PPP_PORT_CLASS *sptr_port;

#ifdef __MLPPP__
	sptr_port = mlppp.port[real_port_number].LinkInfo[0].port;
#else	/*__MLPPP__*/
	sptr_port = &ppp.port[real_port_number];
#endif	/*__MLPPP__*/

	for (protocol_stack_index = 0x0000; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
		if (ppp.port[real_port_number].state == PPP_OPENED_STATE)
			{
			if ((is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,(BYTE) LCP_AUTHENTICATION_PROTOCOL)
			== FALSE) || (ppp.port[real_port_number].authentication.status == SUCCESSFUL))
				{
/*					Some routers continue to send even if they receive a reject.
				if (ppp.port[real_port_number].protocol_stack[protocol_stack_index].number_of_protocol_rejects_rxed <=
					MAXIMUM_NUMBER_OF_PROTOCOL_REJECTS_RECEIVED)
*/					
#ifdef __MLPPP__
				sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else
				sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif

				if ((sptr_ncp->state > PPP_STOPPING_STATE) && (sptr_ncp->state < PPP_OPENED_STATE))
					{
					if (++sptr_ncp->configuration_request_send_interval >= ppp.maximum_configuration_request_send_interval)
						{
						if (++sptr_ncp->number_of_configuration_requests <= ppp.maximum_number_of_configuration_requests)
							{
							execute_ncp_state_machine
								(PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT,sptr_ncp,real_port_number,NULL,0x0000);

							sptr_ncp->configuration_request_send_interval =	0x00000000L;
							}
						else
							{
							execute_ncp_state_machine
								(PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT,sptr_ncp,real_port_number,NULL,0x0000);

							/* printf ("periodic_ncp_conf_or_term_req(), PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT\n") ; */

							sptr_ncp->configuration_request_send_interval =	0x00000000L;
							sptr_ncp->number_of_configuration_requests = 0x00000000L;
							}
						}
					}

				if (((sptr_ncp->state == PPP_CLOSING_STATE) || (sptr_ncp->state == PPP_STOPPING_STATE)))
					{
					if (++sptr_ncp->termination_request_send_interval >= ppp.maximum_termination_request_send_interval)
						{
						if (++sptr_ncp->number_of_termination_requests < ppp.maximum_number_of_termination_requests)
							{
							execute_ncp_state_machine
								(PPP_TIMEOUT_WITH_COUNTER_GREATER_THAN_ZERO_EVENT,sptr_ncp,real_port_number,NULL,0x0000);

							sptr_ncp->termination_request_send_interval = 0x00000000L;
							}
						else
							{
							execute_ncp_state_machine
								(PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT,sptr_ncp,real_port_number,NULL,0x0000);

							/* printf ("periodic_ncp_conf_or_term_req(), PPP_TIMEOUT_WITH_COUNTER_EXPIRED_EVENT\n") ; */

							sptr_ncp->number_of_termination_requests =	0x00000000L;
							sptr_ncp->termination_request_send_interval = 0x00000000L;
							}
						}
					}
				}
			}
		}
}
/****************************************************************************/
static void periodic_lcp_link_quality_report (USHORT real_port_number)
{
	LINK_QUALITY_OPTION	link_quality_option;

	if (is_option_present (&ppp.port[real_port_number].option_lists.tx_accepted,(BYTE) LCP_QUALITY_PROTOCOL) == TRUE)
		{
		if (copy_option (&ppp.port[real_port_number].option_lists.tx_accepted,LCP_QUALITY_PROTOCOL,
			&link_quality_option.quality_protocol,sizeof (link_quality_option.quality_protocol) +
			sizeof (link_quality_option.reporting_time)) == PASS)
			{
			if ((swap_long (link_quality_option.reporting_time) != 0x00000000L) &&
				(++ppp.port[real_port_number].time_to_send_LQR >= swap_long (link_quality_option.reporting_time)))
				{
				send_lcp_link_quality_report (real_port_number);
				}
			}
		}
}
/****************************************************************************/
static void periodic_time_remaining_packets (USHORT real_port_number)
{
	if (ppp.port[real_port_number].configuration.enabled.time_remaining == TRUE)
		{
		++ppp.port[real_port_number].time_remaining_timer;

		if (ppp.port[real_port_number].time_remaining_timer > ppp.port[real_port_number].time_remaining_timeout)
			{
			ppp.port[real_port_number].time_remaining_timer = 0x00000000L;

			send_lcp_time_remaining_packet (real_port_number);
			}
		}
}
/****************************************************************************/
#if 0
static void send_periodic_authentication_packets (USHORT real_port_number)
{
	enum PPP_PROTOCOL_TYPE authentication_protocol;

 	if (ppp.port[real_port_number].state != PPP_OPENED_STATE)
		{
		return;
		}

	if (copy_option (&ppp.port[real_port_number].option_lists.rx_accepted,LCP_AUTHENTICATION_PROTOCOL,
		&authentication_protocol,sizeof (authentication_protocol)) == FAIL)
		{
		return;
		}

 	if (ppp.port[real_port_number].authentication.status == SUCCESSFUL)
		{
		return;
		}

	++ppp.port[real_port_number].authentication.timer;

	if (ppp.port[real_port_number].authentication.timer > ppp.port[real_port_number].authentication.timeout)
		{
		ppp.port[real_port_number].authentication.timer = 0x00000000L;

		if (++ppp.port[real_port_number].authentication.current_number_of_retries <
			ppp.port[real_port_number].authentication.maximum_number_of_retries)
			{
			if	(authentication_protocol == CHAP_PROTOCOL)
				{
				send_lcp_chap_server_packet (real_port_number);
				}
			else
				{
				send_lcp_authentication_request (real_port_number);
				}
			}
		else
			{
 			execute_ppp_state_machine (PPP_CLOSE_EVENT,real_port_number,NULL,0x0000);

			if	(authentication_protocol == CHAP_PROTOCOL)
				{
				if (ppp.fptr_event_upcall != NULL)
					{
					(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATION_REFUSED,real_port_number,(ULONG) authentication_protocol);
					}
				}
			else
				{
				if (ppp.fptr_event_upcall != NULL)
					{
					(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATION_FAILED,real_port_number,(ULONG) authentication_protocol);
					}
				}
			}
		}
}
#endif
/* 12/07/1997, function exhaustively changed because in case of CHAP,
we need to send periodic CHAP challenge packets if it is in out TX
accepted list i.e, if we have configure requested CHAP and he has acked
and PAP auth requests in case it is in our RX accepted list */
void send_periodic_authentication_packets (USHORT real_port_number)
{
	enum PPP_PROTOCOL_TYPE authentication_protocol;
   OPTION_LIST_ENTRY *sptr_authentication_option;

 	if (ppp.port[real_port_number].state != PPP_OPENED_STATE)
	{
		return;
	}
 	if (ppp.port[real_port_number].authentication.status == SUCCESSFUL)
	{
		return;
	}

	++ppp.port[real_port_number].authentication.timer;

	sptr_authentication_option = find_matching_option (&ppp.port[real_port_number].option_lists.tx_accepted,
		LCP_AUTHENTICATION_PROTOCOL);
   if (sptr_authentication_option != NULL)
	{
      authentication_protocol = (enum PPP_PROTOCOL_TYPE) sptr_authentication_option->uptr_data->_ushort ;
		if	(authentication_protocol == CHAP_PROTOCOL)
		{
			if (ppp.port[real_port_number].authentication.txed_authentication_ack != TRUE)
			{
				if (ppp.port[real_port_number].authentication.timer >
            ppp.port[real_port_number].authentication.timeout)
				{
					ppp.port[real_port_number].authentication.timer = 0x00000000L;

					if (++ppp.port[real_port_number].authentication.current_number_of_retries <
							ppp.port[real_port_number].authentication.maximum_number_of_retries)
					{
						send_lcp_chap_server_packet (real_port_number);
					}
					else
					{
			 			execute_ppp_state_machine (PPP_CLOSE_EVENT,real_port_number,NULL,0x0000);
						if (ppp.fptr_event_upcall != NULL)
						{
							(*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATION_REFUSED,real_port_number,(ULONG) authentication_protocol);
						}
					}
				}
			}
		}
	}

	sptr_authentication_option = find_matching_option (&ppp.port[real_port_number].option_lists.rx_accepted,
		LCP_AUTHENTICATION_PROTOCOL);
   if (sptr_authentication_option != NULL)
	{
      authentication_protocol = (enum PPP_PROTOCOL_TYPE) sptr_authentication_option->uptr_data->_ushort ;
		{
		   if	(authentication_protocol == PAP_PROTOCOL)
			{
			   if (ppp.port[real_port_number].authentication.rxed_authentication_ack != TRUE)
				{
				   if (ppp.port[real_port_number].authentication.timer >
               ppp.port[real_port_number].authentication.timeout)
					{
					   ppp.port[real_port_number].authentication.timer = 0x00000000L;

					   if (++ppp.port[real_port_number].authentication.current_number_of_retries <
						   ppp.port[real_port_number].authentication.maximum_number_of_retries)
						{
						   send_lcp_authentication_request (real_port_number);
						}
					   else
						{
			 			   execute_ppp_state_machine (PPP_CLOSE_EVENT,real_port_number,NULL,0x0000);
						   if (ppp.fptr_event_upcall != NULL)
							{
							   (*ppp.fptr_event_upcall) (PPP_EVENT_AUTHENTICATION_FAILED,real_port_number,(ULONG) authentication_protocol);
							}
						}
					}
				}
			}
		}
   }
}

/****************************************************************************/
/*** Sowmya 7/3/96
*** This function checks if it is safe to initiate the CCP state machine.
**** NOTE : CCP is not initialised immediately with NCPs because
**** there was a problem of IP RIPs going without CCP compression
**** even though CCP was negotiated (timing problem). It causes 
**** BSD-LZW to go out of sync and so Unconfirmed Initial CIPX 
**** packets being lost.
***/
/****************************************************************************/
#if defined (CCP)
void	check_to_bring_ccp_up (USHORT real_port_number)
{
	USHORT protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;

	if ( ppp.port[real_port_number].state == PPP_OPENED_STATE )
	{
		for (protocol_stack_index = 0x0000; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
		{
#ifdef __MLPPP__
			sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else	/*__MLPPP__*/
			sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif	/*__MLPPP__*/

			if ((sptr_ncp->protocol_stack_id != ILLEGAL_STACK_ID) && 
				(sptr_ncp->enabled == TRUE) &&
				/* 3 stable states */
				(sptr_ncp->state != PPP_CLOSED_STATE) &&
				(sptr_ncp->state != PPP_STOPPED_STATE) &&
				(sptr_ncp->state != PPP_OPENED_STATE))
			{
				break;
			}
		}
		/* All NCPs are negotiated or disabled or rejected */
		if (protocol_stack_index == NUMBER_OF_NCP_STACKS)
		{
			ccp_state_machine_inited[real_port_number] = TRUE;

			(*ppp.ccp.fptr_execute_ccp_state_machine_function) (PPP_OPEN_EVENT, real_port_number, NULL, 0x0000);		

			bring_ccp_up (real_port_number, NULL, 0x0000, PPP_INITIAL_STATE);
		}
	}
}
#endif 


