/*	$Modname: vnipstr.h$  $version: 1.11$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 04/19/94 keyur
1.1 04/19/94 keyur Added support for version control.
1.2 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.3 06/15/94 keyur cosmetic changes.
1.4 06/20/94 ross length field for ipcp option was incorrect.  Courtesy of John.
1.5 07/18/94 ross general cleanup with options, added header compression, accm features.
1.6 08/08/94 ross working on adding version 2
1.7 08/11/94 ross adding rfc1570 lcp support
1.8 08/24/94 ross adding new ncps.
1.9 11/04/94 ross Testing against net manage ppp.	VJC testing.
1.10 12/13/94 ross connected to NT RAS with Netbios
1.11 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	IP_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN)	compression;
	BYTE_ENUM (BOOLEAN) 	address;
}	IP_OPTIONS_BOOLEAN;

typedef	struct	PPP_IP_CONFIGURATION
{
	IP_OPTIONS_BOOLEAN					enabled;

	IP_OPTIONS_BOOLEAN					remote_enabled;

	USHORT_ENUM (PPP_PROTOCOL_TYPE)	compression_protocol;

	BYTE										maximum_slot_id;	
	BYTE										compression_slot_id;

	USHORT_ENUM (PPP_PROTOCOL_TYPE)	remote_compression_protocol;

	ULONG				 						my_ip_address;
	ULONG				 						remote_ip_address;
} PPP_IP_CONFIGURATION;

typedef	struct	VAN_JACOBSON_HEADER_COMPRESSION_OPTION
{
	BYTE_ENUM (IPCP_OPTION_TYPE)			type;
	USHORT										length;

	USHORT_ENUM (PPP_PROTOCOL_TYPE)		ip_compression_protocol;
	BYTE											maximum_slot_id;
	BYTE											compressed_slot_id;
} VAN_JACOBSON_HEADER_COMPRESSION_OPTION;

typedef	struct	PPP_IPCP_MIBS
{
	ULONG	pppIpOperStatus;
	ULONG	pppIpLocalToRemoteCompressionProtocol;
	ULONG	pppIpRemoteToLocalCompressionProtocol;
	ULONG	pppIpRemoteMaxSlotId;
	ULONG	pppIpLocalMaxSlotId;

	ULONG	pppIpConfigAdminStatus;
	ULONG	pppIpConfigCompression;
} PPP_IPCP_MIBS;

typedef	struct IP_COMPRESSION_OPTION
{
	BYTE_ENUM (IPCP_OPTION_TYPE)	type;
	BYTE							length;
	USHORT_ENUM (PPP_PROTOCOL_TYPE)	ip_compression_protocol;
} IP_COMPRESSION_OPTION;

typedef	struct IP_ADDRESS_OPTION
{
	BYTE_ENUM (IPCP_OPTION_TYPE)	type;
	BYTE							length;
	ULONG							ip_address;
} IP_ADDRESS_OPTION;

typedef	struct	GENERIC_IPCP_OPTION
{
	BYTE_ENUM (IPCP_OPTION_TYPE)	type;
	BYTE							length;
} GENERIC_IPCP_OPTION;

typedef	union	UNION_IPCP_OPTIONS
{
	GENERIC_IPCP_OPTION							generic;
	IP_COMPRESSION_OPTION						ip_compression_option;
	IP_ADDRESS_OPTION								ip_address_option;
	VAN_JACOBSON_HEADER_COMPRESSION_OPTION	vj_compression_option;
}	UNION_IPCP_OPTIONS;

typedef	struct	IPCP_OPTIONS
{
	IP_COMPRESSION_OPTION	compression;
	IP_ADDRESS_OPTION			address;
}	IPCP_OPTIONS;

typedef	struct	IPCP_CONFIGURE_REQUEST
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;

	UNION_IPCP_OPTIONS				union_ipcp_options[VARIABLE_NUMBER];
} IPCP_CONFIGURE_REQUEST;

typedef	struct	IPCP_CONFIGURE_ACK
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;

	UNION_IPCP_OPTIONS				union_ipcp_options[VARIABLE_NUMBER];
} IPCP_CONFIGURE_ACK;

typedef	struct	IPCP_CONFIGURE_NAK
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;

	UNION_IPCP_OPTIONS				union_ipcp_options[VARIABLE_NUMBER];
} IPCP_CONFIGURE_NAK;

typedef	struct	IPCP_CONFIGURATION_REJECT
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;

	UNION_IPCP_OPTIONS				union_ipcp_options[VARIABLE_NUMBER];
} IPCP_CONFIGURATION_REJECT;

typedef	struct	IPCP_TERMINATE_REQUEST
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;
} IPCP_TERMINATE_REQUEST;

typedef	struct	IPCP_TERMINATE_ACK
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;
} IPCP_TERMINATE_ACK;

typedef	struct	IPCP_CODE_REJECT_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;
	BYTE  								rejected_packet[VARIABLE_NUMBER_OF_BYTES];

} IPCP_CODE_REJECT_PACKET;

typedef	struct	IPCP_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT 								length;

	UNION_IPCP_OPTIONS 				options;
} IPCP_PACKET;

typedef	union	UNION_IPCP_PACKET
{
	IPCP_PACKET						generic;
	IPCP_CONFIGURE_REQUEST		configure_request;
	IPCP_CONFIGURE_ACK			configuration_ack;
	IPCP_CONFIGURE_NAK			configuration_nak;
	IPCP_CONFIGURATION_REJECT	configuration_reject;
	IPCP_TERMINATE_REQUEST 		terminate_request;
	IPCP_TERMINATE_ACK			terminate_ack;
	IPCP_CODE_REJECT_PACKET		reject;
} UNION_IPCP_PACKET;

void initialize_ip_ncp (USHORT real_port_number);
