/*	$Modname: vnvppp.h$  $version: 1.20$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 04/12/94 keyur Initial Release.
1.1 04/12/94 keyur Added support for version control.
1.2 04/13/94 keyur Added support for NCP state machine
1.3 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.4 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.5 07/18/94 ross general cleanup with options, added header compression, accm features.
1.6 08/11/94 ross adding rfc1570 lcp support
1.7 08/29/94 ross changed the shorts to ulong decimals.  Since they are ulongs.  Courtesy of Danny.
1.8 09/06/94 ross
1.9 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.10 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.11 12/02/94 ross testing NT3.5 RAS
1.12 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.13 12/11/94 ross adding multiple value option support
1.14 12/13/94 ross connected to NT RAS with Netbios
1.15 01/26/95 ross changes for rwutils
1.16 01/30/95 ross removing duplicate configuration options
1.17 03/03/95 ross added up calls.
1.18 06/26/95 ross initial version of BCP
1.19 09/26/95 ross added changes for dynamic loading
1.20 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 RouterWare, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
void map_ipcp_wan_address (char *cptr_port_number_ip_address_string);
void map_ipcp_address (char *cptr_port_number_ip_address_string);
void add_ppp_option (char *cptr_port_number_and_option_string);
void add_remote_ppp_option (char *cptr_port_number_and_option_string);
/****************************************************************************/
CONFIGURATION_TABLE ppp_configuration_table =
{
	{TRUE},
	{
/* _________________________PPP_________________________________________________________ */

	/* PPP parameters */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port =",
		(ULONG) offsetof (PPP_CLASS,port[0].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Number of Ports =",
		(ULONG) offsetof (PPP_CLASS,number_of_ppp_ports),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

#if defined (CCP)
/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP CCP =",
		(ULONG) offsetof (PPP_CLASS,ccp.enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
#endif
/* _____________________________________________________________________________________________ */
#ifdef __MLPPP__
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP MultiLink =",
		(ULONG) offsetof (MLPPP_CLASS,enabled),
		(ULONG ) &mlppp,
		(ULONG) NULL

	},
#endif
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Number Of Configuration Requests =",
		(ULONG) offsetof (PPP_CLASS,maximum_number_of_configuration_requests),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
				
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Number Of Termination Requests =",
		(ULONG) offsetof (PPP_CLASS,maximum_number_of_termination_requests),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
				
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Number Of Unacknowledged Echo Requests =",
		(ULONG) offsetof (PPP_CLASS,maximum_number_of_unacknowledged_echo_requests),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
				
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Configuration Request Send Interval =",
		(ULONG) offsetof (PPP_CLASS,maximum_configuration_request_send_interval),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
				
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Termination Request Send Interval =",
		(ULONG) offsetof (PPP_CLASS,maximum_termination_request_send_interval),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
				
/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Echo Request Send Interval =",
		(ULONG) offsetof (PPP_CLASS,maximum_echo_request_send_interval),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
		"PPP Port User Name =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.user_name),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
		"PPP Port Remote User Name =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.remote_user_name),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
		"PPP Port User Password =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.password),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
		"PPP Port Remote User Password =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.remote_password),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		add_ppp_option,
		NULL,
		"PPP Port Option =",
		(ULONG) NULL,
		(ULONG) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		add_remote_ppp_option,
		NULL,
		"PPP Port Remote Option =",
		(ULONG) NULL,
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"PPP Maximum Configuration Request Backoff Interval =",
		(ULONG) offsetof (PPP_CLASS,maximum_configuration_request_backoff_interval),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"PPP Port Maximum Receive Unit =",
		(ULONG) offsetof (PPP_CLASS,port[0].lcp_mibs.pppLinkStatusLocalMRU),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS),
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"PPP Port Maximum Remote Receive Unit =",
		(ULONG) offsetof (PPP_CLASS,port[0].lcp_mibs.pppLinkStatusRemoteMRU),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS),
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Asynchronous Link =",
		(ULONG) offsetof (PPP_CLASS,port[0].async.enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"PPP Port Number Of Asynchronous Buffers =",
		(ULONG) offsetof (PPP_CLASS,port[0].async.number_of_buffers),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
				
/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"PPP Port Size Of Asynchronous Buffers =",
		(ULONG) offsetof (PPP_CLASS,port[0].async.size_of_buffers),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Send ID String =",
		(ULONG) offsetof (PPP_CLASS,port[0].configuration.enabled.send_id),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Send Time Remaining =",
		(ULONG) offsetof (PPP_CLASS,port[0].configuration.enabled.time_remaining),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
	(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_string,
		NULL,
		"PPP Port ID String =",
		(ULONG) offsetof (PPP_CLASS,port[0].configuration.tx_identification_message),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
#ifndef __MLPPP__
	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port IP =",
		(ULONG) offsetof (PPP_CLASS,port[0].ncp[PPP_IP_NCP_STACK_INDEX].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port IPX =",
		(ULONG) offsetof (PPP_CLASS,port[0].ncp[PPP_IPX_NCP_STACK_INDEX].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port STP =",
		(ULONG) offsetof (PPP_CLASS,port[0].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port APPLETALK =",
		(ULONG) offsetof (PPP_CLASS,port[0].ncp[PPP_APPLETALK_NCP_STACK_INDEX].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Netbios =",
		(ULONG) offsetof (PPP_CLASS,port[0].ncp[PPP_NETBIOS_NCP_STACK_INDEX].enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

#else  /* __MLPPP__ */

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port IP =",
		(ULONG) offsetof (MLPPP_CLASS,port[0].ncp[PPP_IP_NCP_STACK_INDEX].enabled),
		(ULONG ) &mlppp,
		sizeof (MLPPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port IPX =",
		(ULONG) offsetof (MLPPP_CLASS,port[0].ncp[PPP_IPX_NCP_STACK_INDEX].enabled),
		(ULONG ) &mlppp,
		sizeof (MLPPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port STP =",
		(ULONG) offsetof (MLPPP_CLASS,port[0].ncp[PPP_BRIDGING_NCP_STACK_INDEX].enabled),
		(ULONG ) &mlppp,
		sizeof (MLPPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port APPLETALK =",
		(ULONG) offsetof (MLPPP_CLASS,port[0].ncp[PPP_APPLETALK_NCP_STACK_INDEX].enabled),
		(ULONG ) &mlppp,
		sizeof (MLPPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Netbios =",
		(ULONG) offsetof (MLPPP_CLASS,port[0].ncp[PPP_NETBIOS_NCP_STACK_INDEX].enabled),
		(ULONG ) &mlppp,
		sizeof (MLPPP_PORT_CLASS)
	},

#endif /* __MLPPP__ */

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"PPP Port Time To Send LQR =",
		(ULONG) offsetof (PPP_CLASS,port[0].configuration.link_quality_reporting_interval),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS),
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf =",
		(ULONG) offsetof (PPP_CLASS,printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf Data =",
		(ULONG) offsetof (PPP_CLASS,data_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf Memory =",
		(ULONG) offsetof (PPP_CLASS,memory_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf LCP =",
		(ULONG) offsetof (PPP_CLASS,lcp_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf NCP =",
		(ULONG) offsetof (PPP_CLASS,ncp_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf Alarm =",
		(ULONG) offsetof (PPP_CLASS,alarm_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
#ifdef __MLPPP__
/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Printf MLPPP =",
		(ULONG) offsetof (PPP_CLASS,mlppp_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},
#endif
/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Initialization Breakpoint =",
		(ULONG) offsetof (PPP_CLASS,initialization_breakpoint),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"PPP Run Time Breakpoint =",
		(ULONG) offsetof (PPP_CLASS,runtime_breakpoint),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"PPP Port Periodic Authentication Timer =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.timeout),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
				
/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"PPP Port Maximum Number of Authentication Retries =",
		(ULONG) offsetof (PPP_CLASS,port[0].authentication.maximum_number_of_retries),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
				
#ifdef __DOD__
/* _____________________________________________________________________________________________ */
	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Connection Dial On Demand =",
		(ULONG) offsetof (PPP_CLASS,port[0].dial_on_demand),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"PPP Port Connection Idle Timer =",
		(ULONG) offsetof (PPP_CLASS,port[0].idle_timeout),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

#endif /*__DOD__*/

/* Sachin 19/07/1996 */
	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port Remote Port Client Only =",
		(ULONG) offsetof (PPP_CLASS, port[0].client_only),
		(ULONG) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* Sachin 19/07/1996 */

/* Kamalnath SLIP 07\03\1997 */
/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port SLIP =",
		(ULONG) offsetof (PPP_CLASS,port[0].slip_enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_enable,
		NULL,
		"PPP Port CSLIP =",
		(ULONG) offsetof (PPP_CLASS,port[0].cslip_enabled),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"PPP Port Number Of Slip Buffers =",
		(ULONG) offsetof (PPP_CLASS,port[0].slip_port.number_of_buffers),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
				
/* _____________________________________________________________________________________________ */

	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"PPP Port SLIP Maximum Transmit Unit =",
		(ULONG) offsetof (PPP_CLASS,port[0].slip_port.maximum_transmit_bufsize),
		(ULONG ) &ppp,
		sizeof (PPP_PORT_CLASS)
	},
/* _____________________________________________________________________________________________ */
   
   {
		NULL,
		(enum BOOLEAN *) TRUE,
		"SLIP Printf =",
		(ULONG) offsetof (PPP_CLASS,slip_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"SLIP Printf Data =",
		(ULONG) offsetof (PPP_CLASS,slip_data_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"SLIP Printf Memory =",
		(ULONG) offsetof (PPP_CLASS,slip_memory_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"SLIP Printf Alarm =",
		(ULONG) offsetof (PPP_CLASS,slip_alarm_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"SLIP Printf Event =",
		(ULONG) offsetof (PPP_CLASS,slip_event_printing_enabled),
		(ULONG ) &ppp,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
/* Kamalnath SLIP 07\03\1997 */

/* _____________________________________________________________________________________________ */

	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

	}	
};


