/*	$Modname: vpppastr.h$  $version: 1.6$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 08/24/94 ross
1.1 08/24/94 ross cleanup for release
1.2 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.3 12/02/94 ross testing NT3.5 RAS
1.4 03/03/95 ross added up calls.
1.5 03/10/95 ross general fixes.  see change.doc
1.6 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
typedef	struct	AUTHENTICATION_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN)	pap;
	BYTE_ENUM (BOOLEAN)	pap_server;
	BYTE_ENUM (BOOLEAN)	chap;
	BYTE_ENUM (BOOLEAN)	chap_server;
} AUTHENTICATION_OPTIONS_BOOLEAN;

typedef	struct	AUTHENTICATION_CONFIGURATION
{
	AUTHENTICATION_OPTIONS_BOOLEAN		enabled;

	char											user_name[NAME_SIZE];
	char											password[NAME_SIZE];

	char											chap_secret[NAME_SIZE];

	BYTE											challenge[MAX_CHALLENGE_VALUE_SIZE];

	BYTE											response[RESPONSE_VALUE_SIZE];
} AUTHENTICATION_CONFIGURATION;

typedef struct AUTHENTICATION_REQUEST_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT								length;
	
	BYTE									peer_id_length;
	char									peer_id[MAXIMUM_STRING_LENGTH];
	BYTE									peer_password_length;
	char									peer_password[MAXIMUM_STRING_LENGTH];
} AUTHENTICATION_REQUEST_PACKET;

typedef struct AUTHENTICATION_ACK_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT								length;
	
	BYTE									message_length;
	char									message[MAXIMUM_STRING_LENGTH];
} AUTHENTICATION_ACK_PACKET;

typedef struct AUTHENTICATION_NAK_PACKET
{
	PPP_HEADER							header;
	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE									id;
	USHORT								length;
	
	BYTE									message_length;
	char									message[MAXIMUM_STRING_LENGTH];
} AUTHENTICATION_NAK_PACKET;

typedef	struct	PAP_PACKET
{
	PPP_HEADER	ppp_header;

	LCP_HEADER	lcp_header;

} PAP_PACKET;

typedef	union	UNION_CHAP_VALUE
{
	BYTE	challenge[CHALLENGE_VALUE_SIZE];

	BYTE	response[RESPONSE_VALUE_SIZE];
} UNION_CHAP_VALUE;

typedef	struct	CHAP_PACKET
{
	PPP_HEADER			ppp_header;

	LCP_HEADER			lcp_header;

	BYTE					value_size;

	UNION_CHAP_VALUE	value;

	char					name[VARIABLE_NUMBER_OF_BYTES];

} CHAP_PACKET;

typedef	struct	PPP_AUTHENTICATION_STATISTICS
{
	ULONG	number_of_tx_packets;
	ULONG	number_of_tx_bytes;
	ULONG	number_of_rx_packets;
	ULONG	number_of_rx_bytes;
} PPP_AUTHENTICATION_STATISTICS;

typedef	struct	PPP_SECURITY_MIBS
{
	ULONG		pppSecurityConfigLink;
	ULONG		pppSecurityConfigPreference;
	BYTE		pppSecurityConfigProtocol[20];
	USHORT	pppSecurtiyConfigStatus;

	ULONG		pppSecuritySecretsLink;
	ULONG		pppSecuritySecretsIdIndex;
	USHORT	pppSecuritySecretsDirection;
	BYTE		pppSecuritySecretsProtocol[20];
	USHORT	pppSecuritySecretsIdentity;
	BYTE		pppSecuritySecretsSecret[20];
	USHORT	pppSecuritySecretsStatus;
}	PPP_SECURITY_MIBS;

typedef	struct	PPP_PORT_AUTHENTICATION_CLASS
{
	BYTE_ENUM (AUTHENTICATION_STATUS) 	status;
	BYTE_ENUM (BOOLEAN)					 	chap_authentication;
	PPP_AUTHENTICATION_STATISTICS			statistics;
	BYTE											challenge[MAX_CHALLENGE_VALUE_SIZE];
	BYTE											response[RESPONSE_VALUE_SIZE];
	BYTE											challenge_packet_id;
	ULONG											number_of_authentication_requests;
	char											user_name[NAME_SIZE];
	char											password[NAME_SIZE];
	char											remote_user_name[NAME_SIZE];
	char											remote_password[NAME_SIZE];
	char											chap_secret[NAME_SIZE];
	BYTE											id;

	USHORT										maximum_number_of_retries;
	USHORT										current_number_of_retries;

	ULONG											timer;
	ULONG											timeout;
	
	BYTE											rxed_authentication_ack;
	BYTE											txed_authentication_ack;

} PPP_PORT_AUTHENTICATION_CLASS;

typedef	struct	PPP_AUTHENTICATION_CLASS
{
	AUTHENTICATION_CONFIGURATION	configuration[MAXIMUM_NUMBER_OF_USERS];
	PPP_AUTHENTICATION_STATISTICS	statistics;
	PPP_SECURITY_MIBS					security_mibs;
	ULONG									maximum_number_of_authentication_requests;
	ULONG 								maximum_authentication_request_send_interval;
} PPP_AUTHENTICATION_CLASS;

void MDString (BYTE id,BYTE *bptr_secret,BYTE secret_length,BYTE *bptr_challenge_value,BYTE challenge_length,
	BYTE *bptr_response_value);

void send_lcp_chap_peer_packet (USHORT real_port_number,char *cptr_response,BYTE id);

void ppp_upper_layer_authentication_verification (USHORT real_port_number,ULONG vptr_chap_password_or_pap_pass_or_fail);

