/*	$Modname: vpppstat.h$  $version: 1.4$      $date: 12/13/94$   */
/*
* 	$lgb$
1.0 04/12/94 keyur Initial Release.
1.1 04/12/94 keyur Added support for version control.
1.2 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.3 05/02/94 keyur roradded ncp generic files and changed CLOSE/OPEN to UP/DOWN. Courtesy of John.
1.4 12/13/94 ross connected to NT RAS with Netbios
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
/*
      | State																		 State
      |    0         1         2         3         4         5		    6         7         8           9
Events| Initial   Starting  Closed    Stopped   Closing   Stopping Req-Sent  Ack-Rcvd  Ack-Sent    Opened
------+----------------------------------------------------------------------------------------------------
 Up   |    2     irc,scr/6     -         -         -         -		    -         -         -           -
 Down |    -         -         0       tls/1       0         1		    1         1         1         tld/1
 Open |  tls/1       1     irc,scr/6     3r        5r        5r	    6         7         8           9r
 Close|    0         0         2         2         4         4		irc,str/4 irc,str/4 irc,str/4 tld,irc,str/4
      |
  TO+ |    -         -         -         -       str/4     str/5	  scr/6     scr/6     scr/8         -
  TO- |    -         -         -         -       tlf/2     tlf/3	  tlf/3p    tlf/3p    tlf/3p        -
      |
 RCR+ |    -         -       sta/2 irc,scr,sca/8   4         5		  sca/8   sca,tlu/9   sca/8   tld,scr,sca/8
 RCR- |    -         -       sta/2 irc,scr,scn/6   4         5		  scn/6     scn/7     scn/6   tld,scr,scn/6
 RCA  |    -         -       sta/2     sta/3       4         5		  irc/7     scr/6x  irc,tlu/9   tld,scr/6x
 RCN  |    -         -       sta/2     sta/3       4         5		irc,scr/6   scr/6x  irc,scr/8   tld,scr/6x
      |
 RTR  |    -         -       sta/2     sta/3     sta/4     sta/5	  sta/6     sta/6     sta/6   tld,zrc,sta/5
 RTA  |    -         -         2         3       tlf/2     tlf/3	    6         6         8       tld,scr/6
      |
 RUC  |    -         -       scj/2     scj/3     scj/4     scj/5	  scj/6     scj/7     scj/8       scj/9
 RXJ+ |    -         -         2         3         4         5		    6         6         8           9
 RXJ- |    -         -       tlf/2     tlf/3     tlf/2     tlf/3	  tlf/3     tlf/3     tlf/3   tld,irc,str/5
      |
 RXR  |    -         -         2         3         4         5		    6         7         8         ser/9

*/
void set_ppp_state (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void null_state (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void this_layer_start (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void this_layer_finished (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void this_layer_up (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void this_layer_down (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void initialize_restart_counter (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
void zero_restart_counter (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);

PPP_STATE_MACHINE_TABLE	state_machine_table[NUMBER_OF_PPP_STATES][NUMBER_OF_PPP_EVENTS] = 
{
/* ------------------------------------------------------------------------ */
/*										     INITIAL   0                     			 */		 
/* ------------------------------------------------------------------------ */
{
/* UP	 								  	*/		{set_ppp_state,PPP_CLOSED_STATE},
/* DOWN								  	*/		{null_state,ILLEGAL_PPP_STATE},												 
/* OPEN								  	*/		{this_layer_start,PPP_STARTING_STATE},
/* CLOSE								   */		{set_ppp_state,PPP_INITIAL_STATE},
/* 									   */																		
/* TIMEOUT_WITH_COUNTER_GREATER  */		{null_state,ILLEGAL_PPP_STATE},												 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{null_state,ILLEGAL_PPP_STATE},												 
/* 									   */																		
/* RX									   */																		
/* 									   */																		
/* CONFIGURE_REQUEST_GOOD		   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REQUEST_BAD		   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_ACK					   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_NAK					   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REJECT				   */		{null_state,ILLEGAL_PPP_STATE},												 
/* TERMINATE_REQUEST				   */		{null_state,ILLEGAL_PPP_STATE},												 
/* TERMINATE_ACK					   */		{null_state,ILLEGAL_PPP_STATE},												 
/* UNKNOWN_CODE					   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CODE_REJECT_PERMITTED		   */		{null_state,ILLEGAL_PPP_STATE},												 
/* PROTOCOL_REJECT				   */		{null_state,ILLEGAL_PPP_STATE},												 
/* CODE_REJECT_CATASTROPHIC	   */		{null_state,ILLEGAL_PPP_STATE},												 
/* ECHO_REQUEST					   */		{null_state,ILLEGAL_PPP_STATE},
/* ECHO_REPLY						   */		{null_state,ILLEGAL_PPP_STATE},
/* DISCARD_REQUEST				   */		{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  STARTING	 1										 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* UP										*/		{initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,								 
(void (*) (USHORT,void *,USHORT,enum PPP_STATE))		send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/* DOWN									*/		{null_state,ILLEGAL_PPP_STATE},													 
/* OPEN								   */		{set_ppp_state,PPP_STARTING_STATE},
/* CLOSE								   */		{set_ppp_state,PPP_INITIAL_STATE},
/* 									   */																			
/* TIMEOUT_WITH_COUNTER_GREATER  */		{null_state,ILLEGAL_PPP_STATE},													 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{null_state,ILLEGAL_PPP_STATE},													 
/* 									   */		
/* RX									   */		
/* 									   */		
/* CONFIGURE_REQUEST_GOOD		   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REQUEST_BAD		   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_ACK					   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_NAK					   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REJECT				   */		{null_state,ILLEGAL_PPP_STATE},													 
/* TERMINATE_REQUEST				   */		{null_state,ILLEGAL_PPP_STATE},													 
/* TERMINATE_ACK					   */		{null_state,ILLEGAL_PPP_STATE},													 
/* UNKNOWN_CODE					   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CODE_REJECT_PERMITTED		   */		{null_state,ILLEGAL_PPP_STATE},													 
/* PROTOCOL_REJECT				   */		{null_state,ILLEGAL_PPP_STATE},													 
/* CODE_REJECT_CATASTROPHIC	   */		{null_state,ILLEGAL_PPP_STATE},													 
/* ECHO_REQUEST					   */		{null_state,ILLEGAL_PPP_STATE},													 
/* ECHO_REPLY						   */		{null_state,ILLEGAL_PPP_STATE},
/* DISCARD_REQUEST				   */		{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  CLOSED		 2										 */
/* ------------------------------------------------------------------------ */
{
/* UP										*/	  	{null_state,ILLEGAL_PPP_STATE},        
/* 										*/		
/* DOWN									*/	  	{set_ppp_state,PPP_INITIAL_STATE},
/* OPEN									*/	  	{initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
(void (*) (USHORT,void *,USHORT,enum PPP_STATE))	  	send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/* 										*/
/* CLOSE									*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* 										*/																		 
/* TIMEOUT_WITH_COUNTER_GREATER	*/	  	{null_state,ILLEGAL_PPP_STATE},													 
/* TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{null_state,ILLEGAL_PPP_STATE},													 
/* 										*/																		 
/* RX										*/																		 
/* 										*/																		 
/* CONFIGURE_REQUEST_GOOD			*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REQUEST_BAD			*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REQUEST_BAD_OPTION	*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_ACK						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_NAK						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REJECT					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* TERMINATE_REQUEST					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSED_STATE},
/* TERMINATE_ACK						*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* UNKNOWN_CODE						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_CLOSED_STATE},
/* CODE_REJECT_PERMITTED			*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* PROTOCOL_REJECT					*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* CODE_REJECT_CATASTROPHIC		*/	  	{this_layer_finished,PPP_CLOSED_STATE},
/* ECHO_REQUEST						*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* ECHO_REPLY							*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/* DISCARD_REQUEST					*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  STOPPED	 3										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{null_state,ILLEGAL_PPP_STATE},
/*											*/	
/*	DOWN									*/	  	{this_layer_start,PPP_STARTING_STATE},
/* OPEN									*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	CLOSE									*/	  	{set_ppp_state,PPP_CLOSED_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_ack,PPP_ACK_SENT_STATE},
/*											*/
/*	CONFIGURE_REQUEST_BAD			*/	  	{initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_ACK_SENT_STATE},
/*											*/
/*	CONFIGURE_ACK						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPED_STATE},
/*	CONFIGURE_NAK						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPED_STATE},
/*	CONFIGURE_REJECT					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPED_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPED_STATE},
/*	TERMINATE_ACK						*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_STOPPED_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	ECHO_REPLY							*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	DISCARD_REQUEST					*/	  	{set_ppp_state,PPP_STOPPED_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*								 CLOSING					 4										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{null_state,ILLEGAL_PPP_STATE},
/*											*/		
/*	DOWN									*/	  	{set_ppp_state,PPP_INITIAL_STATE},
/* OPEN									*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CLOSE									*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_CLOSING_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{this_layer_finished,PPP_CLOSED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_ACK						*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_NAK						*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REJECT					*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_CLOSING_STATE},
/*	TERMINATE_ACK						*/	  	{this_layer_finished,PPP_CLOSED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_CLOSING_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{this_layer_finished,PPP_CLOSED_STATE},
/*	ECHO_REQUEST						*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	ECHO_REPLY							*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	DISCARD_REQUEST					*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*								STOPPING					 5										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{null_state,ILLEGAL_PPP_STATE},
/*											*/			
/*	DOWN									*/	  	{set_ppp_state,PPP_INITIAL_STATE},
/* OPEN									*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CLOSE									*/	  	{set_ppp_state,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_STOPPING_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_ACK						*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_NAK						*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REJECT					*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPING_STATE},
/*	TERMINATE_ACK						*/	  	{this_layer_finished,PPP_STOPPED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_STOPPING_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	ECHO_REPLY							*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	DISCARD_REQUEST					*/	  	{set_ppp_state,PPP_STOPPING_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  	{null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  	{null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*										REQUEST_SENT	  6										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ppp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	CLOSE									*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_reject,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_ACK						*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  set_ppp_state,PPP_ACK_RECEIVED_STATE},
/*											*/
/*	CONFIGURE_NAK                 */   {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	ECHO_REPLY							*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	DISCARD_REQUEST					*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  {null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  {null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*									 	 ACK_RECEIVED		7									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ppp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ppp_state,PPP_ACK_RECEIVED_STATE},
/*	CLOSE									*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_ack,NO_CHANGE_TO_PPP_STATE,
/*											*/	  this_layer_up,PPP_OPENED_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_reject,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_ACK						*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_NAK                 */     {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_ACK_RECEIVED_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ppp_state,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/	  {set_ppp_state,PPP_ACK_RECEIVED_STATE},
/*	ECHO_REPLY							*/	  {set_ppp_state,PPP_ACK_RECEIVED_STATE},
/*	DISCARD_REQUEST					*/	  {set_ppp_state,PPP_ACK_RECEIVED_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  {null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  {null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  ACK_SENT		 8									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ppp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	CLOSE									*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_ACK_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_reject,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_ACK						*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  this_layer_up,PPP_OPENED_STATE},
/*	CONFIGURE_NAK                 */   {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_ACK_SENT_STATE},
/*	TERMINATE_REQUEST					*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_ACK_SENT_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	ECHO_REPLY							*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	DISCARD_REQUEST					*/	  {set_ppp_state,PPP_ACK_SENT_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/	  {null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/	  {null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											OPENED			 9									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/		{null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	DOWN									*/		{this_layer_down,PPP_STARTING_STATE},
/*	OPEN									*/		{set_ppp_state,PPP_OPENED_STATE},
/*	CLOSE									*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/		{null_state,ILLEGAL_PPP_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/		{null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_nak,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_reject,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_ACK						*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	CONFIGURE_NAK						*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	TERMINATE_REQUEST					*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		zero_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_ack,PPP_STOPPING_STATE},
/*											*/
/*	TERMINATE_ACK						*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	UNKNOWN_CODE						*/		{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_code_reject,PPP_OPENED_STATE},
/*	CODE_REJECT_PERMITTED			*/		{set_ppp_state,PPP_OPENED_STATE},
/*	PROTOCOL_REJECT					*/		{set_ppp_state,PPP_OPENED_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/		{this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_termination_request,PPP_STOPPING_STATE},
/*											*/
/*	ECHO_REQUEST						*/		{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_echo_reply,PPP_OPENED_STATE},
/*	ECHO_REPLY							*/		{set_ppp_state,PPP_OPENED_STATE},
/*	DISCARD_REQUEST					*/		{set_ppp_state,PPP_OPENED_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{(void (*) (USHORT,void *,USHORT,enum PPP_STATE))send_lcp_echo_request,PPP_OPENED_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{this_layer_down,PPP_STOPPING_STATE}
}
};

