/*	$Modname: vpppstr.h$  $version: 1.43$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/10/93 ross Initial Release.
1.1 01/05/94 ross Added support for version control
1.2 01/05/94 keyur Split it into vlcpstr.h,vncpstr.h and vpppstr.h
1.3 01/20/94 keyur Added some parameters into PPP_CLASS and PP_PORT_CLASS
1.4 01/28/94 keyur Added some more parameters into PPP_CLASS and PPP_PORT_CLASS.
1.5 02/01/94 keyur Added some more parameters into PPP_CLASS and PPP_PORT_CLASS.
1.6 02/02/94 keyur Added some more parameters into PPP_CLASS and PPP_PORT_CLASS.
1.7 02/22/94 keyur Added some more parameters into PPP_CLASS and PPP_PORT_CLASS.
1.8 03/09/94 keyur Added some more parameters into PPP_CLASS and PPP_PORT_CLASS.
1.9 03/09/94 keyur There is no major change to this release.
1.10 03/15/94 keyur Deleted swap extern declaration.
1.11 03/23/94 keyur Cosmetic Changes.
1.12 03/26/94 keyur Added and tested Asynchronous Support and ATCP for Appletalk Support
1.13 03/26/94 keyur Ran Lint compiler and code style program and got rid of unnecessary warnings
1.14 04/04/94 keyur Cosmetic Changes while documenting
1.15 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.16 04/13/94 keyur Added support for NCP state machine
1.17 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.18 04/19/94 keyur Cosmetic Changes
1.19 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.20 06/15/94 keyur added constant for 256.
1.21 07/18/94 ross general cleanup with options, added header compression, accm features.
1.22 08/08/94 ross working on adding version 2
1.23 08/11/94 ross adding rfc1570 lcp support
1.24 08/15/94 ross partial compression implementation.
1.25 08/24/94 ross adding new ncps.
1.26 08/30/94 ross
1.27 09/06/94 ross
1.28 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.29 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.30 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.31 12/02/94 ross testing NT3.5 RAS
1.32 12/03/94 ross testing Windows 95 RAS
1.33 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.34 12/11/94 ross adding multiple value option support
1.35 12/13/94 ross connected to NT RAS with Netbios
1.36 12/13/94 ross connected to NT RAS with Netbios
1.37 01/26/95 ross changes for rwutils
1.38 01/30/95 ross removing duplicate configuration options
1.39 02/27/95 ross dynamic load changes including lsl_control.
1.40 03/03/95 ross added up calls.
1.41 03/10/95 ross general fixes.  see change.doc
1.42 06/26/95 ross initial version of BCP
1.43 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/

/* User database handler */
#include <udb.h>


/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	PPP_STATE_MACHINE_TABLE
{
	void (*fptr_state_function) (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
	BYTE_ENUM (PPP_STATE) end_state;

	void (*fptr_state_function_1) (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
	BYTE_ENUM (PPP_STATE) end_state_1;

	void (*fptr_state_function_2) (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
	BYTE_ENUM (PPP_STATE) end_state_2;

} PPP_STATE_MACHINE_TABLE;

typedef	union	UNION_PPP_MIBS
{
	PPP_IPCP_MIBS	ipcp;
} UNION_PPP_MIBS;

typedef	union	UNION_NCP_CONFIGURATION
{
	PPP_IP_CONFIGURATION					ipcp;
	PPP_IPX_CONFIGURATION				ipxcp;
	PPP_APPLETALK_CONFIGURATION		atcp;
	PPP_NETBIOS_CONFIGURATION			nbfcp;
	PPP_BRIDGING_CONFIGURATION			bcp;
} UNION_NCP_CONFIGURATION;

typedef	struct	RECEIVE_OPTION_FUNCTIONS
{
	enum TEST (*fptr_process_receive_options[NUMBER_OF_LCP_OPTIONS]) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class);
} RECEIVE_OPTION_FUNCTIONS;

typedef	struct	PPP_NCP_CLASS
{
	char													name[30];

	BYTE_ENUM (PROTOCOL_STACK_TYPE)				type;

	USHORT_ENUM (PPP_PROTOCOL_TYPE)				ppp_protocol_stack_type;
	USHORT_ENUM (PPP_PROTOCOL_TYPE)				ncp_protocol_type;

	BYTE_ENUM (BOOLEAN)								enabled;
#ifdef RAS
	BYTE_ENUM (BOOLEAN)								configured;
#endif

	BYTE_ENUM (PPP_STATE)							state;
	BYTE_ENUM (PPP_STATE)							old_state;

	ULONG 												protocol_stack_id;

	RECEIVE_OPTION_FUNCTIONS						receive;				
	RECEIVE_OPTION_FUNCTIONS						receive_nak;

	USHORT												number_of_protocol_rejects_rxed; /* might be needed for compatibility, see ppptimer.c */
	void 													(*fptr_protocol_reject_alarm) (USHORT real_port_number,
																struct PPP_NCP_CLASS *sptr_ncp);

	void 													(*fptr_protocol_stack_up) (USHORT virtual_port_number,
																struct PPP_NCP_CLASS *sptr_ncp);

	USHORT												number_of_configuration_requests;
	USHORT												number_of_termination_requests;

	ULONG													configuration_request_send_interval;
	ULONG													termination_request_send_interval;

	PPP_NCP_STATISTICS								statistics;

	OPTION_LISTS										option_lists;

	UNION_PPP_MIBS										mib;

	BYTE													last_request_id;
	BYTE													sequence_number_of_last_packet_rxed;

	BYTE 													last_txed_configuration_request_packet[DEFAULT_MAXIMUM_MRU];
	USHORT												length_of_last_txed_request;

	USHORT												real_port_number;
} PPP_NCP_CLASS;

typedef	struct	NCP_STATE_MACHINE_TABLE
{
	void (*fptr_state_function) (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,
		USHORT number_of_bytes,enum PPP_STATE end_state);

	BYTE_ENUM (PPP_STATE) end_state;

	void (*fptr_state_function_1) (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,
		USHORT number_of_bytes,enum PPP_STATE end_state);

	BYTE_ENUM (PPP_STATE) end_state_1;

	void (*fptr_state_function_2) (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,
		USHORT number_of_bytes,enum PPP_STATE end_state);

	BYTE_ENUM (PPP_STATE) end_state_2;

} NCP_STATE_MACHINE_TABLE;

#ifdef WAN_CRC_DEFINE
	#define WAN_CRC_DEFINE
typedef	struct	WAN_CRC
{
	USHORT crc;
} WAN_CRC;
#endif

typedef	struct	PPP_PACKET_WITH_MAC_HEADER
{
	BYTE				filler[10];

	PPP_HEADER		header;

	BYTE				protocol_data[1];
} PPP_PACKET_WITH_MAC_HEADER;

typedef	struct	PPP_PACKET
{
	PPP_HEADER							header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;

	BYTE									id;
	USHORT 								length;

	BYTE									data[VARIABLE_NUMBER_OF_BYTES];
} PPP_PACKET;

typedef	struct	PPP_PACKET_WITH_COMPRESSED_ADDRESS_AND_CONTROL
{
	USHORT_ENUM (PPP_PROTOCOL_TYPE)	protocol_type;

	BYTE										data[VARIABLE_NUMBER_OF_BYTES];
} PPP_PACKET_WITH_COMPRESSED_ADDRESS_AND_CONTROL;

typedef	struct	PPP_PACKET_WITH_COMPRESSED_PROTOCOL_FIELD
{
	BYTE								hdlc_address;
	BYTE_ENUM (LLC_FRAME_TYPE)	hdlc_control;

	BYTE								protocol_type;

	BYTE								data[VARIABLE_NUMBER_OF_BYTES];
} PPP_PACKET_WITH_COMPRESSED_PROTOCOL_FIELD;

typedef	struct	HEADER_COMPRESSED_PPP_PACKET
{
	BYTE	protocol_type;

	BYTE	data[VARIABLE_NUMBER_OF_BYTES];
} HEADER_COMPRESSED_PPP_PACKET;


#ifdef __MLPPP__
typedef	struct	MLPPP_HEADER
{
#ifndef BIG_ENDIAN
	ULONG		sequence_number:24;
	ULONG		filler:6;
	ULONG		end:1;
	ULONG		begin:1;
#else
	ULONG		begin:1;			/* not sure of this */
	ULONG		end:1;
	ULONG		filler:6;
	ULONG		sequence_number:24;
#endif
} MLPPP_HEADER;

typedef	struct	MULTILINK_FRAGMENT
{
	PPP_HEADER							header;

	MLPPP_HEADER						mlppp_header;

	BYTE									data[VARIABLE_NUMBER_OF_BYTES];
} MULTILINK_FRAGMENT;
#endif

typedef	union	UNION_PPP_PACKET
{
	PPP_PACKET_WITH_MAC_HEADER								mac_header;
	PPP_PACKET													generic;

	PPP_PACKET_WITH_COMPRESSED_ADDRESS_AND_CONTROL	compressed_address_and_control;
	PPP_PACKET_WITH_COMPRESSED_PROTOCOL_FIELD			compressed_protocol;
	HEADER_COMPRESSED_PPP_PACKET							compressed_address_control_and_protocol;

	LCP_PACKET													lcp;

	UNION_IPXCP_PACKET										ipxcp;
	UNION_IPCP_PACKET											ipcp;
	UNION_ATCP_PACKET											atcp;
#ifdef __MLPPP__
	MULTILINK_FRAGMENT					               multilink_fragment;
#endif

} UNION_PPP_PACKET;

typedef	struct	PPP_STATISTICS
{
	ULONG						number_of_tx_packets;
	ULONG						number_of_tx_bytes;

	PPP_NCP_STATISTICS	ncp_statistics;
	PPP_LCP_STATISTICS	lcp_statistics;
} PPP_STATISTICS;

typedef	struct	ASYNC_BUFFER_LIST_ENTRY
{
	LINK		links;

	BYTE		data[VARIABLE_NUMBER_OF_BYTES];

} ASYNC_BUFFER_LIST_ENTRY;

typedef	struct	PPP_ASYNC_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
	USHORT								number_of_buffers;
	USHORT								size_of_buffers;
	USHORT								actual_size_of_tx_buffer;
	LINK									buffer_free_list;
} PPP_ASYNC_PORT_CLASS;

/* Kamalnath SLIP 06\03\1997 */
typedef	struct	SLIP_TX_BUFFER_LIST_ENTRY
{
	LINK		links;

	BYTE		data[VARIABLE_NUMBER_OF_BYTES]; 

} SLIP_TX_BUFFER_LIST_ENTRY;

typedef	struct	SLIP_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
	USHORT								number_of_buffers;
	USHORT								maximum_transmit_bufsize;
	USHORT								actual_size_of_tx_buffer;
	LINK									buffer_free_list;
} SLIP_PORT_CLASS;
/* Kamalnath SLIP 06\03\1997 */

typedef	struct	SERIAL_DRIVER_CLASS
{
	char										name[20];

	BYTE_ENUM (SERIAL_DRIVER_TYPE)	type;

	enum TEST 								(*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_data,
													USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN device_driver_buffer,
													void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer),
													void *vptr_async_buffer);

	void 										(*fptr_tx_complete) (USHORT port_number);

	enum BOOLEAN 							(*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed);

	void 										(*fptr_timer_routine) (void);

	enum TEST 								(*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,
													ULONG parameter_1);

	void 										(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer);

} SERIAL_DRIVER_CLASS;

typedef	struct	PPP_NETBIOS_CLASS
{
	enum TEST 					(*fptr_name_projection_received) (USHORT port_number,void *vptr_projected_names,
										USHORT number_of_bytes_in_option);
	enum TEST 					(*fptr_peer_information_received) (USHORT port_number,void *vptr_projected_names,
										USHORT number_of_bytes_in_option);
	enum TEST 					(*fptr_multicast_filtering_option_received) (USHORT port_number,void *vptr_projected_names,
										USHORT number_of_bytes_in_option);
	enum TEST 					(*fptr_include_mac_address_option_received) (USHORT port_number,void *vptr_projected_names,
										USHORT number_of_bytes_in_option);
} PPP_NETBIOS_CLASS;

typedef	struct	PPP_VJ_COMPRESSION_CLASS
{
	BYTE (*fptr_compress_tcp_header) (USHORT real_port_number,void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes);
	BYTE (*fptr_get_maximum_connection_states) (USHORT real_port_number);
	enum BOOLEAN (*fptr_get_compress_connection_id) (USHORT real_port_number);
	void (*fptr_uncompress_tcp_header) (USHORT receive_port_number, void **ptr_to_sptr_ip_packet,USHORT *usptr_number_of_bytes,
		BYTE type_of_packet);
} PPP_VJ_COMPRESSION_CLASS;

typedef	struct	PPP_IPX_COMPRESSION_CLASS
{
	void (*fptr_compress_ipx_header) (USHORT real_port_number,void **ptr_to_sptr_ip_packet, USHORT *usptr_number_of_bytes);
	BYTE (*fptr_get_maximum_connection_states) (USHORT real_port_number);
	enum BOOLEAN (*fptr_get_compress_connection_id) (USHORT real_port_number);
	enum TEST (*fptr_uncompress_ipx_header) (USHORT receive_port_number, void **ptr_to_sptr_ip_packet,
		USHORT *usptr_number_of_bytes);
} PPP_IPX_COMPRESSION_CLASS;

#if defined (CCP)
	typedef struct PPP_CCP_CLASS
	{ 
		BYTE_ENUM (BOOLEAN)				enabled;

		OPTION_LISTS						*(*fptr_get_ccp_option_lists_function) (USHORT real_port_number);

		void 									(*fptr_execute_ccp_state_machine_function) (enum PPP_EVENT ppp_event, USHORT real_port_number, 
													void *vptr_packet, USHORT number_of_bytes);

		PPP_PACKET_WITH_MAC_HEADER		*(*(*fptr_get_sender_compression_function_function) (USHORT real_port_number)) 
														(USHORT real_port_number, USHORT protocol_virtual_port_number, 
														enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, 
														USHORT *usptr_ppp_packet_length,	void (**fptr_tx_completion) (USHORT port_number, 
														void *vptr_buffer));
		UNION_PPP_PACKET 					*(*(*fptr_get_receiver_decompression_function_function) (USHORT real_port_number)) 
													(USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, 
													USHORT *usptr_ppp_packet_length);

		enum PPP_STATE 					(*fptr_get_ccp_state_function) (USHORT real_port_number); 

		enum BOOLEAN 						(*fptr_get_sender_compression_database_initialization_status_function) 
													(USHORT real_port_number);
		enum BOOLEAN 						(*fptr_get_receiver_compression_database_initialization_status_function) 
													(USHORT real_port_number);

		void 									(*fptr_ccp_timer_routine) (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
													ULONG maximum_configuration_request_send_interval, 
													ULONG maximum_number_of_configuration_requests, 
													ULONG maximum_termination_request_send_interval,
													ULONG maximum_number_of_termination_requests);

		enum TEST 							(*fptr_ccp_packet_received_function) (USHORT real_port_number, void *vptr_ccp_rx_packet, 
													USHORT number_of_bytes_rxed);
		
		BYTE 									(*fptr_get_last_id_of_ccp_packet_sent_function) (USHORT real_port_number);
		enum BOOLEAN						(*fptr_get_ccp_port_status_function) (USHORT real_port_number);
	} PPP_CCP_CLASS;

	typedef struct PPP_CCP_PORT_CLASS
	{
		OPTION_LISTS option_lists;
	} PPP_CCP_PORT_CLASS;

#endif

typedef	struct	PPP_PORT_CLASS
{
	BYTE_ENUM (PPP_STATE)	  						state;

	BYTE_ENUM (PPP_STATE) 							old_state;

	ULONG													device_driver_id;

	BYTE_ENUM (BOOLEAN) 								enabled;

	LCP_CONFIGURATION									configuration;

	PPP_PORT_AUTHENTICATION_CLASS					authentication;

#ifndef __MLPPP__
	PPP_NCP_CLASS										ncp[NUMBER_OF_NCP_STACKS];
#else
	USHORT												virtual_port_number;
#endif

	OPTION_LISTS										option_lists;

	PPP_ASYNC_PORT_CLASS								async;

	LINK_QUALITY_REPORT								most_recently_received_LQR;
	LINK_QUALITY_COUNTERS							link_quality_counters;

/* Kamalnath 05\03\1997 */
	SLIP_PORT_CLASS									slip_port;
/* Kamalnath 05\03\1997 */

	ECHO_REQUEST_PACKET								echo_request_packet;
	ECHO_REPLY_PACKET									echo_reply_packet;

	BYTE													last_id_of_lcp_packet_sent;
	BYTE													last_id_of_pap_packet_sent;
	BYTE													last_id_of_chap_challenge_packet_sent;
	BYTE													last_id_of_chap_response_packet_sent;

	SERIAL_DRIVER_CLASS								serial_driver;

#ifndef __MLPPP__
	PPP_IPX_COMPRESSION_CLASS						cipx;
	PPP_VJ_COMPRESSION_CLASS						vjc;
#endif

	USHORT												number_of_configuration_requests;
	USHORT												number_of_echo_requests;
	USHORT												number_of_lcp_termination_requests;

	USHORT  												configuration_request_backoff_interval;
	USHORT  												configuration_request_send_interval;
	USHORT  												termination_request_send_interval;
	USHORT  												echo_request_send_interval;

	USHORT  												time_to_send_LQR;

	PPP_STATISTICS										statistics;
	PPP_LCP_STATISTICS								lcp_statistics;

	PPP_LCP_MIBS										lcp_mibs;

	LCP_CONFIGURE_REQUEST	 						last_txed_lcp_configuration_request_packet;
	USHORT												length_of_last_txed_lcp_packet;

	LCP_CONFIGURE_REQUEST	 						last_rxed_lcp_configuration_request_packet;
	USHORT												length_of_last_rxed_lcp_configuration_packet;

	void 													(*fptr_lcp_packet_received[NUMBER_OF_PPP_CONTROL_CODES])
																(USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
																USHORT number_of_bytes_rxed);

	enum BOOLEAN										(*fptr_negotiation_error) (USHORT port_number,
																OPTION_LIST_ENTRY *sptr_received_option,OPTION_LISTS sptr_option_lists);

	RECEIVE_OPTION_FUNCTIONS						receive;				
	RECEIVE_OPTION_FUNCTIONS						receive_nak;

	USHORT												number_of_bytes_rejected;
	USHORT												port_number;

	ULONG													time_remaining_in_seconds;
	ULONG													time_remaining_timer;
	ULONG													time_remaining_timeout;

	ULONG													client_time_remaining;

	BYTE													id_sequence_number;

/* Kamalanath 16\08\1996 */	
	BYTE													dhcp_status;
/* Kamalanath 16\08\1996 */	

#if defined (CCP)
	PPP_CCP_PORT_CLASS								ccp;
#endif

#ifdef __DOD__
	ULONG													idle_timer;

	ULONG													idle_timeout;

	BYTE_ENUM (BOOLEAN)						dial_on_demand;
	
	BYTE_ENUM (PPP_CONNECT_STATE)					connect_state;
	BYTE_ENUM (BOOLEAN)						answering;
#endif /* __DOD__ */

/* Sachin 25/06/1996 */
	BYTE_ENUM (BOOLEAN)      client_only ;
	RAS_USER_DATABASE_RECORD ras_user_database_record ;
/* Sachin 25/06/1996 */

/* Kamalnath 05\03\1997 */
	BYTE_ENUM (BOOLEAN)						slip_enabled;
	BYTE_ENUM (BOOLEAN)						slip_on;
	BYTE_ENUM (BOOLEAN)						cslip_enabled;
	BYTE_ENUM (BOOLEAN)						slip_compression_on;
/* Kamalnath 05\03\1997 */

/* Sachin 02/09/1996 */
	BYTE_ENUM (BOOLEAN)      callback_on ;
/* Sachin 02/09/1996 */

/* Sachin 14/07/1997 */
   BYTE_ENUM (BOOLEAN) accm_applied ;		
/* Sachin 14/07/1997 */

   BYTE   dod_active ; /* Ravi on 10-jan-2000 */		

} PPP_PORT_CLASS;

typedef	struct	PPP_CLASS
{
/*	PPP_AUTHENTICATION_CLASS	authentication; */

#if defined (CCP)
	PPP_CCP_CLASS					ccp;
#endif
	USHORT							number_of_lan_ports;
	ULONG								number_of_ppp_ports;
	USHORT							starting_port_number;
	USHORT							number_of_protocol_stacks_loaded;
	USHORT							number_of_ports_times_number_of_protocol_stacks_loaded;

	ULONG								maximum_number_of_configuration_requests;
	ULONG								maximum_number_of_termination_requests;
	ULONG								maximum_number_of_unacknowledged_echo_requests;
	ULONG								maximum_configuration_request_send_interval;
	ULONG								maximum_termination_request_send_interval;
	ULONG								maximum_echo_request_send_interval;
	ULONG  	  						maximum_configuration_request_backoff_interval;

	ULONG 							timer;
	ULONG								clock_ticks_per_second;
	ULONG								_1_second_counter;

	PPP_NETBIOS_CLASS				netbios;

	void								(*fptr_ncp_packet_rxed[NUMBER_OF_PPP_CONTROL_CODES]) (USHORT real_port_number,
											UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes,struct PPP_NCP_CLASS *sptr_ncp);

	void 								(*fptr_alarm_function) (enum PPP_ALARM_TYPE error_type,
											USHORT port_number,ULONG parameter_1,ULONG parameter_2);

	void 								(*fptr_snmp_trap) (void);

	ULONG 							(*fptr_event_upcall) (USHORT real_port_number,USHORT event,...);

	BYTE_ENUM (BOOLEAN)			printing_enabled;
	BYTE_ENUM (BOOLEAN)			data_printing_enabled;
	BYTE_ENUM (BOOLEAN)			memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)			ncp_printing_enabled;
	BYTE_ENUM (BOOLEAN)			lcp_printing_enabled;
	BYTE_ENUM (BOOLEAN)			alarm_printing_enabled;
#ifdef __MLPPP__
	BYTE_ENUM (BOOLEAN)			mlppp_printing_enabled;
#endif

/* Kamalnath 24\04\1997 */	
	BYTE_ENUM (BOOLEAN)			slip_printing_enabled;
	BYTE_ENUM (BOOLEAN)			slip_data_printing_enabled;
	BYTE_ENUM (BOOLEAN)			slip_memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)			slip_alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN)			slip_event_printing_enabled;
/* Kamalnath 24\04\1997 */	

	BYTE_ENUM (BOOLEAN)			initialization_breakpoint;
	BYTE_ENUM (BOOLEAN)			runtime_breakpoint;

	PPP_PORT_CLASS					port[MAXIMUM_NUMBER_OF_PPP_PORTS];
} PPP_CLASS;

#ifdef GLOBAL_FILE

	USHORT checksum_table[DEFAULT_FCS_TABLE_SIZE] =
		{
    		0x0000, 0x1189, 0x2312, 0x329b, 0x4624, 0x57ad, 0x6536, 0x74bf,
    		0x8c48, 0x9dc1, 0xaf5a, 0xbed3, 0xca6c, 0xdbe5, 0xe97e, 0xf8f7,
    		0x1081, 0x0108, 0x3393, 0x221a, 0x56a5, 0x472c, 0x75b7, 0x643e,
    		0x9cc9, 0x8d40, 0xbfdb, 0xae52, 0xdaed, 0xcb64, 0xf9ff, 0xe876,
    		0x2102, 0x308b, 0x0210, 0x1399, 0x6726, 0x76af, 0x4434, 0x55bd,
    		0xad4a, 0xbcc3, 0x8e58, 0x9fd1, 0xeb6e, 0xfae7, 0xc87c, 0xd9f5,
    		0x3183, 0x200a, 0x1291, 0x0318, 0x77a7, 0x662e, 0x54b5, 0x453c,
    		0xbdcb, 0xac42, 0x9ed9, 0x8f50, 0xfbef, 0xea66, 0xd8fd, 0xc974,
    		0x4204, 0x538d, 0x6116, 0x709f, 0x0420, 0x15a9, 0x2732, 0x36bb,
    		0xce4c, 0xdfc5, 0xed5e, 0xfcd7, 0x8868, 0x99e1, 0xab7a, 0xbaf3,
    		0x5285, 0x430c, 0x7197, 0x601e, 0x14a1, 0x0528, 0x37b3, 0x263a,
    		0xdecd, 0xcf44, 0xfddf, 0xec56, 0x98e9, 0x8960, 0xbbfb, 0xaa72,
    		0x6306, 0x728f, 0x4014, 0x519d, 0x2522, 0x34ab, 0x0630, 0x17b9,
    		0xef4e, 0xfec7, 0xcc5c, 0xddd5, 0xa96a, 0xb8e3, 0x8a78, 0x9bf1,
    		0x7387, 0x620e, 0x5095, 0x411c, 0x35a3, 0x242a, 0x16b1, 0x0738,
    		0xffcf, 0xee46, 0xdcdd, 0xcd54, 0xb9eb, 0xa862, 0x9af9, 0x8b70,
    		0x8408, 0x9581, 0xa71a, 0xb693, 0xc22c, 0xd3a5, 0xe13e, 0xf0b7,
    		0x0840, 0x19c9, 0x2b52, 0x3adb, 0x4e64, 0x5fed, 0x6d76, 0x7cff,
    		0x9489, 0x8500, 0xb79b, 0xa612, 0xd2ad, 0xc324, 0xf1bf, 0xe036,
    		0x18c1, 0x0948, 0x3bd3, 0x2a5a, 0x5ee5, 0x4f6c, 0x7df7, 0x6c7e,
    		0xa50a, 0xb483, 0x8618, 0x9791, 0xe32e, 0xf2a7, 0xc03c, 0xd1b5,
    		0x2942, 0x38cb, 0x0a50, 0x1bd9, 0x6f66, 0x7eef, 0x4c74, 0x5dfd,
    		0xb58b, 0xa402, 0x9699, 0x8710, 0xf3af, 0xe226, 0xd0bd, 0xc134,
    		0x39c3, 0x284a, 0x1ad1, 0x0b58, 0x7fe7, 0x6e6e, 0x5cf5, 0x4d7c,
    		0xc60c, 0xd785, 0xe51e, 0xf497, 0x8028, 0x91a1, 0xa33a, 0xb2b3,
    		0x4a44, 0x5bcd, 0x6956, 0x78df, 0x0c60, 0x1de9, 0x2f72, 0x3efb,
    		0xd68d, 0xc704, 0xf59f, 0xe416, 0x90a9, 0x8120, 0xb3bb, 0xa232,
    		0x5ac5, 0x4b4c, 0x79d7, 0x685e, 0x1ce1, 0x0d68, 0x3ff3, 0x2e7a,
    		0xe70e, 0xf687, 0xc41c, 0xd595, 0xa12a, 0xb0a3, 0x8238, 0x93b1,
    		0x6b46, 0x7acf, 0x4854, 0x59dd, 0x2d62, 0x3ceb, 0x0e70, 0x1ff9,
    		0xf78f, 0xe606, 0xd49d, 0xc514, 0xb1ab, 0xa022, 0x92b9, 0x8330,
    		0x7bc7, 0x6a4e, 0x58d5, 0x495c, 0x3de3, 0x2c6a, 0x1ef1, 0x0f78
		};
#else
	#ifdef MY_GLOBAL
		extern USHORT checksum_table[DEFAULT_FCS_TABLE_SIZE];
	#else
		GLOBAL USHORT checksum_table[DEFAULT_FCS_TABLE_SIZE];
	#endif
#endif


/* ppptx.c */

enum TEST send_ppp_packet (ULONG protocol_stack_id,USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
void ppp_packet_transmitted (USHORT port_number);

enum TEST send_native_ppp_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,
	USHORT number_of_bytes,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_buffer));
void return_buffer (USHORT real_port_number,USHORT protocol_virtual_port_number,enum BOOLEAN device_driver_buffer,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));


/* ppprx.c */

enum BOOLEAN ppp_receive (USHORT real_port_number,UNION_PPP_PACKET **sptr_return_packet,USHORT *usptr_number_of_bytes_rxed);


/* pppinit.c */

void initialize_LQR_counters (USHORT real_port_number);
void ppp_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer);
#ifndef __LSL__
	ULONG get_random_number (void);
#endif
PPP_NCP_CLASS *find_ppp_ncp (USHORT real_port_number,enum PROTOCOL_STACK_TYPE type);
PPP_NCP_CLASS *find_ppp_ncp_using_protocol_type (USHORT real_port_number,enum PPP_PROTOCOL_TYPE ncp_protocol_type);
enum TEST reinitialize_ppp (ULONG clock_ticks_per_second);
enum TEST ppp_device_driver_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);
void ppp_register_event_upcall (ULONG (*fptr_event_upcall) (USHORT real_port_number,USHORT event,...));

#if defined (_MSC_VER)
ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);
#endif

/* ppptimer.c */

void ppp_timer_routine (void);


/* ppputil.c */

void reset_counters_on_this_port (USHORT real_port_number);
void reset_lcp_ncp_options_boolean (USHORT real_port_number);
void reset_lcp_options_boolean (USHORT real_port_number);
void ppp_printf (enum PPP_PRINTF_GROUPS printf_group,const char *cptr_format, ...);

void *ppp_get_a_send_packet (USHORT port_number,ULONG size_of_packet);
void ppp_send_completion (USHORT port_number,void *sptr_tx_packet);
enum BOOLEAN is_dial_on_demand_port_in_use(USHORT port_number);


/* pppasync.c */

void ppp_async_packet_transmitted (USHORT real_port_number,void *vptr);
USHORT async_protocol_packet_tx (USHORT real_port_number,PPP_PACKET_WITH_MAC_HEADER **sptr_tx_packet,
	USHORT number_of_bytes,USHORT protocol_virtual_port_number,enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion)
	(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer);
USHORT async_native_packet_tx (USHORT real_port_number,PPP_PACKET **sptr_tx_packet,USHORT number_of_bytes,
	void (*fptr_tx_completion)(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer);
PPP_PACKET *asynchronous_packet_received (USHORT real_port_number,PPP_PACKET *sptr_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
void build_async_buffer_list (USHORT real_port_number);
void free_async_buffer_list (USHORT real_port_number);

USHORT calculate_frame_check_sequence (USHORT check_sum,BYTE *bptr_async_packet,USHORT number_of_bytes);


/* pppsnmp.c */

void display_packet (BYTE *bptr_packet, USHORT packet_length);

/* pppstat.c */

void execute_ppp_state_machine (enum PPP_EVENT ppp_event,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes);

/* pppipsta.c */

void execute_ipcp_state_machine (enum PPP_EVENT ppp_event,PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,
	void *vptr_packet,USHORT number_of_bytes);

/* pppipxst.c */

void execute_ipxcp_state_machine (enum PPP_EVENT ppp_event,PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,
	void *vptr_packet,USHORT number_of_bytes);

/* pppatsta.c */

void execute_atcp_state_machine (enum PPP_EVENT ppp_event,PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,
	void *vptr_packet,USHORT number_of_bytes);

/* pppncprx.c */

void initialize_ncp (USHORT real_port_number);

enum TEST ncp_packet_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp);

void set_ncp_option (PPP_NCP_CLASS *sptr_ncp,BYTE option_type,USHORT size);

/* pppncptx.c */

void send_ncp_configuration_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void send_ncp_configuration_ack (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed);
void send_ncp_configuration_nak (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,NCP_PACKET *sptr_ncp_rx_packet);
void send_ncp_configuration_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,NCP_PACKET *sptr_ncp_rx_packet);
void send_ncp_termination_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void send_ncp_termination_ack (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number, NCP_PACKET *sptr_ncp_rx_packet);
void send_ncp_code_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number, NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed);
void signal_up_event_to_ncp (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void signal_down_event_to_ncp (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);

/* pppcnpst.c */

void execute_ncp_state_machine (enum PPP_EVENT ppp_event,PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,
	void *vptr_packet,USHORT number_of_bytes);
void reset_ncp_options_boolean (PPP_NCP_CLASS *sptr_ncp);

void set_ncp_state (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_this_layer_start (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_this_layer_finished (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_this_layer_up (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_this_layer_down (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_initialize_restart_counter (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,
	USHORT number_of_bytes,enum PPP_STATE end_state);
void ncp_zero_restart_counter (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);
void ncp_null_state (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,
	enum PPP_STATE end_state);

/* pppiptx.c */

void send_ipcp_configuration_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void send_ipcp_configuration_nak (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,IPCP_PACKET *sptr_lcp_rx_packet);
void send_ipcp_configuration_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,IPCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);

/* pppattx.c */
void send_atcp_configuration_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void send_atcp_configuration_nak (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,ATCP_PACKET *sptr_lcp_rx_packet);
void send_atcp_configuration_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,ATCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);

/* pppipxtx.c */

void send_ipxcp_configuration_request (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number);
void send_ipxcp_configuration_nak (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,IPCP_PACKET *sptr_lcp_rx_packet);
void send_ipxcp_configuration_reject (PPP_NCP_CLASS *sptr_ncp,USHORT real_port_number,IPCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed);

/* ppplrxop.c */

enum TEST process_configuration_options (USHORT real_port_number,LCP_PACKET *sptr_lcp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed);

/* ppplcprx.c */

void initialize_lcp (USHORT real_port_number);

/* pppoptn.c */

void add_configuration_option (OPTION_LIST *sptr_option_list,enum OPTION_STATE state,
	BYTE option_type,BYTE length,void *vptr_option_data,char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value,
	enum BOOLEAN negotiation_required,enum BOOLEAN negotiable,enum BOOLEAN automatic_nak_processing);
void remove_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type);
void replace_configuration_option (OPTION_LIST *sptr_option_list,OPTION_LIST_ENTRY *sptr_option_to_replace,
	enum OPTION_STATE state);
void free_ppp_option_lists (OPTION_LISTS *sptr_option_lists);
void add_alternate_to_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,void *vptr_option_data,
	char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value);
void add_configuration_option_range (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,void *vptr_option_data,
	char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value);
enum TEST add_new_ppp_option_to_list (OPTION_LIST *sptr_option_list,enum OPTION_STATE state,BYTE option_type,BYTE length,
	void *vptr_option_data,enum BOOLEAN negotiation_required,enum BOOLEAN negotiable,enum BOOLEAN automatic_nak_processing);
OPTION_LIST_ENTRY *duplicate_option (OPTION_LIST_ENTRY *sptr_to_option_to_copy);

enum BOOLEAN is_option_present (OPTION_LIST *sptr_option_list,BYTE option_type);
enum TEST copy_option_from_entry (OPTION_LIST_ENTRY *sptr_matching_option,void *vptr_destination,USHORT maximum_size);
enum TEST copy_data_to_option (OPTION_LIST_ENTRY *sptr_matching_option,void *vptr_source,USHORT size);
void delete_entry_from_option_list (OPTION_LIST *sptr_option_list,OPTION_LIST_ENTRY *sptr_option_to_delete);
void free_ppp_option_list (OPTION_LIST *sptr_option_list);

void replace_data_field_in_option (OPTION_LIST_ENTRY *sptr_option,UNION_OPTION_DATA_TYPES *uptr_new_data,BYTE new_length);
OPTION_LIST_ENTRY *find_matching_option (OPTION_LIST *sptr_option_list,BYTE type);
USHORT get_size_of_ppp_options (OPTION_LIST *sptr_option_list);
void store_ppp_options_in_packet (OPTION_LIST *sptr_option_list,PPP_OPTION *sptr_destination_option);
enum TEST copy_option (OPTION_LIST *sptr_option_list,BYTE option_type,void *vptr_destination,USHORT maximum_size);
enum OPTION_PARSE_RESULT parse_ppp_options_from_configure_request (OPTION_LISTS *sptr_option_lists,
	PPP_OPTION *sptr_received_option,USHORT length_of_options,RECEIVE_OPTION_FUNCTIONS *sptr_receive_functions,void *vptr_class);
enum OPTION_PARSE_RESULT parse_ppp_options_from_nak_configure (OPTION_LISTS *sptr_option_lists,PPP_OPTION *sptr_received_option,
	USHORT length_of_options,RECEIVE_OPTION_FUNCTIONS *sptr_receive_functions,void *vptr_class);
enum OPTION_PARSE_RESULT parse_ppp_options_from_reject_configure (OPTION_LISTS *sptr_option_lists,
	PPP_OPTION *sptr_received_option,USHORT length_of_options);

/* pppoptna.c */

void copy_configuration_options_to_tx_accepted_options (OPTION_LISTS *sptr_option_lists);

/* pppauth.c */

void send_lcp_chap_server_packet (USHORT real_port_number);
void pap_packet_received (USHORT real_port_number,PAP_PACKET *sptr_authentication_packet,USHORT number_of_bytes_rxed);
void chap_packet_received (USHORT real_port_number,CHAP_PACKET *sptr_chap_rx_packet,USHORT number_of_bytes_rxed);
void send_lcp_authentication_request (USHORT real_port_number);


/* pppstate.c */

void bring_ncps_up (USHORT real_port_number,void *vptr_packet,USHORT number_of_bytes,enum PPP_STATE end_state);
#if defined (CCP)
	void bring_ccp_up (USHORT real_port_number, void *vptr_packet,USHORT number_of_bytes, enum PPP_STATE end_state);
#endif
/* pppstprx.c */

void *extract_bcp_lan_id (UNION_PPP_PACKET *sptr_tx_packet,USHORT *usptr_number_of_bytes_to_send);

PPP_PACKET_WITH_MAC_HEADER *add_bcp_lan_id (USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT *usptr_number_of_bytes_to_send,enum BOOLEAN do_not_calculate_crc,
	void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer));

void ppp_free_a_bridge_send_packet (USHORT real_port_number,void *vptr_tx_packet);

/*	pppoptnp.c */

enum TEST ppp_ncp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_option,PPP_NCP_CLASS *sptr_ncp);
enum TEST ppp_ncp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_option,PPP_NCP_CLASS *sptr_ncp);
enum TEST ppp_lcp_configure_request_option_processor (OPTION_LIST_ENTRY *sptr_option,PPP_PORT_CLASS *sptr_port);
enum TEST ppp_lcp_configure_nak_option_processor (OPTION_LIST_ENTRY *sptr_option,PPP_PORT_CLASS *sptr_port);

OPTION_LIST_ENTRY *option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option);
ALTERNATE_OPTION *alternate_option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option);
enum BOOLEAN range_option_value_match (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option);
enum TEST set_option_values_for_nak (OPTION_LIST_ENTRY *sptr_local_option,OPTION_LIST_ENTRY *sptr_remote_option);

/* pppconfg.c */

void get_option_value (char *value_type_string,char *value_string,BYTE *bptr_return_data,BYTE *bptr_return_length,
	enum BOOLEAN *eptr_return_value_swapped);
char *copy_parameter (char *cptr_parameter,char *cptr_option,BYTE *bptr_number_of_parameters_processed);
ULONG get_ppp_configuration_table_address (void);

void add_ppp_option (char *cptr_port_number_and_option_string);
void add_remote_ppp_option (char *cptr_port_number_and_option_string);

/* pppcfgar.c */

enum TEST get_alternate_option_values (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped);
enum TEST get_range_option_values (char *cptr_option_string,char *cptr_return_ncp_name,char *cptr_return_option_name,
	BYTE *bptr_return_option_number,BYTE *bptr_return_data,BYTE *bptr_return_length,enum BOOLEAN *eptr_return_value_swapped);

/* pppnbsrx.c */

void initialize_netbios_ncp (USHORT real_port_number);

/* pppupcal.c */

ULONG ppp_event_upcall_example (USHORT event,USHORT real_port_number,...);

/* pppdebug.c */
void check_for_ppp_initialization_breakpoint (void);
void check_for_ppp_runtime_breakpoint (void);

#ifdef __DOD__

/* pppdod.c */

void ppp_link_active (USHORT real_port_number);
void ppp_link_idle (USHORT real_port_number);
void reset_ppp_idle_timer (USHORT real_port_number);

#endif /*__DOD__*/

#if defined (CCP)
	
	/* ccp\ccpinit.c */
	
	#if defined (CCP_MODULE)
		
	#endif

	void initialize_ccp 
	(
		USHORT number_of_ppp_ports, 
		
		void (**ptr_fptr_execute_ccp_state_machine_function) (enum PPP_EVENT ppp_event, USHORT real_port_number, 
			void *vptr_packet, USHORT number_of_bytes),

		PPP_PACKET_WITH_MAC_HEADER	*(*(**ptr_fptr_get_sender_compression_function_function) (USHORT real_port_number)) 
			(USHORT real_port_number, USHORT protocol_virtual_port_number, enum BOOLEAN device_driver_buffer, 
			PPP_PACKET_WITH_MAC_HEADER *sptr_ppp_packet, USHORT *usptr_ppp_packet_length,	
			void (**fptr_tx_completion) (USHORT port_number, void *vptr_buffer)),

		UNION_PPP_PACKET *(*(**ptr_fptr_get_receiver_decompression_function_function) (USHORT real_port_number)) 
			(USHORT real_port_number, UNION_PPP_PACKET *uptr_ppp_packet, USHORT *usptr_ppp_packet_length),

		void (**ptr_fptr_ccp_timer_routine) (USHORT real_port_number, USHORT number_of_protocol_stacks_loaded, 
			ULONG maximum_configuration_request_send_interval, ULONG maximum_number_of_configuration_requests, 
			ULONG maximum_termination_request_send_interval, ULONG maximum_number_of_termination_requests),

		enum TEST (**ptr_fptr_ccp_packet_received_function) (USHORT real_port_number, void *vptr_ccp_rx_packet, 
			USHORT number_of_bytes_rxed),
		
		OPTION_LISTS *(**ptr_fptr_get_ccp_option_lists_function) (USHORT real_port_number),

		enum PPP_STATE (**ptr_fptr_get_ccp_state_function) (USHORT real_port_number), 

		enum BOOLEAN (**ptr_fptr_get_sender_compression_database_initialization_status_function) (USHORT real_port_number),

		enum BOOLEAN (**ptr_fptr_get_receiver_compression_database_initialization_status_function) (USHORT real_port_number),

		enum BOOLEAN (**ptr_fptr_get_ccp_port_status_function) (USHORT real_port_number),
		
		BYTE (**ptr_fptr_get_last_id_of_ccp_packet_sent_function) (USHORT real_port_number),

		ULONG (*fptr_get_device_driver_id_function) (USHORT real_port_number),
		ULONG (*fptr_get_maximum_number_of_termination_requests_function) (void),
		ULONG (*fptr_get_ppp_remote_MRU_function) (USHORT real_port_number),
		OPTION_LISTS *(*fptr_get_ccp_option_lists_created_by_ppp_function) (USHORT real_port_number)
	);
#endif

/* Kamalnath SLIP 24\04\1997 */

/* slip.c */
void slip_packet_transmitted (USHORT real_port_number,void *vptr_txed_packet);
USHORT send_slip_packet (USHORT real_port_number,void **sptr_tx_packet,	USHORT number_of_bytes,USHORT protocol_virtual_port_number,
		enum BOOLEAN device_driver_buffer, void (*fptr_tx_completion)(USHORT port_number,void *vptr_ethernet_buffer),void **vptr_async_buffer);
enum TEST receive_slip_packet (USHORT real_port_number, BYTE **sptr_rxed_packet,USHORT *usptr_number_of_bytes_rxed);

/* sliputil.c */
void build_slip_buffer_list (USHORT real_port_number);
void free_slip_buffer_list (USHORT real_port_number);
void slip_printf (enum SLIP_PRINTF_GROUPS printf_group,const char *cptr_format, ...);

/* Kamalnath SLIP 24\04\1997 */
#ifdef __MLPPP__
USHORT map_physical_port_to_virtual_port(USHORT real_port_number);
USHORT join_multilink_if_negotiated(USHORT real_port_number,USHORT virtual_port_number);
enum TEST remove_link_from_bundle(USHORT real_port_number,USHORT virtual_port_number);
void mlppp_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer);
void mlppp_packet_transmitted (USHORT real_port_number);
void initialize_mlppp_ports (void);
#endif /* __MLPPP__ */
