#ifndef __SCRTDATA__

#define __SCRTDATA__

#include "scrttype.h"
#include "scrtfuns.h"
#include "scrtcons.h"
#include "scrtenum.h"


BuiltInType BuiltInCommands[] = {

		{"RGETC", RgetcHdlr},
		{"RGETS", RgetsHdlr},
		{"GETDCD", GetDCDHdlr},
		{"HANGUP", HangupHdlr},
		{"BAUDRATE", BaudRateHdlr},
		{"STOPBITS", StopBitsHdlr},
		{"PARITY", ParityHdlr},
		{"DEC", DecHdlr},
		{"INC", IncHdlr},
		{"EXIT", ExitHdlr},
		{"ATOI", AtoiHdlr},
		{"ITOA", ItoaHdlr},
		{"STRLEN", StrlenHdlr},
		{"STRCAT", StrcatHdlr},
		{"STRCMP", StrcmpHdlr},
		{"STRCPY", StrcpyHdlr},
		{"STRFMT", StrfmtHdlr},
		{"TOUPPER", ToUpperCaseHdlr},
		{"TOLOWER", ToLowerCaseHdlr},
		{"TRANSMIT", TransmitHdlr},
		{"WAITFOR", WaitForHdlr},
		{"WAIT", WaitHdlr},
		{"BREAK", BreakHdlr},
		{"RXFLUSH", RxFlushHdlr},
		{"TXFLUSH", TxFlushHdlr},
		{"THISLAYERUP", ThisLayerUpHdlr},

		{"SETRTS", SetRTSHdlr},
		{"GETCTS", GetCTSHdlr},
		{"SETDTR", SetDTRHdlr},
		{"ACTIVATEDOD", ActivateDODHdlr} /* Ravi on 10-jan-2000 */
/*		{"GETDSR", GetDSRHdlr} */
};

WORD NoOfCommands = sizeof(BuiltInCommands) / sizeof(BuiltInType);

PreDefVarType PreDefVars[] = {
/*	List of pre-defined variables.	*/
	{"$CONDN_VAR", E_INTEGER},
	{"$RET_VAR", E_INTEGER},
} ;

int NoOfPreDefVars = sizeof (PreDefVars) / sizeof (PreDefVarType) ;

unsigned long ScriptCodeIndex[MAX_NO_OF_PORTS] ;

int (*CmdHdlrs[]) (BYTE PortNum) = 
{
	UnaryMinusFun,	/*	Q_UNARY_MINUS		*/
	PlusFun,			/*	Q_PLUS				*/
	MinusFun,		/*	Q_MINUS				*/
	TimesFun,		/*	Q_TIMES				*/
	DivFun,			/*	Q_DIV				*/
	LessOrEqFun,	/*	Q_LESS_OR_EQUAL		*/
	GreaterOrEqFun,	/*	Q_GREATER_OR_EQUAL	*/
	IsEqFun,			   /*	Q_IS_EQUAL			*/
	IsNotEqFun,			/*	Q_IS_NOT_EQUAL		*/
	LessFun,			/*	Q_LESS				*/
	GreaterFun,		/*	Q_GREATER			*/
	NotFun,			/*	Q_NOT				*/
	NULL,			/*	Q_LP				*/
	NULL,			/*	Q_RP				*/
	AndFun,			/*	Q_AND				*/
	OrFun,			/*	Q_OR				*/
	NULL,			/*	Q_COMMA				*/
	NULL,			/*	Q_ID				*/
	NULL,			/*	Q_INT_CONST			*/
	NULL,			/*	Q_REAL_CONST		*/
	NULL,			/*	Q_STRING_CONST		*/
	MovFun,			/*	Q_MOV				*/
	LabelFun,		/*	Q_LABEL_DEFun		*/
	JmpFun,			/*	Q_JMP				*/
	JzFun,			/*	Q_JZ				*/
	JnzFun,			/*	Q_JNZ				*/
	JeqFun,			/*	Q_JEQ				*/
	JneqFun,			/*	Q_JNEQ				*/
	PushFun,			/*	Q_PUSH				*/
	CallFun,			/*	Q_CALL				*/
	RetFun,			/*	Q_RET				*/
	LineNoFun,		/*	Q_LINENO			*/
	ProcFun,			/*	Q_PROCEDURE			*/
	EndProcFun,		/*	Q_ENDPROCEDURE		*/
	ParamFun,		/*	Q_PARAM				*/
	DeclareFun,		/*	Q_DECLARE			*/
	TempCountFun,	/*	Q_TEMPCOUNT			*/
	KillFun			/*	Q_KILL				*/
};

#endif

