#ifndef __SCRTENUM__

#define __SCRTENUM__

extern enum 
{	/*	The order should match entries in Precedence table.	*/
	Q_UNARY_MINUS, /* 0 */
	Q_PLUS,
	Q_MINUS,
	Q_TIMES,
	Q_DIV,
	Q_LESS_OR_EQUAL,	/* 5 */
	Q_GREATER_OR_EQUAL,
	Q_IS_EQUAL,
	Q_IS_NOT_EQUAL,
	Q_LESS,
	Q_GREATER,		  /* A */
	Q_NOT,
	Q_LP,
	Q_RP,
	Q_AND,
	Q_OR,				  /* F */
	Q_COMMA,
	Q_ID,
	Q_INT_CONST,
	Q_REAL_CONST,
	Q_STRING_CONST,
	Q_SEMICOLON,		/* 15 */
	Q_COLON,
	Q_ASSIGNMENT,
	Q_LABEL,
	Q_ILLEGAL,
	Q_IF,				  /* 1A */
	Q_THEN,
	Q_ELSE,
	Q_ENDIF,
	Q_WHILE,
	Q_DO,				  /* 1F */
	Q_ENDWHILE,
	Q_FOR,
	Q_TO,
	Q_DOWNTO,
	Q_STEP,
	Q_ENDFOR,			/* 25 */
	Q_SWITCH,
	Q_CASE,
	Q_DEFAULT,
	Q_ENDCASE,
	Q_ENDSWITCH,	  /* 2A */
	Q_PROC,
	Q_ENDPROC,
	Q_FORWARD,
	Q_RETURN,
	Q_GOTO,			  /* 2F */
	Q_VAR,
	Q_INTEGER,
	Q_REAL,
	Q_STRING,
	Q_VOID				/* 33 */
} tok_type ;


extern enum 
{
	/*	List of operators/instructions.	*/
	Q_MOV = Q_SEMICOLON,	  								/* 15 */
	Q_LABEL_DEFN,	/*	Label declaration.	*/
	Q_JMP,	/*	Unconditional jump.	*/
	Q_JZ,	/*	Jump on zero.	*/
	Q_JNZ,	/*	Jump on non-zero.	*/
	Q_JEQ,	/*	Jump on first and second arg value same.	*/
	Q_JNEQ,	/*	Jump on first and second arg value difference.	*/
	Q_PUSH,	/*	Push argument for call.	*/			/* 1C */
	Q_CALL,	/*	Function call.	*/						/* 1D */
	Q_RET,	/*	Return from a function.	*/
	Q_LINENO,	/*	Psuedocode for embedding line numbers.	*/
	Q_PROCEDURE,	/*	Psuedocode for procedure beginning.	*/
	Q_ENDPROCEDURE,	/*	Psuedocode for procedure end.	*/
	Q_PARAM,	/*	Psuedocode for procedure parameter.	*/
	Q_DECLARE,	/*	Psuedocode for variable declaration.	*/
	Q_TEMPCOUNT,	/*	Psuedocode indicating no. of temporaries.	*/
	Q_KILL	/*	Psuedocode for killing temporaries.	*/
} inst_type ;


extern enum 
{
	E_INTEGER,	/*	Expression evaluates to an integer.	*/
	E_REAL,		/*	Expression evaluates to a real.	*/
	E_STRING,	/*	Expression evaluates to a string.	*/
	E_INT_CONST,	/*	Expression is an integer constant.	*/
	E_REAL_CONST,	/*	Expression is a real constant.	*/
	E_STRING_CONST,	/*	Expression is a string constant.	*/
	E_VOID,		/*	Expression type is void.	*/
	E_INVALID,	/*	Expression is invalid.	*/
	E_UNKNOWN	/*	Expression type unknown.	*/
} expression_type;


extern enum 
{
	VAR_GLOBAL,	/*	Global variable.	*/
	VAR_PARAM,	/*	Parameter variable.	*/
	VAR_LOCAL,	/*	Local variable.	*/
	VAR_TEMPORARY,	/*	Temporary variable.	*/
	VAR_CONDITION,	/*	$CONDN_VAR.	*/
	VAR_RETURN		/*	$RET_VAR.	*/
} var_type ;

enum SCRIPT_PRINTF_GROUPS
{
	ALARM_SCRIPT_PRINTF,
	NON_CRITICAL_SCRIPT_PRINTF
} ;


#endif
