#include "defs.h"
/****************************************************************************
	File	: CHATRX.C
	Synop	: WANCHAT module, WAN receive portion of Chat
	Auth	: Vidyasagaran P
	Date	: 13th Sept 1995
	Modi	: 7/11/95 Sowmya added support for TELNET-WAN Chat
			  20/6/96 Sanjay added RTS support
****************************************************************************/

#include	"chat.h"
#include	"..\kuim.h"
#include	"..\vuimstr.h"
#include	"..\vuim.h"

/* External prototypes */
extern	send_chat_pkt_to_telnet_client(BYTE *, ULONG);
extern	send_chat_pkt_to_specific_telnet_client(BYTE *, ULONG, BYTE *);
extern	int	ChatClient;
extern	char	*RebootMessage;
extern	BYTE *dialout_client_ptr[];
extern void EnableWAN1RTS(void);
extern void EnableWAN2RTS(void);
extern void EnableWAN3RTS(void);

extern void DisableWAN1RTS(void);
extern void DisableWAN2RTS(void);
extern void DisableWAN3RTS(void);

/* Local prototypes */
static enum BOOLEAN chat_receive_wan_packet(int port_number);
void EnableRTSOnWAN(int port_number);
void DisableRTSOnWAN(int port_number);

/* Added by Sowmya. 7/11/95 */
/* Check for chat packet received from wan port is made here. 
The function will take care of routing the packet properly to SMC or TELNET */

void	ChatForeground(void)
{
	ULONG	counter;
	UIM_TX_DESCRIPTOR	*UIMDescriptor;
	int	save_pl;

	if (ChatOnPort)
	{
		/* check for any WAN packet received */
		if (chat_receive_wan_packet(ChatOnPort - 1))
			ChatIdleTimer = CHAT_IDLE_TIMER_VALUE;	/* reset this */

		if (!ChatIdleTimer)
		{
			/* Disable interrupts */
			save_pl = _GPL();
			_SPL(7);
			if (ChatClient == SMC_CHAT)
			{
				/* timer expired, send message to console */
				UIMDescriptor = get_entry_from_list(&uim.free_tx_list);

				strcpy(UIMDescriptor->sptr_tx_packet, RebootMessage);
				/* initialize the UIM descriptor length */
				UIMDescriptor->length = strlen(RebootMessage);

				/* schedule this packet on SMC */
				schedule_pkt_on_SMC(UIMDescriptor);
			}
			else if (ChatClient == TELNET_CHAT)
			{
				/* send error to telnet client */
				send_chat_pkt_to_telnet_client(RebootMessage, strlen(RebootMessage));
			}		
			for (counter = 0; counter < 0x10000; counter++);
			_SPL(save_pl);
			Reset();
		}
	}
	else 
	{
		int i;

		/* In this case, check on all ports for received packets */

		for (i = 0; i < MAX_WAN_PORTS; i++)
		{
			if (dialout_client_ptr[i] == NULL)
				continue;
			chat_receive_wan_packet(i);
		}
	}
}	

/****************************************************************************
	routine	:	chat_receive_wan_packet
****************************************************************************/
static enum BOOLEAN chat_receive_wan_packet(int port_number)
{
	CHAT_RXTX_DESCRIPTOR *sptr_current_rx_descriptor;
	int	TmpSr, actual_free;		/* 01/02/97 */
	BYTE	*buffer_save_pointer;
	UIM_TX_DESCRIPTOR	*UIMDescriptor;

/* 
	We are going to modify the current_rx_list linked list. Which is also being
   	modified when a packet received from the network. so disable ints.
*/
	TmpSr = _GPL(); 
	_SPL(7);
	sptr_current_rx_descriptor = (CHAT_RXTX_DESCRIPTOR *) get_entry_from_list (&wan_chat.current_rx_list[port_number]);

	if (sptr_current_rx_descriptor == NULL) {	/* nothing received on WAN */
		_SPL(TmpSr);
		return FALSE;
	}

	/* Chat Session using TELNET : 7/11/95 Sowmya*/
	if (ChatClient == TELNET_CHAT)
	{
		send_chat_pkt_to_telnet_client(sptr_current_rx_descriptor->sptr_buffer,
						sptr_current_rx_descriptor->length);
	}
	else if (ChatClient == SMC_CHAT)
	{
		/* schedule this packet on SMC */
		/* A packet is received on WAN, get a TX descriptor from SMC */
		UIMDescriptor = get_entry_from_list(&uim.free_tx_list);

		/* save the buffer pointer for now */
		buffer_save_pointer = UIMDescriptor->sptr_tx_packet;

		/* attach the WAN received data buffer with SMC descriptor */
		UIMDescriptor->sptr_tx_packet = sptr_current_rx_descriptor->sptr_buffer;
		/* initialize the UIM descriptor length */
		UIMDescriptor->length = sptr_current_rx_descriptor->length;

		/* schedule this packet on SMC */
		schedule_pkt_on_SMC(UIMDescriptor);

		/* attach the saved buffer pointer from SMC to the
		WAN side for further receive */
		sptr_current_rx_descriptor->sptr_buffer = buffer_save_pointer;
	}
	else
	{
		/* Assume anything else is from dialout and to be sent to telnet */
		send_chat_pkt_to_specific_telnet_client(sptr_current_rx_descriptor->sptr_buffer,
						sptr_current_rx_descriptor->length, dialout_client_ptr[port_number]);
	}

	/* add the WAN chat descriptor to free_rx_list */
	add_entry_to_list (&wan_chat.free_rx_list[port_number], (LINK *)sptr_current_rx_descriptor);
	wan_chat.num_free_rx_buf[port_number]++;

	/* Sanjay 15/Jun/96. Each time this is done, re-enable RTS if there is
	** more than 1/4 buffer space.
	*/
	/* 01/02/97 Vidy/Sachin */
	actual_free = wan_chat.num_free_rx_buf[port_number] +
						wan_chat.num_scheduled_rx_buf[port_number];
	if (actual_free >= (CHAT_NUMBER_OF_RX_DESCRIPTORS / 4))
	{
		EnableRTSOnWAN(port_number);
	}

	_SPL(TmpSr);
	return TRUE;
}

/****************************************************************************/
/* this is called whenever a new packet is received from wan port and a new
   buffer is to be allocated for reception. This is also called in the
   beginning when wan port controller is being initialized. After the buffer
   is got from the free_rx_list the descriptor is added to scheduled_for_rx
   queue. This is called with interrupts disabled from wan port interrupt
   service routine.
   Modified by Sanjay 20, June, 1996 - Changed so that if number of remaining
   buffers falls to <= 1/4th, we de-assert RTS. We de-assert RTS in
   the hope that there will not be future calls to this function that can
   possibly return a NULL pointer. RTS is re-enabled when buffer level
   increases to > 1/4.
*/
/****************************************************************************/
void *chat_get_a_free_wan_rx_descriptor(int port_number)
{
	CHAT_RXTX_DESCRIPTOR *sptr_free_rx_descriptor;

	sptr_free_rx_descriptor = (CHAT_RXTX_DESCRIPTOR *) get_entry_from_list(&wan_chat.free_rx_list[port_number]);

	/* If coding (and perhaps timing) is right, this function would never 
	** have been called if there were no buffers as we manipulate RTS.
	*/
	if (sptr_free_rx_descriptor == NULL) 
	{
#ifdef DEBUG
		printf("WAN CHAT: No free buf for rx, num buf = %d\r\n", wan_chat.num_free_rx_buf[port_number]);
#endif

		/* To prevent problems due to lack of receive buffer space, we shall 
		** pick up an element from the current_rx_list and use it here. 
		** This will screw up app receive sequence, but there is no buffer
		** anywhere else. NOTE that if there are no buffers in the free list,
		** some buffers are in the scheduled_for_rx list and the rest in the
		** current_rx_list.
		*/
		sptr_free_rx_descriptor = (CHAT_RXTX_DESCRIPTOR *) get_entry_from_list (&wan_chat.current_rx_list[port_number]);
#ifdef DEBUG
		if (sptr_free_rx_descriptor == NULL)
		{
			printf("CHAT: What?!! There is no element in current rx list too.\n\r");
			return NULL;
		}
#endif /* DEBUG */
		add_entry_to_list(&wan_chat.scheduled_for_rx[port_number], (LINK *)sptr_free_rx_descriptor);
		DisableRTSOnWAN(port_number); /* Arrange to stop receiving */
		return sptr_free_rx_descriptor->sptr_buffer;
	}

	add_entry_to_list(&wan_chat.scheduled_for_rx[port_number], (LINK *)sptr_free_rx_descriptor);
	wan_chat.num_scheduled_rx_buf[port_number]++;
	wan_chat.num_free_rx_buf[port_number]--;
	if (wan_chat.num_free_rx_buf[port_number] <= (CHAT_NUMBER_OF_RX_DESCRIPTORS / 4))
	{
		DisableRTSOnWAN(port_number);
	}
	return (sptr_free_rx_descriptor->sptr_buffer);
}

/****************************************************************************/
/* if a packet is received with no errors and also an free rx_descriptor is
   available this is called. this just picks up the packet from 
   scheduled_for_rx queue and put it on current_rx_list.
   This is called with interrupts disabled.
*/
/****************************************************************************/
void	chat_put_wan_pkt_on_recvd_que(int port_number, int len_of_wan_pkt)
{
	CHAT_RXTX_DESCRIPTOR  *sptr_rx_descriptor;


	sptr_rx_descriptor = (CHAT_RXTX_DESCRIPTOR *) get_entry_from_list (&wan_chat.scheduled_for_rx[port_number]);
	if (sptr_rx_descriptor == NULL)
	{
#ifdef DEBUG
		printf("CHAT: scheduled_for_rx list empty\n\r");
#endif /* DEBUG */
		return;
	}
	sptr_rx_descriptor->length = len_of_wan_pkt;
	wan_chat.num_scheduled_rx_buf[port_number]--;
	add_entry_to_list (&wan_chat.current_rx_list[port_number], (LINK *)sptr_rx_descriptor);
}

/****************************************************************************/
/* this is called whenever there an wan packet which is in error is
   received. In this case it is necessarry to take out the first packet from
   scheduled_for_rx queue and put it in end. This is done this way as we will
   continue to use the same buffer for subsequent reception. 
   this is called with ints disabled.
*/
/****************************************************************************/
void chat_wan_rx_error_adjust_scheduled_rx_list(int port_number)
{
	static int err_count = 0;
	LINK  *sptr_rx_descriptor;

	sptr_rx_descriptor = get_entry_from_list (&wan_chat.scheduled_for_rx[port_number]);
	if(sptr_rx_descriptor == NULL){
#ifdef DEBUG
		err_count++;
		printf("CHAT: Rx error %d\n\r", err_count);
#endif /* DEBUG */
		return;
	}
	add_entry_to_list (&wan_chat.scheduled_for_rx[port_number], (LINK *)sptr_rx_descriptor);
}

void EnableRTSOnWAN(int port_number)
{
	switch (port_number)
	{
#if 0		/* Sreelu for wan device config */
	case 0:
		EnableWAN1RTS();
		break;
#endif	/* Sreelu for wan device config */

	case 0:
		EnableWAN2RTS();
		break;
	case 1:
		EnableWAN3RTS();
		break;
	}
}

void DisableRTSOnWAN(int port_number)
{
#ifdef DEBUG
	printf("CHAT: Disabling RTS\n\r");
#endif /* DEBUG */

	switch (port_number)
	{
#if 0		/* Sreelu for wan device config */
	case 0:
		DisableWAN1RTS();
		break;
#endif	/* Sreelu for wan device config */

	case 0:
		DisableWAN2RTS();
		break;
	case 1:
		DisableWAN3RTS();
		break;
	}
}
