#include "defs.h"
/****************************************************************************
	file	:
	Synop	: WANCHAT module. WAN send portion of WAN chat
	Auth	: Vidyasagaran P
	Date	: 13th Sept 1995
	Modi	:
****************************************************************************/
#include	"\rtrware\stdlib\stdlib.h"
#include <string.h>

#include "chat.h"
#include	"..\kuim.h"
#include	"..\vuimstr.h"

/***************************************************************************
	routine	:	chat_send_wan_packet
	Synops	:	Send a packet(one or more chars) received on SMC to the WAN
					port which is in chat mode.
****************************************************************************/
enum TEST chat_send_wan_packet (BYTE *sptr_tx_buffer, USHORT number_of_bytes, USHORT port_number)
{
	CHAT_RXTX_DESCRIPTOR *sptr_current_tx_descriptor;
	int	save_pl;		/* location to save interupt priority level */

	/* Disable interrupts */
	save_pl = _GPL();
	_SPL(7);
	/* free list is also manipulated by interrupt service routine */
	sptr_current_tx_descriptor = get_entry_from_list (&wan_chat.free_tx_list[port_number]);

	if (sptr_current_tx_descriptor == NULL) {
/*		++sptr_wan_port_class->statistics.number_of_rejected_tx_packets; */

		/* Enable interrupts before getting out */
		_SPL(save_pl);
		return (FAIL);
	}

	sptr_current_tx_descriptor->length = number_of_bytes;
	memcpy(sptr_current_tx_descriptor->sptr_buffer, sptr_tx_buffer, number_of_bytes);

	/* Check if the port is free */
	if (wan_chat.sptr_current_tx_descriptor[port_number] == NULL) {
		/* Port is free; set current_tx_descriptor */
		wan_chat.sptr_current_tx_descriptor[port_number] = sptr_current_tx_descriptor;

		/* schedule this buffer to go */
		ChatScheduleTxPort(port_number, sptr_current_tx_descriptor);
	} else {
		/* Otherwise add entry into current_tx_list and get out, ISR will take care */
	   add_entry_to_list (&wan_chat.current_tx_list[port_number], (LINK *) sptr_current_tx_descriptor);
	}
	/* Enable interrupts */
	_SPL(save_pl);
	return (PASS);
}
/****************************************************************************/
/* This is going to be called from the transmit interrupt service routine */
/****************************************************************************/
void chat_wan_tx_isr_complete(int port_number)
{
	CHAT_RXTX_DESCRIPTOR *sptr_current_tx_descriptor;

	sptr_current_tx_descriptor = wan_chat.sptr_current_tx_descriptor[port_number];
	if (sptr_current_tx_descriptor == NULL) {
		/* something went wrong */
		printf ( "WAN CHAT: Panic, current_tx_descriptor NULL!\r\n");
		return;
	}

	/* add this descriptor to the free_tx_list */
   add_entry_to_list (&wan_chat.free_tx_list[port_number], (LINK *)sptr_current_tx_descriptor);

	/* check on the current_tx_list for any more packets */
	sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan_chat.current_tx_list[port_number]);

	/* update the current_tx_descriptor in port_class for next interrupt */
	wan_chat.sptr_current_tx_descriptor[port_number] = sptr_current_tx_descriptor;
	if (sptr_current_tx_descriptor != NULL) {
		/* schedule this buffer to go */
		ChatScheduleTxPort(((USHORT)port_number), sptr_current_tx_descriptor);
	}
}	

int ChatScheduleTxPort(USHORT port_number, CHAT_RXTX_DESCRIPTOR *descriptor)
{
	switch (port_number) {
#if 0		/* Sreelu for wan device config */
		case 0:
				ChatTxPktOnSCC2(descriptor->sptr_buffer, descriptor->length);
				break;
#endif	/* Sreelu for wan device config */

		case 0:
				ChatTxPktOnSCC3(descriptor->sptr_buffer, descriptor->length);
				break;
		case 1:
				ChatTxPktOnSCC4(descriptor->sptr_buffer, descriptor->length);
				break;
		}
	return(PASS);
}

