/****************************************************************************
	file	: vchatstr.h
	Synop	: WANCHAT module. type and prototype definitions
	Auth	: Vidyasagaran P
	Date	: 13th Sept 1995
	Modi	:
****************************************************************************/
#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

typedef	struct	CHAT_RXTX_DESCRIPTOR
{
	LINK						links;
	USHORT					length;
	BYTE						*sptr_buffer;
} CHAT_RXTX_DESCRIPTOR;

typedef	struct	CHAT_CLASS
{
	enum BOOLEAN						enabled;

	/* TX related structures, only one transmit BD is there */	
	CHAT_RXTX_DESCRIPTOR				tx_descriptor[MAX_WAN_PORTS][CHAT_NUMBER_OF_TX_DESCRIPTORS];
	CHAT_RXTX_DESCRIPTOR				*sptr_current_tx_descriptor[MAX_WAN_PORTS];	/* Desc being
														emptied at the moment */
	LINK									free_tx_list[MAX_WAN_PORTS];		/* Q of free Descs */
	LINK									current_tx_list[MAX_WAN_PORTS];	/* Q of received Descs */

	/* RX related structures, multiple receive BDs are there */
	CHAT_RXTX_DESCRIPTOR				rx_descriptor[MAX_WAN_PORTS][CHAT_NUMBER_OF_RX_DESCRIPTORS];
	LINK									free_rx_list[MAX_WAN_PORTS];		/* Q of free Descs */
	LINK									current_rx_list[MAX_WAN_PORTS];	/* Q of received Descs */
	LINK									scheduled_for_rx[MAX_WAN_PORTS];	/* Q of Descs for rcv */
	int									num_free_rx_buf[MAX_WAN_PORTS];
	int									num_scheduled_rx_buf[MAX_WAN_PORTS];
} WAN_CHAT_CLASS;

/* function prototypes in various chat module files */
/* chatinit.c */
enum BOOLEAN start_chat_on_port(int	port_number, BYTE);
void	stop_chat_on_port(int port_number);
void ReclaimBuffersFromWAN(int port_number);
int initialize_chat_rxtx_descriptors (int port_number);
enum BOOLEAN start_dialout_on_port(USHORT port_number, BYTE *dialout_client,
	ULONG BaudRate, BYTE DataBits, BYTE Parity, BYTE StopBits);
void stop_dialout_on_port(USHORT port_number);

/* chatrx.c */
void *chat_get_a_free_wan_rx_descriptor(int port_num /* NOT USED */);
void	chat_put_wan_pkt_on_recvd_que(int port_num /* NOT USED */, int len_of_wan_pkt);
void chat_wan_rx_error_adjust_scheduled_rx_list(int port_num /* NOT USED */);

/* chattx.c */
enum TEST chat_send_wan_packet (BYTE *sptr_tx_buffer, USHORT number_of_bytes, USHORT port_number);
void chat_wan_tx_isr_complete(int port_number);
int ChatScheduleTxPort(USHORT port_number, CHAT_RXTX_DESCRIPTOR *descriptor);

/* chatscc.68k */
void	ChatInitSCC2(int port_speed,USHORT wan_buffer_size, USHORT mode_bits);
void	ChatInitSCC3(int port_speed,USHORT wan_buffer_size, USHORT mode_bits);
void	ChatInitSCC4(int port_speed,USHORT wan_buffer_size, USHORT mode_bits);
void	ChatStopAllSCCs(void);
void	ChatSetLocalIO14(ULONG Value);

void	ChatTxPktOnSCC2(void *buffer, int count);
void	ChatTxPktOnSCC3(void *buffer, int count);
void	ChatTxPktOnSCC4(void *buffer, int count);

void	ChatTurnOnTXAndRXOfSCC2(void);
void	ChatTurnOnTXAndRXOfSCC3(void);
void	ChatTurnOnTXAndRXOfSCC4(void);



