/*****************************************************************************
	file	: uimmux.c
	Synop	: routines and handlers for MMV101 stuff
	Auth	: Vidyasagaran P
	Date	: 24th Sept 1995
	Modi	:
*****************************************************************************/
#include	"uim.h"
#include "..\wandrv\modem.h"
#include	"brcif.h"

BYTE		*LocalIO = 0xFF000000;
#define	MUX_DONE_BIT_MASK			0x80
#define	CONSOLE_WITH_MMV101		0x87
#define	CONSOLE_WITH_ROUTER		0xC7

char	*MuxDoneSequence = "ATRZ\r\n";

ULONG	CheckMuxDoneSetupTimer = 0;
BYTE	SettingUpMux = 0;

/****************************************************************************
Synop	:	check if MUX module is present. If not present return 0.
			Clear BIT 6 in LocalIO+$14 and start MuxInitDoneTimer.
****************************************************************************/
int	initialize_mux_module_talk(void)
{
	if ( ! check_MMV101_present()) {
		return ERR_NO_MUX_PRESENT;
	}

	CheckMuxDoneSetupTimer = MUX_SETUP_DONE_TIMER;
	SettingUpMux = 1;
	*(ULONG *)(LocalIO+0x14) = CONSOLE_WITH_MMV101;
	return 0;
}
/****************************************************************************
Synop	:	check to see if MMV101 hardware is present. return 1 if yes, 0 else
****************************************************************************/
int	check_MMV101_present(void)
{
	return TRUE;
}
/****************************************************************************
Synop	:	Called when MuxInitDoneTimer expires. if BIT 7 in LocalIO+$10
			is still clear restart the timer. other wise warm boot router
*****************************************************************************/
int	check_mux_initialization_done(void)
{
	int counter;

	/* after init we need to wait before we check for done bit */
	if (CheckMuxDoneSetupTimer)
		return 0;

	if (*(ULONG *)(LocalIO+0x10) & MUX_DONE_BIT_MASK) {
			*(ULONG *)(LocalIO+0x14) = CONSOLE_WITH_ROUTER;
			printf("\n\rMux module setup done. Router will reboot now.\n\r");
			for (counter = 0; counter < 0x10000; counter++);
			printf(MuxDoneSequence);
	 		*DownloadFlag = WARM_BOOT_MODE;
			close_lsl ();
			Reset();
	}
	return 0;
}
